//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ptr::NonNull;
use objc2_core_foundation::*;

use crate::*;

/// Provides Captive Network Support with an updated list of
/// SSIDs that this application will perform authentication on.
///
/// Captive Network Support suppresses showing the Web Sheet
/// for a captive Wi-Fi network if that network's SSID is in the
/// specified list.
///
/// On iOS, the registrations persist until the application is
/// removed from the device.
///
/// On MacOSX, the registrations persist as long as the application
/// is running.
///
///
/// Parameter `ssidArray`: A CFArray of CFStrings of the SSIDs.
///
/// Returns: Returns TRUE if the operation succeeded, FALSE otherwise.
///
/// # Safety
///
/// `ssid_array` generic must be of the correct type.
#[deprecated]
#[inline]
pub unsafe extern "C-unwind" fn CNSetSupportedSSIDs(ssid_array: &CFArray) -> bool {
    extern "C-unwind" {
        fn CNSetSupportedSSIDs(ssid_array: &CFArray) -> Boolean;
    }
    let ret = unsafe { CNSetSupportedSSIDs(ssid_array) };
    ret != 0
}

/// Tells Captive Network Support that your application has
/// authenticated the device to the network. Captive Network Support
/// will notify the rest of the system that WiFi is now a viable
/// interface.
///
/// Parameter `interfaceName`: Name of the interface that is now online.
///
/// Returns: Returns TRUE if the operation succeeded, FALSE otherwise.
#[deprecated]
#[inline]
pub extern "C-unwind" fn CNMarkPortalOnline(interface_name: &CFString) -> bool {
    extern "C-unwind" {
        fn CNMarkPortalOnline(interface_name: &CFString) -> Boolean;
    }
    let ret = unsafe { CNMarkPortalOnline(interface_name) };
    ret != 0
}

/// Tells Captive Network Support that the device is not
/// authenticated on the given network interface.
///
/// Parameter `interfaceName`: Name of the interface that is still captive.
///
/// Returns: Returns TRUE if the operation succeeded, FALSE otherwise.
#[deprecated]
#[inline]
pub extern "C-unwind" fn CNMarkPortalOffline(interface_name: &CFString) -> bool {
    extern "C-unwind" {
        fn CNMarkPortalOffline(interface_name: &CFString) -> Boolean;
    }
    let ret = unsafe { CNMarkPortalOffline(interface_name) };
    ret != 0
}

/// copies a list of all interfaces CaptiveNetworkSupport is monitoring.
///
/// Returns: An array of CFStringRef- BSD interface names.
/// Returns NULL if an error was encountered.
/// You MUST release the returned value.
#[inline]
pub extern "C-unwind" fn CNCopySupportedInterfaces() -> Option<CFRetained<CFArray>> {
    extern "C-unwind" {
        fn CNCopySupportedInterfaces() -> Option<NonNull<CFArray>>;
    }
    let ret = unsafe { CNCopySupportedInterfaces() };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

extern "C" {
    /// NetworkInfo Dictionary key for SSID in CFData format
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/systemconfiguration/kcnnetworkinfokeyssiddata?language=objc)
    pub static kCNNetworkInfoKeySSIDData: &'static CFString;
}

extern "C" {
    /// NetworkInfo Dictionary key for SSID in CFString format
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/systemconfiguration/kcnnetworkinfokeyssid?language=objc)
    pub static kCNNetworkInfoKeySSID: &'static CFString;
}

extern "C" {
    /// NetworkInfo Dictionary key for BSSID in CFString format
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/systemconfiguration/kcnnetworkinfokeybssid?language=objc)
    pub static kCNNetworkInfoKeyBSSID: &'static CFString;
}

/// Returns the network information for the specified interface when the requesting application meets one of following 4 requirements -.
/// 1. application is using CoreLocation API and has the user's authorization to access location.
/// 2. application has used the NEHotspotConfiguration API to configure the current Wi-Fi network.
/// 3. application has active VPN configurations installed.
/// 4. application has active NEDNSSettingsManager configurations installed.
///
/// - An application will receive NULL if it is linked against iOS 19.0 SDK (or newer) regardless of fulfillment of the above requirements.
/// - An application that is linked against iOS 12.0 SDK and above must have the "com.apple.developer.networking.wifi-info" entitlement.
/// - An application will receive a pseudo network information if it is linked against an SDK before iOS 13.0, and if it fails to meet any of the
/// above requirements.
/// - An application will receive NULL if it is linked against iOS 13.0 SDK (or newer), and if it fails to meet any of the above requirements.
/// - On Mac Catalyst platform, to receive current Wi-Fi network information, an application must have "com.apple.developer.networking.wifi-info"
/// entitlement and user's authorization to access location.
///
/// Network Information dictionary will contain the following keys, and values:
/// <pre>
///
/// ```text
///     Keys                      : Values
///     =======================================
///     kCNNetworkInfoKeySSIDData : CFDataRef
///     kCNNetworkInfoKeySSID     : CFStringRef
///     kCNNetworkInfoKeyBSSID    : CFStringRef
/// ```
///
/// </pre>
///
/// Pseudo network information will contain "Wi-Fi" SSID and "00:00:00:00:00:00" BSSID. For China region, the SSID will be "WLAN".
///
/// Parameter `interfaceName`: Name of the interface you are interested in
///
/// Returns: Network Information dictionary associated with the interface.
/// Returns NULL if an error was encountered.
/// You MUST release the returned value.
#[deprecated]
#[inline]
pub extern "C-unwind" fn CNCopyCurrentNetworkInfo(
    interface_name: &CFString,
) -> Option<CFRetained<CFDictionary>> {
    extern "C-unwind" {
        fn CNCopyCurrentNetworkInfo(interface_name: &CFString) -> Option<NonNull<CFDictionary>>;
    }
    let ret = unsafe { CNCopyCurrentNetworkInfo(interface_name) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}
