//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ptr::NonNull;
use objc2_core_foundation::*;

use crate::*;

#[cfg(feature = "SCDynamicStore")]
impl SCDynamicStore {
    /// Copies the DHCP information for the requested serviceID,
    /// or the primary service if serviceID == NULL.
    ///
    /// Parameter `store`: An SCDynamicStoreRef representing the dynamic store session
    /// that should be used for communication with the server.
    /// If NULL, a temporary session will be used.
    ///
    /// Parameter `serviceID`: A CFStringRef containing the requested service.
    /// If NULL, returns information for the primary service.
    ///
    /// Returns: Returns a dictionary containing DHCP information if successful;
    /// NULL otherwise.
    /// Use the DHCPInfoGetOption function to retrieve
    /// individual options from the returned dictionary.
    ///
    /// A non-NULL return value must be released using CFRelease().
    #[doc(alias = "SCDynamicStoreCopyDHCPInfo")]
    #[cfg(feature = "SCDynamicStore")]
    #[inline]
    pub fn dhcp_info(
        store: Option<&SCDynamicStore>,
        service_id: Option<&CFString>,
    ) -> Option<CFRetained<CFDictionary>> {
        extern "C-unwind" {
            fn SCDynamicStoreCopyDHCPInfo(
                store: Option<&SCDynamicStore>,
                service_id: Option<&CFString>,
            ) -> Option<NonNull<CFDictionary>>;
        }
        let ret = unsafe { SCDynamicStoreCopyDHCPInfo(store, service_id) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }
}

/// Returns a non-NULL CFDataRef containing the DHCP
/// option data, if present.
///
/// Parameter `info`: The non-NULL DHCP information dictionary returned by
/// calling SCDynamicStoreCopyDHCPInfo.
///
/// Parameter `code`: The DHCP option code (see RFC 2132) to return
/// data for.
///
/// Returns: Returns a non-NULL CFDataRef containing the option data;
/// NULL if the requested option data is not present.
///
/// The return value must NOT be released.
///
/// # Safety
///
/// `info` generics must be of the correct type.
#[inline]
pub unsafe extern "C-unwind" fn DHCPInfoGetOptionData(
    info: &CFDictionary,
    code: u8,
) -> Option<CFRetained<CFData>> {
    extern "C-unwind" {
        fn DHCPInfoGetOptionData(info: &CFDictionary, code: u8) -> Option<NonNull<CFData>>;
    }
    let ret = unsafe { DHCPInfoGetOptionData(info, code) };
    ret.map(|ret| unsafe { CFRetained::retain(ret) })
}

/// Returns a CFDateRef corresponding to the lease start time,
/// if present.
///
/// Parameter `info`: The non-NULL DHCP information dictionary returned by
/// calling SCDynamicStoreCopyDHCPInfo.
///
/// Returns: Returns a non-NULL CFDateRef if lease start time information is
/// present; NULL if the information is not present or if the
/// configuration method is not DHCP.
///
/// The return value must NOT be released.
///
/// # Safety
///
/// `info` generics must be of the correct type.
#[inline]
pub unsafe extern "C-unwind" fn DHCPInfoGetLeaseStartTime(
    info: &CFDictionary,
) -> Option<CFRetained<CFDate>> {
    extern "C-unwind" {
        fn DHCPInfoGetLeaseStartTime(info: &CFDictionary) -> Option<NonNull<CFDate>>;
    }
    let ret = unsafe { DHCPInfoGetLeaseStartTime(info) };
    ret.map(|ret| unsafe { CFRetained::retain(ret) })
}

/// Returns a CFDateRef corresponding to the lease expiration time,
/// if present.
///
/// Parameter `info`: The non-NULL DHCP information dictionary returned by
/// calling SCDynamicStoreCopyDHCPInfo.
///
/// Returns: Returns a non-NULL CFDateRef if the DHCP lease has an expiration;
/// NULL if the lease is infinite i.e. has no expiration, or the
/// configuration method is not DHCP. An infinite lease can be determined
/// by a non-NULL lease start time (see DHCPInfoGetLeaseStartTime above).
///
/// The return value must NOT be released.
///
/// # Safety
///
/// `info` generics must be of the correct type.
#[inline]
pub unsafe extern "C-unwind" fn DHCPInfoGetLeaseExpirationTime(
    info: &CFDictionary,
) -> Option<CFRetained<CFDate>> {
    extern "C-unwind" {
        fn DHCPInfoGetLeaseExpirationTime(info: &CFDictionary) -> Option<NonNull<CFDate>>;
    }
    let ret = unsafe { DHCPInfoGetLeaseExpirationTime(info) };
    ret.map(|ret| unsafe { CFRetained::retain(ret) })
}

#[cfg(feature = "SCDynamicStore")]
#[deprecated = "renamed to `SCDynamicStore::dhcp_info`"]
#[inline]
pub extern "C-unwind" fn SCDynamicStoreCopyDHCPInfo(
    store: Option<&SCDynamicStore>,
    service_id: Option<&CFString>,
) -> Option<CFRetained<CFDictionary>> {
    extern "C-unwind" {
        fn SCDynamicStoreCopyDHCPInfo(
            store: Option<&SCDynamicStore>,
            service_id: Option<&CFString>,
        ) -> Option<NonNull<CFDictionary>>;
    }
    let ret = unsafe { SCDynamicStoreCopyDHCPInfo(store, service_id) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}
