//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::cell::UnsafeCell;
use core::ffi::*;
use core::marker::{PhantomData, PhantomPinned};
use core::ptr::NonNull;
#[cfg(feature = "dispatch2")]
use dispatch2::*;
#[cfg(feature = "objc2")]
use objc2::__framework_prelude::*;
use objc2_core_foundation::*;

use crate::*;

/// This is the handle to manage a connection-oriented service.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/systemconfiguration/scnetworkconnection?language=objc)
#[doc(alias = "SCNetworkConnectionRef")]
#[repr(C)]
pub struct SCNetworkConnection {
    inner: [u8; 0],
    _p: UnsafeCell<PhantomData<(*const UnsafeCell<()>, PhantomPinned)>>,
}

cf_type!(
    unsafe impl SCNetworkConnection {}
);
#[cfg(feature = "objc2")]
cf_objc2_type!(
    unsafe impl RefEncode<"__SCNetworkConnection"> for SCNetworkConnection {}
);

/// Structure containing user-specified data and callbacks
/// for a SCNetworkConnection.
/// Field: version The version number of the structure type being passed
/// in as a parameter to the SCNetworkConnectionCreateWithServiceID
/// function.  This structure is version 0.
/// Field: info A C pointer to a user-specified block of data.
/// Field: retain The callback used to add a retain for the info field.
/// If this parameter is not a pointer to a function of the correct
/// prototype, the behavior is undefined.  The value may be NULL.
/// Field: release The calllback used to remove a retain previously added
/// for the info field.  If this parameter is not a pointer to a
/// function of the correct prototype, the behavior is undefined.
/// The value may be NULL.
/// Field: copyDescription The callback used to provide a description of
/// the info field.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/systemconfiguration/scnetworkconnectioncontext?language=objc)
#[repr(C)]
#[allow(unpredictable_function_pointer_comparisons)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct SCNetworkConnectionContext {
    pub version: CFIndex,
    pub info: *mut c_void,
    pub retain: Option<unsafe extern "C-unwind" fn(NonNull<c_void>) -> NonNull<c_void>>,
    pub release: Option<unsafe extern "C-unwind" fn(NonNull<c_void>)>,
    pub copyDescription: Option<unsafe extern "C-unwind" fn(NonNull<c_void>) -> NonNull<CFString>>,
}

#[cfg(feature = "objc2")]
unsafe impl Encode for SCNetworkConnectionContext {
    const ENCODING: Encoding = Encoding::Struct(
        "?",
        &[
            <CFIndex>::ENCODING,
            <*mut c_void>::ENCODING,
            <Option<unsafe extern "C-unwind" fn(NonNull<c_void>) -> NonNull<c_void>>>::ENCODING,
            <Option<unsafe extern "C-unwind" fn(NonNull<c_void>)>>::ENCODING,
            <Option<unsafe extern "C-unwind" fn(NonNull<c_void>) -> NonNull<CFString>>>::ENCODING,
        ],
    );
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for SCNetworkConnectionContext {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// Status of the network connection.
/// This status is intended to be generic and high level.
/// An extended status, specific to the type of network
/// connection is also available for applications that
/// need additonal information.
///
/// The network connection refers to an invalid service.
///
/// The network connection is disconnected.
///
/// The network connection is connecting.
///
/// The network connection is connected.
///
/// The network connection is disconnecting.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/systemconfiguration/scnetworkconnectionstatus?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct SCNetworkConnectionStatus(pub i32);
impl SCNetworkConnectionStatus {
    #[doc(alias = "kSCNetworkConnectionInvalid")]
    pub const Invalid: Self = Self(-1);
    #[doc(alias = "kSCNetworkConnectionDisconnected")]
    pub const Disconnected: Self = Self(0);
    #[doc(alias = "kSCNetworkConnectionConnecting")]
    pub const Connecting: Self = Self(1);
    #[doc(alias = "kSCNetworkConnectionConnected")]
    pub const Connected: Self = Self(2);
    #[doc(alias = "kSCNetworkConnectionDisconnecting")]
    pub const Disconnecting: Self = Self(3);
}

#[cfg(feature = "objc2")]
unsafe impl Encode for SCNetworkConnectionStatus {
    const ENCODING: Encoding = i32::ENCODING;
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for SCNetworkConnectionStatus {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// PPP-specific status of the network connection.
/// This status is returned as part of the extended information
/// for a PPP service.
/// Note: additional status might be returned in the future.
/// Your application should be prepared to receive an unknown value.
///
/// PPP is disconnected.
///
/// PPP is initializing.
///
/// PPP is connecting the lower connection layer (for example,
/// the modem is dialing out).
///
/// PPP is waiting for networking traffic to automatically
/// establish the connection.
///
/// The PPP lower layer is connected and PPP is negotiating the
/// link layer (LCP protocol).
///
/// PPP is authenticating to the server (PAP, CHAP, MS-CHAP or
/// EAP protocols).
///
/// PPP is waiting for the server to call back.
///
/// PPP is now authenticated and negotiating the networking
/// layer (IPCP or IPv6CP protocols)
///
/// PPP is now fully connected for at least one networking layer.
/// Additional networking protocol might still be negotiating.
///
/// PPP networking and link protocols are terminating.
///
/// PPP is disconnecting the lower level (for example, the modem
/// is hanging up).
///
/// PPP is disconnected and maintaining the link temporarily off.
///
/// PPP is suspended as a result of the suspend command (for
/// example, when a V.92 Modem is On Hold).
///
/// PPP has found a busy server and is waiting for redial.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/systemconfiguration/scnetworkconnectionpppstatus?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct SCNetworkConnectionPPPStatus(pub i32);
impl SCNetworkConnectionPPPStatus {
    #[doc(alias = "kSCNetworkConnectionPPPDisconnected")]
    pub const Disconnected: Self = Self(0);
    #[doc(alias = "kSCNetworkConnectionPPPInitializing")]
    pub const Initializing: Self = Self(1);
    #[doc(alias = "kSCNetworkConnectionPPPConnectingLink")]
    pub const ConnectingLink: Self = Self(2);
    #[doc(alias = "kSCNetworkConnectionPPPDialOnTraffic")]
    pub const DialOnTraffic: Self = Self(3);
    #[doc(alias = "kSCNetworkConnectionPPPNegotiatingLink")]
    pub const NegotiatingLink: Self = Self(4);
    #[doc(alias = "kSCNetworkConnectionPPPAuthenticating")]
    pub const Authenticating: Self = Self(5);
    #[doc(alias = "kSCNetworkConnectionPPPWaitingForCallBack")]
    pub const WaitingForCallBack: Self = Self(6);
    #[doc(alias = "kSCNetworkConnectionPPPNegotiatingNetwork")]
    pub const NegotiatingNetwork: Self = Self(7);
    #[doc(alias = "kSCNetworkConnectionPPPConnected")]
    pub const Connected: Self = Self(8);
    #[doc(alias = "kSCNetworkConnectionPPPTerminating")]
    pub const Terminating: Self = Self(9);
    #[doc(alias = "kSCNetworkConnectionPPPDisconnectingLink")]
    pub const DisconnectingLink: Self = Self(10);
    #[doc(alias = "kSCNetworkConnectionPPPHoldingLinkOff")]
    pub const HoldingLinkOff: Self = Self(11);
    #[doc(alias = "kSCNetworkConnectionPPPSuspended")]
    pub const Suspended: Self = Self(12);
    #[doc(alias = "kSCNetworkConnectionPPPWaitingForRedial")]
    pub const WaitingForRedial: Self = Self(13);
}

#[cfg(feature = "objc2")]
unsafe impl Encode for SCNetworkConnectionPPPStatus {
    const ENCODING: Encoding = i32::ENCODING;
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for SCNetworkConnectionPPPStatus {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// Type of the callback function used when a
/// status event is delivered.
///
/// Parameter `status`: The connection status.
///
/// Parameter `connection`: The connection reference.
///
/// Parameter `info`: Application-specific information.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/systemconfiguration/scnetworkconnectioncallback?language=objc)
pub type SCNetworkConnectionCallBack = Option<
    unsafe extern "C-unwind" fn(
        NonNull<SCNetworkConnection>,
        SCNetworkConnectionStatus,
        *mut c_void,
    ),
>;

unsafe impl ConcreteType for SCNetworkConnection {
    /// Returns the type identifier of all SCNetworkConnection
    /// instances.
    #[doc(alias = "SCNetworkConnectionGetTypeID")]
    #[inline]
    fn type_id() -> CFTypeID {
        extern "C-unwind" {
            fn SCNetworkConnectionGetTypeID() -> CFTypeID;
        }
        unsafe { SCNetworkConnectionGetTypeID() }
    }
}

impl SCNetworkConnection {
    /// Provides the default service ID and a dictionary of user
    /// options for the connection.  Applications can use the
    /// returned serviceID and userOptions values to open a
    /// connection on the fly.
    ///
    /// Parameter `selectionOptions`: Currently unimplemented. Pass NULL for this
    /// version.
    ///
    /// Parameter `serviceID`: Reference to the default serviceID for starting
    /// connections, this value will be returned by the function.
    ///
    /// Parameter `userOptions`: Reference to default userOptions for starting
    /// connections, this will be returned by the function.
    ///
    /// Returns: Returns TRUE if there is a valid service to dial;
    /// FALSE if the function was unable to retrieve a service to dial.
    ///
    /// # Safety
    ///
    /// - `selection_options` generics must be of the correct type.
    /// - `service_id` must be a valid pointer.
    /// - `user_options` must be a valid pointer.
    #[doc(alias = "SCNetworkConnectionCopyUserPreferences")]
    #[inline]
    pub unsafe fn user_preferences(
        selection_options: Option<&CFDictionary>,
        service_id: NonNull<*const CFString>,
        user_options: NonNull<*const CFDictionary>,
    ) -> bool {
        extern "C-unwind" {
            fn SCNetworkConnectionCopyUserPreferences(
                selection_options: Option<&CFDictionary>,
                service_id: NonNull<*const CFString>,
                user_options: NonNull<*const CFDictionary>,
            ) -> Boolean;
        }
        let ret = unsafe {
            SCNetworkConnectionCopyUserPreferences(selection_options, service_id, user_options)
        };
        ret != 0
    }

    /// Creates a new connection reference to use for getting
    /// the status or for connecting or disconnecting the associated
    /// service.
    ///
    /// Parameter `allocator`: The CFAllocator that should be used to allocate
    /// memory for the connection structure.  This parameter may be
    /// NULL in which case the current default CFAllocator is used.
    /// If this reference is not a valid CFAllocator, the behavior
    /// is undefined.
    ///
    /// Parameter `serviceID`: A string that defines the service identifier
    /// of the connection.  Service identifiers uniquely identify
    /// services in the system configuration database.
    ///
    /// Parameter `callout`: The function to be called when the status
    /// of the connection changes.  If this parameter is NULL, the
    /// application will not receive notifications of status change
    /// and will need to poll for updates.
    ///
    /// Parameter `context`: The SCNetworkConnectionContext associated with the
    /// callout.
    ///
    /// Returns: Returns a reference to the new SCNetworkConnection.
    ///
    /// # Safety
    ///
    /// - `callout` must be implemented correctly.
    /// - `context` must be a valid pointer or null.
    #[doc(alias = "SCNetworkConnectionCreateWithServiceID")]
    #[inline]
    pub unsafe fn with_service_id(
        allocator: Option<&CFAllocator>,
        service_id: &CFString,
        callout: SCNetworkConnectionCallBack,
        context: *mut SCNetworkConnectionContext,
    ) -> Option<CFRetained<SCNetworkConnection>> {
        extern "C-unwind" {
            fn SCNetworkConnectionCreateWithServiceID(
                allocator: Option<&CFAllocator>,
                service_id: &CFString,
                callout: SCNetworkConnectionCallBack,
                context: *mut SCNetworkConnectionContext,
            ) -> Option<NonNull<SCNetworkConnection>>;
        }
        let ret = unsafe {
            SCNetworkConnectionCreateWithServiceID(allocator, service_id, callout, context)
        };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    /// Returns the service ID associated with the SCNetworkConnection.
    ///
    /// Parameter `connection`: The SCNetworkConnection to obtain status from.
    ///
    /// Returns: Returns the service ID associated with the SCNetworkConnection.
    #[doc(alias = "SCNetworkConnectionCopyServiceID")]
    #[inline]
    pub fn service_id(&self) -> Option<CFRetained<CFString>> {
        extern "C-unwind" {
            fn SCNetworkConnectionCopyServiceID(
                connection: &SCNetworkConnection,
            ) -> Option<NonNull<CFString>>;
        }
        let ret = unsafe { SCNetworkConnectionCopyServiceID(self) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    /// Returns the status of the SCNetworkConnection.
    /// A status is one of the following values:
    /// <pre>
    ///
    /// ```text
    /// &#32
    ///     kSCNetworkConnectionInvalid
    ///     kSCNetworkConnectionDisconnected
    ///     kSCNetworkConnectionConnecting
    ///     kSCNetworkConnectionDisconnecting
    ///     kSCNetworkConnectionConnected
    /// ```
    ///
    /// </pre>
    ///
    /// Parameter `connection`: The SCNetworkConnection to obtain status from.
    ///
    /// Returns: Returns the status value.
    #[doc(alias = "SCNetworkConnectionGetStatus")]
    #[inline]
    pub fn status(&self) -> SCNetworkConnectionStatus {
        extern "C-unwind" {
            fn SCNetworkConnectionGetStatus(
                connection: &SCNetworkConnection,
            ) -> SCNetworkConnectionStatus;
        }
        unsafe { SCNetworkConnectionGetStatus(self) }
    }

    /// Returns the extended status of the connection.
    /// An extended status dictionary contains specific dictionaries
    /// describing the status for each subcomponent of the service.
    ///
    /// For example, a status dictionary will contain the following
    /// sub-dictionaries, keys, and values:
    /// <pre>
    ///
    /// ```text
    /// &#32
    ///     IPv4  : Addresses      : the assigned IP address.
    /// &#32
    ///     PPP   : Status         : the PPP-specific status of type
    ///                  SCNetworkConnectionPPPStatus.
    /// &#32
    ///         LastCause      : Available when the status is "Disconnected"
    ///                  and contains the last error associated with
    ///                  connecting or disconnecting.
    /// &#32
    ///         ConnectTime    : the time when the connection was
    ///                  established.
    /// &#32
    ///     Modem : ConnectSpeed   : the speed of the modem connection
    ///                  in bits/second.
    /// &#32
    ///     IPSec : Status         : the IPSec-specific status of type
    ///                  SCNetworkConnectionIPSecStatus
    /// &#32
    ///         ConnectTime    : the time when the connection was
    ///                  established.
    ///
    /// ```
    ///
    /// </pre>
    /// Other dictionaries could be present for PPPoE, PPTP, and L2TP.
    ///
    /// The status dictionary may be extended in the future to contain
    /// additional information.
    ///
    /// Parameter `connection`: The SCNetworkConnection to obtain status from.
    ///
    /// Returns: Returns the status dictionary.
    /// If NULL is returned, the error can be retrieved using the SCError function.
    #[doc(alias = "SCNetworkConnectionCopyExtendedStatus")]
    #[inline]
    pub fn extended_status(&self) -> Option<CFRetained<CFDictionary>> {
        extern "C-unwind" {
            fn SCNetworkConnectionCopyExtendedStatus(
                connection: &SCNetworkConnection,
            ) -> Option<NonNull<CFDictionary>>;
        }
        let ret = unsafe { SCNetworkConnectionCopyExtendedStatus(self) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    /// Returns the statistics of the SCNetworkConnection.
    /// A statistic dictionary contains specific dictionaries
    /// with statistics for each subcomponent of the service.
    ///
    /// For example, a statistics dictionary will contain the following
    /// sub-dictionaries, keys, and values:
    /// <pre>
    ///
    /// ```text
    /// &#32
    ///     PPP : BytesIn    :
    ///     PPP : BytesOut   : Contains the number of bytes going up into
    ///                (or coming out of) the network stack for
    ///                any networking protocol without the PPP
    ///                headers and trailers.
    /// &#32
    ///     PPP : PacketsIn  :
    ///     PPP : PacketsOut : Contains the number of packets going up into
    ///                (or coming out of) the network stack for
    ///                any networking protocol without the PPP
    ///                headers and trailers.
    /// &#32
    ///     PPP : ErrorsIn   :
    ///     PPP : ErrorsOut  : Contains the number of errors going up into
    ///                (or coming out of) the network stack for
    ///                any networking protocol without the PPP
    ///                headers and trailers.
    /// ```
    ///
    /// </pre>
    /// The statistics dictionary may be extended in the future to
    /// contain additional information.
    ///
    /// Parameter `connection`: The SCNetworkConnection to obtained statistics from.
    ///
    /// Returns: Returns the statistics dictionary.
    /// If NULL is returned, the error can be retrieved using the SCError function.
    #[doc(alias = "SCNetworkConnectionCopyStatistics")]
    #[inline]
    pub fn statistics(&self) -> Option<CFRetained<CFDictionary>> {
        extern "C-unwind" {
            fn SCNetworkConnectionCopyStatistics(
                connection: &SCNetworkConnection,
            ) -> Option<NonNull<CFDictionary>>;
        }
        let ret = unsafe { SCNetworkConnectionCopyStatistics(self) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    /// Starts the connection for the SCNetworkConnection.
    /// The connection process is asynchronous and the function will
    /// return immediately.  The connection status can be obtained
    /// by polling or by callback.  The connection is made with the
    /// default settings from the administrator.  Some of the settings
    /// can be overridden for the duration of the connection.  These
    /// are specified in an options dictionary.  The options dictionary
    /// uses the same format as a network service defined in the system
    /// configuration preferences schema.
    ///
    /// Note: Starting and stopping of connections is implicitly
    /// arbitrated.  Calling SCNetworkConnectionStart on a connection
    /// already started will indicate that the application has
    /// interest in the connection and it shouldn't be stopped by
    /// anyone else.
    ///
    /// Parameter `connection`: The SCNetworkConnection to start.
    ///
    /// Parameter `userOptions`: The options dictionary to start the connection with.
    /// If userOptions is NULL, the default settings will be used.
    /// If userOptions are specified, they must be in the same format
    /// as network services stored in the system configuration
    /// preferences schema.  The options will override the default
    /// settings defined for the service.
    ///
    /// For security reasons, not all options can be overridden; the
    /// appropriate merging of all settings will be done before the
    /// connection is established, and inappropriate options will be
    /// ignored.
    ///
    /// Parameter `linger`: This parameter indicates whether or not the connection
    /// can stay around when the application no longer has interest
    /// in it.  A typical application should pass FALSE, and the
    /// connection will be automatically stopped when the reference
    /// is released or if the application quits.  If the application
    /// passes TRUE, the application can release the reference or
    /// exit and the connection will be maintained until a timeout
    /// event, until a specific stop request occurs, or until an
    /// error is encountered.
    ///
    /// Returns: Returns TRUE if the connection was correctly started (the
    /// actual connection is not established yet, and the connection
    /// status needs to be periodically checked); FALSE if the
    /// connection request was not started.  The error must be
    /// retrieved from the SCError function.
    ///
    /// # Safety
    ///
    /// `user_options` generics must be of the correct type.
    #[doc(alias = "SCNetworkConnectionStart")]
    #[inline]
    pub unsafe fn start(&self, user_options: Option<&CFDictionary>, linger: bool) -> bool {
        extern "C-unwind" {
            fn SCNetworkConnectionStart(
                connection: &SCNetworkConnection,
                user_options: Option<&CFDictionary>,
                linger: Boolean,
            ) -> Boolean;
        }
        let ret = unsafe { SCNetworkConnectionStart(self, user_options, linger as _) };
        ret != 0
    }

    /// Stops the connection for the SCNetworkConnection.
    /// The disconnection process is asynchronous and the function
    /// will return immediately.  The connection status can be
    /// obtained by polling or by callback.  This function performs
    /// an arbitrated stop of the connection.  If several applications
    /// have marked their interest in the connection, by calling
    /// SCNetworkConnectionStart, the call will succeed but the
    /// actual connection will be maintained until the last interested
    /// application calls SCNetworkConnectionStop.
    ///
    /// In certain cases, you might want to stop the connection anyway.
    /// In these cases, you set the forceDisconnect argument to TRUE.
    ///
    /// Parameter `connection`: The SCNetworkConnection to stop.
    ///
    /// Returns: Returns TRUE if the disconnection request succeeded;
    /// FALSE if the disconnection request failed.
    /// The error must be retrieved from the SCError function.
    #[doc(alias = "SCNetworkConnectionStop")]
    #[inline]
    pub fn stop(&self, force_disconnect: bool) -> bool {
        extern "C-unwind" {
            fn SCNetworkConnectionStop(
                connection: &SCNetworkConnection,
                force_disconnect: Boolean,
            ) -> Boolean;
        }
        let ret = unsafe { SCNetworkConnectionStop(self, force_disconnect as _) };
        ret != 0
    }

    /// Copies the user options used to start the connection.
    /// This is a mechanism a client can use to retrieve the user options
    /// previously passed to the SCNetworkConnectionStart function.
    ///
    /// Parameter `connection`: The SCNetworkConnection to obtain options from.
    ///
    /// Returns: Returns the service dictionary containing the connection options.
    /// The dictionary can be empty if no user options were used.
    /// If NULL is returned, the error can be retrieved using the SCError function.
    #[doc(alias = "SCNetworkConnectionCopyUserOptions")]
    #[inline]
    pub fn user_options(&self) -> Option<CFRetained<CFDictionary>> {
        extern "C-unwind" {
            fn SCNetworkConnectionCopyUserOptions(
                connection: &SCNetworkConnection,
            ) -> Option<NonNull<CFDictionary>>;
        }
        let ret = unsafe { SCNetworkConnectionCopyUserOptions(self) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    /// Schedules a connection with the run loop.
    ///
    /// Parameter `connection`: The SCNetworkConnection to schedule.
    ///
    /// Parameter `runLoop`: The run loop to schedule with.
    ///
    /// Parameter `runLoopMode`: The run loop mode.
    ///
    /// Returns: Returns TRUE if the connection is scheduled successfully;
    /// FALSE if the scheduling failed.
    /// The error can be retrieved using the SCError function.
    #[doc(alias = "SCNetworkConnectionScheduleWithRunLoop")]
    #[inline]
    pub fn schedule_with_run_loop(&self, run_loop: &CFRunLoop, run_loop_mode: &CFString) -> bool {
        extern "C-unwind" {
            fn SCNetworkConnectionScheduleWithRunLoop(
                connection: &SCNetworkConnection,
                run_loop: &CFRunLoop,
                run_loop_mode: &CFString,
            ) -> Boolean;
        }
        let ret = unsafe { SCNetworkConnectionScheduleWithRunLoop(self, run_loop, run_loop_mode) };
        ret != 0
    }

    /// Unschedules a connection from the run loop.
    ///
    /// Parameter `connection`: The SCNetworkConnection to unschedule.
    ///
    /// Parameter `runLoop`: The run loop to unschedule from.
    ///
    /// Parameter `runLoopMode`: The run loop mode.
    ///
    /// Returns: Returns TRUE if the connection is unscheduled successfully;
    /// FALSE if the unscheduling failed.
    /// The error can be retrieved using the SCError function.
    #[doc(alias = "SCNetworkConnectionUnscheduleFromRunLoop")]
    #[inline]
    pub fn unschedule_from_run_loop(&self, run_loop: &CFRunLoop, run_loop_mode: &CFString) -> bool {
        extern "C-unwind" {
            fn SCNetworkConnectionUnscheduleFromRunLoop(
                connection: &SCNetworkConnection,
                run_loop: &CFRunLoop,
                run_loop_mode: &CFString,
            ) -> Boolean;
        }
        let ret =
            unsafe { SCNetworkConnectionUnscheduleFromRunLoop(self, run_loop, run_loop_mode) };
        ret != 0
    }

    /// Caller provides a dispatch queue on which the callback contained in connection will run.
    ///
    /// Parameter `connection`: The SCNetworkConnection to notify.
    ///
    /// Parameter `queue`: The libdispatch queue to run the callback on.
    /// Pass NULL to disable notifications, and release queue.
    ///
    /// Returns: Returns TRUE if the notifications have been enabled/disabled as desired;
    /// FALSE if not.
    /// The error can be retrieved using the SCError function.
    ///
    /// # Safety
    ///
    /// `queue` possibly has additional threading requirements.
    #[doc(alias = "SCNetworkConnectionSetDispatchQueue")]
    #[cfg(feature = "dispatch2")]
    #[inline]
    pub unsafe fn set_dispatch_queue(&self, queue: Option<&DispatchQueue>) -> bool {
        extern "C-unwind" {
            fn SCNetworkConnectionSetDispatchQueue(
                connection: &SCNetworkConnection,
                queue: Option<&DispatchQueue>,
            ) -> Boolean;
        }
        let ret = unsafe { SCNetworkConnectionSetDispatchQueue(self, queue) };
        ret != 0
    }
}

#[deprecated = "renamed to `SCNetworkConnection::user_preferences`"]
#[inline]
pub unsafe extern "C-unwind" fn SCNetworkConnectionCopyUserPreferences(
    selection_options: Option<&CFDictionary>,
    service_id: NonNull<*const CFString>,
    user_options: NonNull<*const CFDictionary>,
) -> bool {
    extern "C-unwind" {
        fn SCNetworkConnectionCopyUserPreferences(
            selection_options: Option<&CFDictionary>,
            service_id: NonNull<*const CFString>,
            user_options: NonNull<*const CFDictionary>,
        ) -> Boolean;
    }
    let ret = unsafe {
        SCNetworkConnectionCopyUserPreferences(selection_options, service_id, user_options)
    };
    ret != 0
}

#[deprecated = "renamed to `SCNetworkConnection::with_service_id`"]
#[inline]
pub unsafe extern "C-unwind" fn SCNetworkConnectionCreateWithServiceID(
    allocator: Option<&CFAllocator>,
    service_id: &CFString,
    callout: SCNetworkConnectionCallBack,
    context: *mut SCNetworkConnectionContext,
) -> Option<CFRetained<SCNetworkConnection>> {
    extern "C-unwind" {
        fn SCNetworkConnectionCreateWithServiceID(
            allocator: Option<&CFAllocator>,
            service_id: &CFString,
            callout: SCNetworkConnectionCallBack,
            context: *mut SCNetworkConnectionContext,
        ) -> Option<NonNull<SCNetworkConnection>>;
    }
    let ret =
        unsafe { SCNetworkConnectionCreateWithServiceID(allocator, service_id, callout, context) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[deprecated = "renamed to `SCNetworkConnection::service_id`"]
#[inline]
pub extern "C-unwind" fn SCNetworkConnectionCopyServiceID(
    connection: &SCNetworkConnection,
) -> Option<CFRetained<CFString>> {
    extern "C-unwind" {
        fn SCNetworkConnectionCopyServiceID(
            connection: &SCNetworkConnection,
        ) -> Option<NonNull<CFString>>;
    }
    let ret = unsafe { SCNetworkConnectionCopyServiceID(connection) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[deprecated = "renamed to `SCNetworkConnection::status`"]
#[inline]
pub extern "C-unwind" fn SCNetworkConnectionGetStatus(
    connection: &SCNetworkConnection,
) -> SCNetworkConnectionStatus {
    extern "C-unwind" {
        fn SCNetworkConnectionGetStatus(
            connection: &SCNetworkConnection,
        ) -> SCNetworkConnectionStatus;
    }
    unsafe { SCNetworkConnectionGetStatus(connection) }
}

#[deprecated = "renamed to `SCNetworkConnection::extended_status`"]
#[inline]
pub extern "C-unwind" fn SCNetworkConnectionCopyExtendedStatus(
    connection: &SCNetworkConnection,
) -> Option<CFRetained<CFDictionary>> {
    extern "C-unwind" {
        fn SCNetworkConnectionCopyExtendedStatus(
            connection: &SCNetworkConnection,
        ) -> Option<NonNull<CFDictionary>>;
    }
    let ret = unsafe { SCNetworkConnectionCopyExtendedStatus(connection) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[deprecated = "renamed to `SCNetworkConnection::statistics`"]
#[inline]
pub extern "C-unwind" fn SCNetworkConnectionCopyStatistics(
    connection: &SCNetworkConnection,
) -> Option<CFRetained<CFDictionary>> {
    extern "C-unwind" {
        fn SCNetworkConnectionCopyStatistics(
            connection: &SCNetworkConnection,
        ) -> Option<NonNull<CFDictionary>>;
    }
    let ret = unsafe { SCNetworkConnectionCopyStatistics(connection) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[deprecated = "renamed to `SCNetworkConnection::start`"]
#[inline]
pub unsafe extern "C-unwind" fn SCNetworkConnectionStart(
    connection: &SCNetworkConnection,
    user_options: Option<&CFDictionary>,
    linger: bool,
) -> bool {
    extern "C-unwind" {
        fn SCNetworkConnectionStart(
            connection: &SCNetworkConnection,
            user_options: Option<&CFDictionary>,
            linger: Boolean,
        ) -> Boolean;
    }
    let ret = unsafe { SCNetworkConnectionStart(connection, user_options, linger as _) };
    ret != 0
}

#[deprecated = "renamed to `SCNetworkConnection::stop`"]
#[inline]
pub extern "C-unwind" fn SCNetworkConnectionStop(
    connection: &SCNetworkConnection,
    force_disconnect: bool,
) -> bool {
    extern "C-unwind" {
        fn SCNetworkConnectionStop(
            connection: &SCNetworkConnection,
            force_disconnect: Boolean,
        ) -> Boolean;
    }
    let ret = unsafe { SCNetworkConnectionStop(connection, force_disconnect as _) };
    ret != 0
}

#[deprecated = "renamed to `SCNetworkConnection::user_options`"]
#[inline]
pub extern "C-unwind" fn SCNetworkConnectionCopyUserOptions(
    connection: &SCNetworkConnection,
) -> Option<CFRetained<CFDictionary>> {
    extern "C-unwind" {
        fn SCNetworkConnectionCopyUserOptions(
            connection: &SCNetworkConnection,
        ) -> Option<NonNull<CFDictionary>>;
    }
    let ret = unsafe { SCNetworkConnectionCopyUserOptions(connection) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[deprecated = "renamed to `SCNetworkConnection::schedule_with_run_loop`"]
#[inline]
pub extern "C-unwind" fn SCNetworkConnectionScheduleWithRunLoop(
    connection: &SCNetworkConnection,
    run_loop: &CFRunLoop,
    run_loop_mode: &CFString,
) -> bool {
    extern "C-unwind" {
        fn SCNetworkConnectionScheduleWithRunLoop(
            connection: &SCNetworkConnection,
            run_loop: &CFRunLoop,
            run_loop_mode: &CFString,
        ) -> Boolean;
    }
    let ret =
        unsafe { SCNetworkConnectionScheduleWithRunLoop(connection, run_loop, run_loop_mode) };
    ret != 0
}

#[deprecated = "renamed to `SCNetworkConnection::unschedule_from_run_loop`"]
#[inline]
pub extern "C-unwind" fn SCNetworkConnectionUnscheduleFromRunLoop(
    connection: &SCNetworkConnection,
    run_loop: &CFRunLoop,
    run_loop_mode: &CFString,
) -> bool {
    extern "C-unwind" {
        fn SCNetworkConnectionUnscheduleFromRunLoop(
            connection: &SCNetworkConnection,
            run_loop: &CFRunLoop,
            run_loop_mode: &CFString,
        ) -> Boolean;
    }
    let ret =
        unsafe { SCNetworkConnectionUnscheduleFromRunLoop(connection, run_loop, run_loop_mode) };
    ret != 0
}

#[cfg(feature = "dispatch2")]
#[deprecated = "renamed to `SCNetworkConnection::set_dispatch_queue`"]
#[inline]
pub unsafe extern "C-unwind" fn SCNetworkConnectionSetDispatchQueue(
    connection: &SCNetworkConnection,
    queue: Option<&DispatchQueue>,
) -> bool {
    extern "C-unwind" {
        fn SCNetworkConnectionSetDispatchQueue(
            connection: &SCNetworkConnection,
            queue: Option<&DispatchQueue>,
        ) -> Boolean;
    }
    let ret = unsafe { SCNetworkConnectionSetDispatchQueue(connection, queue) };
    ret != 0
}
