/*
    SPDX-FileCopyrightText: 2009, 2010, 2012 Martin Gräßlin <mgraesslin@kde.org>
    SPDX-FileCopyrightText: 2025 Vlad Zahorodnii <vlad.zahorodnii@kde.org>

    SPDX-License-Identifier: GPL-2.0-or-later
*/

#pragma once

#include "decorationbuttongroup.h"

#include <KDecoration3/Decoration>
#include <KSharedConfig>

namespace KSvg
{
class FrameSvg;
}

namespace Aurorae
{

class DecorationTheme;

class Decoration : public KDecoration3::Decoration
{
    Q_OBJECT

public:
    explicit Decoration(QObject *parent = nullptr, const QVariantList &args = QVariantList());
    ~Decoration() override;

    qreal buttonSizeFactor() const;
    void setButtonSizeFactor(qreal factor);

    void paint(QPainter *painter, const QRectF &repaintRegion) override;

public Q_SLOTS:
    bool init() override;

Q_SIGNALS:
    void buttonSizeFactorChanged();

private:
    void onWindowActiveChanged();
    void onWindowSizeChanged();
    void onWindowMaximizedChanged();
    void onWindowCaptionChanged();
    void onWindowScaleChanged();

    void onDecorationBordersChanged();
    void onDecorationSettingsChanged();

    KDecoration3::DecorationButton *instantiateButton(KDecoration3::DecorationButtonType type, KDecoration3::Decoration *decoration, QObject *parent) const;

    void updateButtonSizeFactor();
    void updateBorders();
    void updateResizeOnlyBorders();
    void updateSize();
    void updateTitleBar();
    void updateCaption();
    void positionButtons();
    void updateDecoration();
    void updateInnerBorder();
    void updateShadow();
    void updateBlur();

    void setCurrentDecoration(KSvg::FrameSvg *decoration);
    void setCurrentInnerBorder(KSvg::FrameSvg *innerBorder);

    KSharedConfigPtr m_auroraerc;
    std::shared_ptr<DecorationTheme> m_theme;
    QString m_themeName;

    std::unique_ptr<KSvg::FrameSvg> m_decoration;
    std::unique_ptr<KSvg::FrameSvg> m_decorationInactive;
    std::unique_ptr<KSvg::FrameSvg> m_decorationMaximized;
    std::unique_ptr<KSvg::FrameSvg> m_decorationMaximizedInactive;
    std::unique_ptr<KSvg::FrameSvg> m_innerBorder;
    std::unique_ptr<KSvg::FrameSvg> m_innerBorderInactive;
    std::unique_ptr<KSvg::FrameSvg> m_blur;

    KSvg::FrameSvg *m_currentDecoration = nullptr;
    KSvg::FrameSvg *m_currentInnerBorder = nullptr;

    std::unique_ptr<DecorationButtonGroup> m_leftButtons;
    std::unique_ptr<DecorationButtonGroup> m_rightButtons;
    std::unique_ptr<QTimer> m_buttonsTimer;

    QRectF m_captionRect;
    qreal m_buttonSizeFactor = 1.0;

    std::shared_ptr<KDecoration3::DecorationShadow> m_shadow;
    KSvg::FrameSvg *m_shadowSvg = nullptr;
};

} // namespace Aurorae
