/*
 * Decompiled with CFR 0.152.
 */
package org.mvel.tests.perftests;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import junit.framework.TestCase;
import org.mvel.MVEL;
import org.mvel.integration.impl.MapVariableResolverFactory;
import org.mvel.tests.main.CoreConfidenceTests;
import org.mvel.tests.main.res.Bar;
import org.mvel.tests.main.res.Base;
import org.mvel.tests.main.res.Foo;

public class CompiledPerformanceTests
extends TestCase {
    private static final int ITERATIONS = 1000000;
    protected Foo foo = new Foo();
    protected Map<String, Object> map = new HashMap<String, Object>();
    protected Base base = new Base();

    public CompiledPerformanceTests() {
        this.foo.setBar(new Bar());
        this.map.put("foo", this.foo);
        this.map.put("a", null);
        this.map.put("b", null);
        this.map.put("c", "cat");
        this.map.put("BWAH", "");
        this.map.put("misc", new CoreConfidenceTests.MiscTestClass());
        this.map.put("pi", "3.14");
        this.map.put("hour", "60");
        this.map.put("zero", 0);
    }

    public void testToListBenchmark() {
        String text = "misc.toList(foo.bar.name, 'hello', 42, ['key1' : 'value1', c : [ foo.bar.age, 'car', 42 ]], [42, [c : 'value1']] )";
        MapVariableResolverFactory variableTable = new MapVariableResolverFactory(this.map);
        Serializable compiled = MVEL.compileExpression(text);
        for (int i = 0; i < 1000000; ++i) {
            MVEL.executeExpression((Object)compiled, variableTable);
        }
        CompiledPerformanceTests.assertEquals((int)1000000, (int)((CoreConfidenceTests.MiscTestClass)this.map.get("misc")).getExec());
    }

    public void testToListBenchmark2() {
        this.testToListBenchmark();
    }

    public void testToListBenchmark3() {
        this.testToListBenchmark();
    }
}

