/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.testng.TestNGException;
import org.testng.internal.BaseTestMethod;
import org.testng.internal.Parameters;
import org.testng.internal.annotations.IAnnotationFinder;
import org.testng.xml.XmlTest;

public class FactoryMethod
extends BaseTestMethod {
    private Object m_instance = null;
    private XmlTest m_xmlTest = null;

    public FactoryMethod(Method method, Object instance, XmlTest xmlTest, IAnnotationFinder annotationFinder) {
        super(method, annotationFinder);
        if (!instance.getClass().isAssignableFrom(method.getDeclaringClass())) {
            throw new TestNGException("Mismatch between instance/method classes:" + instance.getClass() + " " + method.getDeclaringClass());
        }
        this.m_instance = instance;
        this.m_xmlTest = xmlTest;
    }

    public Object[] invoke() {
        Object[] result = new Object[]{};
        Object[] parameters = Parameters.createFactoryParameters(this.getMethod(), this.m_xmlTest.getParameters(), this.getAnnotationFinder(), this.m_xmlTest.getSuite());
        try {
            result = (Object[])this.getMethod().invoke(this.m_instance, parameters);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return result;
    }
}

