/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import bsh.EvalError;
import bsh.Interpreter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.testng.IMethodSelector;
import org.testng.ITestNGMethod;
import org.testng.TestRunner;
import org.testng.internal.ClassHelper;
import org.testng.internal.MethodHelper;
import org.testng.internal.Utils;
import org.testng.xml.XmlClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlMethodSelector
implements IMethodSelector {
    private Map<String, String> m_includedGroups = new HashMap<String, String>();
    private Map<String, String> m_excludedGroups = new HashMap<String, String>();
    private List<XmlClass> m_classes = null;
    private String m_expression = null;
    private Map<String, String> m_includedMethods = new HashMap<String, String>();
    private Map<String, String> m_logged = new HashMap<String, String>();
    private boolean m_verbose = true;

    @Override
    public boolean includeMethod(ITestNGMethod tm, boolean isTestMethod) {
        boolean result = false;
        result = null != this.m_expression ? this.includeMethodFromExpression(tm, isTestMethod) : this.includeMethodFromIncludeExclude(tm, isTestMethod);
        return result;
    }

    private boolean includeMethodFromExpression(ITestNGMethod tm, boolean isTestMethod) {
        boolean result = false;
        Interpreter interpreter = new Interpreter();
        try {
            HashMap<String, String> groups = new HashMap<String, String>();
            for (String group : tm.getGroups()) {
                groups.put(group, group);
            }
            interpreter.set("method", tm.getMethod());
            interpreter.set("groups", groups);
            interpreter.set("testngMethod", tm);
            Object evalResult = interpreter.eval(this.m_expression);
            result = (Boolean)evalResult;
        }
        catch (EvalError e) {
            e.printStackTrace();
        }
        return result;
    }

    private boolean includeMethodFromIncludeExclude(ITestNGMethod tm, boolean isTestMethod) {
        boolean result = false;
        Method m = tm.getMethod();
        String[] groups = tm.getGroups();
        Map<String, String> includedGroups = this.m_includedGroups;
        Map<String, String> excludedGroups = this.m_excludedGroups;
        if (includedGroups.size() == 0 && excludedGroups.size() == 0 && !this.hasIncludedMethods() && !this.hasExcludedMethods()) {
            result = true;
        } else if (includedGroups.size() == 0 && excludedGroups.size() == 0 && !isTestMethod) {
            result = true;
        } else if (this.m_includedMethods.containsKey(MethodHelper.calculateMethodCanonicalName(tm))) {
            result = true;
        } else {
            boolean isIncludedInGroups = XmlMethodSelector.isIncluded(groups, this.m_includedGroups.values());
            boolean isExcludedInGroups = XmlMethodSelector.isExcluded(groups, this.m_excludedGroups.values());
            if (isIncludedInGroups && !isExcludedInGroups) {
                result = true;
            } else if (isExcludedInGroups) {
                result = false;
            }
            if (isTestMethod) {
                Method method = tm.getMethod();
                Class<?> methodClass = method.getDeclaringClass();
                String fullMethodName = methodClass.getName() + "." + method.getName();
                String[] fullyQualifiedMethodName = new String[]{fullMethodName};
                for (XmlClass xmlClass : this.m_classes) {
                    Class cls = ClassHelper.forName(xmlClass.getName());
                    if (null == cls) {
                        Utils.log("XmlMethodSelector", 1, "Cannot find class in classpath " + xmlClass.getName());
                        continue;
                    }
                    if (!cls.isAssignableFrom(methodClass) && !methodClass.isAssignableFrom(cls)) continue;
                    List<String> includedMethods = this.createQualifiedMethodNames(xmlClass, xmlClass.getIncludedMethods());
                    boolean isIncludedInMethods = XmlMethodSelector.isIncluded(fullyQualifiedMethodName, includedMethods);
                    List<String> excludedMethods = this.createQualifiedMethodNames(xmlClass, xmlClass.getExcludedMethods());
                    boolean isExcludedInMethods = XmlMethodSelector.isExcluded(fullyQualifiedMethodName, excludedMethods);
                    if (!result) continue;
                    result = isIncludedInMethods && !isExcludedInMethods;
                }
            }
        }
        Package pkg = m.getDeclaringClass().getPackage();
        String methodName = pkg != null ? pkg.getName() + "." + m.getName() : m.getName();
        this.logInclusion(result ? "Including" : "Excluding", "method", methodName + "()");
        return result;
    }

    private void logInclusion(String including, String type, String name) {
        if (!this.m_logged.containsKey(name)) {
            XmlMethodSelector.log(3, including + " " + type + " " + name);
            this.m_logged.put(name, name);
        }
    }

    private boolean hasIncludedMethods() {
        for (XmlClass xmlClass : this.m_classes) {
            if (xmlClass.getIncludedMethods().size() <= 0) continue;
            return true;
        }
        return false;
    }

    private boolean hasExcludedMethods() {
        for (XmlClass xmlClass : this.m_classes) {
            if (xmlClass.getExcludedMethods().size() <= 0) continue;
            return true;
        }
        return false;
    }

    private List<String> createQualifiedMethodNames(XmlClass xmlClass, List<String> methods) {
        ArrayList<String> vResult = new ArrayList<String>();
        for (Class cls = xmlClass.getSupportClass(); null != cls; cls = cls.getSuperclass()) {
            for (String methodName : methods) {
                Method[] allMethods = cls.getDeclaredMethods();
                Pattern pattern = Pattern.compile(methodName);
                for (Method m : allMethods) {
                    if (!pattern.matcher(m.getName()).matches()) continue;
                    vResult.add(cls.getName() + "." + m.getName());
                }
            }
        }
        return vResult;
    }

    public void setXmlClasses(List<XmlClass> classes) {
        this.m_classes = classes;
    }

    public Map<String, String> getExcludedGroups() {
        return this.m_excludedGroups;
    }

    public Map<String, String> getIncludedGroups() {
        return this.m_includedGroups;
    }

    public void setExcludedGroups(Map<String, String> excludedGroups) {
        this.m_excludedGroups = excludedGroups;
    }

    public void setIncludedGroups(Map<String, String> includedGroups) {
        this.m_includedGroups = includedGroups;
    }

    private static boolean isIncluded(String[] groups, Collection<String> includedGroups) {
        if (includedGroups.size() == 0) {
            return true;
        }
        return XmlMethodSelector.isMemberOf(groups, includedGroups);
    }

    private static boolean isExcluded(String[] groups, Collection<String> excludedGroups) {
        return XmlMethodSelector.isMemberOf(groups, excludedGroups);
    }

    private static boolean isMemberOf(String[] groups, Collection<String> list) {
        for (String group : groups) {
            for (String o : list) {
                String regexpStr = o.toString();
                boolean match = Pattern.matches(regexpStr, group);
                if (!match) continue;
                return true;
            }
        }
        return false;
    }

    private static void log(int level, String s) {
        if (level <= TestRunner.getVerbose()) {
            XmlMethodSelector.ppp(s);
        }
    }

    private static void ppp(String s) {
        System.out.println("[XmlMethodSelector] " + s);
    }

    public void setExpression(String expression) {
        this.m_expression = expression;
    }

    @Override
    public void setTestMethods(List<ITestNGMethod> testMethods) {
        String[] groups = this.m_includedGroups.keySet().toArray(new String[this.m_includedGroups.size()]);
        HashSet<String> groupClosure = new HashSet<String>();
        HashSet<ITestNGMethod> methodClosure = new HashSet<ITestNGMethod>();
        ArrayList<ITestNGMethod> includedMethods = new ArrayList<ITestNGMethod>();
        for (ITestNGMethod m : testMethods) {
            if (!this.includeMethod(m, true)) continue;
            includedMethods.add(m);
        }
        MethodHelper.findGroupTransitiveClosure(this, includedMethods, testMethods, groups, groupClosure, methodClosure);
        if (this.m_includedGroups.size() > 0) {
            this.m_includedGroups = new HashMap<String, String>();
            for (String g : groupClosure) {
                this.m_includedGroups.put(g, g);
                XmlMethodSelector.log(3, "Including group " + (this.m_includedGroups.containsKey(g) ? ": " : "(implicit): ") + g);
            }
            for (ITestNGMethod m : methodClosure) {
                String methodName = m.getMethod().getDeclaringClass().getName() + "." + m.getMethodName();
                this.m_includedMethods.put(methodName, methodName);
                this.logInclusion("Including", "method ", methodName);
            }
        }
    }

    private ITestNGMethod[] filterTestMethods(List<ITestNGMethod> methods) {
        ArrayList<ITestNGMethod> vResult = new ArrayList<ITestNGMethod>();
        for (ITestNGMethod m : methods) {
            if (!this.includeMethod(m, true)) continue;
            vResult.add(m);
        }
        return vResult.toArray(new ITestNGMethod[vResult.size()]);
    }

    public void setVerbose(boolean b) {
        this.m_verbose = b;
    }
}

