%ifdef CONFIG
{
  "HostFeatures": ["AVX"],
  "RegData": {
    "RAX": "0x1111111111111111",
    "RBX": "0x2222222222222222",
    "RCX": "0x3333333333333333",
    "RDX": "0x4444444444444444",
    "RSI": "0x5555555555555555",
    "RDI": "0x6666666666666666",
    "MM0": "0x1112131415161718",
    "MM1": "0x2122232425262728",
    "MM2": "0x3132333435363738",
    "MM3": "0x4142434445464748",
    "MM4": "0x5152535455565758",
    "MM5": "0x6162636465666768",
    "MM6": "0x7172737475767778",
    "MM7": "0x8182838485868788",
    "XMM0":  ["0x0000000000000000", "0x0000000000000000", "0xA1A2A3A4A5A6A7AA", "0xABFD392482039840"],
    "XMM1":  ["0x0000000000000000", "0x0000000000000000", "0x4142434445464748", "0x3987432929293847"],
    "XMM2":  ["0x0000000000000000", "0x0000000000000000", "0x6162636465666768", "0xACDEFACDEFACDEFA"],
    "XMM3":  ["0x0000000000000000", "0x0000000000000000", "0x3132333435363738", "0xEADC3284ADCE9339"],
    "XMM4":  ["0x0000000000000000", "0x0000000000000000", "0x7172737475767778", "0x3459238471238023"],
    "XMM5":  ["0x0000000000000000", "0x0000000000000000", "0xA1AAA3A4A5A6A7A8", "0x3784769228479192"],
    "XMM6":  ["0x0000000000000000", "0x0000000000000000", "0x6162636465666768", "0xACDEFACDEFACDEFA"],
    "XMM7":  ["0x0000000000000000", "0x0000000000000000", "0x6162636465666768", "0xACDEFACDEFACDEFA"],
    "XMM8":  ["0x0000000000000000", "0x0000000000000000", "0xD1D2D3D4DDD6D7D8", "0x3674823989ADEF73"],
    "XMM9":  ["0x0000000000000000", "0x0000000000000000", "0xB1B2B3B4B5B6BBB8", "0xADEADE3894353499"],
    "XMM10": ["0x0000000000000000", "0x0000000000000000", "0xD1D2D3D4DDD6D7D8", "0x3674823989ADEF73"],
    "XMM11": ["0x0000000000000000", "0x0000000000000000", "0xB1B2B3B4B5B6BBB8", "0xADEADE3894353499"],
    "XMM12": ["0x0000000000000000", "0x0000000000000000", "0xA1AAA3A4A5A6A7A8", "0x3784769228479192"],
    "XMM13": ["0x0000000000000000", "0x0000000000000000", "0x6162636465666768", "0xACDEFACDEFACDEFA"],
    "XMM14": ["0x0000000000000000", "0x0000000000000000", "0xE1E2E3EEE5E6E7E8", "0x3756438328472389"],
    "XMM15": ["0x0000000000000000", "0x0000000000000000", "0xB1B2B3B4B5B6BBB8", "0xADEADE3894353499"]
  }
}
%endif

%define IS_AVX
%include "xsave_macros.mac"

mov rsp, 0xE0000000

; Set up MMX and XMM state
set_up_mmx_state .xmm_data
set_up_xmm_state .xmm_data

overwrite_fxsave_slots

; Now save our state (X87 and AVX only)
mov eax, 0b101
xsave [rsp]

; Corrupt MMX And XMM state
corrupt_mmx_and_xmm_registers

; Now reload the state we just saved
xrstor [rsp]

; Load the three 16bytes of "available" slots to make sure it wasn't overwritten
; Reserved can be overwritten regardless
load_fxsave_slots

hlt

; Give ourselves a region of 1000 bytes set to 0xFF
align 64
.xsave_data:
  times 1000 db 0xFF

define_xmm_data_section
