%ifdef CONFIG
{
  "HostFeatures": ["AVX"],
  "RegData": {
    "XMM0": ["0x400000003F800000", "0x4080000040400000", "0x400000003F800000", "0x4080000040400000"],
    "XMM1": ["0x40C0000040A00000", "0x4100000040E00000", "0x40C0000040A00000", "0x4100000040E00000"],
    "XMM2": ["0x40C0000040A00000", "0x4100000040E00000", "0x0000000000000000", "0x0000000000000000"],
    "XMM3": ["0x40C0000040A00000", "0x4100000040E00000", "0x0000000000000000", "0x0000000000000000"],
    "XMM4": ["0x40C0000040A00000", "0x4100000040E00000", "0x40C0000040A00000", "0x4100000040E00000"],
    "XMM5": ["0x40C0000040A00000", "0x4100000040E00000", "0x40C0000040A00000", "0x4100000040E00000"]
  }
}
%endif

lea rdx, [rel .data]

vmovapd ymm0, [rdx]
vmovapd ymm1, [rdx + 32]

; Memory operand
vmaxps xmm2, xmm0, [rdx + 32]
vmaxps ymm4, ymm0, [rdx + 32]

; Register only
vmaxps xmm3, xmm0, xmm1
vmaxps ymm5, ymm1, ymm0

hlt

align 32
.data:
dq 0x400000003F800000 ; 2, 1
dq 0x4080000040400000 ; 4, 3
dq 0x400000003F800000 ; 2, 1
dq 0x4080000040400000 ; 4, 3

dq 0x40C0000040A00000 ; 6, 5
dq 0x4100000040E00000 ; 8, 7
dq 0x40C0000040A00000 ; 6, 5
dq 0x4100000040E00000 ; 8, 7
