%ifdef CONFIG
{
  "HostFeatures": ["AVX"],
  "RegData": {
    "XMM4":  ["0x0202020202020202", "0x0000000000000000", "0x0000000000000000", "0x0000000000000000"],
    "XMM5":  ["0x0000000000000000", "0x0202020202020202", "0x0000000000000000", "0x0000000000000000"],
    "XMM6":  ["0xFF01FF0100FF00FF", "0x0000000000000000", "0x0000000000000000", "0x0000000000000000"],
    "XMM7":  ["0x0000000000000000", "0xFF01FF0100FF00FF", "0x0000000000000000", "0x0000000000000000"],
    "XMM8":  ["0x0202020202020202", "0xFF01FF0100FF00FF", "0x0000000000000000", "0x0000000000000000"],
    "XMM9":  ["0x0000000000000000", "0x0000000000000000", "0x0000000000000000", "0x0000000000000000"],
    "XMM10": ["0xFF01FF0100FF00FF", "0x0000000000000000", "0x0000000000000000", "0x0000000000000000"],
    "XMM11": ["0x800080007FFF7FFF", "0x800080007FFF7FFF", "0x0000000000000000", "0x0000000000000000"]
  }
}
%endif

lea rdx, [rel .data]

vmovaps ymm0, [rdx]
vmovaps ymm1, [rdx + 32]
vmovaps ymm2, [rdx + 32 * 2]
vmovaps ymm3, [rdx + 32 * 3]

vphsubsw xmm4, xmm0, [rdx + 32]
vphsubsw xmm5, xmm1, [rdx]

vphsubsw xmm6, xmm2, [rdx + 32]
vphsubsw xmm7, xmm1, [rdx + 32 * 2]

vphsubsw xmm8, xmm0, [rdx + 32 * 2]
vphsubsw xmm9, xmm1, [rdx + 32]

vphsubsw xmm10, xmm2, [rdx + 32]
vphsubsw xmm11, xmm3, [rdx + 32 * 3]

hlt

align 32
.data:
dq 0x4142434445464748
dq 0x5152535455565758
dq 0x6162636465666768
dq 0x7172737475767778

dq 0x7F7F7F7F7F7F7F7F
dq 0x8080808080808080
dq 0x8080808080808080
dq 0x7F7F7F7F7F7F7F7F

dq 0x2119221823172416
dq 0x3941384237433644
dq 0x4598654387293847
dq 0x7620937492893892

dq 0x00007FFF00007FFF
dq 0x7FFFFFFF7FFFFFFF
dq 0x7FFFFFFF7FFFFFFF
dq 0x00007FFF00007FFF
