﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/appfabric/AppFabric_EXPORTS.h>
#include <aws/appfabric/model/IngestionState.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace AppFabric {
namespace Model {

/**
 * <p>Contains a summary of an ingestion.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/IngestionSummary">AWS
 * API Reference</a></p>
 */
class IngestionSummary {
 public:
  AWS_APPFABRIC_API IngestionSummary() = default;
  AWS_APPFABRIC_API IngestionSummary(Aws::Utils::Json::JsonView jsonValue);
  AWS_APPFABRIC_API IngestionSummary& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_APPFABRIC_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) of the ingestion.</p>
   */
  inline const Aws::String& GetArn() const { return m_arn; }
  inline bool ArnHasBeenSet() const { return m_arnHasBeenSet; }
  template <typename ArnT = Aws::String>
  void SetArn(ArnT&& value) {
    m_arnHasBeenSet = true;
    m_arn = std::forward<ArnT>(value);
  }
  template <typename ArnT = Aws::String>
  IngestionSummary& WithArn(ArnT&& value) {
    SetArn(std::forward<ArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the application.</p>
   */
  inline const Aws::String& GetApp() const { return m_app; }
  inline bool AppHasBeenSet() const { return m_appHasBeenSet; }
  template <typename AppT = Aws::String>
  void SetApp(AppT&& value) {
    m_appHasBeenSet = true;
    m_app = std::forward<AppT>(value);
  }
  template <typename AppT = Aws::String>
  IngestionSummary& WithApp(AppT&& value) {
    SetApp(std::forward<AppT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The ID of the application tenant.</p>
   */
  inline const Aws::String& GetTenantId() const { return m_tenantId; }
  inline bool TenantIdHasBeenSet() const { return m_tenantIdHasBeenSet; }
  template <typename TenantIdT = Aws::String>
  void SetTenantId(TenantIdT&& value) {
    m_tenantIdHasBeenSet = true;
    m_tenantId = std::forward<TenantIdT>(value);
  }
  template <typename TenantIdT = Aws::String>
  IngestionSummary& WithTenantId(TenantIdT&& value) {
    SetTenantId(std::forward<TenantIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The status of the ingestion.</p>
   */
  inline IngestionState GetState() const { return m_state; }
  inline bool StateHasBeenSet() const { return m_stateHasBeenSet; }
  inline void SetState(IngestionState value) {
    m_stateHasBeenSet = true;
    m_state = value;
  }
  inline IngestionSummary& WithState(IngestionState value) {
    SetState(value);
    return *this;
  }
  ///@}
 private:
  Aws::String m_arn;
  bool m_arnHasBeenSet = false;

  Aws::String m_app;
  bool m_appHasBeenSet = false;

  Aws::String m_tenantId;
  bool m_tenantIdHasBeenSet = false;

  IngestionState m_state{IngestionState::NOT_SET};
  bool m_stateHasBeenSet = false;
};

}  // namespace Model
}  // namespace AppFabric
}  // namespace Aws
