﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/backup-gateway/model/DeleteHypervisorRequest.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::BackupGateway::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

Aws::String DeleteHypervisorRequest::SerializePayload() const {
  JsonValue payload;

  if (m_hypervisorArnHasBeenSet) {
    payload.WithString("HypervisorArn", m_hypervisorArn);
  }

  return payload.View().WriteReadable();
}

Aws::Http::HeaderValueCollection DeleteHypervisorRequest::GetRequestSpecificHeaders() const {
  Aws::Http::HeaderValueCollection headers;
  headers.insert(Aws::Http::HeaderValuePair("X-Amz-Target", "BackupOnPremises_v20210101.DeleteHypervisor"));
  return headers;
}
