﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/bedrock/model/GetCustomModelResult.h>
#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/UnreferencedParam.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>

#include <utility>

using namespace Aws::Bedrock::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws;

GetCustomModelResult::GetCustomModelResult(const Aws::AmazonWebServiceResult<JsonValue>& result) { *this = result; }

GetCustomModelResult& GetCustomModelResult::operator=(const Aws::AmazonWebServiceResult<JsonValue>& result) {
  JsonView jsonValue = result.GetPayload().View();
  if (jsonValue.ValueExists("modelArn")) {
    m_modelArn = jsonValue.GetString("modelArn");
    m_modelArnHasBeenSet = true;
  }
  if (jsonValue.ValueExists("modelName")) {
    m_modelName = jsonValue.GetString("modelName");
    m_modelNameHasBeenSet = true;
  }
  if (jsonValue.ValueExists("jobName")) {
    m_jobName = jsonValue.GetString("jobName");
    m_jobNameHasBeenSet = true;
  }
  if (jsonValue.ValueExists("jobArn")) {
    m_jobArn = jsonValue.GetString("jobArn");
    m_jobArnHasBeenSet = true;
  }
  if (jsonValue.ValueExists("baseModelArn")) {
    m_baseModelArn = jsonValue.GetString("baseModelArn");
    m_baseModelArnHasBeenSet = true;
  }
  if (jsonValue.ValueExists("customizationType")) {
    m_customizationType = CustomizationTypeMapper::GetCustomizationTypeForName(jsonValue.GetString("customizationType"));
    m_customizationTypeHasBeenSet = true;
  }
  if (jsonValue.ValueExists("modelKmsKeyArn")) {
    m_modelKmsKeyArn = jsonValue.GetString("modelKmsKeyArn");
    m_modelKmsKeyArnHasBeenSet = true;
  }
  if (jsonValue.ValueExists("hyperParameters")) {
    Aws::Map<Aws::String, JsonView> hyperParametersJsonMap = jsonValue.GetObject("hyperParameters").GetAllObjects();
    for (auto& hyperParametersItem : hyperParametersJsonMap) {
      m_hyperParameters[hyperParametersItem.first] = hyperParametersItem.second.AsString();
    }
    m_hyperParametersHasBeenSet = true;
  }
  if (jsonValue.ValueExists("trainingDataConfig")) {
    m_trainingDataConfig = jsonValue.GetObject("trainingDataConfig");
    m_trainingDataConfigHasBeenSet = true;
  }
  if (jsonValue.ValueExists("validationDataConfig")) {
    m_validationDataConfig = jsonValue.GetObject("validationDataConfig");
    m_validationDataConfigHasBeenSet = true;
  }
  if (jsonValue.ValueExists("outputDataConfig")) {
    m_outputDataConfig = jsonValue.GetObject("outputDataConfig");
    m_outputDataConfigHasBeenSet = true;
  }
  if (jsonValue.ValueExists("trainingMetrics")) {
    m_trainingMetrics = jsonValue.GetObject("trainingMetrics");
    m_trainingMetricsHasBeenSet = true;
  }
  if (jsonValue.ValueExists("validationMetrics")) {
    Aws::Utils::Array<JsonView> validationMetricsJsonList = jsonValue.GetArray("validationMetrics");
    for (unsigned validationMetricsIndex = 0; validationMetricsIndex < validationMetricsJsonList.GetLength(); ++validationMetricsIndex) {
      m_validationMetrics.push_back(validationMetricsJsonList[validationMetricsIndex].AsObject());
    }
    m_validationMetricsHasBeenSet = true;
  }
  if (jsonValue.ValueExists("creationTime")) {
    m_creationTime = jsonValue.GetString("creationTime");
    m_creationTimeHasBeenSet = true;
  }
  if (jsonValue.ValueExists("customizationConfig")) {
    m_customizationConfig = jsonValue.GetObject("customizationConfig");
    m_customizationConfigHasBeenSet = true;
  }
  if (jsonValue.ValueExists("modelStatus")) {
    m_modelStatus = ModelStatusMapper::GetModelStatusForName(jsonValue.GetString("modelStatus"));
    m_modelStatusHasBeenSet = true;
  }
  if (jsonValue.ValueExists("failureMessage")) {
    m_failureMessage = jsonValue.GetString("failureMessage");
    m_failureMessageHasBeenSet = true;
  }

  const auto& headers = result.GetHeaderValueCollection();
  const auto& requestIdIter = headers.find("x-amzn-requestid");
  if (requestIdIter != headers.end()) {
    m_requestId = requestIdIter->second;
    m_requestIdHasBeenSet = true;
  }

  return *this;
}
