﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/clouddirectory/model/AttributeKeyAndValue.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws {
namespace CloudDirectory {
namespace Model {

AttributeKeyAndValue::AttributeKeyAndValue(JsonView jsonValue) { *this = jsonValue; }

AttributeKeyAndValue& AttributeKeyAndValue::operator=(JsonView jsonValue) {
  if (jsonValue.ValueExists("Key")) {
    m_key = jsonValue.GetObject("Key");
    m_keyHasBeenSet = true;
  }
  if (jsonValue.ValueExists("Value")) {
    m_value = jsonValue.GetObject("Value");
    m_valueHasBeenSet = true;
  }
  return *this;
}

JsonValue AttributeKeyAndValue::Jsonize() const {
  JsonValue payload;

  if (m_keyHasBeenSet) {
    payload.WithObject("Key", m_key.Jsonize());
  }

  if (m_valueHasBeenSet) {
    payload.WithObject("Value", m_value.Jsonize());
  }

  return payload;
}

}  // namespace Model
}  // namespace CloudDirectory
}  // namespace Aws
