﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/connect/model/NotificationDeliveryType.h>
#include <aws/core/Globals.h>
#include <aws/core/utils/EnumParseOverflowContainer.h>
#include <aws/core/utils/HashingUtils.h>

using namespace Aws::Utils;

namespace Aws {
namespace Connect {
namespace Model {
namespace NotificationDeliveryTypeMapper {

static const int EMAIL_HASH = HashingUtils::HashString("EMAIL");

NotificationDeliveryType GetNotificationDeliveryTypeForName(const Aws::String& name) {
  int hashCode = HashingUtils::HashString(name.c_str());
  if (hashCode == EMAIL_HASH) {
    return NotificationDeliveryType::EMAIL;
  }
  EnumParseOverflowContainer* overflowContainer = Aws::GetEnumOverflowContainer();
  if (overflowContainer) {
    overflowContainer->StoreOverflow(hashCode, name);
    return static_cast<NotificationDeliveryType>(hashCode);
  }

  return NotificationDeliveryType::NOT_SET;
}

Aws::String GetNameForNotificationDeliveryType(NotificationDeliveryType enumValue) {
  switch (enumValue) {
    case NotificationDeliveryType::NOT_SET:
      return {};
    case NotificationDeliveryType::EMAIL:
      return "EMAIL";
    default:
      EnumParseOverflowContainer* overflowContainer = Aws::GetEnumOverflowContainer();
      if (overflowContainer) {
        return overflowContainer->RetrieveOverflow(static_cast<int>(enumValue));
      }

      return {};
  }
}

}  // namespace NotificationDeliveryTypeMapper
}  // namespace Model
}  // namespace Connect
}  // namespace Aws
