/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.variables;

import java.util.Arrays;
import java.util.List;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.PatternFilter;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCScriptContext;
import org.jkiss.dbeaver.model.exec.DBCScriptContextListener;
import org.jkiss.dbeaver.model.sql.SQLScriptContext;
import org.jkiss.dbeaver.model.sql.registry.SQLQueryParameterRegistry;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.ISearchContextProvider;
import org.jkiss.dbeaver.ui.ISearchExecutor;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.ListContentProvider;
import org.jkiss.dbeaver.ui.controls.ProgressPageControl;
import org.jkiss.dbeaver.ui.controls.ViewerColumnController;
import org.jkiss.dbeaver.ui.editors.StringEditorInput;
import org.jkiss.dbeaver.ui.editors.SubEditorSite;
import org.jkiss.dbeaver.ui.editors.TextEditorUtils;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditor;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorBase;
import org.jkiss.dbeaver.ui.editors.sql.variables.AssignVariableAction;
import org.jkiss.dbeaver.ui.editors.sql.variables.RemoveVariablesAction;
import org.jkiss.dbeaver.ui.navigator.NavigatorUtils;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

public class SQLVariablesPanel
extends Composite
implements DBCScriptContextListener {
    protected static final Log log = Log.getLog(SQLVariablesPanel.class);
    private final SQLEditor mainEditor;
    private SQLEditorBase valueEditor;
    private TableViewer varsTable;
    private boolean showParameters;
    private boolean saveInProgress;
    private DBCScriptContext.VariableInfo curVariable;

    public SQLVariablesPanel(Composite parent, SQLEditor editor) {
        super(parent, 0);
        this.mainEditor = editor;
        this.setLayout((Layout)new FillLayout());
    }

    private void createControls() {
        this.mainEditor.getGlobalScriptContext().addListener((DBCScriptContextListener)this);
        this.addDisposeListener(e -> this.mainEditor.getGlobalScriptContext().removeListener((DBCScriptContextListener)this));
        SashForm sash = new SashForm((Composite)this, 512);
        VariableListControl variableListControl = new VariableListControl((Composite)sash);
        variableListControl.createOrSubstituteProgressPanel(this.mainEditor.getSite());
        Composite editorGroup = UIUtils.createPlaceholder((Composite)sash, (int)1);
        UIUtils.createControlLabel((Composite)editorGroup, (String)"Value");
        Composite editorPH = new Composite(editorGroup, 0);
        GridData gd = new GridData(1808);
        gd.verticalIndent = 3;
        gd.horizontalSpan = 1;
        gd.minimumHeight = 100;
        gd.minimumWidth = 100;
        editorPH.setLayoutData((Object)gd);
        editorPH.setLayout((Layout)new FillLayout());
        this.valueEditor = new SQLEditorBase(){

            @Nullable
            public DBCExecutionContext getExecutionContext() {
                return SQLVariablesPanel.this.mainEditor.getExecutionContext();
            }

            @Override
            public void createPartControl(Composite parent) {
                super.createPartControl(parent);
                this.getAction("Preferences.ContextAction").setEnabled(false);
            }

            @Override
            public boolean isFoldingEnabled() {
                return false;
            }
        };
        try {
            this.valueEditor.init((IEditorSite)new SubEditorSite(this.mainEditor.getSite()), (IEditorInput)new StringEditorInput("Variable value", (CharSequence)"", true, GeneralUtils.getDefaultFileEncoding()));
        }
        catch (PartInitException e2) {
            log.error((Object)e2);
        }
        this.valueEditor.createPartControl(editorPH);
        this.valueEditor.setWordWrap(true);
        this.valueEditor.reloadSyntaxRules();
        this.valueEditor.getEditorControlWrapper().setLayoutData(new GridData(1808));
        final StyledText editorControl = this.valueEditor.getEditorControl();
        TextEditorUtils.enableHostEditorKeyBindingsSupport((IWorkbenchPartSite)this.mainEditor.getSite(), (Control)editorControl);
        if (editorControl != null) {
            editorControl.addFocusListener((FocusListener)new FocusAdapter(){

                public void focusLost(FocusEvent e) {
                    SQLVariablesPanel.this.saveVariableValue(editorControl);
                }
            });
        }
        sash.setWeights(new int[]{600, 400});
    }

    private void saveVariableValue(StyledText editorControl) {
        String varValue = editorControl.getText();
        if (this.curVariable != null) {
            this.saveInProgress = true;
            try {
                this.curVariable.value = varValue;
                this.mainEditor.getGlobalScriptContext().setVariable(this.curVariable.name, (Object)varValue);
                this.varsTable.refresh();
            }
            finally {
                this.saveInProgress = false;
            }
        }
    }

    private void editCurrentVariable() {
        ISelection selection = this.varsTable.getSelection();
        StyledText editorControl = this.valueEditor.getEditorControl();
        if (editorControl == null) {
            return;
        }
        if (!selection.isEmpty()) {
            this.curVariable = (DBCScriptContext.VariableInfo)((IStructuredSelection)selection).getFirstElement();
            StringEditorInput sqlInput = new StringEditorInput("Variable " + this.curVariable.name, (CharSequence)CommonUtils.toString((Object)this.curVariable.value), false, GeneralUtils.DEFAULT_ENCODING);
            this.valueEditor.setInput((IEditorInput)sqlInput);
            this.valueEditor.reloadSyntaxRules();
        }
    }

    public void refreshVariables() {
        if (this.varsTable == null) {
            this.createControls();
        }
        SQLScriptContext context = this.mainEditor.getGlobalScriptContext();
        List variables = context.getVariables();
        if (this.showParameters) {
            for (SQLQueryParameterRegistry.ParameterInfo param : SQLQueryParameterRegistry.getInstance().getAllParameters()) {
                if (context.hasVariable(param.name)) continue;
                Object parameterValue = context.getParameterDefaultValue(param.name);
                if (parameterValue == null) {
                    parameterValue = param.value;
                }
                variables.add(new DBCScriptContext.VariableInfo(param.name, parameterValue, DBCScriptContext.VariableType.PARAMETER));
            }
        }
        this.varsTable.setInput((Object)variables);
        this.valueEditor.setInput((IEditorInput)new StringEditorInput("Variable", (CharSequence)"", true, GeneralUtils.DEFAULT_ENCODING));
        this.valueEditor.reloadSyntaxRules();
    }

    public void variableChanged(DBCScriptContextListener.ContextAction action, DBCScriptContext.VariableInfo variable) {
        if (this.saveInProgress) {
            return;
        }
        UIUtils.asyncExec(this::refreshVariables);
    }

    public void parameterChanged(DBCScriptContextListener.ContextAction action, String name, Object value) {
        if (this.saveInProgress) {
            return;
        }
        UIUtils.asyncExec(this::refreshVariables);
    }

    private class VariableListControl
    extends ProgressPageControl {
        private final ISearchExecutor searcher;
        private Action addAction;
        private Action deleteAction;

        public VariableListControl(Composite parent) {
            super(parent, 0x10000000);
            this.searcher = new ISearchExecutor(){

                public boolean performSearch(String searchString, int options) {
                    try {
                        PatternFilter searchFilter = new PatternFilter(){

                            protected boolean isLeafMatch(Viewer viewer, Object element) {
                                DBCScriptContext.VariableInfo variable = (DBCScriptContext.VariableInfo)element;
                                return this.wordMatches(variable.name) || this.wordMatches(CommonUtils.toString((Object)variable.value));
                            }
                        };
                        searchFilter.setPattern(searchString);
                        ((VariableListControl)VariableListControl.this).SQLVariablesPanel.this.varsTable.setFilters(new ViewerFilter[]{searchFilter});
                        return true;
                    }
                    catch (PatternSyntaxException e) {
                        log.error((Object)e.getMessage());
                        return false;
                    }
                }

                public void cancelSearch() {
                    ((VariableListControl)VariableListControl.this).SQLVariablesPanel.this.varsTable.setFilters(new ViewerFilter[0]);
                }
            };
            SQLVariablesPanel.this.varsTable = new TableViewer((Composite)this, 65538);
            SQLVariablesPanel.this.varsTable.getTable().setHeaderVisible(true);
            SQLVariablesPanel.this.varsTable.getTable().setLinesVisible(true);
            SQLVariablesPanel.this.varsTable.getTable().setLayoutData((Object)new GridData(1808));
            ViewerColumnController columnController = new ViewerColumnController("sqlVariablesViewer", (ColumnViewer)SQLVariablesPanel.this.varsTable);
            SQLVariablesPanel.this.varsTable.setContentProvider((IContentProvider)new ListContentProvider());
            columnController.addColumn("Variable", "Variable or parameter name", 16384, true, true, (CellLabelProvider)new ColumnLabelProvider(){

                public String getText(Object element) {
                    return ((DBCScriptContext.VariableInfo)element).name;
                }
            });
            columnController.addColumn("Value", "Variable or parameter value", 16384, true, true, (CellLabelProvider)new ColumnLabelProvider(){

                public String getText(Object element) {
                    return CommonUtils.toString((Object)((DBCScriptContext.VariableInfo)element).value);
                }
            });
            columnController.addColumn("Type", "Variable type", 16384, true, true, (CellLabelProvider)new ColumnLabelProvider(){

                public String getText(Object element) {
                    return ((DBCScriptContext.VariableInfo)element).type.getTitle();
                }
            });
            columnController.createColumns(true);
            SQLVariablesPanel.this.varsTable.addSelectionChangedListener(event -> {
                if (this.deleteAction != null) {
                    Object varElement = event.getSelection().isEmpty() ? null : ((IStructuredSelection)SQLVariablesPanel.this.varsTable.getSelection()).getFirstElement();
                    this.deleteAction.setEnabled(varElement instanceof DBCScriptContext.VariableInfo);
                    this.updateActions();
                }
                SQLVariablesPanel.this.editCurrentVariable();
            });
            NavigatorUtils.createContextMenu((IWorkbenchSite)SQLVariablesPanel.this.mainEditor.getSite(), (Viewer)SQLVariablesPanel.this.varsTable, manager -> {});
        }

        protected ISearchExecutor getSearchRunner() {
            return this.searcher;
        }

        protected void addSearchAction(IContributionManager contributionManager) {
            contributionManager.add((IAction)new Action("Find variable", DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.SEARCH)){

                public void run() {
                    VariableListControl.this.performSearch(ISearchContextProvider.SearchType.NONE);
                }
            });
        }

        protected void createSearchControls() {
            super.createSearchControls();
            Text textControl = this.getSearchTextControl();
            if (textControl != null) {
                TextEditorUtils.enableHostEditorKeyBindingsSupport((IWorkbenchPartSite)SQLVariablesPanel.this.mainEditor.getSite(), (Control)textControl);
            }
        }

        public void fillCustomActions(IContributionManager contributionManager) {
            super.fillCustomActions(contributionManager);
            this.addAction = new Action("Add variable", DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.ADD)){

                public void run() {
                    AssignVariableAction action = new AssignVariableAction(((VariableListControl)VariableListControl.this).SQLVariablesPanel.this.mainEditor, "");
                    action.setEditable(true);
                    action.run();
                }
            };
            contributionManager.add((IAction)this.addAction);
            this.deleteAction = new Action("Delete variable", DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.DELETE)){

                public void run() {
                    if (!((VariableListControl)VariableListControl.this).SQLVariablesPanel.this.varsTable.getSelection().isEmpty()) {
                        StructuredSelection selection = (StructuredSelection)((VariableListControl)VariableListControl.this).SQLVariablesPanel.this.varsTable.getSelection();
                        List<String> varsList = Arrays.stream(selection.toArray()).map(el -> ((DBCScriptContext.VariableInfo)el).name).collect(Collectors.toList());
                        new RemoveVariablesAction(((VariableListControl)VariableListControl.this).SQLVariablesPanel.this.mainEditor, varsList).run();
                    }
                }
            };
            this.deleteAction.setEnabled(false);
            contributionManager.add((IAction)this.deleteAction);
            Action showParamsAction = new Action("Show parameters", 2){

                public void run() {
                    ((VariableListControl)VariableListControl.this).SQLVariablesPanel.this.showParameters = !((VariableListControl)VariableListControl.this).SQLVariablesPanel.this.showParameters;
                    SQLVariablesPanel.this.refreshVariables();
                }
            };
            showParamsAction.setChecked(SQLVariablesPanel.this.showParameters);
            showParamsAction.setImageDescriptor(DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.SQL_PARAMETER));
            showParamsAction.setDescription("Show query parameters");
            contributionManager.add((IContributionItem)ActionUtils.makeActionContribution((IAction)showParamsAction, (boolean)true));
        }
    }
}

