/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * UNICODE LICENSE V3
 *
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright © 1991-2025 Unicode, Inc.
 *
 * NOTICE TO USER: Carefully read the following legal agreement. BY
 * DOWNLOADING, INSTALLING, COPYING OR OTHERWISE USING DATA FILES, AND/OR
 * SOFTWARE, YOU UNEQUIVOCALLY ACCEPT, AND AGREE TO BE BOUND BY, ALL OF THE
 * TERMS AND CONDITIONS OF THIS AGREEMENT. IF YOU DO NOT AGREE, DO NOT
 * DOWNLOAD, INSTALL, COPY, DISTRIBUTE OR USE THE DATA FILES OR SOFTWARE.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of data files and any associated documentation (the "Data Files") or
 * software and any associated documentation (the "Software") to deal in the
 * Data Files or Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, and/or sell
 * copies of the Data Files or Software, and to permit persons to whom the
 * Data Files or Software are furnished to do so, provided that either (a)
 * this copyright and permission notice appear with all copies of the Data
 * Files or Software, or (b) this copyright and permission notice appear in
 * associated Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS NOTICE
 * BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THE DATA
 * FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall
 * not be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written
 * authorization of the copyright holder.
 *
 * SPDX-License-Identifier: Unicode-3.0
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_ks extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_TO = "ٹونگا";
        final String metaValue_ar = "عربی";
        final String metaValue_ae = "اَویستَن";
        final String metaValue_chr = "چیروکی";
        final String metaValue_cop = "کاپٹِک";
        final String metaValue_ka = "جارجِیَن";
        final String metaValue_got = "گوتھِک";
        final String metaValue_ko = "کوریَن";
        final String metaValue_lo = "لاو";
        final String metaValue_nqo = "این کو";
        final String metaValue_si = "سِنہالا";
        final String metaValue_su = "سَنڈَنیٖز";
        final String metaValue_ta = "تَمِل";
        final String metaValue_te = "تیلگوٗ";
        final String metaValue_th = "تھاے";
        final String metaValue_bo = "تِبتی";
        final String metaValue_vai = "واے";
        final String metaValue_peo = "پرون فارسی";
        final String metaValue_ru = "روٗسی";
        final Object[][] data = new Object[][] {
            { "001", "دُنیا" },
            { "002", "اَفریٖکا" },
            { "003", "شُمٲلی اَمریٖکا" },
            { "005", "جَنوٗنی اَمرٖیٖکا" },
            { "009", "اوشَنیا" },
            { "011", "مَغریٖبی اَفریٖکا" },
            { "013", "مرکٔزی اَمریٖکا" },
            { "014", "مَشرِقی اَفریٖکا" },
            { "015", "شُمٲلی اَفریٖکا" },
            { "017", "وسطی اَفریٖکا" },
            { "018", "جنوٗبی اَفریٖکا" },
            { "019", "اَمریٖکَس" },
            { "021", "شُمٲلی اَمریٖکا خٕطہٕ" },
            { "029", "کَرِببیٖن" },
            { "030", "مَشرِقی ایشیا" },
            { "034", "جنوٗبی ایشیا" },
            { "035", "جنوٗبہِ مَشرِقی ایشیا" },
            { "039", "جنوٗبی یوٗرَپ" },
            { "053", "آسٹریلیشیا" },
            { "054", "مؠلَنیٖشِیا" },
            { "057", "مَیکرونَیشِیَن خٕطہٕ" },
            { "061", "پالنیشِیا" },
            { "142", "ایشیا" },
            { "143", "مرکٔزی ایشیا" },
            { "145", "مَغرِبی ایشیا" },
            { "150", "یوٗرَپ" },
            { "151", "مشرِقی یوٗرَپ" },
            { "154", "شُمٲلی یوٗرَپ" },
            { "155", "مغرِبی یوٗرَپ" },
            { "202", "ذیلی سہارن افریقہ" },
            { "419", "لاطیٖنی اَمریٖکا" },
            { "AC", "ایسنشن جزیرٕ" },
            { "AD", "اینڈورا" },
            { "AE", "مُتحدہ عرَب امارات" },
            { "AF", "اَفغانَستان" },
            { "AG", "اؠنٹِگُوا تہٕ باربوڑا" },
            { "AI", "انگوئیلا" },
            { "AL", "البانیا" },
            { "AM", "اَرمانِیا" },
            { "AO", "انگولا" },
            { "AQ", "اینٹارٹِکا" },
            { "AR", "أرجَنٹینا" },
            { "AS", "اَمریٖکَن سَموا" },
            { "AT", "آسٹریا" },
            { "AU", "آسٹریلِیا" },
            { "AW", "اَروٗبا" },
            { "AX", "ایلینڑ جٔزیٖرٕ" },
            { "AZ", "آذربائیجان" },
            { "BA", "بوسنِیا تہٕ ہَرزِگووِنا" },
            { "BB", "باربیڈوس" },
            { "BD", "بَنگلادیش" },
            { "BE", "بیلجِیَم" },
            { "BF", "بُرکِنا فیسو" },
            { "BG", "بَلجیرِیا" },
            { "BH", "بحریٖن" },
            { "BI", "بورَنڈِ" },
            { "BJ", "بِنِن" },
            { "BL", "سینٹ بارتَھیلمی" },
            { "BM", "برمودا" },
            { "BN", "برونے" },
            { "BO", "بولِوِیا" },
            { "BQ", "کیریبین نیدرلینڈس" },
            { "BR", "برازِل" },
            { "BS", "بَہامَس" },
            { "BT", "بوٗٹان" },
            { "BV", "بووَٹ جٔزیٖرٕ" },
            { "BW", "بوتَسوانا" },
            { "BY", "بیلاروٗس" },
            { "BZ", "بیلز" },
            { "CA", "کینیڈا" },
            { "CC", "کوکَس (کیٖلِنگ) جٔزیٖرٕ" },
            { "CD", "کونگو کِنشاسا" },
            { "CF", "مرکٔزی اَفریٖکی جموٗریَت" },
            { "CG", "کونگو بٔرزاوِلی" },
            { "CH", "سُوِزَرلینڑ" },
            { "CI", "کوٹ ڈلوائر" },
            { "CK", "کُک جٔزیٖرٕ" },
            { "CL", "چِلی" },
            { "CM", "کیمِروٗن" },
            { "CN", "چیٖن" },
            { "CO", "کولَمبِیا" },
            { "CP", "کلیپرٹن جزیرٕ" },
            { "CR", "کوسٹا ریکا" },
            { "CU", "کیوٗبا" },
            { "CV", "کیپ ؤرڑی" },
            { "CW", "کیوراکو" },
            { "CX", "کرِسمَس جٔزیٖرٕ" },
            { "CY", "سائپرس" },
            { "CZ", "چیکیا" },
            { "DE", "جرمٔنی" },
            { "DG", "ڈیگو گریشیا" },
            { "DJ", "جِبوٗتی" },
            { "DK", "ڈینمارٕک" },
            { "DM", "ڈومِنِکا" },
            { "DO", "ڈومِنِکَن جموٗرِیَت" },
            { "DZ", "اؠلجیرِیا" },
            { "EA", "سیوٹا تٕہ مٔلیلا" },
            { "EC", "اِکواڑور" },
            { "EE", "ایسٹونِیا" },
            { "EG", "مصر" },
            { "EH", "مشرِقی سَہارا" },
            { "ER", "اِرٕٹِیا" },
            { "ES", "سٕپین" },
            { "ET", "اِتھوپِیا" },
            { "EU", "یوٗرپی یونین" },
            { "EZ", "یوٗرو زون" },
            { "FI", "فِن لینڈ" },
            { "FJ", "فِجی" },
            { "FK", "فٕلاکلینڑ جٔزیٖرٕ" },
            { "FM", "مائیکرونیشیا" },
            { "FO", "فارو جزیرہ" },
            { "FR", "فرانس" },
            { "GA", "گیبان" },
            { "GB", "متحدہ مملِکت" },
            { "GD", "گرینیڈا" },
            { "GE", "جارجِیا" },
            { "GF", "فرانسِسی گِانا" },
            { "GG", "گورنسے" },
            { "GH", "گانا" },
            { "GI", "جِبرالٹَر" },
            { "GL", "گرین لینڈ" },
            { "GM", "گَمبِیا" },
            { "GN", "گِنی" },
            { "GP", "گواڈلوپ" },
            { "GQ", "اِکوِٹورِیَل گِنی" },
            { "GR", "گریٖس" },
            { "GS", "جنوٗبی جارجِیا تہٕ جنوٗبی سینڑوٕچ جٔزیٖرٕ" },
            { "GT", "گواٹمالا" },
            { "GU", "گُوام" },
            { "GW", "گیٖنی بِساو" },
            { "GY", "گُیانا" },
            { "HK", "ہانگ کانگ ایس اے آر چیٖن" },
            { "HM", "ہَرٕڑ تہٕ مؠکڈونالڑٕ جٔزیٖرٕ" },
            { "HN", "ہونڈورس" },
            { "HR", "کروشِیا" },
            { "HT", "ہیتی" },
            { "HU", "ہَنگری" },
            { "IC", "کینری جزیرٕ" },
            { "ID", "انڈونیشیا" },
            { "IE", "اَیَرلینڑ" },
            { "IL", "اسرا ییل" },
            { "IM", "آیِل آف مین" },
            { "IN", "ہِندوستان" },
            { "IQ", "ایٖراق" },
            { "IR", "ایٖران" },
            { "IS", "اَیِسلینڑ" },
            { "IT", "اِٹلی" },
            { "JE", "جٔرسی" },
            { "JM", "جَمایکا" },
            { "JO", "جورڈن" },
            { "JP", "جاپان" },
            { "KE", "کِنیا" },
            { "KG", "کرغزستان" },
            { "KH", "کَمبوڑِیا" },
            { "KI", "کِرٕباتی" },
            { "KM", "کَمورَس" },
            { "KN", "سینٹ کِٹَس تہٕ نیوِس" },
            { "KP", "شُمٲلی کورِیا" },
            { "KR", "جنوٗبی کورِیا" },
            { "KW", "کُویت" },
            { "KY", "کیمَن جٔزیٖرٕ" },
            { "KZ", "قازقستان" },
            { "LA", "لاس" },
            { "LB", "لؠبنان" },
            { "LC", "سینٹ لوٗسِیا" },
            { "LI", "لِکٹیسٹیٖن" },
            { "LK", "سری لنکا" },
            { "LR", "لایبیرِیا" },
            { "LS", "لیسوتھو" },
            { "LT", "لِتھُوانِیا" },
            { "LU", "لَکسَمبٔرٕگ" },
            { "LV", "لیٹوِیا" },
            { "LY", "لِبیا" },
            { "MA", "موروکو" },
            { "MC", "مونیکو" },
            { "MD", "مولڈووا" },
            { "ME", "موٹونیگِریو" },
            { "MF", "سینٹ مارٹِن" },
            { "MG", "میڈاگاسکار" },
            { "MH", "مارشَل جٔزیٖرٕ" },
            { "MK", "شُمالی میسڈونیا" },
            { "ML", "مالی" },
            { "MM", "میانمار (برما)" },
            { "MN", "مَنگولِیا" },
            { "MO", "مَکاوو ایس اے آر چیٖن" },
            { "MP", "شُمٲلی مارِیانا جٔزیٖرٕ" },
            { "MQ", "مارٹِنِک" },
            { "MR", "مارٕٹانِیا" },
            { "MS", "مانٹسیراٹ" },
            { "MT", "مالٹا" },
            { "MU", "مورِشَس" },
            { "MV", "مالدیٖو" },
            { "MW", "ملاوی" },
            { "MX", "مؠکسِکو" },
            { "MY", "مَلیشِیا" },
            { "MZ", "موزَمبِک" },
            { "NA", "نامِبِیا" },
            { "NC", "نِو کیلِڑونِیا" },
            { "NE", "نایجَر" },
            { "NF", "نارفاک جٔزیٖرٕ" },
            { "NG", "نایجیرِیا" },
            { "NI", "ناکاراگُوا" },
            { "NL", "نیٖدَرلینڑ" },
            { "NO", "ناروے" },
            { "NP", "نیپال" },
            { "NR", "نارووٗ" },
            { "NU", "نیوٗ" },
            { "NZ", "نیوزی لینڈ" },
            { "OM", "اومان" },
            { "PA", "پَناما" },
            { "PE", "پیٖروٗ" },
            { "PF", "فرانسی پولِنیشِیا" },
            { "PG", "پاپُوا نیوٗ گیٖنی" },
            { "PH", "فلپائن" },
            { "PK", "پاکِستان" },
            { "PL", "پولینڈ" },
            { "PM", "سینٹ پیٖری تہٕ موکیلِیَن" },
            { "PN", "پِٹکیرٕنؠ جٔزیٖرٕ" },
            { "PR", "پٔرٹو رِکو" },
            { "PS", "فلسطینی علاقٕہ" },
            { "PT", "پُرتِگال" },
            { "PW", "پَلاو" },
            { "PY", "پَراگُے" },
            { "QA", "قَطِر" },
            { "QO", "آوُٹلاینِگ اوشینِیا" },
            { "RE", "رِیوٗنِیَن" },
            { "RO", "رومانِیا" },
            { "RS", "سَربِیا" },
            { "RU", "روٗس" },
            { "RW", "روٗوانڈا" },
            { "SA", "سعودی عرب" },
            { "SB", "سولامان جٔزیٖرٕ" },
            { "SC", "سیشَلِس" },
            { "SD", "سوٗڈان" },
            { "SE", "سویڈن" },
            { "SG", "سِنگاپوٗر" },
            { "SH", "سینٹ ہؠلِنا" },
            { "SI", "سَلووینِیا" },
            { "SJ", "سَوالبریڑ تہٕ جان ماییڑ" },
            { "SK", "سَلوواکِیا" },
            { "SL", "سیرا لیون" },
            { "SM", "سین میرِنو" },
            { "SN", "سینیگَل" },
            { "SO", "سومالِیا" },
            { "SR", "سُرِنام" },
            { "SS", "جنوبی سوڈان" },
            { "ST", "ساو توم تہٕ پرنسِپی" },
            { "SV", "ایل سلویڈر" },
            { "SX", "سِنٹ مارٹِن" },
            { "SY", "شام" },
            { "SZ", "ایسواتنی" },
            { "TA", "ٹریسٹن ڈا کنہا" },
            { "TC", "تُرکس تٕہ کیکو جزیرٕ" },
            { "TD", "چاڑ" },
            { "TF", "فرانسِسی جَنوٗبی عَلاقہٕ" },
            { "TG", "ٹوگو" },
            { "TH", "تھائی لینڈ" },
            { "TJ", "تاجکِستان" },
            { "TK", "ٹوکلو" },
            { "TL", "تیمور-لیسٹ" },
            { "TM", "تُرکمنستان" },
            { "TN", "ٹونیشِیا" },
            { "TO", metaValue_TO },
            { "TR", "تُرکی" },
            { "TT", "ٹرنِنداد تہٕ ٹوبیگو" },
            { "TV", "توٗوالوٗ" },
            { "TW", "تایوان" },
            { "TZ", "تَنجانِیا" },
            { "UA", "یوٗرِکین" },
            { "UG", "یوٗگانڑا" },
            { "UM", "یوٗنایٹِڑ سِٹیٹِس ماینَر آوُٹلییِنگ جٔزیٖرٕ" },
            { "UN", "متحدہ مُمٲلک" },
            { "US", "یوٗنایٹِڑ سِٹیٹِس" },
            { "UY", "یوٗروگے" },
            { "UZ", "اُزبِکِستان" },
            { "VA", "ویٹِکَن سِٹی" },
            { "VC", "سینٹ وینسؠٹ تہٕ گریناڑاینٕز" },
            { "VE", "وینازوٗلا" },
            { "VG", "بَرطانوی ؤرجِن جٔزیٖرٕ" },
            { "VI", "یوٗ ایس ؤرجِن جٔزیٖرٕ" },
            { "VN", "ویتنام" },
            { "VU", "وانوٗتوٗ" },
            { "WF", "والِس تہٕ فیوٗچوٗنا" },
            { "WS", "سامو" },
            { "XA", "سوڈو-ایسنٹس" },
            { "XB", "سوڈو-بیڈی" },
            { "XK", "کوسوو" },
            { "YE", "یَمَن" },
            { "YT", "مَییٹ" },
            { "ZA", "جنوبی افریقہ" },
            { "ZM", "زیمبیا" },
            { "ZW", "زِمبابے" },
            { "ZZ", "نامولوٗم علاقٕہ" },
            { "aa", "اَفار" },
            { "ab", "اَبخازِیان" },
            { "ae", metaValue_ae },
            { "af", "اَفریٖکانز" },
            { "ak", "اَکان" },
            { "am", "اَمہاری" },
            { "an", "اَراگونی" },
            { "ar", metaValue_ar },
            { "as", "اسٲمؠ" },
            { "av", "اَوارِک" },
            { "ay", "ایمارا" },
            { "az", "اَزَربیجانی" },
            { "ba", "بَشکیٖر" },
            { "be", "بیلَروٗشیَن" },
            { "bg", "بینا" },
            { "bi", "بِسلاما" },
            { "bm", "بَمبارا" },
            { "bn", "بَنگٲلؠ" },
            { "bo", metaValue_bo },
            { "br", "بریٹَن" },
            { "bs", "بوسنِیَن" },
            { "ca", "کَتلان" },
            { "ce", "چیچَن" },
            { "ch", "کَمورو" },
            { "co", "کارسِکَن" },
            { "cr", "کری" },
            { "cs", "چیک" },
            { "cu", "چٔرچ سلاوِک" },
            { "cv", "چُواش" },
            { "cy", "ویلش" },
            { "da", "ڈینِش" },
            { "de", "جٔرمَن" },
            { "dv", "دِویہی" },
            { "dz", "زونگکھا" },
            { "ee", "ایٖو" },
            { "el", "یوٗنٲنی" },
            { "en", "اَنگیٖزؠ" },
            { "eo", "ایسپَرینٹو" },
            { "es", "ہسپانوی" },
            { "et", "ایسٹونیَن" },
            { "eu", "باسک" },
            { "fa", "فارسی" },
            { "ff", "فُلاہ" },
            { "fi", "فِنِش" },
            { "fj", "فِجیَن" },
            { "fo", "فَروس" },
            { "fr", "فرانسیسی" },
            { "fy", "مغربی فرِشیَن" },
            { "ga", "اَیرِش" },
            { "gd", "سکوٹِش گیےلِک" },
            { "gl", "گیلِشِیَن" },
            { "gn", "گُوارَنی" },
            { "gu", "گُجرٲتی" },
            { "gv", "مینکس" },
            { "ha", "ہاوسا" },
            { "he", "عبرٲنؠ" },
            { "hi", "ہِندی" },
            { "ho", "ہِری موتوٗ" },
            { "hr", "کروشِیَن" },
            { "ht", "ہیتِیاں" },
            { "hu", "ہَنگیریَن" },
            { "hy", "اَرمینیَن" },
            { "hz", "ہیریٖرو" },
            { "ia", "اِنٹَرلِنگوا" },
            { "id", "اِنڈونیشیا" },
            { "ie", "اِنٹَر لِننگویے" },
            { "ig", "اِگبو" },
            { "ii", "سِچوان یٖی" },
            { "ik", "اِنُپِیاک" },
            { "io", "اِڈو" },
            { "is", "آیِسلینڈِک" },
            { "it", "اِطالوی" },
            { "iu", "اِنُکتِتوٗ" },
            { "ja", "جاپٲنؠ" },
            { "jv", "جَوَنیٖز" },
            { "ka", metaValue_ka },
            { "kg", "کونگو" },
            { "ki", "کِکُیوٗ" },
            { "kj", "کُوانیاما" },
            { "kk", "کازَخ" },
            { "kl", "کَلالِسُت" },
            { "km", "خَمیر" },
            { "kn", "کَنَڑ" },
            { "ko", metaValue_ko },
            { "kr", "کَنوٗری" },
            { "ks", "کٲشُر" },
            { "ku", "کُردِش" },
            { "kv", "کومی" },
            { "kw", "کورنِش" },
            { "ky", "کِرگِز" },
            { "la", "لاتیٖنی" },
            { "lb", "لُکھزیمبورگِش" },
            { "lg", "گاندا" },
            { "li", "لِمبٔرگِش" },
            { "ln", "لِنگالا" },
            { "lo", metaValue_lo },
            { "lt", "لِتھوانِیَن" },
            { "lu", "لوُبا کَتَنگا" },
            { "lv", "لَتوِیَن" },
            { "mg", "مَلاگَسی" },
            { "mh", "مارشَلیٖز" },
            { "mi", "ماوری" },
            { "mk", "میکَڈونیَن" },
            { "ml", "مٔلیالَم" },
            { "mn", "مَنگولی" },
            { "mr", "مَرٲٹھؠ" },
            { "ms", "مَلَے" },
            { "mt", "مَلتیٖس" },
            { "my", "بٔمیٖز" },
            { "na", "ناورُ" },
            { "nb", "ناروییَن بوکمال" },
            { "nd", "شُمال ڈَبیل" },
            { "ne", "نیپٲلؠ" },
            { "ng", "ڈونگا" },
            { "nl", "ڈَچ" },
            { "nn", "ناروییَن نَے نورسک" },
            { "no", "ناروییَن" },
            { "nr", "جنوب ڈیبیل" },
            { "nv", "نَواجو" },
            { "ny", "نِیَنجا" },
            { "oc", "اوکسیٖٹَن" },
            { "oj", "اوجِبوا" },
            { "om", "اۆرومو" },
            { "or", "اۆرِیا" },
            { "os", "اۆسیٹِک" },
            { "pa", "پَنجٲبؠ" },
            { "pi", "پالی" },
            { "pl", "پالِش" },
            { "ps", "پَشتوٗ" },
            { "pt", "پُرتَگیٖز" },
            { "qu", "کُویشُوا" },
            { "rm", "رومانش" },
            { "rn", "رُندی" },
            { "ro", "رومٲنی" },
            { "ru", metaValue_ru },
            { "rw", "کِنیاوِندا" },
            { "sa", "سَنسکرٕت" },
            { "sc", "سراڈیٖنی" },
            { "sd", "سِندی" },
            { "se", "شُمٲلی سَمی" },
            { "sg", "سَنگو" },
            { "sh", "سیربو کروشِیَن" },
            { "si", metaValue_si },
            { "sk", "سلووَک" },
            { "sl", "سلووینیَن" },
            { "sm", "سَمواَن" },
            { "sn", "شونا" },
            { "so", "سومٲلی" },
            { "sq", "البانِیَن" },
            { "sr", "سٔربِیَن" },
            { "ss", "سواتی" },
            { "st", "جنوبی ستھو" },
            { "su", metaValue_su },
            { "sv", "سویٖڈِش" },
            { "sw", "سواہِلی" },
            { "ta", metaValue_ta },
            { "te", metaValue_te },
            { "tg", "تاجِک" },
            { "th", metaValue_th },
            { "ti", "ٹِگرِنیا" },
            { "tk", "تُرکمین" },
            { "tl", "تَماشیک" },
            { "tn", "سوانا" },
            { "to", metaValue_TO },
            { "tr", "تُرکِش" },
            { "ts", "ژونگا" },
            { "tt", "تَتار" },
            { "tw", "توی" },
            { "ty", "تاہیشِیَن" },
            { "uk", "یوٗکرینیٲیی" },
            { "ur", "اُردوٗ" },
            { "uz", "اُزبیک" },
            { "ve", "ویندا" },
            { "vi", "وِیَتنَمیٖز" },
            { "vo", "وولَپُک" },
            { "wa", "وَلوٗن" },
            { "wo", "وولوف" },
            { "xh", "کھوسا" },
            { "yi", "یِدِش" },
            { "yo", "یورُبا" },
            { "za", "زُہانگ" },
            { "zh", "چیٖنی ﴿ترجمع اِشارٕ: خاص طور، مینڈارن چیٖنی۔﴾" },
            { "zu", "زُلوٗ" },
            { "ace", "اَچَےنیٖز" },
            { "ach", "اَکولی" },
            { "ada", "اَدَنگمیے" },
            { "ady", "اَدَیٖگیے" },
            { "afh", "اَفرِہِلی" },
            { "ain", "اینوٗ" },
            { "akk", "اَکادِیَن" },
            { "ale", "اَلویتی" },
            { "alt", "جنوٗبی اَلتایی" },
            { "ang", "پرون اَنگریٖزی" },
            { "anp", "اَنگِکا" },
            { "arc", "اَرَمیک" },
            { "arn", "ایرو کونِیَن" },
            { "arp", "اَراپاہو" },
            { "arw", "اَراوَک" },
            { "ast", "ایسٹوٗریَن" },
            { "awa", "اَوَدی" },
            { "bal", "بَلوٗچی" },
            { "ban", "بالِنیٖز" },
            { "bas", "باسا" },
            { "bej", "بیجا" },
            { "bem", "بیمبا" },
            { "bho", "بوجپوٗری" },
            { "bik", "بِکول" },
            { "bin", "بِنی" },
            { "bla", "سِکسِکا" },
            { "bra", "برج" },
            { "bua", "بُرِیَت" },
            { "bug", "بَگنیٖز" },
            { "byn", "بٕلِن" },
            { "cad", "کاڈو" },
            { "car", "کارِب" },
            { "cch", "اتسَم" },
            { "ceb", "سیباونو" },
            { "chb", "چیٖبچا" },
            { "chg", "چھَگتاے" },
            { "chk", "چُکیٖز" },
            { "chm", "ماری" },
            { "chn", "چِنوٗک جارگَن" },
            { "cho", "چوکتَو" },
            { "chp", "شیپویان" },
            { "chr", metaValue_chr },
            { "chy", "شییون" },
            { "cop", metaValue_cop },
            { "crh", "کرٕمیٖن تُرکی" },
            { "csb", "کَشوٗبِیَن" },
            { "dak", "ڈکوٹا" },
            { "dar", "دَرگوا" },
            { "del", "ڈیلوییَر" },
            { "den", "سلیو" },
            { "dgr", "ڈاگرِب" },
            { "din", "ڈِنکا" },
            { "doi", "ڈوگری" },
            { "dsb", "بۆنِم ساربِیَن" },
            { "dua", "دُوالا" },
            { "dum", "وَستی پُرتُگالی" },
            { "dyu", "ڈِیوٗلا" },
            { "efi", "ایفِک" },
            { "egy", "قدیٖمی مِصری" },
            { "eka", "ایکاجُک" },
            { "elx", "ایلامایِٹ" },
            { "enm", "وَسطی اَنگریٖزؠ" },
            { "ewo", "ایوونڈو" },
            { "fan", "فینگ" },
            { "fat", "فانٹی" },
            { "fil", "فِلِپیٖنو" },
            { "fon", "فون" },
            { "frm", "وسطی فرینچ" },
            { "fro", "پرون فرینچ" },
            { "frr", "شُمٲلی فرِشیَن" },
            { "frs", "مشرِقی فرِشیَن" },
            { "fur", "فروٗلِیَن" },
            { "gaa", "گا" },
            { "gay", "گیےیو" },
            { "gba", "گبایا" },
            { "gez", "گیٖز" },
            { "gil", "گِلبٔرٹیٖز" },
            { "gmh", "وَسطی ہاے جٔرمَن" },
            { "goh", "پرون ہاے جٔرمَن" },
            { "gon", "گوندی" },
            { "gor", "گورینٹیلو" },
            { "got", metaValue_got },
            { "grb", "گرِبو" },
            { "grc", "قدیٖم یوٗنٲنی" },
            { "gsw", "سٕوِس جٔرمَن" },
            { "gwi", "گُوِچ اِن" },
            { "hai", "ہَیدا" },
            { "haw", "ہوایِیَن" },
            { "hil", "ہِلیٖگینَن" },
            { "hit", "ہِتایِت" },
            { "hmn", "ہمونگ" },
            { "hsb", "ہیرِم ساربِیَن" },
            { "hup", "ہُپا" },
            { "iba", "اِبان" },
            { "ilo", "اِلوکو" },
            { "inh", "اِنگُش" },
            { "jbo", "لوجبان" },
            { "jpr", "جوڈیو فارسی" },
            { "jrb", "جوڈیو عربی" },
            { "kaa", "کارا کَلپَک" },
            { "kab", "کَبایِل" },
            { "kac", "کاچِن" },
            { "kaj", "جُوٗ" },
            { "kam", "کامبا" },
            { "kaw", "کَوی" },
            { "kbd", "کَبارڈِیَن" },
            { "kcg", "تَیَپ" },
            { "kfo", "کورو" },
            { "kha", "کھاسی" },
            { "kho", "کھوتَنیٖز" },
            { "kmb", "کِمبُندوٗ" },
            { "kok", "کونکَنی" },
            { "kos", "کوسرییَن" },
            { "kpe", "کَپیلی" },
            { "krc", "کراچیے بَلکار" },
            { "krl", "کَریلِیَن" },
            { "kru", "کُرُکھ" },
            { "kum", "کُمِک" },
            { "kut", "کُتینَے" },
            { "lad", "لیڈِنو" },
            { "lah", "لَہَندا" },
            { "lam", "لَمبا" },
            { "lez", "لیزگِیَن" },
            { "lol", "مونگو" },
            { "loz", "لوزی" },
            { "lua", "لوٗبا لوٗلُوا" },
            { "lui", "لویِسینو" },
            { "lun", "لُندا" },
            { "luo", "لُوو" },
            { "lus", "لُسہاے" },
            { "mad", "مَدُریٖز" },
            { "mag", "مَگاے" },
            { "mai", "میتَھلی" },
            { "mak", "مَکَسار" },
            { "man", "مَندِنگو" },
            { "mas", "مَساے" },
            { "mdf", "موکشا" },
            { "mdr", "مَندَر" },
            { "men", "میندیے" },
            { "mga", "وَستی ایرِش" },
            { "mic", "مِکمیک" },
            { "min", "مِنَنگکَباو" },
            { "mnc", "مانچوٗ" },
            { "mni", "مَنیپوٗری" },
            { "moh", "موہاک" },
            { "mos", "موسی" },
            { "mul", "واریاہ زبان" },
            { "mus", "کریٖک" },
            { "mwl", "مِراندیٖز" },
            { "mwr", "مارواڑی" },
            { "myv", "ایرزِیا" },
            { "nap", "نیٖپالیٹَن" },
            { "nds", "بۆنِم جٔرمَن" },
            { "new", "نیواری" },
            { "nia", "نِیاس" },
            { "niu", "نِیویَن" },
            { "nog", "نوگاے" },
            { "non", "پرون نارسی" },
            { "nqo", metaValue_nqo },
            { "nso", "شمالی ستھو" },
            { "nwc", "کلاسِکَل نیواری" },
            { "nym", "نِیَمویزی" },
            { "nyn", "نِیَنکول" },
            { "nyo", "نِیورو" },
            { "nzi", "نَظیٖما" },
            { "osa", "اۆسیج" },
            { "ota", "اوٹومَن تُرکِش" },
            { "pag", "پَنگاسِنَن" },
            { "pal", "پَہلَوی" },
            { "pam", "پَمپَنگا" },
            { "pap", "پَپِیامینٹو" },
            { "pau", "پَلااُواں" },
            { "peo", metaValue_peo },
            { "phn", "فونیٖشیَن" },
            { "pon", "پانپییَن" },
            { "pro", "پرون پرووینچَل" },
            { "raj", "راجِستھٲنؠ" },
            { "rap", "رَپانوی" },
            { "rar", "رَروٹونگَن" },
            { "rom", "رومَنی" },
            { "rup", "اَرومانی" },
            { "sad", "سَندَویے" },
            { "sah", "یاکُت" },
            { "sam", "سَمارِتَن اَرامیک" },
            { "sas", "سَسَک" },
            { "sat", "سَنتالی" },
            { "scn", "سِچِلِیَن" },
            { "sco", "سکاٹس" },
            { "sel", "سیلکُپ" },
            { "sga", "پرون ایرِش" },
            { "shn", "شان" },
            { "sid", "سِدامو" },
            { "sma", "جنوٗبی سَمی" },
            { "smj", "لولیے سَمی" },
            { "smn", "اِناری سَمی" },
            { "sms", "سکولٹ سَمی" },
            { "snk", "سونِنکیے" },
            { "sog", "سوگڈِیَن" },
            { "srn", "سرانَن ٹونگو" },
            { "srr", "سیریر" },
            { "suk", "سُکُما" },
            { "sus", "سُسوٗ" },
            { "sux", "سُمیریَن" },
            { "syr", "سیٖریٲیی" },
            { "tem", "ٹِمنیے" },
            { "ter", "ٹیرینو" },
            { "tet", "ٹیٹَم" },
            { "tig", "ٹاےگریے" },
            { "tiv", "تیٖو" },
            { "tkl", "ٹوکیٖلاو" },
            { "tlh", "کِلِنگون" },
            { "tli", "ٹِلِنگِت" },
            { "tmh", "تاماشیک" },
            { "tog", "نیاسا ٹونگا" },
            { "tpi", "ٹاک پِسِن" },
            { "tsi", "ژھِمشِیان" },
            { "tum", "تُمبُکا" },
            { "tvl", "تُوالوٗ" },
            { "tyv", "تُویٖنیَن" },
            { "udm", "اُدمُرت" },
            { "uga", "اُگارتِک" },
            { "umb", "یُمبُندوٗ" },
            { "und", "اَنزٲنؠ یا نَہ لَگہٕہار زبان" },
            { "vai", metaValue_vai },
            { "vot", "ووتِک" },
            { "wal", "والامو" },
            { "war", "وَریے" },
            { "was", "واشو" },
            { "xal", "کالمِک" },
            { "yao", "یاو" },
            { "yap", "یَپیٖز" },
            { "zap", "زَپوتیک" },
            { "zen", "زیناگا" },
            { "zun", "زوٗنی" },
            { "zxx", "کانہہ تہِ لِسانیاتی مواد نہٕ" },
            { "zza", "زازا" },
            { "Arab", metaValue_ar },
            { "Aran", "نستعلیق" },
            { "Armn", "اَرمانیَن" },
            { "Avst", metaValue_ae },
            { "Bali", "بالَنیٖز" },
            { "Batk", "باتَک" },
            { "Beng", "بینگٲلؠ" },
            { "Blis", "بِلِس سِمبلز" },
            { "Bopo", "بوپوموفو" },
            { "Brah", "براہمی" },
            { "Brai", "بریل" },
            { "Bugi", "بُگِنیٖز" },
            { "Buhd", "بُہِد" },
            { "Cans", "یُنِفایِڑ کنیڑِیَن ایب آرجِنَل سِلیبِک" },
            { "Cari", "کاریَن" },
            { "Cham", "چَم" },
            { "Cher", metaValue_chr },
            { "Cirt", "کِرتھ" },
            { "Copt", metaValue_cop },
            { "Cprt", "کِپرایِٹ" },
            { "Cyrl", "سَیرِلِک" },
            { "Cyrs", "پرون چٔرچسلیوونِک سَیرِلِک" },
            { "Deva", "دیوناگری" },
            { "Dsrt", "ڈیسٔریٹ" },
            { "Egyd", "اِجپشِیَن ڈِماٹِک" },
            { "Egyh", "اِجِپشَن ہَیریٹِک" },
            { "Egyp", "اِجِپشَن ہَیروگلِپھس" },
            { "Ethi", "اِتھیوپِک" },
            { "Geok", "جارجِیَن کھتسوری" },
            { "Geor", metaValue_ka },
            { "Glag", "گلیگولِٹِک" },
            { "Goth", metaValue_got },
            { "Grek", "گرَنتھا" },
            { "Gujr", "گریٖک" },
            { "Guru", "گُجرٲتؠ" },
            { "Hang", "ہانگُل" },
            { "Hani", "ہان" },
            { "Hano", "ہانُنوٗ" },
            { "Hans", "سَہل ﴿ترجمع اِشارٕ: یِم ورژن رَسم الخط ہُک ناؤ چھُ چیٖنی باپتھ زَبانٕ ناؤ کِس مجموعَس سٕتؠ اِستعمال یِوان کرنٕہ۔﴾" },
            { "Hant", "رِوٲجی ﴿ترجمع اِشارٕ: یِم ورژن رَسم الخط ہُک ناؤ چھُ چیٖنی باپتھ زَبانٕ ناؤ کِس مجموعَس سٕتؠ اِستعمال یِوان کرنٕہ۔﴾" },
            { "Hebr", "ہِبرِو" },
            { "Hira", "ہیٖراگانا" },
            { "Hmng", "پَہاو مانگ" },
            { "Hrkt", "کَٹاکانا یا ہِراگانا" },
            { "Hung", "پرون ہَنگیریَن" },
            { "Inds", "اِنڈَس" },
            { "Ital", "اولڈ اِٹیلِک" },
            { "Java", "جاوَنیٖز" },
            { "Jpan", "جاپٲنی" },
            { "Kali", "کایا لی" },
            { "Kana", "کَتاکانا" },
            { "Khar", "خَروشتھی" },
            { "Khmr", "کھٕمیر" },
            { "Knda", "کَنَڑا" },
            { "Kore", metaValue_ko },
            { "Lana", "لانا" },
            { "Laoo", metaValue_lo },
            { "Latf", "فرکتُر لیٹِن" },
            { "Latg", "گیلِک لیٹَن" },
            { "Latn", "لاطیٖنی" },
            { "Lepc", "لیپکا" },
            { "Limb", "لِمبوٗ" },
            { "Lina", "لیٖنیَر اے" },
            { "Linb", "لیٖنیَر بی" },
            { "Lyci", "لیسِیَن" },
            { "Lydi", "لیدِیَن" },
            { "Mand", "مَندییَن" },
            { "Mani", "مانیشییَن" },
            { "Maya", "مایَن ہیٖروگلِپھ" },
            { "Mero", "مِرایٹِک" },
            { "Mlym", "مَلیالَم" },
            { "Mong", "مَنگولیَن" },
            { "Moon", "موٗن" },
            { "Mtei", "میتی مایَک" },
            { "Mymr", "مَیَنمار" },
            { "Nkoo", metaValue_nqo },
            { "Ogam", "اوگہام" },
            { "Olck", "اول چِکی" },
            { "Orkh", "اورکھون" },
            { "Orya", "اورِیا" },
            { "Osma", "اوسمانیا" },
            { "Perm", "اولڈ پٔرمِک" },
            { "Phag", "پھاگس پا" },
            { "Phlv", "بوٗک پَہَلوی" },
            { "Phnx", "پھونِشِیَن" },
            { "Plrd", "پولاڑ پھونِٹِک" },
            { "Rjng", "ریجَنگ" },
            { "Roro", "رونگو رونگو" },
            { "Runr", "رَنِک" },
            { "Samr", "سَمارِٹَن" },
            { "Sara", "سَراتی" },
            { "Saur", "سوراشٹرا" },
            { "Sgnw", "اِشارٲتی لِکھٲے" },
            { "Shaw", "شاویَن" },
            { "Sinh", metaValue_si },
            { "Sund", metaValue_su },
            { "Sylo", "سیلوتی ناگری" },
            { "Syrc", "سیٖرِیَک" },
            { "Syre", "ایسٹرینجِلو سیٖرِیَک" },
            { "Syrj", "مغرِبی سیٖریَک" },
            { "Syrn", "مشرَقی سیٖریَک" },
            { "Tagb", "تَگبَنوا" },
            { "Tale", "تَیلیے" },
            { "Talu", "نۆو تیلو" },
            { "Taml", metaValue_ta },
            { "Telu", metaValue_te },
            { "Teng", "تینگوار" },
            { "Tfng", "تِفِناگ" },
            { "Tglg", "تَگَلوگ" },
            { "Thaa", "تھانا" },
            { "Thai", metaValue_th },
            { "Tibt", metaValue_bo },
            { "Ugar", "اُگارِٹِک" },
            { "Vaii", metaValue_vai },
            { "Visp", "وِزِبٕل سپیٖچ" },
            { "Xpeo", metaValue_peo },
            { "Xsux", "سُمیرو اکادیَن کوٗنِفام" },
            { "Yiii", "یٖی" },
            { "Zxxx", "لیکھنَے" },
            { "Zyyy", "عام" },
            { "Zzzz", "نامولوٗم رَسم الخط" },
            { "de_AT", "آسٹرِیَن جٔرمَن" },
            { "de_CH", "سٕوِس ہائی جٔرمَن" },
            { "en_AU", "آسٹریلیَن اَنگریٖزؠ" },
            { "en_CA", "کینَڈِیٲیی اَنگریٖزؠ" },
            { "en_GB", "بَرطانوی اَنگریٖزؠ" },
            { "en_US", "امریٖکی اَنٛگریٖزؠ" },
            { "es_ES", "یوٗرپی ہسپانوی" },
            { "es_MX", "میکسیکن ہسپانوی" },
            { "fr_CA", "کَنیڈیَن فرانسیسی" },
            { "fr_CH", "سٕوٕس فرانسیسی" },
            { "nl_BE", "فلیمِش" },
            { "pt_BR", "برازیٖلی پُرتَگیٖز" },
            { "pt_PT", "یوٗرپی پُرتَگیٖز" },
            { "ro_MD", "مولداوِیَن" },
            { "%%1901", "رؠوٲتی جٔرمَن عِلمہِ ہِجا" },
            { "%%1994", "مَیعٲری روٗسی عِلمہِ ہِجا" },
            { "%%1996", "جٔرمَن عِلمہِ ہِجا ۱۹۹۶سُک" },
            { "ar_001", "ماڈرن معیٲری عربی" },
            { "es_419", "لاطیٖنی امریٖکی ہسپانوی" },
            { "key.ca", "کیلنڑر" },
            { "key.cu", "ضَرب" },
            { "%%BISKE", "سین جارجِیو/بِلا بوٗلؠ" },
            { "%%LIPAW", "روٗسی زَبانہِ ہِنز لِپوواز بوٗلؠ" },
            { "%%NEDIS", "نؠٹِسون بوٗلؠ" },
            { "%%NJIVA", "نیجِوا بوٗلؠ" },
            { "%%OSOJS", "اُشیکو/اوسوجین بوٗلؠ" },
            { "%%POSIX", "کَمپیوٗٹَر" },
            { "%%ROZAJ", metaValue_ru },
            { "%%SAAHO", "سوہو" },
            { "%%SOLBA", "ثٹولوِزا/سولبِکا بوٗلؠ" },
            { "zh_Hans", "سَہل چیٖنی" },
            { "zh_Hant", "رِوٲجی چیٖنی" },
            { "%%FONIPA", "آوازیات" },
            { "%%FONUPA", "یوٗ پی اے آوازِیات" },
            { "%%SCOUSE", "سِکوس" },
            { "%%TARASK", "تاراسکیٖوِکا علمہ ہِجاِ" },
            { "%%AREVELA", "مَشرِقی اَمریٖکا" },
            { "%%MONOTON", "اَکٔے لہجہٕ واجؠن زَبان" },
            { "%%POLYTON", "واریاہ لہجہٕ واجؠن زَبان" },
            { "%%REVISED", "دُبارٕ دۄہراونہٕ آمُت عِلمہِ ہِجا" },
            { "%%1606NICT", "بعد وَقت وَسطی فرانس پؠٹھ ۱۶٠۶ تام" },
            { "%%BAKU1926", "جٔمع کٔرِتھ تُرکی لاطیٖنی اَچھر" },
            { "%%SCOTLAND", "سُکاٹِش مَیعٲری اَنگریٖزؠ" },
            { "type.ca.roc", "جموٗریٲتی چیٖنی کیلَنڑَر" },
            { "type.nu.arab", "اَربی-اِنڈِک ہندسٕہ" },
            { "type.nu.deva", "دیوناگری ہندسٕہ" },
            { "type.nu.latn", "مغربی ہندسٕہ" },
            { "type.ca.hebrew", "ہِبرِو کیلنڑَر" },
            { "type.ca.indian", "انڈین نیشنل کیلنڈر" },
            { "type.co.pinyin", "آسان بَناونہٕ آمُت چیٖنی پیٖنیَن تَرتیٖب" },
            { "type.co.stroke", "رؠوٲتی چیٖنی سٹروک تَرتیٖب" },
            { "type.ca.chinese", "چیٖنی کیلَنڑَر" },
            { "type.ca.iso8601", "ISO-8601 کیلنڈر" },
            { "type.nu.arabext", "توسیٖع شُدہ اَربی-اِنڈِک ہندسٕہ" },
            { "type.ca.buddhist", "بُدَن ہُند کیلنڑَر" },
            { "type.ca.japanese", "جاپٲنؠ کیلنڑَر" },
            { "type.co.standard", "معیٲری ترتیٖب آڈر" },
            { "type.ca.gregorian", "گرگوریَن کیلنڑَر" },
            { "type.co.phonebook", "فون بُک تَرتیٖب" },
            { "type.co.traditional", "رؠوٲتی تَرتیٖب" },
        };
        return data;
    }
}
