/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * UNICODE LICENSE V3
 *
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright © 1991-2025 Unicode, Inc.
 *
 * NOTICE TO USER: Carefully read the following legal agreement. BY
 * DOWNLOADING, INSTALLING, COPYING OR OTHERWISE USING DATA FILES, AND/OR
 * SOFTWARE, YOU UNEQUIVOCALLY ACCEPT, AND AGREE TO BE BOUND BY, ALL OF THE
 * TERMS AND CONDITIONS OF THIS AGREEMENT. IF YOU DO NOT AGREE, DO NOT
 * DOWNLOAD, INSTALL, COPY, DISTRIBUTE OR USE THE DATA FILES OR SOFTWARE.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of data files and any associated documentation (the "Data Files") or
 * software and any associated documentation (the "Software") to deal in the
 * Data Files or Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, and/or sell
 * copies of the Data Files or Software, and to permit persons to whom the
 * Data Files or Software are furnished to do so, provided that either (a)
 * this copyright and permission notice appear with all copies of the Data
 * Files or Software, or (b) this copyright and permission notice appear in
 * associated Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS NOTICE
 * BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THE DATA
 * FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall
 * not be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written
 * authorization of the copyright holder.
 *
 * SPDX-License-Identifier: Unicode-3.0
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_lo extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_DE = "ເຢຍລະມັນ";
        final String metaValue_FR = "ຝຣັ່ງ";
        final String metaValue_JP = "ຍີ່ປຸ່ນ";
        final String metaValue_LA = "ລາວ";
        final String metaValue_MN = "ມອງໂກເລຍ";
        final String metaValue_WS = "ຊາມົວ";
        final String metaValue_TH = "ໄທ";
        final String metaValue_VN = "ຫວຽດນາມ";
        final String metaValue_CN = "ຈີນ";
        final String metaValue_TK = "ໂຕເກເລົາ";
        final String metaValue_TV = "ຕູວາລູ";
        final String metaValue_hy = "ອາເມນຽນ";
        final String metaValue_ccp = "ຊາກມາ";
        final String metaValue_cop = "ຄອບຕິກ";
        final String metaValue_ka = "ຈໍຈຽນ";
        final String metaValue_el = "ກຣີກ";
        final String metaValue_he = "ຮີບຣິວ";
        final String metaValue_kn = "ຄັນນາດາ";
        final String metaValue_la = "ລາຕິນ";
        final String metaValue_men = "ເມນເດ";
        final String metaValue_my = "ມຽນມາ";
        final String metaValue_nqo = "ເອັນໂກ";
        final String metaValue_or = "ໂອເດຍ";
        final String metaValue_si = "ສິນຫາລາ";
        final String metaValue_SY = "ຊີເຣຍ";
        final String metaValue_ta = "ທາມິລ";
        final String metaValue_tl = "ຕາກາລອກ";
        final String metaValue_bo = "ທິເບທັນ";
        final String metaValue_vai = "ໄວ";
        final String metaValue_ssy = "ຊາໂຮ";
        final Object[][] data = new Object[][] {
            { "001", "ໂລກ" },
            { "002", "ອາຟຣິກາ" },
            { "003", "ອາເມລິກາເໜືອ" },
            { "005", "ອາເມລິກາໃຕ້" },
            { "009", "ໂອຊີອານີ" },
            { "011", "ອາຟຣິກາຕາເວັນຕົກ" },
            { "013", "ອາເມລິກາກາງ" },
            { "014", "ອາຟຣິກາຕາເວັນອອກ" },
            { "015", "ອາຟຣິກາເໜືອ" },
            { "017", "ອາຟຣິກາກາງ" },
            { "018", "ອາຟຣິກາຕອນໃຕ້" },
            { "019", "ອາເມຣິກາ" },
            { "021", "ພາກເໜືອອາເມລີກາ" },
            { "029", "ຄາຣິບບຽນ" },
            { "030", "ອາຊີຕາເວັນອອກ" },
            { "034", "ອາຊີໃຕ້" },
            { "035", "ອາຊີຕາເວັນອອກສຽງໃຕ້" },
            { "039", "ຢູໂຣບໃຕ້" },
            { "053", "ໂອດສະຕາລີ" },
            { "054", "ເມລານີເຊຍ" },
            { "057", "ເຂດໄມໂຄຣເນຊຽນ" },
            { "061", "ໂພລີນີເຊຍ" },
            { "142", "ອາຊີ" },
            { "143", "ອາຊີກາງ" },
            { "145", "ອາຊີຕາເວັນຕົກ" },
            { "150", "ຢູໂຣບ" },
            { "151", "ຢູໂຣບຕາເວັນອອກ" },
            { "154", "ຢູໂຣບເໜືອ" },
            { "155", "ຢູໂຣບຕາເວັນຕົກ" },
            { "202", "ຊັບ ຊາຮາຣານ ອາຟຣິກາ" },
            { "419", "ລາຕິນ ອາເມລິກາ" },
            { "AC", "ເກາະອາເຊນຊັນ" },
            { "AD", "ອັນດໍຣາ" },
            { "AE", "ສະຫະລັດອາຣັບເອມິເຣດ" },
            { "AF", "ອາຟການິດສະຖານ" },
            { "AG", "ແອນທິກົວ ແລະ ບາບູດາ" },
            { "AI", "ແອນກຸຍລາ" },
            { "AL", "ແອວເບເນຍ" },
            { "AM", "ອາເມເນຍ" },
            { "AO", "ແອງໂກລາ" },
            { "AQ", "ແອນຕາດຕິກາ" },
            { "AR", "ອາເຈນທິນາ" },
            { "AS", "ອາເມຣິກາ ຊາມົວ" },
            { "AT", "ອອສເທຣຍ" },
            { "AU", "ອອສເຕຣເລຍ" },
            { "AW", "ອາຣູບາ" },
            { "AX", "ຫມູ່ເກາະໂອລັນ" },
            { "AZ", "ອາເຊີໄບຈານ" },
            { "BA", "ບອດສະເນຍ ແລະ ແຮສໂກວີນາ" },
            { "BB", "ບາບາໂດສ" },
            { "BD", "ບັງກະລາເທດ" },
            { "BE", "ເບວຢຽມ" },
            { "BF", "ເບີກິນາ ຟາໂຊ" },
            { "BG", "ບັງກາເຣຍ" },
            { "BH", "ບາເຣນ" },
            { "BI", "ບູຣຸນດິ" },
            { "BJ", "ເບນິນ" },
            { "BL", "ເຊນ ບາເທເລມີ" },
            { "BM", "ເບີມິວດາ" },
            { "BN", "ບຣູໄນ" },
            { "BO", "ໂບລິເວຍ" },
            { "BQ", "ຄາຣິບບຽນ ເນເທີແລນ" },
            { "BR", "ບຣາຊິວ" },
            { "BS", "ບາຮາມາສ" },
            { "BT", "ພູຖານ" },
            { "BV", "ເກາະບູເວດ" },
            { "BW", "ບອດສະວານາ" },
            { "BY", "ເບລາຣຸສ" },
            { "BZ", "ເບລີຊ" },
            { "CA", "ແຄນາດາ" },
            { "CC", "ຫມູ່ເກາະໂກໂກສ" },
            { "CD", "ຄອງໂກ - ຄິນຊາຊາ" },
            { "CF", "ສາທາລະນະລັດອາຟຣິກາກາງ" },
            { "CG", "ຄອງໂກ - ບຣາຊາວິວ" },
            { "CH", "ສະວິດເຊີແລນ" },
            { "CI", "ໂຄຕີ ວົວ" },
            { "CK", "ໝູ່ເກາະຄຸກ" },
            { "CL", "ຊິລີ" },
            { "CM", "ຄາເມຣູນ" },
            { "CN", metaValue_CN },
            { "CO", "ໂຄລົມເບຍ" },
            { "CP", "ເກາະຄລິບເປີຕັນ" },
            { "CQ", "ຊາກຄ໌" },
            { "CR", "ໂຄສຕາ ຣິກາ" },
            { "CU", "ຄິວບາ" },
            { "CV", "ເຄບ ເວີດ" },
            { "CW", "ຄູຣາຊາວ" },
            { "CX", "ເກາະຄຣິສມາດ" },
            { "CY", "ໄຊປຣັສ" },
            { "CZ", "ເຊັກເຊຍ" },
            { "DE", metaValue_DE },
            { "DG", "ດິເອໂກ ກາເຊຍ" },
            { "DJ", "ຈິບູຕິ" },
            { "DK", "ເດນມາກ" },
            { "DM", "ໂດມີນິຄາ" },
            { "DO", "ສາທາລະນະລັດ ໂດມິນິກັນ" },
            { "DZ", "ອັລຈິເຣຍ" },
            { "EA", "ເຊວຕາ & ເມລິນລາ" },
            { "EC", "ເອກວາດໍ" },
            { "EE", "ເອສໂຕເນຍ" },
            { "EG", "ອີຢິບ" },
            { "EH", "ຊາຮາຣາຕາເວັນຕົກ" },
            { "ER", "ເອຣິເທຣຍ" },
            { "ES", "ສະເປນ" },
            { "ET", "ອີທິໂອເປຍ" },
            { "EU", "ສະຫະພາບຢູໂຣບ" },
            { "EZ", "ເຂດຢູໂຣບ" },
            { "FI", "ຟິນແລນ" },
            { "FJ", "ຟິຈິ" },
            { "FK", "ຫມູ່ເກາະຟອກແລນ" },
            { "FM", "ໄມໂຄຣນີເຊຍ" },
            { "FO", "ຫມູ່ເກາະແຟໂຣ" },
            { "FR", metaValue_FR },
            { "GA", "ກາບອນ" },
            { "GB", "ສະຫະລາດຊະອະນາຈັກ" },
            { "GD", "ເກຣເນດາ" },
            { "GE", "ຈໍເຈຍ" },
            { "GF", "ເຟຣນຊ໌ ກຸຍອານາ" },
            { "GG", "ເກີນຊີ" },
            { "GH", "ການາ" },
            { "GI", "ຈິບບຣອນທາ" },
            { "GL", "ກຣີນແລນ" },
            { "GM", "ສາທາລະນະລັດແກມເບຍ" },
            { "GN", "ກິນີ" },
            { "GP", "ກົວດາລູບ" },
            { "GQ", "ເອຄົວໂທຣຽວ ກີນີ" },
            { "GR", "ກຣີຊ" },
            { "GS", "ໝູ່ເກາະ ຈໍເຈຍຕອນໃຕ້ ແລະ ແຊນວິດຕອນໃຕ້" },
            { "GT", "ກົວເທມາລາ" },
            { "GU", "ກວາມ" },
            { "GW", "ກິນີ-ບິສເຊົາ" },
            { "GY", "ກາຍຢານາ" },
            { "HK", "ຮົງກົງ ເຂດປົກຄອງພິເສດ ຈີນ" },
            { "HM", "ໝູ່ເກາະເຮີດ & ແມັກໂດນອລ" },
            { "HN", "ຮອນດູຣັສ" },
            { "HR", "ໂຄຣເອເທຍ" },
            { "HT", "ໄຮຕິ" },
            { "HU", "ຮັງກາຣີ" },
            { "IC", "ໝູ່ເກາະຄານາຣີ" },
            { "ID", "ອິນໂດເນເຊຍ" },
            { "IE", "ໄອແລນ" },
            { "IL", "ອິສຣາເອວ" },
            { "IM", "ເອວ ອອບ ແມນ" },
            { "IN", "ອິນເດຍ" },
            { "IO", "ເຂດແດນອັງກິດໃນມະຫາສະໝຸດອິນເດຍ" },
            { "IQ", "ອີຣັກ" },
            { "IR", "ອີຣານ" },
            { "IS", "ໄອສແລນ" },
            { "IT", "ອິຕາລີ" },
            { "JE", "ເຈີຊີ" },
            { "JM", "ຈາໄມຄາ" },
            { "JO", "ຈໍແດນ" },
            { "JP", metaValue_JP },
            { "KE", "ເຄນຢາ" },
            { "KG", "ຄຽກກິດສະຖານ" },
            { "KH", "ກຳປູເຈຍ" },
            { "KI", "ຄິຣິບາທິ" },
            { "KM", "ໂຄໂມໂຣສ" },
            { "KN", "ເຊນ ຄິດ ແລະ ເນວິສ" },
            { "KP", "ເກົາຫລີເໜືອ" },
            { "KR", "ເກົາຫລີໃຕ້" },
            { "KW", "ກູເວດ" },
            { "KY", "ໝູ່ເກາະ ເຄແມນ" },
            { "KZ", "ຄາຊັກສະຖານ" },
            { "LA", metaValue_LA },
            { "LB", "ເລບານອນ" },
            { "LC", "ເຊນ ລູເຊຍ" },
            { "LI", "ລິດເທນສະຕາຍ" },
            { "LK", "ສີລັງກາ" },
            { "LR", "ລິເບີເຣຍ" },
            { "LS", "ເລໂຊໂທ" },
            { "LT", "ລິທົວເນຍ" },
            { "LU", "ລຸກແຊມເບີກ" },
            { "LV", "ລັດເວຍ" },
            { "LY", "ລິເບຍ" },
            { "MA", "ໂມຣັອກໂຄ" },
            { "MC", "ໂມນາໂຄ" },
            { "MD", "ໂມນໂດວາ" },
            { "ME", "ມອນເຕເນໂກຣ" },
            { "MF", "ເຊນ ມາທິນ" },
            { "MG", "ມາດາກາສະກາ" },
            { "MH", "ຫມູ່ເກາະມາແຊວ" },
            { "MK", "ແມຊິໂດເນຍເໜືອ" },
            { "ML", "ມາລີ" },
            { "MM", "ມຽນມາ (ເບີມາ)" },
            { "MN", metaValue_MN },
            { "MO", "ມາກາວ ເຂດປົກຄອງພິເສດ ຈີນ" },
            { "MP", "ໝູ່ເກາະມາເຣຍນາຕອນເໜືອ" },
            { "MQ", "ມາຕິນີກ" },
            { "MR", "ມົວຣິເທເນຍ" },
            { "MS", "ມອນເຊີຣາດ" },
            { "MT", "ມອນທາ" },
            { "MU", "ມົວຣິຊຽສ" },
            { "MV", "ມັນດິຟ" },
            { "MW", "ມາລາວີ" },
            { "MX", "ເມັກຊິໂກ" },
            { "MY", "ມາເລເຊຍ" },
            { "MZ", "ໂມແຊມບິກ" },
            { "NA", "ນາມີເບຍ" },
            { "NC", "ນິວ ຄາເລໂດເນຍ" },
            { "NE", "ນິເຈີ" },
            { "NF", "ເກາະນໍໂຟກ" },
            { "NG", "ໄນຈີເຣຍ" },
            { "NI", "ນິກຄາຣາກົວ" },
            { "NL", "ເນເທີແລນ" },
            { "NO", "ນໍເວ" },
            { "NP", "ເນປານ" },
            { "NR", "ນາອູຣູ" },
            { "NU", "ນີອູເອ" },
            { "NZ", "ນິວຊີແລນ" },
            { "OM", "ໂອມານ" },
            { "PA", "ພານາມາ" },
            { "PE", "ເປຣູ" },
            { "PF", "ເຟຣນຊ໌ ໂພລິນີເຊຍ" },
            { "PG", "ປາປົວນິວກີນີ" },
            { "PH", "ຟິລິບປິນ" },
            { "PK", "ປາກິດສະຖານ" },
            { "PL", "ໂປແລນ" },
            { "PM", "ເຊນ ປີແອ ມິເກວລອນ" },
            { "PN", "ໝູ່ເກາະພິດແຄນ" },
            { "PR", "ເພືອໂຕ ຣິໂກ" },
            { "PS", "ດິນແດນປາເລດສະຕິນ" },
            { "PT", "ພອລທູໂກ" },
            { "PW", "ປາລາວ" },
            { "PY", "ພາຣາກວຍ" },
            { "QA", "ກາຕາ" },
            { "QO", "ເຂດຫ່າງໄກໂອຊີເນຍ" },
            { "RE", "ເຣອູນິຍົງ" },
            { "RO", "ໂຣແມເນຍ" },
            { "RS", "ເຊີເບຍ" },
            { "RU", "ຣັດເຊຍ" },
            { "RW", "ຣວັນດາ" },
            { "SA", "ຊາອຸດິ ອາຣາເບຍ" },
            { "SB", "ຫມູ່ເກາະໂຊໂລມອນ" },
            { "SC", "ເຊເຊວເລສ" },
            { "SD", "ຊູດານ" },
            { "SE", "ສະວີເດັນ" },
            { "SG", "ສິງກະໂປ" },
            { "SH", "ເຊນ ເຮເລນາ" },
            { "SI", "ສະໂລເວເນຍ" },
            { "SJ", "ສະວາບາ ແລະ ແຢນ ມາເຢນ" },
            { "SK", "ສະໂລວາເກຍ" },
            { "SL", "ເຊຍຣາ ລີໂອນ" },
            { "SM", "ແຊນ ມາຣິໂນ" },
            { "SN", "ເຊນີໂກລ" },
            { "SO", "ໂຊມາເລຍ" },
            { "SR", "ຊູຣິນາມ" },
            { "SS", "ຊູດານໃຕ້" },
            { "ST", "ເຊົາທູເມ ແລະ ພຣິນຊິບ" },
            { "SV", "ເອວ ຊໍວາດໍ" },
            { "SX", "ຊິນ ມາເທັນ" },
            { "SY", metaValue_SY },
            { "SZ", "​ເອ​ສະ​ວາ​ຕິ​ນີ" },
            { "TA", "ທຣິສຕັນ ດາ ກັນຮາ" },
            { "TC", "ໝູ່ເກາະ ເທີກ ແລະ ໄຄໂຄສ" },
            { "TD", "ຊາດ" },
            { "TF", "ເຂດແດນທາງໃຕ້ຂອງຝຮັ່ງ" },
            { "TG", "ໂຕໂກ" },
            { "TH", metaValue_TH },
            { "TJ", "ທາຈິກິດສະຖານ" },
            { "TK", metaValue_TK },
            { "TL", "ທິມໍ-ເລສເຕ" },
            { "TM", "ເທີກເມນິສະຖານ" },
            { "TN", "ຕູນິເຊຍ" },
            { "TO", "ທອງກາ" },
            { "TR", "ເທີຄີ" },
            { "TT", "ທຣິນິແດດ ແລະ ໂທແບໂກ" },
            { "TV", metaValue_TV },
            { "TW", "ໄຕ້ຫວັນ" },
            { "TZ", "ທານຊາເນຍ" },
            { "UA", "ຢູເຄຣນ" },
            { "UG", "ອູການດາ" },
            { "UM", "ໝູ່ເກາະຮອບນອກຂອງສະຫະລັດຯ" },
            { "UN", "ສະຫະປະຊາຊາດ" },
            { "US", "ສະຫະລັດ" },
            { "UY", "ອູຣຸກວຍ" },
            { "UZ", "ອຸສເບກິສະຖານ" },
            { "VA", "ນະຄອນ ວາຕິກັນ" },
            { "VC", "ເຊນ ວິນເຊນ ແລະ ເກຣເນດິນ" },
            { "VE", "ເວເນຊູເອລາ" },
            { "VG", "ໝູ່ເກາະ ເວີຈິນຂອງອັງກິດ" },
            { "VI", "ໝູ່ເກາະ ເວີຈິນ ຂອງສະຫະລັດ" },
            { "VN", metaValue_VN },
            { "VU", "ວານົວຕູ" },
            { "WF", "ວາລລິສ ແລະ ຟູຕູນາ" },
            { "WS", metaValue_WS },
            { "XA", "ສຳນຽງຊູໂດ" },
            { "XB", "ຊູໂດບີດີ" },
            { "XK", "ໂຄໂຊໂວ" },
            { "YE", "ເຢເມນ" },
            { "YT", "ມາຢັອດ" },
            { "ZA", "ອາຟຣິກາໃຕ້" },
            { "ZM", "ແຊມເບຍ" },
            { "ZW", "ຊິມບັບເວ" },
            { "ZZ", "ຂົງເຂດທີ່ບໍ່ຮູ້ຈັກ" },
            { "aa", "ອະຟາ" },
            { "ab", "ແອບຄາຊຽນ" },
            { "ae", "ອາເວັສແຕນ" },
            { "af", "ອາຟຣິການ" },
            { "ak", "ອາການ" },
            { "am", "ອຳຮາຣິກ" },
            { "an", "ອາຣາໂກເນັດ" },
            { "ar", "ອາຣັບ" },
            { "as", "ອັສຊາມີສ" },
            { "av", "ອາວາຣິກ" },
            { "ay", "ອາຍມາລາ" },
            { "az", "ອາເຊີໄບຈານິ" },
            { "ba", "ບາຣກີ" },
            { "be", "ເບລາຣັສຊຽນ" },
            { "bg", "ບັງກາຣຽນ" },
            { "bi", "ບິສລະມາ" },
            { "bm", "ບາມບາຣາ" },
            { "bn", "ເບັງກາລີ" },
            { "bo", metaValue_bo },
            { "br", "ເບຣຕັນ" },
            { "bs", "ບອສນຽນ" },
            { "ca", "ຄາຕາລານ" },
            { "ce", "ຊີເຄນ" },
            { "ch", "ຊາມໍໂຣ" },
            { "co", "ຄໍຊິກາ" },
            { "cr", "ຄີ" },
            { "cs", "ເຊກ" },
            { "cu", "ໂບດສລາວິກ" },
            { "cv", "ຊູວາຊ" },
            { "cy", "ເວວ" },
            { "da", "ແດນິຊ" },
            { "de", metaValue_DE },
            { "dv", "ດີວີຮີ" },
            { "dz", "ດີຊອງຄາ" },
            { "ee", "ອິວາ" },
            { "el", metaValue_el },
            { "en", "ອັງກິດ" },
            { "eo", "ເອສປາຍ" },
            { "es", "ສະແປນນິຊ" },
            { "et", "ເອສໂຕນຽນ" },
            { "eu", "ບັສກີ" },
            { "fa", "ເປີຊຽນ" },
            { "ff", "ຟູລາ" },
            { "fi", "ຟິນນິຊ" },
            { "fj", "ຟິຈຽນ" },
            { "fo", "ຟາໂຣສ" },
            { "fr", metaValue_FR },
            { "fy", "ຟຣິຊຽນ ຕາເວັນຕົກ" },
            { "ga", "ໄອຣິສ" },
            { "gd", "ສະກັອດເກລິກ" },
            { "gl", "ກາລິຊຽນ" },
            { "gn", "ກົວຣານີ" },
            { "gu", "ກູຈາຣາຕິ" },
            { "gv", "ແມງຊ໌" },
            { "ha", "ເຮົາຊາ" },
            { "he", metaValue_he },
            { "hi", "ຮິນດິ" },
            { "ho", "ຮິຣິໂມຕູ" },
            { "hr", "ໂຄຣເອທຽນ" },
            { "ht", "ໄຮຕຽນ" },
            { "hu", "ຮັງກາຣຽນ" },
            { "hy", metaValue_hy },
            { "hz", "ເຮິຮິໂຣ" },
            { "ia", "ອິນເຕີລິງລົວ" },
            { "id", "ອິນໂດເນຊຽນ" },
            { "ie", "ອິນເຕີລິງກຣີ" },
            { "ig", "ອິກໂບ" },
            { "ii", "ເສສວນ ອີ" },
            { "ik", "ອິນນູປຽກ" },
            { "io", "ອີໂດ" },
            { "is", "ໄອສແລນດິກ" },
            { "it", "ອິຕາລຽນ" },
            { "iu", "ອິນນຸກຕິຕັດ" },
            { "ja", metaValue_JP },
            { "jv", "ຈາແວນີສ" },
            { "ka", metaValue_ka },
            { "kg", "ຄອງໂກ" },
            { "ki", "ຄິຄູຢຸ" },
            { "kj", "ກວນຍາມາ" },
            { "kk", "ຄາຊັກ" },
            { "kl", "ກຣີນແລນລິດ" },
            { "km", "ຂະເໝນ" },
            { "kn", metaValue_kn },
            { "ko", "ເກົາຫລີ" },
            { "kr", "ຄານຸລິ" },
            { "ks", "ຄາສເມຍຣິ" },
            { "ku", "ເຄີມານຈິ" },
            { "kv", "ໂຄມິ" },
            { "kw", "ຄໍນິຊ" },
            { "ky", "ເກຍກີສ" },
            { "la", metaValue_la },
            { "lb", "ລັກເຊມບວກກິຊ" },
            { "lg", "ແກນດາ" },
            { "li", "ລິມເບີກີຊ" },
            { "ln", "ລິງກາລາ" },
            { "lo", metaValue_LA },
            { "lt", "ລິທົວນຽນ" },
            { "lu", "ລູບາ-ຄາຕັງກາ" },
            { "lv", "ລັດວຽນ" },
            { "mg", "ມາລາກາສຊີ" },
            { "mh", "ມາຊານເລັດ" },
            { "mi", "ມາວຣິ" },
            { "mk", "ແມຊິໂດນຽນ" },
            { "ml", "ມາເລອາລຳ" },
            { "mn", metaValue_MN },
            { "mr", "ມາຣາທີ" },
            { "ms", "ມາເລ" },
            { "mt", "ມອລທີສ" },
            { "my", metaValue_my },
            { "na", "ນາຢູລູ" },
            { "nb", "ນໍເວຈຽນ ບັອກມອລ" },
            { "nd", "ເອັນເດເບເລເໜືອ" },
            { "ne", "ເນປາລີ" },
            { "ng", "ເອັນດອງກາ" },
            { "nl", "ດັຊ" },
            { "nn", "ນໍເວຈຽນ ນີນອກ" },
            { "no", "ນໍເວຈຽນ" },
            { "nr", "ນີບີລີໃຕ້" },
            { "nv", "ນາວາໂຈ" },
            { "ny", "ນານຈາ" },
            { "oc", "ອັອກຊີຕານ" },
            { "oj", "ໂອຈິບວາ" },
            { "om", "ໂອໂຣໂມ" },
            { "or", metaValue_or },
            { "os", "ອອດເຊຕິກ" },
            { "pa", "ປັນຈາບີ" },
            { "pi", "ປາລີ" },
            { "pl", "ໂປລິຊ" },
            { "ps", "ປາສໂຕ" },
            { "pt", "ປອກຕຸຍກິສ" },
            { "qu", "ຄີຊົວ" },
            { "rm", "ໂຣແມນຊ໌" },
            { "rn", "ຣຸນດິ" },
            { "ro", "ໂຣແມນຽນ" },
            { "ru", "ລັດເຊຍ" },
            { "rw", "ຄິນຢາວານດາ" },
            { "sa", "ສັນສະກຣິດ" },
            { "sc", "ສາດີນຽນ" },
            { "sd", "ສິນທິ" },
            { "se", "ຊາມິເໜືອ" },
            { "sg", "ແຊງໂກ" },
            { "sh", "ເຊີໂບ-ໂກເຊຍ" },
            { "si", metaValue_si },
            { "sk", "ສະໂລແວັກ" },
            { "sl", "ສະໂລເວນຽນ" },
            { "sm", metaValue_WS },
            { "sn", "ໂຊນາ" },
            { "so", "ໂຊມາລີ" },
            { "sq", "ອານບານຽນ" },
            { "sr", "ເຊີບຽນ" },
            { "ss", "ສະວາຕິ" },
            { "st", "ໂຊໂທໃຕ້" },
            { "su", "ຊຸນແດນນີສ" },
            { "sv", "ສະວີດິຊ" },
            { "sw", "ຊວາຮີລິ" },
            { "ta", metaValue_ta },
            { "te", "ເຕລູກູ" },
            { "tg", "ທາຈິກ" },
            { "th", metaValue_TH },
            { "ti", "ຕິກຣິນຢາ" },
            { "tk", "ເທີກເມັນ" },
            { "tl", metaValue_tl },
            { "tn", "ເຕສະວານາ" },
            { "to", "ທອງການ" },
            { "tr", "ເທີຄິຊ" },
            { "ts", "ເຕຊອງກາ" },
            { "tt", "ທາທາ" },
            { "tw", "ທວີ" },
            { "ty", "ຕາຮີຕຽນ" },
            { "ug", "ອຸຍເຄີ" },
            { "uk", "ຢູເຄຣນຽນ" },
            { "ur", "ອູຣດູ" },
            { "uz", "ອຸສເບກ" },
            { "ve", "ເວນດາ" },
            { "vi", metaValue_VN },
            { "vo", "ໂວລາພັກ" },
            { "wa", "ວໍລູມ" },
            { "wo", "ວໍລອບ" },
            { "xh", "ໂຮຊາ" },
            { "yi", "ຢິວ" },
            { "yo", "ໂຢຣູບາ" },
            { "za", "ຊວາງ" },
            { "zh", metaValue_CN },
            { "zu", "ຊູລູ" },
            { "ace", "ແອັກຊີເນັສ" },
            { "ach", "ອາໂຄລີ" },
            { "ada", "ອາແດງມີ" },
            { "ady", "ເອດີຮິ" },
            { "afh", "ແອຟີຮີລີ" },
            { "agq", "ອາເຮັມ" },
            { "ain", "ໄອນູ" },
            { "akk", "ອັກກາດຽມ" },
            { "ale", "ອາເລີດ" },
            { "alt", "ອານໄຕໃຕ້" },
            { "ang", "ອັງກິດໂບຮານ" },
            { "ann", "ໂອໂບໂລ" },
            { "anp", "ແອນຈີກາ" },
            { "arc", "ອາລາມິກ" },
            { "arn", "ມາພຸດຊີ" },
            { "arp", "ອາຣາປາໂຮ" },
            { "ars", "ນາຈດີ ອາຣາບິກ" },
            { "arw", "ອາຣາແວກ" },
            { "asa", "ອາຊູ" },
            { "ast", "ອັສຕູຮຽນ" },
            { "atj", "ອາຕິກາແມກ" },
            { "awa", "ອາວາຮິ" },
            { "bal", "ບາລູຊີ" },
            { "ban", "ບາລີເນັດ" },
            { "bas", "ບາຊາ" },
            { "bax", "ບາມຸນ" },
            { "bbj", "ໂຄມາລາ" },
            { "bej", "ບີເຈ" },
            { "bem", "ເບັມບາ" },
            { "bez", "ບີນາ" },
            { "bfd", "ບາຟັດ" },
            { "bgc", "ຮາຢານວີ" },
            { "bgn", "ບາໂລຈີ ພາກຕາເວັນຕົກ" },
            { "bho", "ໂບພູຣິ" },
            { "bik", "ບີຄອນ" },
            { "bin", "ບີນີ" },
            { "bkm", "ກົມ" },
            { "bla", "ຊິກຊິກາ" },
            { "blo", "ອານີ" },
            { "bra", "ບຣາ" },
            { "brx", "ໂບດູ" },
            { "bss", "ອາຄຸດ" },
            { "bua", "ບູຣຽດ" },
            { "bug", "ບູຈີເນັດ" },
            { "bum", "ບູລູ" },
            { "byn", "ບລິນ" },
            { "byv", "ເມດູມບາ" },
            { "cad", "ແຄດໂດ" },
            { "car", "ຄາຣິບ" },
            { "cay", "ຄາຢູກາ" },
            { "cch", "ອາດແຊມ" },
            { "ccp", metaValue_ccp },
            { "ceb", "ຊີບູໂນ" },
            { "cgg", "ຊີກາ" },
            { "chb", "ຊິບຊາ" },
            { "chg", "ຊາກາໄຕ" },
            { "chk", "ຊູເກດ" },
            { "chm", "ມາຣິ" },
            { "chn", "ຊີນຸກຈາກອນ" },
            { "cho", "ຊອກຕິວ" },
            { "chp", "ຊີພິວຢານ" },
            { "chr", "ຊີໂຣກີ" },
            { "chy", "ຊີເຢນນີ" },
            { "ckb", "ໂຊຣານິ ເຄີດິຊ" },
            { "clc", "ຊິວໂຄຕິນ" },
            { "cop", metaValue_cop },
            { "crg", "ມິຊິຟ" },
            { "crh", "ຄຣີເມນເຕີຄິຊ" },
            { "crj", "ຄຣີຕາເວັນອອກສ່ຽງໃຕ້" },
            { "crk", "ເພລນຄຣີ" },
            { "crl", "ຄຣີຕາເວັນອອກສ່ຽງເໜືອ" },
            { "crm", "ມູສຄຣີ" },
            { "crr", "ຄາໂຣລິນາ ອາກອນຄວຽນ" },
            { "crs", "ເຊເຊວາ ໂຄຣດ ຝຣັ່ງ" },
            { "csb", "ກາຊູບຽນ" },
            { "csw", "ຊວາມປີຄຣີ" },
            { "dak", "ດາໂກຕາ" },
            { "dar", "ດາກວາ" },
            { "dav", "ໄຕຕາ" },
            { "del", "ເດລາວາ" },
            { "den", "ຊີເລັບ" },
            { "dgr", "ໂດກຣິບ" },
            { "din", "ດິນກາ" },
            { "dje", "ຊາມາ" },
            { "doi", "ດອກຣີ" },
            { "dsb", "ຊໍບຽນຕໍ່ກວ່າ" },
            { "dua", "ດົວລາ" },
            { "dum", "ດັກກາງ" },
            { "dyo", "ໂຈລາ-ຟອນຢີ" },
            { "dyu", "ດູລາ" },
            { "dzg", "ດາຊາກາ" },
            { "ebu", "ເອັມບູ" },
            { "efi", "ອີຟິກ" },
            { "egy", "ອີຢິບບູຮານ" },
            { "eka", "ອີກາຈັກ" },
            { "elx", "ອີລາໄມ" },
            { "enm", "ອັງກິດກາງ" },
            { "ewo", "ອີວອນດູ" },
            { "fan", "ແຟງ" },
            { "fat", "ແຟນຕີ" },
            { "fil", "ຟີລິປີໂນ" },
            { "fon", "ຟອນ" },
            { "frc", "ຝຣັ່ງເຄຈຸນ" },
            { "frm", "ຟຮັ່ງເສດກາງ" },
            { "fro", "ຟຮັ່ງເສດໂບຮານ" },
            { "frr", "ຟຣີຊຽນເໜືອ" },
            { "frs", "ຟຣີຊຽນຕາເວັນອອກ" },
            { "fur", "ຟຣີລຽນ" },
            { "gaa", "ກາ" },
            { "gag", "ກາກາອຸຊ" },
            { "gay", "ກາໂຢ" },
            { "gba", "ບາຍາ" },
            { "gez", "ກີ" },
            { "gil", "ກິນເບີເທັດ" },
            { "gmh", "ເຢຍລະມັນສູງກາງ" },
            { "goh", "ເຢຍລະມັນສູງໂບຮານ" },
            { "gon", "ກອນດີ" },
            { "gor", "ໂກຣອນຕາໂຣ" },
            { "got", "ກອດຮິກ" },
            { "grb", "ກຣີໂບ" },
            { "grc", "ແອນຊຽນກຣີກ" },
            { "gsw", "ສະວິສ ເຈີແມນ" },
            { "guz", "ກູຊິ" },
            { "gwi", "ວິດອິນ" },
            { "hai", "ໄຮດາ" },
            { "haw", "ຮາໄວອຽນ" },
            { "hax", "ໄຮດາໃຕ້" },
            { "hil", "ຮິຣິໄກນອນ" },
            { "hit", "ຮິດໄຕ" },
            { "hmn", "ມອງ" },
            { "hsb", "ຊໍບຽນ ທາງຕອນເໜືອ" },
            { "hup", "ຮູປາ" },
            { "hur", "ຮາລໂກເມລຽມ" },
            { "iba", "ໄອບານ" },
            { "ibb", "ໄອໄບໄບໂອ" },
            { "ikt", "ອິນັກທິທັດຄານາດາຕາເວັນຕົກ" },
            { "ilo", "ໄອໂລໂກ" },
            { "inh", "ອິນກັຊ" },
            { "jbo", "ໂລບບັນ" },
            { "jgo", "ງອມບາ" },
            { "jmc", "ມາແຊມ" },
            { "jpr", "ຈູແດວ-ເພີຊຽນ" },
            { "jrb", "ຈູແດວ-ອາລາບິກ" },
            { "kaa", "ກາຣາ-ການປາກ" },
            { "kab", "ກາໄບລ໌" },
            { "kac", "ກາຊິນ" },
            { "kaj", "ຈຣູ" },
            { "kam", "ກາມບາ" },
            { "kaw", "ກະວີ" },
            { "kbd", "ກາບາດຽນ" },
            { "kbl", "ຄາແນມບູ" },
            { "kcg", "ຕີບ" },
            { "kde", "ມາຄອນເດ" },
            { "kea", "ຄາເວີເດຍນູ" },
            { "kfo", "ໂຄໂລ" },
            { "kgp", "ເຄນກັງ" },
            { "kha", "ຄາສິ" },
            { "kho", "ໂຄຕັນ" },
            { "khq", "ຄອຍຣາ ຊິນີ" },
            { "kkj", "ຄາໂກ" },
            { "kln", "ຄາເລັນຈິນ" },
            { "kmb", "ຄິມບັນດູ" },
            { "koi", "ໂຄມີ-ເພີມຢັກ" },
            { "kok", "ກອນການີ" },
            { "kos", "ຄູສໄລ" },
            { "kpe", "ກາແປຣ" },
            { "krc", "ກາຣາໄຊ-ບານກາ" },
            { "krl", "ກາເຣລຽນ" },
            { "kru", "ກູຣູກ" },
            { "ksb", "ຊຳບາລ້າ" },
            { "ksf", "ບາເຟຍ" },
            { "ksh", "ໂຄລອກນຽນ" },
            { "kum", "ຄູມີກ" },
            { "kut", "ຄູເທໄນ" },
            { "kwk", "ຄວາກຄວາກລາ" },
            { "kxv", "ຄູວີ" },
            { "lad", "ລາດີໂນ" },
            { "lag", "ແລນກິ" },
            { "lah", "ລານດາ" },
            { "lam", "ແລມບາ" },
            { "lez", "ລີຊຽນ" },
            { "lij", "ລີກູຣຽນ" },
            { "lil", "ລິນລູເອັດ" },
            { "lkt", "ລາໂກຕາ" },
            { "lmo", "ລອມບາດ" },
            { "lol", "ແມັງໂກ້" },
            { "lou", "ລຸຍຊີອານນາ ຄຣີໂອນ" },
            { "loz", "ໂລຊິ" },
            { "lrc", "ລູຣິ ທາງຕອນເໜືອ" },
            { "lsm", "ຊາອາເມຍ" },
            { "lua", "ລູບາ-ລູລົວ" },
            { "lui", "ລູເຊໂນ" },
            { "lun", "ລຸນດາ" },
            { "luo", "ລົວ" },
            { "lus", "ມີໂຊ" },
            { "luy", "ລູໄຍ" },
            { "mad", "ມາດູລາ" },
            { "maf", "ມາຟາ" },
            { "mag", "ມາກາຮິ" },
            { "mai", "ໄມທີລິ" },
            { "mak", "ມາກາຊາຣ" },
            { "man", "ມັນດິງກາ" },
            { "mas", "ມາໄຊ" },
            { "mde", "ມາບາ" },
            { "mdf", "ມອກຊາ" },
            { "mdr", "ມານດາຣ" },
            { "men", metaValue_men },
            { "mer", "ເມຣູ" },
            { "mfe", "ມໍຣິສເຢນ" },
            { "mga", "ໄອລິດກາງ" },
            { "mgh", "ມາຄູວາ-ມີດໂຕ" },
            { "mgo", "ເມທາ" },
            { "mic", "ມິກແມກ" },
            { "min", "ມີແນງກາບູ" },
            { "mnc", "ແມນຈູ" },
            { "mni", "ມານີພູຣິ" },
            { "moe", "ອິນນຸໄອມັນ" },
            { "moh", "ໂມຫາ" },
            { "mos", "ມອສຊີ" },
            { "mua", "ມັນດັງ" },
            { "mul", "ຫລາຍພາສາ" },
            { "mus", "ມັສໂກກີ" },
            { "mwl", "ມີລັນດາ" },
            { "mwr", "ມາວາຣິ" },
            { "mye", "ມໍຢິນ" },
            { "myv", "ເອີຍາ" },
            { "mzn", "ມາແຊນເດີລັງ" },
            { "nap", "ນາໂປລີ" },
            { "naq", "ນາມາ" },
            { "nds", "ເຢຍລະມັນ ຕອນໃຕ້" },
            { "new", "ນີວາຣິ" },
            { "nia", "ນີ່ອັດ" },
            { "niu", "ນີ່ອູ" },
            { "nmg", "ກວາຊີໂອ" },
            { "nnh", "ຈີ່ມບູນ" },
            { "nog", "ນໍໄກ" },
            { "non", "ນໍໂບຮານ" },
            { "nqo", metaValue_nqo },
            { "nso", "ໂຊໂທເໜືອ" },
            { "nus", "ເນີ" },
            { "nwc", "ເນວາດັ້ງເດີມ" },
            { "nym", "ນາມວີຊິ" },
            { "nyn", "ນານຄອນ" },
            { "nyo", "ໂນໂຣ" },
            { "nzi", "ນິມາ" },
            { "ojb", "ໂອຈິບວາຕາເວັນຕົກສ່ຽງເໜືອ" },
            { "ojc", "ໂອຈິບວາກາງ" },
            { "ojs", "ໂອຈິຄຣີ" },
            { "ojw", "ໂອຈິບວາຕາເວັນຕົກ" },
            { "oka", "ໂອກະນາກັນ" },
            { "osa", "ໂອແຊກ" },
            { "ota", "ຕູກີອອດໂຕມັນ" },
            { "pag", "ປານກາຊີນານ" },
            { "pal", "ພາລາວີ" },
            { "pam", "ປາມປານກາ" },
            { "pap", "ປາມເປຍເມັນໂທ" },
            { "pau", "ປາລົວອານ" },
            { "pcm", "ໄນຈີຣຽນພິດກິນ" },
            { "peo", "ເປີເຊຍໂບຮານ" },
            { "phn", "ຟີນີເຊຍ" },
            { "pis", "ປິຈິນ" },
            { "pon", "ພອນເພ" },
            { "pqm", "ມາລິຊີດ ພາສຊາມາໂຄດດີ" },
            { "prg", "ປຣັສຊຽນ" },
            { "pro", "ໂປວອງຊານໂບຮານ" },
            { "quc", "Kʼicheʼ" },
            { "raj", "ຣາຈັສທານິ" },
            { "rap", "ຣາປານຸຍ" },
            { "rar", "ຣາໂຣທອນການ" },
            { "rhg", "ໂຣຮິນຢາ" },
            { "rof", "ຣົມໂບ" },
            { "rom", "ໂຣເມນີ" },
            { "rup", "ອາໂຣມານຽນ" },
            { "rwk", "ອາຣວາ" },
            { "sad", "ຊັນດາວ" },
            { "sah", "ຊາກາ" },
            { "sam", "ສາມາຣິແຕນ-" },
            { "saq", "ຊຳບູຣູ" },
            { "sas", "ຊາຊັກ" },
            { "sat", "ຊານທາລິ" },
            { "sba", "ກຳເບ" },
            { "sbp", "ຊານກູ" },
            { "scn", "ຊີຊິລີນ" },
            { "sco", "ສກອດ" },
            { "sdh", "ພາກໄຕ້ ຂອງ ກູດິດ" },
            { "see", "ຊີນີກາ" },
            { "seh", "ຊີນາ" },
            { "sel", "ເຊນຄັບ" },
            { "ses", "ໂຄຍຣາໂບໂຣ ເຊນນິ" },
            { "sga", "ອີຣິຊເກົ່າ" },
            { "shi", "ທາເຊວຫິດ" },
            { "shn", "ຊານ" },
            { "shu", "ອາລັບ-ຊາດ" },
            { "sid", "ຊິດາໂມ" },
            { "slh", "ລູຊຸດຊີດໃຕ້" },
            { "sma", "ຊາມິໃຕ້" },
            { "smj", "ລຸນຊາມິ" },
            { "smn", "ອີນາຣິຊາມິ" },
            { "sms", "ສກອດຊາມິ" },
            { "snk", "ໂຊນິນກີ" },
            { "sog", "ຊອກດິນ" },
            { "srn", "ສຣານນານຕອນໂກ" },
            { "srr", "ເຊເລີ" },
            { "ssy", metaValue_ssy },
            { "str", "ຊ່ອງແຄບເຊລີຊ" },
            { "suk", "ຊູຄູມ້າ" },
            { "sus", "ຊູຊູ" },
            { "sux", "ຊູເມີເລຍ" },
            { "swb", "ໂຄໂນຣຽນ" },
            { "syc", "ຊີເລຍແບບດັ້ງເດີມ" },
            { "syr", "ຊີເລຍ" },
            { "szl", "ຊີເລສຊຽນ" },
            { "tce", "ທຸດຊອນໃຕ້" },
            { "tem", "ທີມເນ" },
            { "teo", "ເຕໂຊ" },
            { "ter", "ເຕເລໂນ" },
            { "tet", "ເຕຕູມ" },
            { "tgx", "ທາກີຊ" },
            { "tht", "ທາວທັນ" },
            { "tig", "ໄທກຣີ" },
            { "tiv", "ຕີວ" },
            { "tkl", metaValue_TK },
            { "tlh", "ຄຣິງກອນ" },
            { "tli", "ທລີງກິດ" },
            { "tmh", "ທາມາກເຊກ" },
            { "tog", "ນາຍອາຊາຕອງກາ" },
            { "tok", "ໂທກີໂພນາ" },
            { "tpi", "ທອກພີຊິນ" },
            { "trv", "ຕາໂລໂກ" },
            { "tsi", "ຊີມຊີແອນ" },
            { "ttm", "ທັດໂຈນເເໜືອ" },
            { "tum", "ຕຳບູກາ" },
            { "tvl", metaValue_TV },
            { "twq", "ຕາຊາວັກ" },
            { "tyv", "ຕູວີນຽນ" },
            { "tzm", "ອັດລາສ ທາມາຊີກ ກາງ" },
            { "udm", "ອຸດມັດ" },
            { "uga", "ຢູກາລິກ" },
            { "umb", "ອຳບັນດູ" },
            { "und", "ບໍ່ສາມາດລະບຸພາສາ" },
            { "vai", metaValue_vai },
            { "vec", "ເວເນຊຽນ" },
            { "vmw", "ມາຄູວາ" },
            { "vot", "ໂວຕິກ" },
            { "vun", "ວັນໂຈ" },
            { "wae", "ວາເຊີ" },
            { "wal", "ໂວເລຕາ" },
            { "war", "ວາເລ" },
            { "was", "ວາໂຊ" },
            { "wbp", "ວາຣພິຣິ" },
            { "wuu", "ຈີນອູ" },
            { "xal", "ການມິກ" },
            { "xnr", "ຄັງຣີ" },
            { "xog", "ໂຊກາ" },
            { "yao", "ເຢົ້າ" },
            { "yap", "ຢັບ" },
            { "yav", "ແຍງເບນ" },
            { "ybb", "ແຢມບາ" },
            { "yrl", "ນີນກາຕູ" },
            { "yue", "ກວາງຕຸ້ງ" },
            { "zap", "ຊາໂປແຕບ" },
            { "zbl", "ສັນຍາລັກບລີຊິມ" },
            { "zen", "ເຊນາກາ" },
            { "zgh", "ໂມຣັອກແຄນ ທາມາຊີກ ມາດຕະຖານ" },
            { "zun", "ຊູນີ" },
            { "zxx", "ບໍ່ມີເນື້ອຫາພາສາ" },
            { "zza", "ຊາຊາ" },
            { "Adlm", "ແອດລາມ" },
            { "Afak", "ອັບຟາກາ" },
            { "Arab", "ອາຣາບິກ" },
            { "Aran", "ນາສຕໍລິກ (ຄຳໃບ້ການແປ: ລະຫັດພິເສດກຳນົດຮູບແບບຕົວໜັງສືອາຣັບ.)" },
            { "Armi", "ອິມພີຮຽນ ອາເມອິກ" },
            { "Armn", metaValue_hy },
            { "Avst", "ອະເວສຕະ" },
            { "Bali", "ບາລີ" },
            { "Bamu", "ບາມູມ" },
            { "Bass", "ບັດຊາ" },
            { "Batk", "ບາຕັກ" },
            { "Beng", "ເບັງກາ" },
            { "Blis", "ບລິກຊິມໂບລສ" },
            { "Bopo", "ຈູ້ອິນ" },
            { "Brah", "ພຮາຫມີ" },
            { "Brai", "ເບຣວ" },
            { "Bugi", "ບູກິສ" },
            { "Buhd", "ບູຮິດ" },
            { "Cakm", metaValue_ccp },
            { "Cans", "ສັນຍາລັກຊົນເຜົ່າພື້ນເມືອງແຄນນາດາ" },
            { "Cari", "ຄາເຮຍ" },
            { "Cham", "ຈາມ" },
            { "Cher", "ເຊໂຣກີ" },
            { "Cirt", "ເຊີຮ" },
            { "Copt", metaValue_cop },
            { "Cprt", "ໄຊເປຍ" },
            { "Cyrl", "ຊີຣິວລິກ" },
            { "Cyrs", "ເຊຮັດສລາ ໂວນິກຊີຮິກລິກໂບຮານ" },
            { "Deva", "ດີວານາກາຣີ" },
            { "Dsrt", "ເດເຊເຮ" },
            { "Dupl", "ຊົວເລດັບໂລຍັນ" },
            { "Egyd", "ດີໂມຕິກອີຍິບ" },
            { "Egyh", "ເຮຍຮາຕິກອີຍິບ" },
            { "Egyp", "ເຮຍໂຮກລິຟອີຍິບ" },
            { "Ethi", "ອີທິໂອປິກ" },
            { "Geok", "ຄອດຊູຮີຈໍເຈຍ" },
            { "Geor", metaValue_ka },
            { "Glag", "ກລາໂກລິຕິກ" },
            { "Goth", "ໂກຮິກ" },
            { "Gran", "ເຄນທາ" },
            { "Grek", metaValue_el },
            { "Gujr", "ຈູຈາຣາທີ" },
            { "Guru", "ກົວມູຄີ" },
            { "Hanb", "ຮັນ" },
            { "Hang", "ຮັນກູນ" },
            { "Hani", "ຮານ" },
            { "Hano", "ຮານູໂນໂອ" },
            { "Hans", "ແບບຮຽບງ່າຍ" },
            { "Hant", "ແບບດັ້ງເດີມ" },
            { "Hebr", metaValue_he },
            { "Hira", "ຣິຣະງະນະ" },
            { "Hluw", "ອັກລຮະອານາໂຕເລຍ" },
            { "Hmng", "ປາເຮາເມັງ" },
            { "Hrkt", "ຕາຕາລາງພະຍາງພາສາຍີ່ປຸ່ນ" },
            { "Hung", "ຮັງກາຮີໂບຮານ" },
            { "Inds", "ອິນດັດ" },
            { "Ital", "ອີຕາລີໂບຮານ" },
            { "Jamo", "ຈາໂມ" },
            { "Java", "ຈາວາ" },
            { "Jpan", metaValue_JP },
            { "Jurc", "ຈູຮເຊັນ" },
            { "Kali", "ຄຍາ" },
            { "Kana", "ຄະຕະກະນະ" },
            { "Khar", "ຂໍໂຮກສີ" },
            { "Khmr", "ຂະແມ" },
            { "Khoj", "ຄໍຈຄີ" },
            { "Knda", metaValue_kn },
            { "Kore", "ເກົາຫຼີ" },
            { "Kpel", "ເປລເລ" },
            { "Kthi", "ກາຍຕິ" },
            { "Lana", "ລ້ານນາ" },
            { "Laoo", metaValue_LA },
            { "Latf", "ລາຕິນ-ຟຮັ່ງເຕຣ" },
            { "Latg", "ລາຕິນ-ແກລິກ" },
            { "Latn", metaValue_la },
            { "Lepc", "ເລຊາ" },
            { "Limb", "ລິມບູ" },
            { "Lina", "ລີເນຍ" },
            { "Linb", "ລີເນຍຣ" },
            { "Lisu", "ເຟຣເຊຮ" },
            { "Loma", "ໂລມາ" },
            { "Lyci", "ໄລເຊຍ" },
            { "Lydi", "ລີເດຍ" },
            { "Mand", "ແມນດຽນ" },
            { "Mani", "ມານິແຊນ" },
            { "Maya", "ມາຍາໄຮໂຮກລິບ" },
            { "Mend", metaValue_men },
            { "Merc", "ເຄເລີຊີເມໂຮອິຕິກ" },
            { "Mero", "ເມໂຮຕິກ" },
            { "Mlym", "ມາເລຢາລາມ" },
            { "Mong", "ມົງໂກນ" },
            { "Moon", "ມູນ" },
            { "Mroo", "ເມໂຮ" },
            { "Mtei", "ເມເທມາເຍກ" },
            { "Mymr", metaValue_my },
            { "Narb", "ອາຮະເບຍເໜືອໂບຮານ" },
            { "Nbat", "ນາບາທາທຽນ" },
            { "Nkgb", "ກີບາ-ນາຊີ" },
            { "Nkoo", metaValue_nqo },
            { "Nshu", "ນຸຊຸ" },
            { "Ogam", "ອອກຄອນ" },
            { "Olck", "ໂອຊິກິ" },
            { "Orkh", "ອອກສມັນຍາ" },
            { "Orya", metaValue_or },
            { "Palm", "ພາລໄມຮິນ" },
            { "Perm", "ເພີມີໂບຮານ" },
            { "Phag", "ຟາກສ-ປາ" },
            { "Phli", "ປະຫລາວີອິນສຄິບຊັນແນລ" },
            { "Phlp", "ປະຫລາວີຊອດເຕຮ໌" },
            { "Phlv", "ປະຫລາວີບຸກ" },
            { "Phnx", "ຟີນິເຊຍ" },
            { "Plrd", "ສັດຕະສາດພໍຮລາ" },
            { "Prti", "ພາຮ໌ເທຍອິນສຄຮິປຊັນແນລ" },
            { "Rjng", "ເຮຈັງ" },
            { "Rohg", "ຮານິຟີ" },
            { "Roro", "ຮອງໂກຮອງໂກ" },
            { "Runr", "ຮູນິກ" },
            { "Samr", "ຊາມາເລຍ" },
            { "Sara", "ຊາຮາຕິ" },
            { "Sarb", "ອາລະເບຍໃຕ້ໂບຮານ" },
            { "Saur", "ໂສຮັດຕຣະ" },
            { "Sgnw", "ໄຊນ໌ໄຮຕີ້ງ" },
            { "Shaw", "ຊອວຽນ" },
            { "Shrd", "ຊາຮາດາ" },
            { "Sind", "ດຸດາວາດີ" },
            { "Sinh", metaValue_si },
            { "Sora", "ໂສຮາສົມເປັງ" },
            { "Sund", "ຊຸນດາ" },
            { "Sylo", "ຊີໂລຕິນາກຣີ" },
            { "Syrc", metaValue_SY },
            { "Syre", "ຊີເຮຍເອສທຮານຈີໂລ" },
            { "Syrj", "ຊີເຮຍຕາເວັນຕົກ" },
            { "Syrn", "ຊີເຮຍຕາເວັນອອກ" },
            { "Tagb", "ຕັກບັນວາ" },
            { "Takr", "ທາຄຮີ" },
            { "Tale", "ໄທເລ" },
            { "Talu", "ໄທລື້ໃໝ່" },
            { "Taml", metaValue_ta },
            { "Tang", "ຕັນກັນ" },
            { "Tavt", "ໄທຫວຽດ" },
            { "Telu", "ເທລູກູ" },
            { "Teng", "ເທງກວາຮ" },
            { "Tfng", "ທີຟີນາກ" },
            { "Tglg", metaValue_tl },
            { "Thaa", "ທານາ" },
            { "Thai", metaValue_TH },
            { "Tibt", metaValue_bo },
            { "Tirh", "ເທຮຸທາ" },
            { "Ugar", "ຍູກາຮິດ" },
            { "Vaii", metaValue_vai },
            { "Visp", "ຄຳເວົ້າທີ່ເບີ່ງເຫັນໄດ້" },
            { "Wara", "ວາຮັງກສິຕິ" },
            { "Wole", "ໂອລີເອ" },
            { "Xpeo", "ເປຮເຊຍໂບຮານ" },
            { "Xsux", "ອັກສອນຮູບປລີ່ມສຸເມເຮຍ-ອັດຄາເດຍ" },
            { "Yiii", "ຍີ" },
            { "Zinh", "ອິນເຮຮິດ" },
            { "Zmth", "ເຄື່ອງໝາຍທາງຄະນິດສາດ" },
            { "Zsye", "ອີໂມຈິ" },
            { "Zsym", "ສັນຍາລັກ" },
            { "Zxxx", "ບໍ່ມີພາສາຂຽນ" },
            { "Zyyy", "ສາມັນ" },
            { "Zzzz", "ແບບຂຽນທີ່ບໍ່ຮູ້ຈັກ" },
            { "de_AT", "ເຢຍລະມັນ (ໂອສຕຣິດ)" },
            { "de_CH", "ສະວິສ ໄຮ ເຈີແມນ" },
            { "en_GB", "ອັງກິດ (ບຣິດທິຊ)" },
            { "en_US", "ອັງກິດ (ອາເມລິກັນ)" },
            { "es_ES", "ສະເປັນ ຢຸໂຣບ" },
            { "es_MX", "ເມັກຊິກັນ ສະແປນນິຊ" },
            { "fa_AF", "ດາຣີ" },
            { "fr_CH", "ຝຣັ່ງ (ສວິສ)" },
            { "nl_BE", "ຟລີມິຊ" },
            { "pt_PT", "ປອກຕຸຍກິສ ຢຸໂຣບ" },
            { "ro_MD", "ໂມດາວຽນ" },
            { "sw_CD", "ຄອງໂກ ຊວາຮີລິ" },
            { "%%1901", "ເຢຍລະມັນອໍໂທກຣາຟີດັ້ງເດີມ" },
            { "%%1994", "ອັກສອນເຣຊ່ຽນມາດຕະຖານ" },
            { "%%1996", "ເຢຍລະມັນອໍໂທກຣາຟີປີ1996" },
            { "ar_001", "ອາຣາບິກມາດຕະຖານສະໄໝໃໝ່" },
            { "es_419", "ລາຕິນ ອາເມຣິກັນ ສະແປນນິຊ" },
            { "key.ca", "ປະຕິທິນ" },
            { "key.cf", "ຮູບແບບສະກຸນເງິນ" },
            { "key.co", "ຮຽງລຳດັບ" },
            { "key.cu", "ສະກຸນເງິນ" },
            { "key.em", "ການນໍາສະເໜີອີໂມຈິ" },
            { "key.hc", "ຮອບວຽນຊົ່ວໂມງ( 12 ຫຼື 24)" },
            { "key.lb", "ຮູບແບບເສັ້ນຂັ້ນ" },
            { "key.lw", "ຮູບແບບເສັ້ນຂັ້ນພາຍໃນຄໍາສັບ" },
            { "key.ms", "ລະບົບການວັດແທກ" },
            { "key.nu", "ຕົວເລກ" },
            { "key.ss", "ຮູບແບບປະໂຫຍກຂັ້ນຫຼັງຕົວອັກສອນຫຍໍ້" },
            { "nds_NL", "ຊາຊອນ ຕອນໄຕ" },
            { "%%ALUKU", "ພາສາພື້ນເມືອງອລູຄຸ" },
            { "%%BISKE", "ພາສາພື້ນເມືອງຊານຈິໂອໂຈ/ບິລາ" },
            { "%%BOONT", "ບູນທລິ່ງ" },
            { "%%JAUER", "ເຍົາເອີ" },
            { "%%KKCOR", "ອັກຂະລະວິທີສາມັນ" },
            { "%%LIPAW", "ພາສາພື້ນເມືອງລິໂພວາຊ໌ຂອງເຣຊ່ຽນ" },
            { "%%NEDIS", "ພາສາພື້ນເມືອງນາທິໂຊເນ" },
            { "%%NJIVA", "ພາສາພື້ນເມືອງຈີວາ/ນີວາ" },
            { "%%OSOJS", "ພາສາພື້ນເມືອງໂອຊຽກໂຄ/ໂອໂຊຍາເນ" },
            { "%%POSIX", "ຄອມພິວເຕີ" },
            { "%%PUTER", "ພິວເຕີ" },
            { "%%ROZAJ", "ເຣຊ່ຽນ" },
            { "%%RUMGR", "ຣຳກຣ໌" },
            { "%%SAAHO", metaValue_ssy },
            { "%%SOLBA", "ພາສາພື້ນເມືອງສະໂຕວິຊ໌ຊ່າ/ໂຊລ໌ບີກາ" },
            { "%%UCCOR", "ອັກຂະລະວິທີແບບຄົບວົງຈອນ" },
            { "zh_Hans", "ຈີນແບບຮຽບງ່າຍ" },
            { "zh_Hant", "ຈີນແບບດັ້ງເດີມ" },
            { "%%FONIPA", "ສັດທະສາດອັກສອນສາກົນ" },
            { "%%FONUPA", "ສັດທະສາດອັກສອນ UPA" },
            { "%%NDYUKA", "ພາສາພື້ນເມືອງດິວຄາ" },
            { "%%PAMAKA", "ພາສາພື້ນເມືອງພາມາຄາ" },
            { "%%PINYIN", "ພິນຢິນ" },
            { "%%SCOUSE", "ສະເກົາສ໌" },
            { "%%TARASK", "ອັກຂະລະວິທີທາຣາຊ໌ເຄຍວິກາ" },
            { "%%UCRCOR", "ອັກຂະລະວິທີສະບັບປັບປຸງແບບຄົບວົງຈອນ" },
            { "%%ULSTER", "ອັລສະເຕີ" },
            { "%%ALALC97", "ການຖອດອັກສອນເປັນອັກສອນໂຣມັນຕາມເກນຂອງສະມາຄົມຫ້ອງສະໝຸດອາເມລິກາແລະຫ້ອງສະໝຸດລັດຖະສະພາ ສະບັບພິມປີ 1997" },
            { "%%AREVELA", "ອາເມເນຍຕາເວັນອອກ" },
            { "%%AREVMDA", "ອາເມເນຍຕາເວັນຕົກ" },
            { "%%BAUDDHA", "ພະພຸດທະເຈົ້າ" },
            { "%%HEPBURN", "ການຖອດອັກສອນແບບເຮບເບິນ" },
            { "%%ITIHASA", "ອິຕິຫາສະ" },
            { "%%LAUKIKA", "ລົວກິກາ" },
            { "%%MONOTON", "ໂມໂນໂທນິກ" },
            { "%%POLYTON", "ໂພລີໂທນິກ" },
            { "%%REVISED", "ອັກຂະລະວິທີສະບັບປັບປຸງ" },
            { "%%SURSILV", "ຊູຣ໌ຊີລ໌" },
            { "%%SUTSILV", "ຊຸຕ໌ຊີລ໌" },
            { "%%VAIDIKA", "ເວດິກາ" },
            { "%%1606NICT", "ປາຍຍຸກກາງຝຣັ່ງເຖິງປີ ຄສ 1606" },
            { "%%1694ACAD", "ຕອນຕົ້ນຍຸກໃໝ່ຝຣັ່ງ" },
            { "%%1959ACAD", "ວິຊາການ" },
            { "%%BAKU1926", "ຕົວອັກສອນລາຕິນເທີກິກແບບຄົບວົງຈອນ" },
            { "%%BISCAYAN", "ບິສຄາຍັນ" },
            { "%%FONXSAMP", "ຟອນແຊມ" },
            { "%%HOGNORSK", "ພາສານໍວີຈ່ຽນສູງ" },
            { "%%JYUTPING", "ການຖອດອັກສອນແບບຍູດພິງ" },
            { "%%LUNA1918", "ລູນ່າ1918" },
            { "%%PETR1708", "ພີທ໌1708" },
            { "%%SCOTLAND", "ພາສາອັງກິດມາດຕະຖານສະກັອດ" },
            { "%%SURMIRAN", "ຊູຣ໌ມິລານ" },
            { "%%VALENCIA", "ວາເລັນເຊຍ" },
            { "%%VALLADER", "ວັລລາເດີ" },
            { "%%WADEGILE", "ການຖອດອັກສອນແບບເວດ-ໄຈລ໌" },
            { "type.ca.roc", "ປະຕິທິນໄຕ້ຫວັນ" },
            { "type.hc.h11", "ຕາມລະບົບ 12 ຊົ່ວໂມງ (0–11)" },
            { "type.hc.h12", "ຕາມລະບົບ 12 ຊົ່ວໂມງ (1–12)" },
            { "type.hc.h23", "ຕາມລະບົບ 24 ຊົ່ວໂມງ (0–23)" },
            { "type.hc.h24", "ຕາມລະບົບ 24 ຊົ່ວໂມງ (1–24)" },
            { "type.nu.arab", "ຕົວເລກອາຣາບິກ-ອິນດິກ" },
            { "type.nu.armn", "ຕົວເລກອາເມນຽນ" },
            { "type.nu.bali", "ຕົວເລກບາລີ" },
            { "type.nu.beng", "ຕົວເລກບັງກລາ" },
            { "type.nu.cakm", "ຕົວເລກຈັກກະມາ" },
            { "type.nu.cham", "ຕົວເລກຊຣາມ" },
            { "type.nu.deva", "ຕົວເລກເດວານາກາຣີ" },
            { "type.nu.ethi", "ຕົວເລກເອທິໂອປິກ" },
            { "type.nu.geor", "ຕົວເລກຈໍຈຽນ" },
            { "type.nu.grek", "ຕົວເລກກຣີກ" },
            { "type.nu.gujr", "ຕົວເລກກຸຈາຣາທີ" },
            { "type.nu.guru", "ຕົວເລກກົວມູຄິ" },
            { "type.nu.hans", "ຕົວເລກຈີນແບບຮຽບງ່າຍ" },
            { "type.nu.hant", "ຕົວເລກຈີນແບບດັ້ງເດີມ" },
            { "type.nu.hebr", "ຕົວເລກຮິບຣິວ" },
            { "type.nu.java", "ຕົວເລກຊົວ" },
            { "type.nu.jpan", "ຕົວເລກຍີ່ປຸ່ນ" },
            { "type.nu.kali", "ຕົວເລກກາຢາ" },
            { "type.nu.khmr", "ຕົວເລກຂະແມ" },
            { "type.nu.knda", "ຕົວເລກແຄນນາດາ" },
            { "type.nu.lana", "ຕົວເລກໄທທຳໂຮລາ" },
            { "type.nu.laoo", "ຕົວເລກລາວ" },
            { "type.nu.latn", "ຕົວເລກຕາເວັນຕົກ" },
            { "type.nu.lepc", "ຕົວເລກເລຊາ" },
            { "type.nu.limb", "ຕົວເລກລິມບູ" },
            { "type.nu.mlym", "ຕົວເລກມາເລອາລຳ" },
            { "type.nu.mong", "ຕົວເລກມ່ອງໂກເລຍ" },
            { "type.nu.mtei", "ຕົວເລກເມໄຕມາເຢກ" },
            { "type.nu.mymr", "ຕົວເລກມຽນມາ" },
            { "type.nu.nkoo", "ຕົວເລກເອັນໂກ້" },
            { "type.nu.olck", "ຕົວເລກໂອລຈິກິ" },
            { "type.nu.orya", "ຕົວເລກໂອດິອາ" },
            { "type.nu.saur", "ຕົວເລກເສົາລັດທາ" },
            { "type.nu.sund", "ຕົວເລກຊຸນດາ" },
            { "type.nu.talu", "ຕົວເລກໄຕລື້ໃໝ່" },
            { "type.nu.taml", "ຕົວເລກທາມິລແບບດັ້ງເດີມ" },
            { "type.nu.telu", "ຕົວເລກເຕລູກູ" },
            { "type.nu.thai", "ຕົວເລກໄທ" },
            { "type.nu.tibt", "ຕົວເລກທິເບດ" },
            { "type.nu.vaii", "ຕົວເລກໃນລະບົບໄວ" },
            { "type.ca.dangi", "ປະ​ຕິ​ທິນ​ດັງ​ກີ" },
            { "type.co.ducet", "ຮຽງຕາມລຳດັບຢູນິໂຄດເລີ່ມຕົ້ນ" },
            { "type.lb.loose", "ຮູບແບບເສັ້ນຂັ້ນແບບຫຼວມ" },
            { "type.nu.roman", "ຕົວເລກໂຣມັນ" },
            { "type.ca.coptic", "ປະຕິທິນຄັອບຕິກ" },
            { "type.ca.hebrew", "ປະ​ຕິ​ທິນ​ຮີບ​ຣິວ" },
            { "type.ca.indian", "ປະຕິທິນແຫ່ງຊາດອິນເດຍ" },
            { "type.co.pinyin", "ລຽງຕາມການອອກສຽງພາສາຈີນ" },
            { "type.co.search", "ການຊອກຫາທົ່ວໄປ" },
            { "type.co.stroke", "ລຽງຕາມການລາກເສັ້ນ" },
            { "type.co.unihan", "ລຽງລຳດັບຕາມຈຳນວນຂີດ" },
            { "type.lb.normal", "ຮູບແບບເສັ້ນຂັ້ນແບບປົກກະຕິ" },
            { "type.lb.strict", "ຮູບແບບເສັ້ນຂັ້ນແບບເຄັ່ງຄັດ" },
            { "type.ms.metric", "ລະບົບເມທຣິກ" },
            { "type.ca.chinese", "ປະຕິທິນຈີນ" },
            { "type.ca.islamic", "ປະຕິທິນອິສະລາມ" },
            { "type.ca.iso8601", "ປະ​ຕິ​ທິນ ISO-8601" },
            { "type.ca.persian", "ປະຕິທິນເປີຊຽນ" },
            { "type.cf.account", "ຮູບແບບສະກຸນເງິນການບັນຊີ" },
            { "type.nu.arabext", "ຕົວເລກອາຣາບິກ-ອິນດິກຕົວເຕັມ" },
            { "type.nu.armnlow", "ຕົວເລກອາເມນຽນຕົວພິມນ້ອຍ" },
            { "type.nu.greklow", "ຕົວເລກກຣີກຕົວພິມນ້ອຍ" },
            { "type.nu.hanidec", "ຕົວເລກທົດສະນິຍົມຈີນ" },
            { "type.nu.hansfin", "ຕົວເລກທາງການເງິນແບບຮຽບງ່າຍຂອງຈີນ" },
            { "type.nu.hantfin", "ຕົວເລກທາງການເງິນແບບດັ້ງເດີມຂອງຈີນ" },
            { "type.nu.jpanfin", "ຕົວເລກທາງການເງິນຂອງຍີ່ປຸ່ນ" },
            { "type.nu.tamldec", "ຕົວເລກທາມິວ" },
            { "type.ca.buddhist", "ປະຕິທິນ ພຸດທະສັງກາດ" },
            { "type.ca.ethiopic", "ປະຕິທິນເອທິໂອເປຍ" },
            { "type.ca.japanese", "ປະຕິທິນຍີ່ປຸ່ນ" },
            { "type.cf.standard", "ຮູບແບບສະກຸນເງິນມາດຕະຖານ" },
            { "type.co.searchjl", "ຄົ້ນຫາຕາມພະຍັນຊະນະຂຶ້ນຕົ້ນທີ່ເປັນຮັງກີຣ" },
            { "type.co.standard", "ຮຽງຕາມມາດຕະຖານ" },
            { "type.ms.uksystem", "ລະບົບການວັດແທກແບບອິມເພີຣຽວ" },
            { "type.ms.ussystem", "ລະບົບການວັດແທກແບບສະຫະລັດ" },
            { "type.nu.fullwide", "ຕົວເລກຄວາມກວ້າງເຕັມ" },
            { "type.nu.lanatham", "ຕົວເລກໄທທຳທຳ" },
            { "type.nu.mymrshan", "ຕົວເລກຊານພະມ້າ" },
            { "type.nu.romanlow", "ຕົວເລກໂຣມັນຕົວພິມນ້ອຍ" },
            { "type.ca.gregorian", "ປະຕິທິນເກຣໂກຣຽນ" },
            { "type.co.phonebook", "ລຽງຕາມສະໝຸດໂທລະສັບ" },
            { "type.co.dictionary", "ລຽງຕາມພົດຈະນານຸກົມ" },
            { "type.co.traditional", "ລຽງຕາມແບບດັ້ງເດີມ" },
            { "type.ca.islamic-civil", "ປະຕິທິນອິດສະລາມ" },
            { "type.ca.islamic-umalqura", "ປະຕິທິນອິດສະລາມ (ອຳອາວຄິວຣາ)" },
            { "type.ca.ethiopic-amete-alem", "ປະຕິທິນປີໂອເອທິໂອເປຍ" },
        };
        return data;
    }
}
