/* { dg-do compile { target { ! ia32 } } } */
/* { dg-options "-O2 -mavx512vl -mavx512bw" } */

typedef char V1 __attribute__((vector_size (16)));
typedef short V2 __attribute__((vector_size (16)));
typedef char V5 __attribute__((vector_size (32)));
typedef short V6 __attribute__((vector_size (32)));
typedef int V7 __attribute__((vector_size (32)));

void
f1 (V1 x)
{
  register V1 a __asm ("xmm16");
  a = x;
  asm volatile ("" : "+v" (a));
  a = __builtin_shuffle (a, (V1) { 0 });
  asm volatile ("" : "+v" (a));
}

/* { dg-final { scan-assembler "vpbroadcastb\[^\n\r]*xmm16\[^\n\r]*xmm16" } } */

void
f2 (V2 x)
{
  register V2 a __asm ("xmm16");
  a = x;
  asm volatile ("" : "+v" (a));
  a = __builtin_shuffle (a, (V2) { 0 });
  asm volatile ("" : "+v" (a));
}

/* { dg-final { scan-assembler "vpbroadcastw\[^\n\r]*xmm16\[^\n\r]*xmm16" } } */

void
f5 (V5 x)
{
  register V5 a __asm ("xmm16");
  a = x;
  asm volatile ("" : "+v" (a));
  a = __builtin_shuffle (a, (V5) { 0 });
  asm volatile ("" : "+v" (a));
}

/* { dg-final { scan-assembler "vpbroadcastb\[^\n\r]*(xmm16\[^\n\r]*ymm16|ymm16\[^\n\r]*xmm16)" } } */

void
f6 (V6 x)
{
  register V6 a __asm ("xmm16");
  a = x;
  asm volatile ("" : "+v" (a));
  a = __builtin_shuffle (a, (V6) { 0 });
  asm volatile ("" : "+v" (a));
}

/* { dg-final { scan-assembler "vpbroadcastw\[^\n\r]*(xmm16\[^\n\r]*ymm16|ymm16\[^\n\r]*xmm16)" } } */

void
f7 (V7 x)
{
  register V7 a __asm ("xmm16");
  a = x;
  asm volatile ("" : "+v" (a));
  a = __builtin_shuffle (a, (V7) { 0 });
  asm volatile ("" : "+v" (a));
}

/* { dg-final { scan-assembler "vpbroadcastd\[^\n\r]*(xmm16\[^\n\r]*ymm16|ymm16\[^\n\r]*xmm16)" } } */
