// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// When writing a match expression against `GuardrailPiiEntityType`, it is important to ensure
/// your code is forward-compatible. That is, if a match arm handles a case for a
/// feature that is supported by the service but has not been represented as an enum
/// variant in a current version of SDK, your code should continue to work when you
/// upgrade SDK to a future version in which the enum does include a variant for that
/// feature.
///
/// Here is an example of how you can make a match expression forward-compatible:
///
/// ```text
/// # let guardrailpiientitytype = unimplemented!();
/// match guardrailpiientitytype {
///     GuardrailPiiEntityType::Address => { /* ... */ },
///     GuardrailPiiEntityType::Age => { /* ... */ },
///     GuardrailPiiEntityType::AwsAccessKey => { /* ... */ },
///     GuardrailPiiEntityType::AwsSecretKey => { /* ... */ },
///     GuardrailPiiEntityType::CaHealthNumber => { /* ... */ },
///     GuardrailPiiEntityType::CaSocialInsuranceNumber => { /* ... */ },
///     GuardrailPiiEntityType::CreditDebitCardCvv => { /* ... */ },
///     GuardrailPiiEntityType::CreditDebitCardExpiry => { /* ... */ },
///     GuardrailPiiEntityType::CreditDebitCardNumber => { /* ... */ },
///     GuardrailPiiEntityType::DriverId => { /* ... */ },
///     GuardrailPiiEntityType::Email => { /* ... */ },
///     GuardrailPiiEntityType::InternationalBankAccountNumber => { /* ... */ },
///     GuardrailPiiEntityType::IpAddress => { /* ... */ },
///     GuardrailPiiEntityType::LicensePlate => { /* ... */ },
///     GuardrailPiiEntityType::MacAddress => { /* ... */ },
///     GuardrailPiiEntityType::Name => { /* ... */ },
///     GuardrailPiiEntityType::Password => { /* ... */ },
///     GuardrailPiiEntityType::Phone => { /* ... */ },
///     GuardrailPiiEntityType::Pin => { /* ... */ },
///     GuardrailPiiEntityType::SwiftCode => { /* ... */ },
///     GuardrailPiiEntityType::UkNationalHealthServiceNumber => { /* ... */ },
///     GuardrailPiiEntityType::UkNationalInsuranceNumber => { /* ... */ },
///     GuardrailPiiEntityType::UkUniqueTaxpayerReferenceNumber => { /* ... */ },
///     GuardrailPiiEntityType::Url => { /* ... */ },
///     GuardrailPiiEntityType::Username => { /* ... */ },
///     GuardrailPiiEntityType::UsBankAccountNumber => { /* ... */ },
///     GuardrailPiiEntityType::UsBankRoutingNumber => { /* ... */ },
///     GuardrailPiiEntityType::UsIndividualTaxIdentificationNumber => { /* ... */ },
///     GuardrailPiiEntityType::UsPassportNumber => { /* ... */ },
///     GuardrailPiiEntityType::UsSocialSecurityNumber => { /* ... */ },
///     GuardrailPiiEntityType::VehicleIdentificationNumber => { /* ... */ },
///     other @ _ if other.as_str() == "NewFeature" => { /* handles a case for `NewFeature` */ },
///     _ => { /* ... */ },
/// }
/// ```
/// The above code demonstrates that when `guardrailpiientitytype` represents
/// `NewFeature`, the execution path will lead to the second last match arm,
/// even though the enum does not contain a variant `GuardrailPiiEntityType::NewFeature`
/// in the current version of SDK. The reason is that the variable `other`,
/// created by the `@` operator, is bound to
/// `GuardrailPiiEntityType::Unknown(UnknownVariantValue("NewFeature".to_owned()))`
/// and calling `as_str` on it yields `"NewFeature"`.
/// This match expression is forward-compatible when executed with a newer
/// version of SDK where the variant `GuardrailPiiEntityType::NewFeature` is defined.
/// Specifically, when `guardrailpiientitytype` represents `NewFeature`,
/// the execution path will hit the second last match arm as before by virtue of
/// calling `as_str` on `GuardrailPiiEntityType::NewFeature` also yielding `"NewFeature"`.
///
/// Explicitly matching on the `Unknown` variant should
/// be avoided for two reasons:
/// - The inner data `UnknownVariantValue` is opaque, and no further information can be extracted.
/// - It might inadvertently shadow other intended match arms.
///
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    ::std::clone::Clone, ::std::cmp::Eq, ::std::cmp::Ord, ::std::cmp::PartialEq, ::std::cmp::PartialOrd, ::std::fmt::Debug, ::std::hash::Hash,
)]
pub enum GuardrailPiiEntityType {
    #[allow(missing_docs)] // documentation missing in model
    Address,
    #[allow(missing_docs)] // documentation missing in model
    Age,
    #[allow(missing_docs)] // documentation missing in model
    AwsAccessKey,
    #[allow(missing_docs)] // documentation missing in model
    AwsSecretKey,
    #[allow(missing_docs)] // documentation missing in model
    CaHealthNumber,
    #[allow(missing_docs)] // documentation missing in model
    CaSocialInsuranceNumber,
    #[allow(missing_docs)] // documentation missing in model
    CreditDebitCardCvv,
    #[allow(missing_docs)] // documentation missing in model
    CreditDebitCardExpiry,
    #[allow(missing_docs)] // documentation missing in model
    CreditDebitCardNumber,
    #[allow(missing_docs)] // documentation missing in model
    DriverId,
    #[allow(missing_docs)] // documentation missing in model
    Email,
    #[allow(missing_docs)] // documentation missing in model
    InternationalBankAccountNumber,
    #[allow(missing_docs)] // documentation missing in model
    IpAddress,
    #[allow(missing_docs)] // documentation missing in model
    LicensePlate,
    #[allow(missing_docs)] // documentation missing in model
    MacAddress,
    #[allow(missing_docs)] // documentation missing in model
    Name,
    #[allow(missing_docs)] // documentation missing in model
    Password,
    #[allow(missing_docs)] // documentation missing in model
    Phone,
    #[allow(missing_docs)] // documentation missing in model
    Pin,
    #[allow(missing_docs)] // documentation missing in model
    SwiftCode,
    #[allow(missing_docs)] // documentation missing in model
    UkNationalHealthServiceNumber,
    #[allow(missing_docs)] // documentation missing in model
    UkNationalInsuranceNumber,
    #[allow(missing_docs)] // documentation missing in model
    UkUniqueTaxpayerReferenceNumber,
    #[allow(missing_docs)] // documentation missing in model
    Url,
    #[allow(missing_docs)] // documentation missing in model
    Username,
    #[allow(missing_docs)] // documentation missing in model
    UsBankAccountNumber,
    #[allow(missing_docs)] // documentation missing in model
    UsBankRoutingNumber,
    #[allow(missing_docs)] // documentation missing in model
    UsIndividualTaxIdentificationNumber,
    #[allow(missing_docs)] // documentation missing in model
    UsPassportNumber,
    #[allow(missing_docs)] // documentation missing in model
    UsSocialSecurityNumber,
    #[allow(missing_docs)] // documentation missing in model
    VehicleIdentificationNumber,
    /// `Unknown` contains new variants that have been added since this code was generated.
    #[deprecated(note = "Don't directly match on `Unknown`. See the docs on this enum for the correct way to handle unknown variants.")]
    Unknown(crate::primitives::sealed_enum_unknown::UnknownVariantValue),
}
impl ::std::convert::From<&str> for GuardrailPiiEntityType {
    fn from(s: &str) -> Self {
        match s {
            "ADDRESS" => GuardrailPiiEntityType::Address,
            "AGE" => GuardrailPiiEntityType::Age,
            "AWS_ACCESS_KEY" => GuardrailPiiEntityType::AwsAccessKey,
            "AWS_SECRET_KEY" => GuardrailPiiEntityType::AwsSecretKey,
            "CA_HEALTH_NUMBER" => GuardrailPiiEntityType::CaHealthNumber,
            "CA_SOCIAL_INSURANCE_NUMBER" => GuardrailPiiEntityType::CaSocialInsuranceNumber,
            "CREDIT_DEBIT_CARD_CVV" => GuardrailPiiEntityType::CreditDebitCardCvv,
            "CREDIT_DEBIT_CARD_EXPIRY" => GuardrailPiiEntityType::CreditDebitCardExpiry,
            "CREDIT_DEBIT_CARD_NUMBER" => GuardrailPiiEntityType::CreditDebitCardNumber,
            "DRIVER_ID" => GuardrailPiiEntityType::DriverId,
            "EMAIL" => GuardrailPiiEntityType::Email,
            "INTERNATIONAL_BANK_ACCOUNT_NUMBER" => GuardrailPiiEntityType::InternationalBankAccountNumber,
            "IP_ADDRESS" => GuardrailPiiEntityType::IpAddress,
            "LICENSE_PLATE" => GuardrailPiiEntityType::LicensePlate,
            "MAC_ADDRESS" => GuardrailPiiEntityType::MacAddress,
            "NAME" => GuardrailPiiEntityType::Name,
            "PASSWORD" => GuardrailPiiEntityType::Password,
            "PHONE" => GuardrailPiiEntityType::Phone,
            "PIN" => GuardrailPiiEntityType::Pin,
            "SWIFT_CODE" => GuardrailPiiEntityType::SwiftCode,
            "UK_NATIONAL_HEALTH_SERVICE_NUMBER" => GuardrailPiiEntityType::UkNationalHealthServiceNumber,
            "UK_NATIONAL_INSURANCE_NUMBER" => GuardrailPiiEntityType::UkNationalInsuranceNumber,
            "UK_UNIQUE_TAXPAYER_REFERENCE_NUMBER" => GuardrailPiiEntityType::UkUniqueTaxpayerReferenceNumber,
            "URL" => GuardrailPiiEntityType::Url,
            "USERNAME" => GuardrailPiiEntityType::Username,
            "US_BANK_ACCOUNT_NUMBER" => GuardrailPiiEntityType::UsBankAccountNumber,
            "US_BANK_ROUTING_NUMBER" => GuardrailPiiEntityType::UsBankRoutingNumber,
            "US_INDIVIDUAL_TAX_IDENTIFICATION_NUMBER" => GuardrailPiiEntityType::UsIndividualTaxIdentificationNumber,
            "US_PASSPORT_NUMBER" => GuardrailPiiEntityType::UsPassportNumber,
            "US_SOCIAL_SECURITY_NUMBER" => GuardrailPiiEntityType::UsSocialSecurityNumber,
            "VEHICLE_IDENTIFICATION_NUMBER" => GuardrailPiiEntityType::VehicleIdentificationNumber,
            other => GuardrailPiiEntityType::Unknown(crate::primitives::sealed_enum_unknown::UnknownVariantValue(other.to_owned())),
        }
    }
}
impl ::std::str::FromStr for GuardrailPiiEntityType {
    type Err = ::std::convert::Infallible;

    fn from_str(s: &str) -> ::std::result::Result<Self, <Self as ::std::str::FromStr>::Err> {
        ::std::result::Result::Ok(GuardrailPiiEntityType::from(s))
    }
}
impl GuardrailPiiEntityType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            GuardrailPiiEntityType::Address => "ADDRESS",
            GuardrailPiiEntityType::Age => "AGE",
            GuardrailPiiEntityType::AwsAccessKey => "AWS_ACCESS_KEY",
            GuardrailPiiEntityType::AwsSecretKey => "AWS_SECRET_KEY",
            GuardrailPiiEntityType::CaHealthNumber => "CA_HEALTH_NUMBER",
            GuardrailPiiEntityType::CaSocialInsuranceNumber => "CA_SOCIAL_INSURANCE_NUMBER",
            GuardrailPiiEntityType::CreditDebitCardCvv => "CREDIT_DEBIT_CARD_CVV",
            GuardrailPiiEntityType::CreditDebitCardExpiry => "CREDIT_DEBIT_CARD_EXPIRY",
            GuardrailPiiEntityType::CreditDebitCardNumber => "CREDIT_DEBIT_CARD_NUMBER",
            GuardrailPiiEntityType::DriverId => "DRIVER_ID",
            GuardrailPiiEntityType::Email => "EMAIL",
            GuardrailPiiEntityType::InternationalBankAccountNumber => "INTERNATIONAL_BANK_ACCOUNT_NUMBER",
            GuardrailPiiEntityType::IpAddress => "IP_ADDRESS",
            GuardrailPiiEntityType::LicensePlate => "LICENSE_PLATE",
            GuardrailPiiEntityType::MacAddress => "MAC_ADDRESS",
            GuardrailPiiEntityType::Name => "NAME",
            GuardrailPiiEntityType::Password => "PASSWORD",
            GuardrailPiiEntityType::Phone => "PHONE",
            GuardrailPiiEntityType::Pin => "PIN",
            GuardrailPiiEntityType::SwiftCode => "SWIFT_CODE",
            GuardrailPiiEntityType::UkNationalHealthServiceNumber => "UK_NATIONAL_HEALTH_SERVICE_NUMBER",
            GuardrailPiiEntityType::UkNationalInsuranceNumber => "UK_NATIONAL_INSURANCE_NUMBER",
            GuardrailPiiEntityType::UkUniqueTaxpayerReferenceNumber => "UK_UNIQUE_TAXPAYER_REFERENCE_NUMBER",
            GuardrailPiiEntityType::Url => "URL",
            GuardrailPiiEntityType::Username => "USERNAME",
            GuardrailPiiEntityType::UsBankAccountNumber => "US_BANK_ACCOUNT_NUMBER",
            GuardrailPiiEntityType::UsBankRoutingNumber => "US_BANK_ROUTING_NUMBER",
            GuardrailPiiEntityType::UsIndividualTaxIdentificationNumber => "US_INDIVIDUAL_TAX_IDENTIFICATION_NUMBER",
            GuardrailPiiEntityType::UsPassportNumber => "US_PASSPORT_NUMBER",
            GuardrailPiiEntityType::UsSocialSecurityNumber => "US_SOCIAL_SECURITY_NUMBER",
            GuardrailPiiEntityType::VehicleIdentificationNumber => "VEHICLE_IDENTIFICATION_NUMBER",
            GuardrailPiiEntityType::Unknown(value) => value.as_str(),
        }
    }
    /// Returns all the `&str` representations of the enum members.
    pub const fn values() -> &'static [&'static str] {
        &[
            "ADDRESS",
            "AGE",
            "AWS_ACCESS_KEY",
            "AWS_SECRET_KEY",
            "CA_HEALTH_NUMBER",
            "CA_SOCIAL_INSURANCE_NUMBER",
            "CREDIT_DEBIT_CARD_CVV",
            "CREDIT_DEBIT_CARD_EXPIRY",
            "CREDIT_DEBIT_CARD_NUMBER",
            "DRIVER_ID",
            "EMAIL",
            "INTERNATIONAL_BANK_ACCOUNT_NUMBER",
            "IP_ADDRESS",
            "LICENSE_PLATE",
            "MAC_ADDRESS",
            "NAME",
            "PASSWORD",
            "PHONE",
            "PIN",
            "SWIFT_CODE",
            "UK_NATIONAL_HEALTH_SERVICE_NUMBER",
            "UK_NATIONAL_INSURANCE_NUMBER",
            "UK_UNIQUE_TAXPAYER_REFERENCE_NUMBER",
            "URL",
            "USERNAME",
            "US_BANK_ACCOUNT_NUMBER",
            "US_BANK_ROUTING_NUMBER",
            "US_INDIVIDUAL_TAX_IDENTIFICATION_NUMBER",
            "US_PASSPORT_NUMBER",
            "US_SOCIAL_SECURITY_NUMBER",
            "VEHICLE_IDENTIFICATION_NUMBER",
        ]
    }
}
impl ::std::convert::AsRef<str> for GuardrailPiiEntityType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}
impl GuardrailPiiEntityType {
    /// Parses the enum value while disallowing unknown variants.
    ///
    /// Unknown variants will result in an error.
    pub fn try_parse(value: &str) -> ::std::result::Result<Self, crate::error::UnknownVariantError> {
        match Self::from(value) {
            #[allow(deprecated)]
            Self::Unknown(_) => ::std::result::Result::Err(crate::error::UnknownVariantError::new(value)),
            known => Ok(known),
        }
    }
}
impl ::std::fmt::Display for GuardrailPiiEntityType {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        match self {
            GuardrailPiiEntityType::Address => write!(f, "ADDRESS"),
            GuardrailPiiEntityType::Age => write!(f, "AGE"),
            GuardrailPiiEntityType::AwsAccessKey => write!(f, "AWS_ACCESS_KEY"),
            GuardrailPiiEntityType::AwsSecretKey => write!(f, "AWS_SECRET_KEY"),
            GuardrailPiiEntityType::CaHealthNumber => write!(f, "CA_HEALTH_NUMBER"),
            GuardrailPiiEntityType::CaSocialInsuranceNumber => write!(f, "CA_SOCIAL_INSURANCE_NUMBER"),
            GuardrailPiiEntityType::CreditDebitCardCvv => write!(f, "CREDIT_DEBIT_CARD_CVV"),
            GuardrailPiiEntityType::CreditDebitCardExpiry => write!(f, "CREDIT_DEBIT_CARD_EXPIRY"),
            GuardrailPiiEntityType::CreditDebitCardNumber => write!(f, "CREDIT_DEBIT_CARD_NUMBER"),
            GuardrailPiiEntityType::DriverId => write!(f, "DRIVER_ID"),
            GuardrailPiiEntityType::Email => write!(f, "EMAIL"),
            GuardrailPiiEntityType::InternationalBankAccountNumber => write!(f, "INTERNATIONAL_BANK_ACCOUNT_NUMBER"),
            GuardrailPiiEntityType::IpAddress => write!(f, "IP_ADDRESS"),
            GuardrailPiiEntityType::LicensePlate => write!(f, "LICENSE_PLATE"),
            GuardrailPiiEntityType::MacAddress => write!(f, "MAC_ADDRESS"),
            GuardrailPiiEntityType::Name => write!(f, "NAME"),
            GuardrailPiiEntityType::Password => write!(f, "PASSWORD"),
            GuardrailPiiEntityType::Phone => write!(f, "PHONE"),
            GuardrailPiiEntityType::Pin => write!(f, "PIN"),
            GuardrailPiiEntityType::SwiftCode => write!(f, "SWIFT_CODE"),
            GuardrailPiiEntityType::UkNationalHealthServiceNumber => write!(f, "UK_NATIONAL_HEALTH_SERVICE_NUMBER"),
            GuardrailPiiEntityType::UkNationalInsuranceNumber => write!(f, "UK_NATIONAL_INSURANCE_NUMBER"),
            GuardrailPiiEntityType::UkUniqueTaxpayerReferenceNumber => write!(f, "UK_UNIQUE_TAXPAYER_REFERENCE_NUMBER"),
            GuardrailPiiEntityType::Url => write!(f, "URL"),
            GuardrailPiiEntityType::Username => write!(f, "USERNAME"),
            GuardrailPiiEntityType::UsBankAccountNumber => write!(f, "US_BANK_ACCOUNT_NUMBER"),
            GuardrailPiiEntityType::UsBankRoutingNumber => write!(f, "US_BANK_ROUTING_NUMBER"),
            GuardrailPiiEntityType::UsIndividualTaxIdentificationNumber => write!(f, "US_INDIVIDUAL_TAX_IDENTIFICATION_NUMBER"),
            GuardrailPiiEntityType::UsPassportNumber => write!(f, "US_PASSPORT_NUMBER"),
            GuardrailPiiEntityType::UsSocialSecurityNumber => write!(f, "US_SOCIAL_SECURITY_NUMBER"),
            GuardrailPiiEntityType::VehicleIdentificationNumber => write!(f, "VEHICLE_IDENTIFICATION_NUMBER"),
            GuardrailPiiEntityType::Unknown(value) => write!(f, "{}", value),
        }
    }
}
