//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
#[cfg(feature = "objc2")]
use objc2::__framework_prelude::*;
use objc2_core_foundation::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiopspoweradapteridkey?language=objc)
pub const kIOPSPowerAdapterIDKey: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"AdapterID\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiopspoweradapterwattskey?language=objc)
pub const kIOPSPowerAdapterWattsKey: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"Watts\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiopspoweradapterrevisionkey?language=objc)
pub const kIOPSPowerAdapterRevisionKey: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"AdapterRevision\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiopspoweradapterserialnumberkey?language=objc)
pub const kIOPSPowerAdapterSerialNumberKey: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"SerialNumber\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiopspoweradapterfamilykey?language=objc)
pub const kIOPSPowerAdapterFamilyKey: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"FamilyCode\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiopspoweradaptercurrentkey?language=objc)
pub const kIOPSPowerAdapterCurrentKey: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"Current\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiopspoweradaptersourcekey?language=objc)
pub const kIOPSPowerAdapterSourceKey: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"Source\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiopsupsmanagementclaimed?language=objc)
pub const kIOPSUPSManagementClaimed: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"/IOKit/UPSPowerManagementClaimed\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiopslowwarnlevelkey?language=objc)
pub const kIOPSLowWarnLevelKey: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"Low Warn Level\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiopsdeadwarnlevelkey?language=objc)
pub const kIOPSDeadWarnLevelKey: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"Shutdown Level\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiopsdynamicstorepath?language=objc)
pub const kIOPSDynamicStorePath: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"/IOKit/PowerSources\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiopscommanddelayedremovepowerkey?language=objc)
pub const kIOPSCommandDelayedRemovePowerKey: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"Delayed Remove Power\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiopscommandenableaudiblealarmkey?language=objc)
pub const kIOPSCommandEnableAudibleAlarmKey: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"Enable Audible Alarm\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiopscommandstartupdelaykey?language=objc)
pub const kIOPSCommandStartupDelayKey: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"Startup Delay\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiopscommandsetcurrentlimitkey?language=objc)
pub const kIOPSCommandSetCurrentLimitKey: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"Set Current Limit\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiopscommandsetrequiredvoltagekey?language=objc)
pub const kIOPSCommandSetRequiredVoltageKey: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"Set Required Voltage\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiopscommandsendcurrentstateofcharge?language=objc)
pub const kIOPSCommandSendCurrentStateOfCharge: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"Send Current State of Charge\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiopscommandsendcurrenttemperature?language=objc)
pub const kIOPSCommandSendCurrentTemperature: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"Send Current Temperature\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiopspowersourceidkey?language=objc)
pub const kIOPSPowerSourceIDKey: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"Power Source ID\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiopspowersourcestatekey?language=objc)
pub const kIOPSPowerSourceStateKey: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"Power Source State\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiopscurrentcapacitykey?language=objc)
pub const kIOPSCurrentCapacityKey: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"Current Capacity\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiopsmaxcapacitykey?language=objc)
pub const kIOPSMaxCapacityKey: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"Max Capacity\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiopsdesigncapacitykey?language=objc)
pub const kIOPSDesignCapacityKey: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"DesignCapacity\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiopsnominalcapacitykey?language=objc)
pub const kIOPSNominalCapacityKey: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"Nominal Capacity\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiopstimetoemptykey?language=objc)
pub const kIOPSTimeToEmptyKey: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"Time to Empty\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiopstimetofullchargekey?language=objc)
pub const kIOPSTimeToFullChargeKey: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"Time to Full Charge\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiopsischargingkey?language=objc)
pub const kIOPSIsChargingKey: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"Is Charging\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiopsinternalfailurekey?language=objc)
pub const kIOPSInternalFailureKey: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"Internal Failure\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiopsispresentkey?language=objc)
pub const kIOPSIsPresentKey: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"Is Present\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiopsvoltagekey?language=objc)
pub const kIOPSVoltageKey: &CStr = unsafe { CStr::from_bytes_with_nul_unchecked(b"Voltage\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiopscurrentkey?language=objc)
pub const kIOPSCurrentKey: &CStr = unsafe { CStr::from_bytes_with_nul_unchecked(b"Current\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiopstemperaturekey?language=objc)
pub const kIOPSTemperatureKey: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"Temperature\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiopsnamekey?language=objc)
pub const kIOPSNameKey: &CStr = unsafe { CStr::from_bytes_with_nul_unchecked(b"Name\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiopstypekey?language=objc)
pub const kIOPSTypeKey: &CStr = unsafe { CStr::from_bytes_with_nul_unchecked(b"Type\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiopstransporttypekey?language=objc)
pub const kIOPSTransportTypeKey: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"Transport Type\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiopsvendoridkey?language=objc)
pub const kIOPSVendorIDKey: &CStr = unsafe { CStr::from_bytes_with_nul_unchecked(b"Vendor ID\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiopsproductidkey?language=objc)
pub const kIOPSProductIDKey: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"Product ID\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiopsvendordatakey?language=objc)
pub const kIOPSVendorDataKey: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"Vendor Specific Data\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiopsbatteryhealthkey?language=objc)
pub const kIOPSBatteryHealthKey: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"BatteryHealth\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiopsbatteryhealthconditionkey?language=objc)
pub const kIOPSBatteryHealthConditionKey: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"BatteryHealthCondition\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiopsbatteryfailuremodeskey?language=objc)
pub const kIOPSBatteryFailureModesKey: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"BatteryFailureModes\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiopshealthconfidencekey?language=objc)
pub const kIOPSHealthConfidenceKey: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"HealthConfidence\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiopsmaxerrkey?language=objc)
pub const kIOPSMaxErrKey: &CStr = unsafe { CStr::from_bytes_with_nul_unchecked(b"MaxErr\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiopsischargedkey?language=objc)
pub const kIOPSIsChargedKey: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"Is Charged\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiopsisfinishingchargekey?language=objc)
pub const kIOPSIsFinishingChargeKey: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"Is Finishing Charge\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiopshardwareserialnumberkey?language=objc)
pub const kIOPSHardwareSerialNumberKey: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"Hardware Serial Number\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiopsserialtransporttype?language=objc)
pub const kIOPSSerialTransportType: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"Serial\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiopsusbtransporttype?language=objc)
pub const kIOPSUSBTransportType: &CStr = unsafe { CStr::from_bytes_with_nul_unchecked(b"USB\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiopsnetworktransporttype?language=objc)
pub const kIOPSNetworkTransportType: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"Ethernet\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiopsinternaltype?language=objc)
pub const kIOPSInternalType: &CStr = unsafe { CStr::from_bytes_with_nul_unchecked(b"Internal\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiopsinternalbatterytype?language=objc)
pub const kIOPSInternalBatteryType: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"InternalBattery\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiopsupstype?language=objc)
pub const kIOPSUPSType: &CStr = unsafe { CStr::from_bytes_with_nul_unchecked(b"UPS\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiopsofflinevalue?language=objc)
pub const kIOPSOffLineValue: &CStr = unsafe { CStr::from_bytes_with_nul_unchecked(b"Off Line\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiopsacpowervalue?language=objc)
pub const kIOPSACPowerValue: &CStr = unsafe { CStr::from_bytes_with_nul_unchecked(b"AC Power\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiopsbatterypowervalue?language=objc)
pub const kIOPSBatteryPowerValue: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"Battery Power\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiopspoorvalue?language=objc)
pub const kIOPSPoorValue: &CStr = unsafe { CStr::from_bytes_with_nul_unchecked(b"Poor\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiopsfairvalue?language=objc)
pub const kIOPSFairValue: &CStr = unsafe { CStr::from_bytes_with_nul_unchecked(b"Fair\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiopsgoodvalue?language=objc)
pub const kIOPSGoodValue: &CStr = unsafe { CStr::from_bytes_with_nul_unchecked(b"Good\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiopscheckbatteryvalue?language=objc)
pub const kIOPSCheckBatteryValue: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"Check Battery\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiopspermanentfailurevalue?language=objc)
pub const kIOPSPermanentFailureValue: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"Permanent Battery Failure\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiopsfailureexternalinput?language=objc)
pub const kIOPSFailureExternalInput: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"Externally Indicated Failure\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiopsfailuresafetyovervoltage?language=objc)
pub const kIOPSFailureSafetyOverVoltage: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"Safety Over-Voltage\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiopsfailurechargeovertemp?language=objc)
pub const kIOPSFailureChargeOverTemp: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"Charge Over-Temperature\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiopsfailuredischargeovertemp?language=objc)
pub const kIOPSFailureDischargeOverTemp: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"Discharge Over-Temperature\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiopsfailurecellimbalance?language=objc)
pub const kIOPSFailureCellImbalance: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"Cell Imbalance\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiopsfailurechargefet?language=objc)
pub const kIOPSFailureChargeFET: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"Charge FET\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiopsfailuredischargefet?language=objc)
pub const kIOPSFailureDischargeFET: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"Discharge FET\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiopsfailuredataflushfault?language=objc)
pub const kIOPSFailureDataFlushFault: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"Data Flush Fault\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiopsfailurepermanentafecomms?language=objc)
pub const kIOPSFailurePermanentAFEComms: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"Permanent AFE Comms\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiopsfailureperiodicafecomms?language=objc)
pub const kIOPSFailurePeriodicAFEComms: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"Periodic AFE Comms\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiopsfailurechargeovercurrent?language=objc)
pub const kIOPSFailureChargeOverCurrent: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"Charge Over-Current\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiopsfailuredischargeovercurrent?language=objc)
pub const kIOPSFailureDischargeOverCurrent: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"Discharge Over-Current\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiopsfailureopenthermistor?language=objc)
pub const kIOPSFailureOpenThermistor: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"Open Thermistor\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiopsfailurefuseblown?language=objc)
pub const kIOPSFailureFuseBlown: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"Fuse Blown\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiopsnotifylowbattery?language=objc)
pub const kIOPSNotifyLowBattery: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"com.apple.system.powersources.lowbattery\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiopsnotifytimeremaining?language=objc)
pub const kIOPSNotifyTimeRemaining: &CStr = unsafe {
    CStr::from_bytes_with_nul_unchecked(b"com.apple.system.powersources.timeremaining\0")
};
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiopstimeremainingnotificationkey?language=objc)
pub const kIOPSTimeRemainingNotificationKey: &CStr = kIOPSNotifyTimeRemaining;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiopsnotifypowersource?language=objc)
pub const kIOPSNotifyPowerSource: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"com.apple.system.powersources.source\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiopsnotifyattach?language=objc)
pub const kIOPSNotifyAttach: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"com.apple.system.powersources.attach\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiopsnotifyanypowersource?language=objc)
pub const kIOPSNotifyAnyPowerSource: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"com.apple.system.powersources\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiopstimeremainingunknown?language=objc)
pub const kIOPSTimeRemainingUnknown: CFTimeInterval = -1.0;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiopstimeremainingunlimited?language=objc)
pub const kIOPSTimeRemainingUnlimited: CFTimeInterval = -2.0;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiopmupspowerkey?language=objc)
pub const kIOPMUPSPowerKey: &CStr = unsafe { CStr::from_bytes_with_nul_unchecked(b"UPS Power\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiopmbatterypowerkey?language=objc)
pub const kIOPMBatteryPowerKey: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"Battery Power\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiopmacpowerkey?language=objc)
pub const kIOPMACPowerKey: &CStr = unsafe { CStr::from_bytes_with_nul_unchecked(b"AC Power\0") };
/// Possible return values from
/// <code>
///
/// ```text
///  IOPSGetBatteryWarningLevel
/// ```
///
/// </code>
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/iokit/iopslowbatterywarninglevel?language=objc)
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct IOPSLowBatteryWarningLevel(pub c_uint);
impl IOPSLowBatteryWarningLevel {
    /// The system is not in a low battery situation, or is on drawing from an external power source.
    ///
    ///
    /// The system displays no low power warnings; neither should application clients of this
    /// API.
    #[doc(alias = "kIOPSLowBatteryWarningNone")]
    pub const None: Self = Self(1);
    /// The battery can provide no more than 20 minutes of runtime.
    ///
    ///
    /// OS X makes no guarantees that the system shall remain in Early Warning for 20 minutes.
    /// Batteries are frequently calibrated differently and may provide runtime
    /// for more, or less, than the estimated 20 minutes.
    /// OS X alerts the user by changing the color of BatteryMonitor to red.
    /// Warning the user is optional for full screen apps.
    #[doc(alias = "kIOPSLowBatteryWarningEarly")]
    pub const Early: Self = Self(2);
    /// The battery can provide no more than 10 minutes of runtime.
    ///
    ///
    /// OS X makes no guarantees that the system shall remain in Final Warning for 10 minutes.
    /// Batteries are frequently calibrated differently and may provide runtime
    /// for more, or less, than the estimated 10 minutes.
    #[doc(alias = "kIOPSLowBatteryWarningFinal")]
    pub const Final: Self = Self(3);
}

#[cfg(feature = "objc2")]
unsafe impl Encode for IOPSLowBatteryWarningLevel {
    const ENCODING: Encoding = c_uint::ENCODING;
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for IOPSLowBatteryWarningLevel {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// Indicates whether the system is at a low battery warning level.
///
///
/// If your app runs in full screen mode and occludes OS X's battery monitor's low
/// battery warnings, you should alert the user at least when the system
/// is in kIOPSLowBatteryWarnFinal.
#[inline]
pub extern "C-unwind" fn IOPSGetBatteryWarningLevel() -> IOPSLowBatteryWarningLevel {
    extern "C-unwind" {
        fn IOPSGetBatteryWarningLevel() -> IOPSLowBatteryWarningLevel;
    }
    unsafe { IOPSGetBatteryWarningLevel() }
}

/// Returns the estimated minutes remaining until all power sources
/// (battery and/or UPS's) are empty, or returns
/// <code>
///
/// ```text
///  kIOPSTimeRemainingUnlimited
/// ```
///
/// </code>
/// if attached to an unlimited power source.
///
///
/// If attached to an "Unlimited" power source, like AC power or any external source, the
/// return value is
/// <code>
///
/// ```text
///  kIOPSTimeRemainingUnlimited
/// ```
///
/// </code>
///
/// If the system is on "Limited" power, like a battery or UPS,
/// but is still calculating the time remaining, which may
/// take several seconds after each system power event
/// (e.g. waking from sleep, or unplugging AC Power), the return value is
/// <code>
///
/// ```text
///  kIOPSTimeRemainingUnknown
/// ```
///
/// </code>
///
/// Otherwise, if the system is on "Limited" power and the system has an accurate time
/// remaining estimate, the system returns a CFTimeInterval estimate of the time
/// remaining until the system is out of battery power.
///
/// If you require more detailed battery information, use
/// <code>
///
/// ```text
///  IOPSCopyPowerSourcesInfo
/// ```
///
/// >
/// </code>
/// and
/// <code>
///
/// ```text
///  IOPSGetPowerSourceDescription
/// ```
///
/// >
/// </code>
/// .
///
///
/// Returns: Returns
/// <code>
///
/// ```text
///  kIOPSTimeRemainingUnknown
/// ```
///
/// </code>
/// if the
/// OS cannot determine the time remaining.
///
/// Returns
/// <code>
///
/// ```text
///  kIOPSTimeRemainingUnlimited
/// ```
///
/// </code>
/// if the
/// system has an unlimited power source.
///
/// Otherwise returns a positive number of type CFTimeInterval, indicating the time
/// remaining in seconds until all power sources are depleted.
#[inline]
pub extern "C-unwind" fn IOPSGetTimeRemainingEstimate() -> CFTimeInterval {
    extern "C-unwind" {
        fn IOPSGetTimeRemainingEstimate() -> CFTimeInterval;
    }
    unsafe { IOPSGetTimeRemainingEstimate() }
}

/// [Apple's documentation](https://developer.apple.com/documentation/iokit/iopowersourcecallbacktype?language=objc)
pub type IOPowerSourceCallbackType = Option<unsafe extern "C-unwind" fn(*mut c_void)>;

/// Returns a blob of Power Source information in an opaque CFTypeRef.
///
///
/// Clients should not directly access data in the returned CFTypeRef -
/// they should use the accessor functions IOPSCopyPowerSourcesList and
/// IOPSGetPowerSourceDescription, instead.
///
///
/// Returns: NULL if errors were encountered, a CFTypeRef otherwise.
/// Caller must CFRelease() the return value when done accessing it.
#[inline]
pub extern "C-unwind" fn IOPSCopyPowerSourcesInfo() -> Option<CFRetained<CFType>> {
    extern "C-unwind" {
        fn IOPSCopyPowerSourcesInfo() -> Option<NonNull<CFType>>;
    }
    let ret = unsafe { IOPSCopyPowerSourcesInfo() };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

/// Returns a CFArray of Power Source handles, each of type CFTypeRef.
///
///
/// The caller shouldn't directly access the CFTypeRefs, but should use
/// IOPSGetPowerSourceDescription on each member of the CFArrayRef.
///
///
/// Parameter `blob`: Takes the CFTypeRef returned by IOPSCopyPowerSourcesInfo()
///
///
/// Returns: Returns NULL if errors were encountered, otherwise a CFArray of CFTypeRefs.
/// Caller must CFRelease() the returned CFArrayRef.
///
/// # Safety
///
/// - `blob` should be of the correct type.
/// - `blob` might not allow `None`.
#[inline]
pub unsafe extern "C-unwind" fn IOPSCopyPowerSourcesList(
    blob: Option<&CFType>,
) -> Option<CFRetained<CFArray>> {
    extern "C-unwind" {
        fn IOPSCopyPowerSourcesList(blob: Option<&CFType>) -> Option<NonNull<CFArray>>;
    }
    let ret = unsafe { IOPSCopyPowerSourcesList(blob) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

/// Returns a CFDictionary with readable information about the specific power source.
///
///
/// See the C-strings defined in IOPSKeys.h for specific keys into the dictionary.
/// Don't expect all keys to be present in any dictionary. Some power sources, for example,
/// may not support the "Time Remaining To Empty" key and it will not be present in their dictionaries.
///
///
/// Parameter `blob`: The CFTypeRef returned by IOPSCopyPowerSourcesInfo()
///
///
/// Parameter `ps`: One of the CFTypeRefs in the CFArray returned by IOPSCopyPowerSourcesList()
///
///
/// Returns: Returns NULL if an error was encountered, otherwise a CFDictionary. Caller should
/// NOT release the returned CFDictionary - it will be released as part of the CFTypeRef returned by
/// IOPSCopyPowerSourcesInfo().
///
/// # Safety
///
/// - `blob` should be of the correct type.
/// - `blob` might not allow `None`.
/// - `ps` should be of the correct type.
/// - `ps` might not allow `None`.
#[inline]
pub unsafe extern "C-unwind" fn IOPSGetPowerSourceDescription(
    blob: Option<&CFType>,
    ps: Option<&CFType>,
) -> Option<CFRetained<CFDictionary>> {
    extern "C-unwind" {
        fn IOPSGetPowerSourceDescription(
            blob: Option<&CFType>,
            ps: Option<&CFType>,
        ) -> Option<NonNull<CFDictionary>>;
    }
    let ret = unsafe { IOPSGetPowerSourceDescription(blob, ps) };
    ret.map(|ret| unsafe { CFRetained::retain(ret) })
}

/// Indicates the power source the computer is currently drawing from.
///
///
/// Determines which power source is providing power.
///
///
/// Parameter `snapshot`: The CFTypeRef returned by IOPSCopyPowerSourcesInfo()
///
///
/// Returns: One of: CFSTR(kIOPMACPowerKey), CFSTR(kIOPMBatteryPowerKey), CFSTR(kIOPMUPSPowerKey)
///
/// # Safety
///
/// - `snapshot` should be of the correct type.
/// - `snapshot` might not allow `None`.
#[inline]
pub unsafe extern "C-unwind" fn IOPSGetProvidingPowerSourceType(
    snapshot: Option<&CFType>,
) -> Option<CFRetained<CFString>> {
    extern "C-unwind" {
        fn IOPSGetProvidingPowerSourceType(snapshot: Option<&CFType>) -> Option<NonNull<CFString>>;
    }
    let ret = unsafe { IOPSGetProvidingPowerSourceType(snapshot) };
    ret.map(|ret| unsafe { CFRetained::retain(ret) })
}

/// Returns a CFRunLoopSourceRef that notifies the caller when power source
/// information changes.
///
///
/// Returns a CFRunLoopSourceRef for scheduling with your CFRunLoop.
/// If your project does not use a CFRunLoop, you can alternatively
/// receive notifications via mach port, dispatch, or signal, via
/// <code>
/// notify.h
/// </code>
/// using the name
/// <code>
///
/// ```text
///  kIOPSTimeRemainingNotificationKey
/// ```
///
/// </code>
/// .
///
/// IOKit delivers this notification when percent remaining or time remaining changes.
/// Thus it fires fairly frequently while discharging or charging the battery;
/// please consider using:
/// <code>
///
/// ```text
///  IOPSCreateLimitedPowerNotification
/// ```
///
/// </code>
/// if you only require
/// notifications when the power source type changes from limited to unlimited.
///
///
/// Parameter `callback`: A function to be called whenever any power source is added, removed, or changes.
///
///
/// Parameter `context`: Any user-defined pointer, passed to the IOPowerSource callback.
///
///
/// Returns: Returns NULL if an error was encountered, otherwise a CFRunLoopSource. Caller must
/// release the CFRunLoopSource.
///
/// # Safety
///
/// - `callback` must be implemented correctly.
/// - `context` must be a valid pointer.
#[inline]
pub unsafe extern "C-unwind" fn IOPSNotificationCreateRunLoopSource(
    callback: IOPowerSourceCallbackType,
    context: *mut c_void,
) -> Option<CFRetained<CFRunLoopSource>> {
    extern "C-unwind" {
        fn IOPSNotificationCreateRunLoopSource(
            callback: IOPowerSourceCallbackType,
            context: *mut c_void,
        ) -> Option<NonNull<CFRunLoopSource>>;
    }
    let ret = unsafe { IOPSNotificationCreateRunLoopSource(callback, context) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

/// Returns a CFRunLoopSourceRef that notifies the caller when power source
/// changes from an unlimited power source (like attached to wall, car, or airplane power), to a limited
/// power source (like a battery or UPS).
///
///
/// Returns a CFRunLoopSourceRef for scheduling with your CFRunLoop.
/// If your project does not use a CFRunLoop, you can alternatively
/// receive this notification via
/// <code>
/// notify.h
/// </code>
/// using the name
/// <code>
///
/// ```text
///  kIOPSNotifyPowerSource
/// ```
///
/// </code>
///
///
/// Parameter `callback`: A function to be called whenever the power source changes from AC to DC..
///
///
/// Parameter `context`: Any user-defined pointer, passed to the IOPowerSource callback.
///
///
/// Returns: Returns NULL if an error was encountered, otherwise a CFRunLoopSource. Caller must
/// release the CFRunLoopSource.
///
/// # Safety
///
/// - `callback` must be implemented correctly.
/// - `context` must be a valid pointer.
#[inline]
pub unsafe extern "C-unwind" fn IOPSCreateLimitedPowerNotification(
    callback: IOPowerSourceCallbackType,
    context: *mut c_void,
) -> Option<CFRetained<CFRunLoopSource>> {
    extern "C-unwind" {
        fn IOPSCreateLimitedPowerNotification(
            callback: IOPowerSourceCallbackType,
            context: *mut c_void,
        ) -> Option<NonNull<CFRunLoopSource>>;
    }
    let ret = unsafe { IOPSCreateLimitedPowerNotification(callback, context) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

/// Returns a CFDictionary that describes the attached (AC) external
/// power adapter (if any external power adapter is attached.
///
///
/// Use the kIOPSPowerAdapter... keys described in IOPSKeys.h
/// to interpret the returned CFDictionary.
///
///
/// Returns: Returns a CFDictionary on success. Caller must release the returned
/// dictionary. If no adapter is attached, or if there's an error,  returns NULL.
#[inline]
pub extern "C-unwind" fn IOPSCopyExternalPowerAdapterDetails() -> Option<CFRetained<CFDictionary>> {
    extern "C-unwind" {
        fn IOPSCopyExternalPowerAdapterDetails() -> Option<NonNull<CFDictionary>>;
    }
    let ret = unsafe { IOPSCopyExternalPowerAdapterDetails() };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

/// Type and arguments of callout C function that is used when a
/// completion routine is called.  This function pointer is set
/// via setEventCallback and is called when an event is available
/// from the UPS.
///
/// Parameter `target`: void * pointer to your data, often a pointer to an object.
///
/// Parameter `result`: Completion result of desired operation.
///
/// Parameter `refcon`: void * pointer to more data.
///
/// Parameter `sender`: Interface instance sending the completion routine.
///
/// Parameter `event`: CFDictionaryRef containing event data.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/iokit/ioupseventcallbackfunction?language=objc)
pub type IOUPSEventCallbackFunction = Option<
    unsafe extern "C-unwind" fn(
        *mut c_void,
        IOReturn,
        *mut c_void,
        *mut c_void,
        *const CFDictionary,
    ),
>;

/// [Apple's documentation](https://developer.apple.com/documentation/iokit/ioupsplugininterface?language=objc)
#[repr(C)]
#[allow(unpredictable_function_pointer_comparisons)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct IOUPSPlugInInterface {
    pub(crate) _reserved: *mut c_void,
    pub QueryInterface:
        Option<unsafe extern "C-unwind" fn(*mut c_void, REFIID, *mut LPVOID) -> HRESULT>,
    pub AddRef: Option<unsafe extern "C-unwind" fn(*mut c_void) -> ULONG>,
    pub Release: Option<unsafe extern "C-unwind" fn(*mut c_void) -> ULONG>,
    pub getProperties:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut *const CFDictionary) -> IOReturn>,
    pub getCapabilities:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut *const CFSet) -> IOReturn>,
    pub getEvent:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut *const CFDictionary) -> IOReturn>,
    pub setEventCallback: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            IOUPSEventCallbackFunction,
            *mut c_void,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub sendCommand:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *const CFDictionary) -> IOReturn>,
}

#[cfg(feature = "objc2")]
unsafe impl Encode for IOUPSPlugInInterface {
    const ENCODING: Encoding = Encoding::Struct("IOUPSPlugInInterface", &[
        <*mut c_void>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,REFIID,*mut LPVOID,) -> HRESULT>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> ULONG>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> ULONG>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut *const CFDictionary,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut *const CFSet,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut *const CFDictionary,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,IOUPSEventCallbackFunction,*mut c_void,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*const CFDictionary,) -> IOReturn>>::ENCODING,
    ]);
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for IOUPSPlugInInterface {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/iokit/ioupsplugininterface_v140?language=objc)
#[repr(C)]
#[allow(unpredictable_function_pointer_comparisons)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct IOUPSPlugInInterface_v140 {
    pub(crate) _reserved: *mut c_void,
    pub QueryInterface:
        Option<unsafe extern "C-unwind" fn(*mut c_void, REFIID, *mut LPVOID) -> HRESULT>,
    pub AddRef: Option<unsafe extern "C-unwind" fn(*mut c_void) -> ULONG>,
    pub Release: Option<unsafe extern "C-unwind" fn(*mut c_void) -> ULONG>,
    pub getProperties:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut *const CFDictionary) -> IOReturn>,
    pub getCapabilities:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut *const CFSet) -> IOReturn>,
    pub getEvent:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut *const CFDictionary) -> IOReturn>,
    pub setEventCallback: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            IOUPSEventCallbackFunction,
            *mut c_void,
            *mut c_void,
        ) -> IOReturn,
    >,
    pub sendCommand:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *const CFDictionary) -> IOReturn>,
    pub createAsyncEventSource:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut *const CFType) -> IOReturn>,
}

#[cfg(feature = "objc2")]
unsafe impl Encode for IOUPSPlugInInterface_v140 {
    const ENCODING: Encoding = Encoding::Struct("IOUPSPlugInInterface_v140", &[
        <*mut c_void>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,REFIID,*mut LPVOID,) -> HRESULT>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> ULONG>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> ULONG>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut *const CFDictionary,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut *const CFSet,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut *const CFDictionary,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,IOUPSEventCallbackFunction,*mut c_void,*mut c_void,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*const CFDictionary,) -> IOReturn>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut *const CFType,) -> IOReturn>>::ENCODING,
    ]);
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for IOUPSPlugInInterface_v140 {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}
