// This file is @generated by prost-build.
/// Resource information.
#[cfg_attr(feature = "with-schemars", derive(schemars::JsonSchema))]
#[cfg_attr(feature = "with-serde", derive(serde::Serialize, serde::Deserialize))]
#[cfg_attr(feature = "with-serde", serde(rename_all = "camelCase"))]
#[cfg_attr(feature = "with-serde", serde(default))]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Resource {
    /// Set of attributes that describe the resource.
    /// Attribute keys MUST be unique (it is not allowed to have more than one
    /// attribute with the same key).
    ///
    /// The attribute values SHOULD NOT contain empty values.
    /// The attribute values SHOULD NOT contain bytes values.
    /// The attribute values SHOULD NOT contain array values different than array of string values, bool values, int values,
    /// double values.
    /// The attribute values SHOULD NOT contain kvlist values.
    /// The behavior of software that receives attributes containing such values can be unpredictable.
    /// These restrictions can change in a minor release.
    /// The restrictions take origin from the OpenTelemetry specification:
    /// <https://github.com/open-telemetry/opentelemetry-specification/blob/v1.47.0/specification/common/README.md#attribute.>
    #[prost(message, repeated, tag = "1")]
    pub attributes: ::prost::alloc::vec::Vec<super::super::common::v1::KeyValue>,
    /// dropped_attributes_count is the number of dropped attributes. If the value is 0, then
    /// no attributes were dropped.
    #[prost(uint32, tag = "2")]
    pub dropped_attributes_count: u32,
    /// Set of entities that participate in this Resource.
    ///
    /// Note: keys in the references MUST exist in attributes of this message.
    ///
    /// Status: \[Development\]
    #[prost(message, repeated, tag = "3")]
    pub entity_refs: ::prost::alloc::vec::Vec<super::super::common::v1::EntityRef>,
}
