/*
 * Copyright (c) 2012, 2026, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * UNICODE LICENSE V3
 *
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright © 1991-2025 Unicode, Inc.
 *
 * NOTICE TO USER: Carefully read the following legal agreement. BY
 * DOWNLOADING, INSTALLING, COPYING OR OTHERWISE USING DATA FILES, AND/OR
 * SOFTWARE, YOU UNEQUIVOCALLY ACCEPT, AND AGREE TO BE BOUND BY, ALL OF THE
 * TERMS AND CONDITIONS OF THIS AGREEMENT. IF YOU DO NOT AGREE, DO NOT
 * DOWNLOAD, INSTALL, COPY, DISTRIBUTE OR USE THE DATA FILES OR SOFTWARE.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of data files and any associated documentation (the "Data Files") or
 * software and any associated documentation (the "Software") to deal in the
 * Data Files or Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, and/or sell
 * copies of the Data Files or Software, and to permit persons to whom the
 * Data Files or Software are furnished to do so, provided that either (a)
 * this copyright and permission notice appear with all copies of the Data
 * Files or Software, or (b) this copyright and permission notice appear in
 * associated Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS NOTICE
 * BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THE DATA
 * FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall
 * not be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written
 * authorization of the copyright holder.
 *
 * SPDX-License-Identifier: Unicode-3.0
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_ko extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_GH = "가나";
        final String metaValue_key_nu = "숫자";
        final Object[][] data = new Object[][] {
            { "001", "세계" },
            { "002", "아프리카" },
            { "003", "북아메리카" },
            { "005", "남아메리카" },
            { "009", "오세아니아" },
            { "011", "서부 아프리카" },
            { "013", "중앙 아메리카" },
            { "014", "동부 아프리카" },
            { "015", "북부 아프리카" },
            { "017", "중부 아프리카" },
            { "018", "남부 아프리카" },
            { "019", "아메리카 대륙" },
            { "021", "북부 아메리카" },
            { "029", "카리브 제도" },
            { "030", "동아시아" },
            { "034", "남아시아" },
            { "035", "동남아시아" },
            { "039", "남유럽" },
            { "053", "오스트랄라시아" },
            { "054", "멜라네시아" },
            { "057", "미크로네시아 지역" },
            { "061", "폴리네시아" },
            { "142", "아시아" },
            { "143", "중앙 아시아" },
            { "145", "서아시아" },
            { "150", "유럽" },
            { "151", "동유럽" },
            { "154", "북유럽" },
            { "155", "서유럽" },
            { "202", "사하라 사막 이남 아프리카" },
            { "419", "라틴 아메리카" },
            { "AC", "어센션섬" },
            { "AD", "안도라" },
            { "AE", "아랍에미리트" },
            { "AF", "아프가니스탄" },
            { "AG", "앤티가 바부다" },
            { "AI", "앵귈라" },
            { "AL", "알바니아" },
            { "AM", "아르메니아" },
            { "AO", "앙골라" },
            { "AQ", "남극 대륙" },
            { "AR", "아르헨티나" },
            { "AS", "아메리칸 사모아" },
            { "AT", "오스트리아" },
            { "AU", "오스트레일리아" },
            { "AW", "아루바" },
            { "AX", "올란드 제도" },
            { "AZ", "아제르바이잔" },
            { "BA", "보스니아 헤르체고비나" },
            { "BB", "바베이도스" },
            { "BD", "방글라데시" },
            { "BE", "벨기에" },
            { "BF", "부르키나파소" },
            { "BG", "불가리아" },
            { "BH", "바레인" },
            { "BI", "부룬디" },
            { "BJ", "베냉" },
            { "BL", "생바르텔레미" },
            { "BM", "버뮤다" },
            { "BN", "브루나이" },
            { "BO", "볼리비아" },
            { "BQ", "네덜란드령 카리브" },
            { "BR", "브라질" },
            { "BS", "바하마" },
            { "BT", "부탄" },
            { "BV", "부베섬" },
            { "BW", "보츠와나" },
            { "BY", "벨라루스" },
            { "BZ", "벨리즈" },
            { "CA", "캐나다" },
            { "CC", "코코스 제도" },
            { "CD", "콩고-킨샤사" },
            { "CF", "중앙 아프리카 공화국" },
            { "CG", "콩고-브라자빌" },
            { "CH", "스위스" },
            { "CI", "코트디부아르" },
            { "CK", "쿡 제도" },
            { "CL", "칠레" },
            { "CM", "카메룬" },
            { "CN", "중국" },
            { "CO", "콜롬비아" },
            { "CP", "클리퍼턴섬" },
            { "CQ", "사크" },
            { "CR", "코스타리카" },
            { "CU", "쿠바" },
            { "CV", "카보베르데" },
            { "CW", "퀴라소" },
            { "CX", "크리스마스섬" },
            { "CY", "키프로스" },
            { "CZ", "체코" },
            { "DE", "독일" },
            { "DG", "디에고 가르시아" },
            { "DJ", "지부티" },
            { "DK", "덴마크" },
            { "DM", "도미니카" },
            { "DO", "도미니카 공화국" },
            { "DZ", "알제리" },
            { "EA", "세우타 및 멜리야" },
            { "EC", "에콰도르" },
            { "EE", "에스토니아" },
            { "EG", "이집트" },
            { "EH", "서사하라" },
            { "ER", "에리트리아" },
            { "ES", "스페인" },
            { "ET", "에티오피아" },
            { "EU", "유럽 연합" },
            { "EZ", "유로존" },
            { "FI", "핀란드" },
            { "FJ", "피지" },
            { "FK", "포클랜드 제도" },
            { "FM", "미크로네시아" },
            { "FO", "페로 제도" },
            { "FR", "프랑스" },
            { "GA", "가봉" },
            { "GB", "영국" },
            { "GD", "그레나다" },
            { "GE", "조지아" },
            { "GF", "프랑스령 기아나" },
            { "GG", "건지" },
            { "GH", metaValue_GH },
            { "GI", "지브롤터" },
            { "GL", "그린란드" },
            { "GM", "감비아" },
            { "GN", "기니" },
            { "GP", "과들루프" },
            { "GQ", "적도 기니" },
            { "GR", "그리스" },
            { "GS", "사우스조지아 사우스샌드위치 제도" },
            { "GT", "과테말라" },
            { "GU", "괌" },
            { "GW", "기니비사우" },
            { "GY", "가이아나" },
            { "HK", "홍콩(중국 특별행정구)" },
            { "HM", "허드 맥도널드 제도" },
            { "HN", "온두라스" },
            { "HR", "크로아티아" },
            { "HT", "아이티" },
            { "HU", "헝가리" },
            { "IC", "카나리아 제도" },
            { "ID", "인도네시아" },
            { "IE", "아일랜드" },
            { "IL", "이스라엘" },
            { "IM", "맨섬" },
            { "IN", "인도" },
            { "IO", "영국령 인도양 지역" },
            { "IQ", "이라크" },
            { "IR", "이란" },
            { "IS", "아이슬란드" },
            { "IT", "이탈리아" },
            { "JE", "저지" },
            { "JM", "자메이카" },
            { "JO", "요르단" },
            { "JP", "일본" },
            { "KE", "케냐" },
            { "KG", "키르기스스탄" },
            { "KH", "캄보디아" },
            { "KI", "키리바시" },
            { "KM", "코모로" },
            { "KN", "세인트키츠 네비스" },
            { "KP", "북한" },
            { "KR", "대한민국" },
            { "KW", "쿠웨이트" },
            { "KY", "케이맨 제도" },
            { "KZ", "카자흐스탄" },
            { "LA", "라오스" },
            { "LB", "레바논" },
            { "LC", "세인트루시아" },
            { "LI", "리히텐슈타인" },
            { "LK", "스리랑카" },
            { "LR", "라이베리아" },
            { "LS", "레소토" },
            { "LT", "리투아니아" },
            { "LU", "룩셈부르크" },
            { "LV", "라트비아" },
            { "LY", "리비아" },
            { "MA", "모로코" },
            { "MC", "모나코" },
            { "MD", "몰도바" },
            { "ME", "몬테네그로" },
            { "MF", "생마르탱" },
            { "MG", "마다가스카르" },
            { "MH", "마셜 제도" },
            { "MK", "북마케도니아" },
            { "ML", "말리" },
            { "MM", "미얀마" },
            { "MN", "몽골" },
            { "MO", "마카오(중국 특별행정구)" },
            { "MP", "북마리아나제도" },
            { "MQ", "마르티니크" },
            { "MR", "모리타니" },
            { "MS", "몬트세라트" },
            { "MT", "몰타" },
            { "MU", "모리셔스" },
            { "MV", "몰디브" },
            { "MW", "말라위" },
            { "MX", "멕시코" },
            { "MY", "말레이시아" },
            { "MZ", "모잠비크" },
            { "NA", "나미비아" },
            { "NC", "뉴칼레도니아" },
            { "NE", "니제르" },
            { "NF", "노퍽섬" },
            { "NG", "나이지리아" },
            { "NI", "니카라과" },
            { "NL", "네덜란드" },
            { "NO", "노르웨이" },
            { "NP", "네팔" },
            { "NR", "나우루" },
            { "NU", "니우에" },
            { "NZ", "뉴질랜드" },
            { "OM", "오만" },
            { "PA", "파나마" },
            { "PE", "페루" },
            { "PF", "프랑스령 폴리네시아" },
            { "PG", "파푸아뉴기니" },
            { "PH", "필리핀" },
            { "PK", "파키스탄" },
            { "PL", "폴란드" },
            { "PM", "생피에르 미클롱" },
            { "PN", "핏케언 제도" },
            { "PR", "푸에르토리코" },
            { "PS", "팔레스타인 지구" },
            { "PT", "포르투갈" },
            { "PW", "팔라우" },
            { "PY", "파라과이" },
            { "QA", "카타르" },
            { "QO", "오세아니아 외곽" },
            { "RE", "레위니옹" },
            { "RO", "루마니아" },
            { "RS", "세르비아" },
            { "RU", "러시아" },
            { "RW", "르완다" },
            { "SA", "사우디아라비아" },
            { "SB", "솔로몬 제도" },
            { "SC", "세이셸" },
            { "SD", "수단" },
            { "SE", "스웨덴" },
            { "SG", "싱가포르" },
            { "SH", "세인트헬레나" },
            { "SI", "슬로베니아" },
            { "SJ", "스발바르제도-얀마웬섬" },
            { "SK", "슬로바키아" },
            { "SL", "시에라리온" },
            { "SM", "산마리노" },
            { "SN", "세네갈" },
            { "SO", "소말리아" },
            { "SR", "수리남" },
            { "SS", "남수단" },
            { "ST", "상투메 프린시페" },
            { "SV", "엘살바도르" },
            { "SX", "신트마르턴" },
            { "SY", "시리아" },
            { "SZ", "에스와티니" },
            { "TA", "트리스탄다쿠나" },
            { "TC", "터크스 케이커스 제도" },
            { "TD", "차드" },
            { "TF", "프랑스령 남방 지역" },
            { "TG", "토고" },
            { "TH", "태국" },
            { "TJ", "타지키스탄" },
            { "TK", "토켈라우" },
            { "TL", "동티모르" },
            { "TM", "투르크메니스탄" },
            { "TN", "튀니지" },
            { "TO", "통가" },
            { "TR", "튀르키예" },
            { "TT", "트리니다드 토바고" },
            { "TV", "투발루" },
            { "TW", "대만" },
            { "TZ", "탄자니아" },
            { "UA", "우크라이나" },
            { "UG", "우간다" },
            { "UM", "미국령 해외 제도" },
            { "UN", "국제연합" },
            { "US", "미국" },
            { "UY", "우루과이" },
            { "UZ", "우즈베키스탄" },
            { "VA", "바티칸 시국" },
            { "VC", "세인트빈센트그레나딘" },
            { "VE", "베네수엘라" },
            { "VG", "영국령 버진아일랜드" },
            { "VI", "미국령 버진아일랜드" },
            { "VN", "베트남" },
            { "VU", "바누아투" },
            { "WF", "왈리스-푸투나 제도" },
            { "WS", "사모아" },
            { "XA", "유사 억양" },
            { "XB", "유사 양방향" },
            { "XK", "코소보" },
            { "YE", "예멘" },
            { "YT", "마요트" },
            { "ZA", "남아프리카" },
            { "ZM", "잠비아" },
            { "ZW", "짐바브웨" },
            { "ZZ", "알려지지 않은 지역" },
            { "aa", "아파르어" },
            { "ab", "압카즈어" },
            { "ae", "아베스타어" },
            { "af", "아프리칸스어" },
            { "ak", "아칸어" },
            { "am", "암하라어" },
            { "an", "아라곤어" },
            { "ar", "아랍어" },
            { "as", "아삼어" },
            { "av", "아바릭어" },
            { "ay", "아이마라어" },
            { "az", "아제르바이잔어" },
            { "ba", "바슈키르어" },
            { "be", "벨라루스어" },
            { "bg", "불가리아어" },
            { "bi", "비슬라마어" },
            { "bm", "밤바라어" },
            { "bn", "벵골어" },
            { "bo", "티베트어" },
            { "br", "브르타뉴어" },
            { "bs", "보스니아어" },
            { "ca", "카탈로니아어" },
            { "ce", "체첸어" },
            { "ch", "차모로어" },
            { "co", "코르시카어" },
            { "cr", "크리어" },
            { "cs", "체코어" },
            { "cu", "교회 슬라브어" },
            { "cv", "추바시어" },
            { "cy", "웨일스어" },
            { "da", "덴마크어" },
            { "de", "독일어" },
            { "dv", "디베히어" },
            { "dz", "종카어" },
            { "ee", "에웨어" },
            { "el", "그리스어" },
            { "en", "영어" },
            { "eo", "에스페란토어" },
            { "es", "스페인어" },
            { "et", "에스토니아어" },
            { "eu", "바스크어" },
            { "fa", "페르시아어" },
            { "ff", "풀라어" },
            { "fi", "핀란드어" },
            { "fj", "피지어" },
            { "fo", "페로어" },
            { "fr", "프랑스어" },
            { "fy", "서부 프리지아어" },
            { "ga", "아일랜드어" },
            { "gd", "스코틀랜드 게일어" },
            { "gl", "갈리시아어" },
            { "gn", "과라니어" },
            { "gu", "구자라트어" },
            { "gv", "맹크스어" },
            { "ha", "하우사어" },
            { "he", "히브리어" },
            { "hi", "힌디어" },
            { "ho", "히리 모투어" },
            { "hr", "크로아티아어" },
            { "ht", "아이티어" },
            { "hu", "헝가리어" },
            { "hy", "아르메니아어" },
            { "hz", "헤레로어" },
            { "ia", "인터링구아" },
            { "id", "인도네시아어" },
            { "ie", "인테르링구에" },
            { "ig", "이그보어" },
            { "ii", "쓰촨 이어" },
            { "ik", "이누피아크어" },
            { "io", "이도어" },
            { "is", "아이슬란드어" },
            { "it", "이탈리아어" },
            { "iu", "이눅티투트어" },
            { "ja", "일본어" },
            { "jv", "자바어" },
            { "ka", "조지아어" },
            { "kg", "콩고어" },
            { "ki", "키쿠유어" },
            { "kj", "쿠안야마어" },
            { "kk", "카자흐어" },
            { "kl", "그린란드어" },
            { "km", "크메르어" },
            { "kn", "칸나다어" },
            { "ko", "한국어" },
            { "kr", "칸누리어" },
            { "ks", "카슈미르어" },
            { "ku", "쿠르만지" },
            { "kv", "코미어" },
            { "kw", "콘월어" },
            { "ky", "키르기스어" },
            { "la", "라틴어" },
            { "lb", "룩셈부르크어" },
            { "lg", "간다어" },
            { "li", "림버거어" },
            { "ln", "링갈라어" },
            { "lo", "라오어" },
            { "lt", "리투아니아어" },
            { "lu", "루바-카탄가어" },
            { "lv", "라트비아어" },
            { "mg", "말라가시어" },
            { "mh", "마셜어" },
            { "mi", "마오리어" },
            { "mk", "마케도니아어" },
            { "ml", "말라얄람어" },
            { "mn", "몽골어" },
            { "mr", "마라티어" },
            { "ms", "말레이어" },
            { "mt", "몰타어" },
            { "my", "버마어" },
            { "na", "나우루어" },
            { "nb", "노르웨이어(보크말)" },
            { "nd", "북부 은데벨레어" },
            { "ne", "네팔어" },
            { "ng", "느동가어" },
            { "nl", "네덜란드어" },
            { "nn", "노르웨이어(니노르스크)" },
            { "no", "노르웨이어" },
            { "nr", "남부 은데벨레어" },
            { "nv", "나바호어" },
            { "ny", "냔자어" },
            { "oc", "오크어" },
            { "oj", "오지브와어" },
            { "om", "오로모어" },
            { "or", "오리야어" },
            { "os", "오세트어" },
            { "pa", "펀자브어" },
            { "pi", "팔리어" },
            { "pl", "폴란드어" },
            { "ps", "파슈토어" },
            { "pt", "포르투갈어" },
            { "qu", "케추아어" },
            { "rm", "로만시어" },
            { "rn", "룬디어" },
            { "ro", "루마니아어" },
            { "ru", "러시아어" },
            { "rw", "르완다어" },
            { "sa", "산스크리트어" },
            { "sc", "사르디니아어" },
            { "sd", "신디어" },
            { "se", "북부 사미어" },
            { "sg", "산고어" },
            { "sh", "세르비아-크로아티아어" },
            { "si", "싱할라어" },
            { "sk", "슬로바키아어" },
            { "sl", "슬로베니아어" },
            { "sm", "사모아어" },
            { "sn", "쇼나어" },
            { "so", "소말리아어" },
            { "sq", "알바니아어" },
            { "sr", "세르비아어" },
            { "ss", "시스와티어" },
            { "st", "남부 소토어" },
            { "su", "순다어" },
            { "sv", "스웨덴어" },
            { "sw", "스와힐리어" },
            { "ta", "타밀어" },
            { "te", "텔루구어" },
            { "tg", "타지크어" },
            { "th", "태국어" },
            { "ti", "티그리냐어" },
            { "tk", "투르크멘어" },
            { "tl", "타갈로그어" },
            { "tn", "츠와나어" },
            { "to", "통가어" },
            { "tr", "튀르키예어" },
            { "ts", "총가어" },
            { "tt", "타타르어" },
            { "tw", "트위어" },
            { "ty", "타히티어" },
            { "ug", "위구르어" },
            { "uk", "우크라이나어" },
            { "ur", "우르두어" },
            { "uz", "우즈베크어" },
            { "ve", "벤다어" },
            { "vi", "베트남어" },
            { "vo", "볼라퓌크어" },
            { "wa", "왈론어" },
            { "wo", "월로프어" },
            { "xh", "코사어" },
            { "yi", "이디시어" },
            { "yo", "요루바어" },
            { "za", "주앙어" },
            { "zh", "중국어" },
            { "zu", "줄루어" },
            { "ace", "아체어" },
            { "ach", "아콜리어" },
            { "ada", "아당메어" },
            { "ady", "아디게어" },
            { "aeb", "튀니지 아랍어" },
            { "afh", "아프리힐리어" },
            { "agq", "아그햄어" },
            { "ain", "아이누어" },
            { "akk", "아카드어" },
            { "ale", "알류트어" },
            { "alt", "남부 알타이어" },
            { "ang", "고대 영어" },
            { "ann", "오볼로어" },
            { "anp", "앙가어" },
            { "arc", "아람어" },
            { "arn", "마푸둥군어" },
            { "arp", "아라파호어" },
            { "arq", "알제리 아랍어" },
            { "ars", "아랍어(나즈디)" },
            { "arw", "아라와크어" },
            { "ary", "모로코 아랍어" },
            { "arz", "이집트 아랍어" },
            { "asa", "아수어" },
            { "ast", "아스투리아어" },
            { "atj", "아티카메쿠어" },
            { "awa", "아와히어" },
            { "bal", "발루치어" },
            { "ban", "발리어" },
            { "bas", "바사어" },
            { "bax", "바문어" },
            { "bbj", "고말라어" },
            { "bej", "베자어" },
            { "bem", "벰바어" },
            { "bez", "베나어" },
            { "bfd", "바푸트어" },
            { "bgc", "하리안비어" },
            { "bgn", "서부 발로치어" },
            { "bho", "호즈푸리어" },
            { "bik", "비콜어" },
            { "bin", "비니어" },
            { "bkm", "콤어" },
            { "bla", "식시카어" },
            { "blo", "아니이어" },
            { "bra", "브라지어" },
            { "brh", "브라후이어" },
            { "brx", "보도어" },
            { "bss", "아쿠즈어" },
            { "bua", "부리아타" },
            { "bug", "부기어" },
            { "bum", "불루어" },
            { "byn", "브린어" },
            { "byv", "메둠바어" },
            { "cad", "카도어" },
            { "car", "카리브어" },
            { "cay", "카유가어" },
            { "cch", "앗삼어" },
            { "ccp", "차크마어" },
            { "ceb", "세부아노어" },
            { "cgg", "치가어" },
            { "chb", "치브차어" },
            { "chg", "차가타이어" },
            { "chk", "추크어" },
            { "chm", "마리어" },
            { "chn", "치누크 자곤" },
            { "cho", "촉토어" },
            { "chp", "치페우얀" },
            { "chr", "체로키어" },
            { "chy", "샤이엔어" },
            { "ckb", "소라니 쿠르드어" },
            { "clc", "칠코틴어" },
            { "cop", "콥트어" },
            { "crg", "미치프어" },
            { "crh", "크리민 터키어; 크리민 타타르어" },
            { "crj", "남동부 크리어" },
            { "crk", "평원 크리어" },
            { "crl", "북동부 크리어" },
            { "crm", "무스크리어" },
            { "crr", "캐롤라이나 알곤킨어" },
            { "crs", "세이셸 크리올 프랑스어" },
            { "csb", "카슈비아어" },
            { "csw", "습지 크리어" },
            { "dak", "다코타어" },
            { "dar", "다르그와어" },
            { "dav", "타이타어" },
            { "del", "델라웨어어" },
            { "den", "슬라브어" },
            { "dgr", "도그리브어" },
            { "din", "딩카어" },
            { "dje", "자르마어" },
            { "doi", "도그리어" },
            { "dsb", "저지 소르비아어" },
            { "dua", "두알라어" },
            { "dum", "중세 네덜란드어" },
            { "dyo", "졸라 포니어" },
            { "dyu", "드율라어" },
            { "dzg", "다장가어" },
            { "ebu", "엠부어" },
            { "efi", "이픽어" },
            { "egy", "고대 이집트어" },
            { "eka", "이카죽어" },
            { "elx", "엘람어" },
            { "enm", "중세 영어" },
            { "ewo", "이원도어" },
            { "fan", "팡그어" },
            { "fat", "판티어" },
            { "fil", "필리핀어" },
            { "fon", "폰어" },
            { "frc", "케이준 프랑스어" },
            { "frm", "중세 프랑스어" },
            { "fro", "고대 프랑스어" },
            { "frr", "북부 프리지아어" },
            { "frs", "동부 프리슬란드어" },
            { "fur", "프리울리어" },
            { "gaa", "가어" },
            { "gag", "가가우스어" },
            { "gan", "간어" },
            { "gay", "가요어" },
            { "gba", "그바야어" },
            { "gbz", "조로아스터 다리어" },
            { "gez", "게이즈어" },
            { "gil", "키리바시어" },
            { "glk", "길라키어" },
            { "gmh", "중세 고지 독일어" },
            { "goh", "고대 고지 독일어" },
            { "gon", "곤디어" },
            { "gor", "고론탈로어" },
            { "got", "고트어" },
            { "grb", "게르보어" },
            { "grc", "고대 그리스어" },
            { "gsw", "독일어(스위스)" },
            { "guz", "구시어" },
            { "gwi", "그위친어" },
            { "hai", "하이다어" },
            { "hak", "하카어" },
            { "haw", "하와이어" },
            { "hax", "남부 하이다어" },
            { "hif", "피지 힌디어" },
            { "hil", "헤리가뇬어" },
            { "hit", "하타이트어" },
            { "hmn", "히몸어" },
            { "hsb", "고지 소르비아어" },
            { "hsn", "샹어" },
            { "hup", "후파어" },
            { "hur", "할코멜렘어" },
            { "iba", "이반어" },
            { "ibb", "이비비오어" },
            { "ikt", "캐나다 서부 이누크티투트어" },
            { "ilo", "이로코어" },
            { "inh", "인귀시어" },
            { "jbo", "로반어" },
            { "jgo", "응곰바어" },
            { "jmc", "마차메어" },
            { "jpr", "유대-페르시아어" },
            { "jrb", "유대-아라비아어" },
            { "kaa", "카라칼파크어" },
            { "kab", "커바일어" },
            { "kac", "카친어" },
            { "kaj", "까꼬토끄어" },
            { "kam", "캄바어" },
            { "kaw", "카위어" },
            { "kbd", "카바르디어" },
            { "kbl", "카넴부어" },
            { "kcg", "티얍어" },
            { "kde", "마콘데어" },
            { "kea", "크리올어" },
            { "kfo", "코로어" },
            { "kgp", "카잉강어" },
            { "kha", "카시어" },
            { "kho", "호탄어" },
            { "khq", "코이라 친니어" },
            { "khw", "코와르어" },
            { "kkj", "카코어" },
            { "kln", "칼렌진어" },
            { "kmb", "킴분두어" },
            { "koi", "코미페르먀크어" },
            { "kok", "코카니어" },
            { "kos", "코스라이엔어" },
            { "kpe", "크펠레어" },
            { "krc", "카라챠이-발카르어" },
            { "krl", "카렐리야어" },
            { "kru", "쿠르크어" },
            { "ksb", "샴발라어" },
            { "ksf", "바피아어" },
            { "ksh", "콜로그니안어" },
            { "kum", "쿠믹어" },
            { "kut", "쿠테네어" },
            { "kwk", "곽왈라어" },
            { "kxv", "쿠비어" },
            { "lad", "라디노어" },
            { "lag", "랑기어" },
            { "lah", "라한다어" },
            { "lam", "람바어" },
            { "lez", "레즈기안어" },
            { "lfn", "링구아 프랑카 노바" },
            { "lij", "리구리아어" },
            { "lil", "릴루엣어" },
            { "lkt", "라코타어" },
            { "lmo", "롬바르드어" },
            { "lol", "몽고어" },
            { "lou", "루이지애나 크리올어" },
            { "loz", "로지어" },
            { "lrc", "북부 루리어" },
            { "lsm", "사미아어" },
            { "lua", "루바-룰루아어" },
            { "lui", "루이세노어" },
            { "lun", "룬다어" },
            { "luo", "루오어" },
            { "lus", "루샤이어" },
            { "luy", "루야어" },
            { "mad", "마두라어" },
            { "maf", "마파어" },
            { "mag", "마가히어" },
            { "mai", "마이틸리어" },
            { "mak", "마카사어" },
            { "man", "만딩고어" },
            { "mas", "마사이어" },
            { "mde", "마바어" },
            { "mdf", "모크샤어" },
            { "mdr", "만다르어" },
            { "men", "멘데어" },
            { "mer", "메루어" },
            { "mfe", "모리스얀어" },
            { "mga", "중세 아일랜드어" },
            { "mgh", "마크후와-메토어" },
            { "mgo", "메타어" },
            { "mic", "미크맥어" },
            { "min", "미낭카바우어" },
            { "mnc", "만주어" },
            { "mni", "마니푸리어" },
            { "moe", "이누아문" },
            { "moh", "모호크어" },
            { "mos", "모시어" },
            { "mrj", "서부 마리어" },
            { "mua", "문당어" },
            { "mul", "다중 언어" },
            { "mus", "크리크어" },
            { "mwl", "미란데어" },
            { "mwr", "마르와리어" },
            { "mye", "미예네어" },
            { "myv", "엘즈야어" },
            { "mzn", "마잔데라니어" },
            { "nan", "민난어" },
            { "nap", "나폴리어" },
            { "naq", "나마어" },
            { "nds", "저지 독일어" },
            { "new", "네와르어" },
            { "nia", "니아스어" },
            { "niu", "니웨언어" },
            { "nmg", "크와시오어" },
            { "nnh", "느기엠본어" },
            { "nog", "노가이어" },
            { "non", "고대 노르웨이어" },
            { "nqo", "응코어" },
            { "nso", "북부 소토어" },
            { "nus", "누에르어" },
            { "nwc", "고전 네와르어" },
            { "nym", "니암웨지어" },
            { "nyn", "니안콜어" },
            { "nyo", "뉴로어" },
            { "nzi", "느지마어" },
            { "ojb", "북서부 오지브와어" },
            { "ojc", "중앙 오지브와어" },
            { "ojs", "오지 크리어" },
            { "ojw", "서부 오지브와어" },
            { "oka", "오카나간어" },
            { "osa", "오세이지어" },
            { "ota", "오스만 터키어" },
            { "pag", "판가시난어" },
            { "pal", "팔레비어" },
            { "pam", "팜팡가어" },
            { "pap", "파피아먼토어" },
            { "pau", "팔라우어" },
            { "pcm", "나이지리아 피진어" },
            { "peo", "고대 페르시아어" },
            { "phn", "페니키아어" },
            { "pis", "피진어" },
            { "pnt", "폰틱어" },
            { "pon", "폼페이어" },
            { "pqm", "말리시트 파사마쿼디어" },
            { "prg", "프러시아어" },
            { "pro", "고대 프로방스어" },
            { "quc", "키체어" },
            { "raj", "라자스탄어" },
            { "rap", "라파뉴이" },
            { "rar", "라로통가어" },
            { "rhg", "로힝야어" },
            { "rof", "롬보어" },
            { "rom", "집시어" },
            { "rue", "루신어" },
            { "rup", "아로마니아어" },
            { "rwk", "르와어" },
            { "sad", "산다웨어" },
            { "sah", "야쿠트어" },
            { "sam", "사마리아 아랍어" },
            { "saq", "삼부루어" },
            { "sas", "사사크어" },
            { "sat", "산탈리어" },
            { "sba", "느감바이어" },
            { "sbp", "상구어" },
            { "scn", "시칠리아어" },
            { "sco", "스코틀랜드어" },
            { "sdh", "남부 쿠르드어" },
            { "see", "세네카어" },
            { "seh", "세나어" },
            { "sel", "셀쿠프어" },
            { "ses", "코이야보로 세니어" },
            { "sga", "고대 아일랜드어" },
            { "shi", "타셸히트어" },
            { "shn", "샨어" },
            { "shu", "차디언 아라비아어" },
            { "sid", "시다모어" },
            { "slh", "남부 루슈트시드어" },
            { "sma", "남부 사미어" },
            { "smj", "룰레 사미어" },
            { "smn", "이나리 사미어" },
            { "sms", "스콜트 사미어" },
            { "snk", "소닌케어" },
            { "sog", "소그디엔어" },
            { "srn", "스라난 통가어" },
            { "srr", "세레르어" },
            { "ssy", "사호어" },
            { "str", "해안 살리시어" },
            { "suk", "수쿠마어" },
            { "sus", "수수어" },
            { "sux", "수메르어" },
            { "swb", "코모로어" },
            { "syc", "고전 시리아어" },
            { "syr", "시리아어" },
            { "szl", "실레시아어" },
            { "tce", "남부 투톤어" },
            { "tem", "팀니어" },
            { "teo", "테조어" },
            { "ter", "테레노어" },
            { "tet", "테툼어" },
            { "tgx", "타기시어" },
            { "tht", "탈탄어" },
            { "tig", "티그레어" },
            { "tiv", "티브어" },
            { "tkl", "토켈라우제도어" },
            { "tkr", "차후르어" },
            { "tlh", "클링온어" },
            { "tli", "틀링깃족어" },
            { "tly", "탈리쉬어" },
            { "tmh", "타마섹어" },
            { "tog", "니아사 통가어" },
            { "tok", "도기 보나" },
            { "tpi", "토크 피신어" },
            { "trv", "타로코어" },
            { "tsi", "트심시안어" },
            { "ttm", "북부 투톤어" },
            { "tum", "툼부카어" },
            { "tvl", "투발루어" },
            { "twq", "타사와크어" },
            { "tyv", "투비니안어" },
            { "tzm", "중앙 모로코 타마지트어" },
            { "udm", "우드말트어" },
            { "uga", "유가리틱어" },
            { "umb", "움분두어" },
            { "und", "알 수 없는 언어" },
            { "vai", "바이어" },
            { "vec", "베네치아어" },
            { "vmw", "마쿠와어" },
            { "vot", "보틱어" },
            { "vun", "분조어" },
            { "wae", "월저어" },
            { "wal", "월라이타어" },
            { "war", "와라이어" },
            { "was", "와쇼어" },
            { "wbp", "왈피리어" },
            { "wuu", "우어" },
            { "xal", "칼미크어" },
            { "xnr", "캉리어" },
            { "xog", "소가어" },
            { "yao", "야오족어" },
            { "yap", "얍페세어" },
            { "yav", "양본어" },
            { "ybb", "옘바어" },
            { "yrl", "넨가투어" },
            { "yue", "광둥어" },
            { "zap", "사포테크어" },
            { "zbl", "블리스 심볼" },
            { "zen", "제나가어" },
            { "zgh", "표준 모로코 타마지트어" },
            { "zun", "주니어" },
            { "zxx", "언어 관련 내용 없음" },
            { "zza", "자자어" },
            { "Adlm", "아들람 문자" },
            { "Afak", "아파카 문자" },
            { "Aghb", "코카시안 알바니아 문자" },
            { "Arab", "아랍 문자" },
            { "Aran", "나스탈리크체" },
            { "Armi", "아랍제국 문자" },
            { "Armn", "아르메니아 문자" },
            { "Avst", "아베스타 문자" },
            { "Bali", "발리 문자" },
            { "Bamu", "바뭄 문자" },
            { "Bass", "바사바흐 문자" },
            { "Batk", "바타크 문자" },
            { "Beng", "벵골 문자" },
            { "Blis", "블리스기호 문자" },
            { "Bopo", "주음부호" },
            { "Brah", "브라미" },
            { "Brai", "브라유 점자" },
            { "Bugi", "부기 문자" },
            { "Buhd", "부히드 문자" },
            { "Cakm", "차크마 문자" },
            { "Cans", "통합 캐나다 원주민 음절문자" },
            { "Cari", "카리 문자" },
            { "Cham", "칸 고어" },
            { "Cher", "체로키 문자" },
            { "Cirt", "키르쓰" },
            { "Copt", "콥트 문자" },
            { "Cprt", "키프로스 문자" },
            { "Cyrl", "키릴 문자" },
            { "Cyrs", "고대교회슬라브어 키릴문자" },
            { "Deva", "데바나가리 문자" },
            { "Dsrt", "디저렛 문자" },
            { "Dupl", "듀플로이안 문자" },
            { "Egyd", "고대 이집트 민중문자" },
            { "Egyh", "고대 이집트 신관문자" },
            { "Egyp", "고대 이집트 신성문자" },
            { "Elba", "엘바산 문자" },
            { "Ethi", "에티오피아 문자" },
            { "Geok", "그루지야 쿠츠리 문자" },
            { "Geor", "조지아 문자" },
            { "Glag", "글라골 문자" },
            { "Goth", "고트 문자" },
            { "Gran", "그란타 문자" },
            { "Grek", "그리스 문자" },
            { "Gujr", "구자라트 문자" },
            { "Guru", "구르무키 문자" },
            { "Hanb", "주음 자모" },
            { "Hang", "한글" },
            { "Hani", "한자" },
            { "Hano", "하누누 문자" },
            { "Hans", "간체" },
            { "Hant", "번체" },
            { "Hebr", "히브리 문자" },
            { "Hira", "히라가나" },
            { "Hluw", "아나톨리아 상형문자" },
            { "Hmng", "파하우 몽 문자" },
            { "Hrkt", metaValue_GH },
            { "Hung", "고대 헝가리 문자" },
            { "Inds", "인더스 문자" },
            { "Ital", "고대 이탈리아 문자" },
            { "Jamo", "자모" },
            { "Java", "자바 문자" },
            { "Jpan", "일본 문자" },
            { "Jurc", "줄첸 문자" },
            { "Kali", "카야 리 문자" },
            { "Kana", "가타카나" },
            { "Khar", "카로슈티 문자" },
            { "Khmr", "크메르 문자" },
            { "Khoj", "코즈키 문자" },
            { "Knda", "칸나다 문자" },
            { "Kore", "한국 문자" },
            { "Kpel", "크펠레 문자" },
            { "Kthi", "카이시 문자" },
            { "Lana", "란나 문자" },
            { "Laoo", "라오 문자" },
            { "Latf", "독일식 로마자" },
            { "Latg", "아일랜드식 로마자" },
            { "Latn", "로마자" },
            { "Lepc", "렙차 문자" },
            { "Limb", "림부 문자" },
            { "Lina", "선형 문자(A)" },
            { "Linb", "선형 문자(B)" },
            { "Lisu", "프레이저 문자" },
            { "Loma", "로마 문자" },
            { "Lyci", "리키아 문자" },
            { "Lydi", "리디아 문자" },
            { "Mahj", "마하자니 문자" },
            { "Mand", "만다이아 문자" },
            { "Mani", "마니교 문자" },
            { "Maya", "마야 상형 문자" },
            { "Mend", "멘데 문자" },
            { "Merc", "메로에 필기체" },
            { "Mero", "메로에 문자" },
            { "Mlym", "말라얄람 문자" },
            { "Mong", "몽골 문자" },
            { "Moon", "문 문자" },
            { "Mroo", "므로 문자" },
            { "Mtei", "메이테이 마옉 문자" },
            { "Mymr", "미얀마 문자" },
            { "Narb", "옛 북부 아라비아 문자" },
            { "Nbat", "나바테아 문자" },
            { "Nkgb", "나시 게바 문자" },
            { "Nkoo", "응코 문자" },
            { "Nshu", "누슈 문자" },
            { "Ogam", "오검 문자" },
            { "Olck", "올 치키 문자" },
            { "Orkh", "오르혼어" },
            { "Orya", "오리야 문자" },
            { "Osma", "오스마니아 문자" },
            { "Palm", "팔미라 문자" },
            { "Perm", "고대 페름 문자" },
            { "Phag", "파스파 문자" },
            { "Phli", "명문 팔라비 문자" },
            { "Phlp", "솔터 팔라비 문자" },
            { "Phlv", "북 팔라비 문자" },
            { "Phnx", "페니키아 문자" },
            { "Plrd", "폴라드 표음 문자" },
            { "Prti", "명문 파라티아 문자" },
            { "Qaag", "저지 문자" },
            { "Rjng", "레장 문자" },
            { "Rohg", "하니피 문자" },
            { "Roro", "롱고롱고" },
            { "Runr", "룬 문자" },
            { "Samr", "사마리아 문자" },
            { "Sara", "사라티" },
            { "Sarb", "옛 남부 아라비아 문자" },
            { "Saur", "사우라슈트라 문자" },
            { "Sgnw", "수화 문자" },
            { "Shaw", "샤비안 문자" },
            { "Shrd", "사라다 문자" },
            { "Sidd", "실담자" },
            { "Sind", "쿠다와디 문자" },
            { "Sinh", "신할라 문자" },
            { "Sora", "소라 솜펭 문자" },
            { "Sund", "순다 문자" },
            { "Sylo", "실헤티 나가리" },
            { "Syrc", "시리아 문자" },
            { "Syre", "에스트랑겔로식 시리아 문자" },
            { "Syrj", "서부 시리아 문자" },
            { "Syrn", "동부 시리아 문자" },
            { "Tagb", "타그반와 문자" },
            { "Takr", "타크리 문자" },
            { "Tale", "타이 레 문자" },
            { "Talu", "신 타이 루에" },
            { "Taml", "타밀 문자" },
            { "Tang", "탕구트 문자" },
            { "Tavt", "태국 베트남 문자" },
            { "Telu", "텔루구 문자" },
            { "Teng", "텡과르 문자" },
            { "Tfng", "티피나그 문자" },
            { "Tglg", "타갈로그 문자" },
            { "Thaa", "타나 문자" },
            { "Thai", "타이 문자" },
            { "Tibt", "티베트 문자" },
            { "Tirh", "티르후타 문자" },
            { "Ugar", "우가리트 문자" },
            { "Vaii", "바이 문자" },
            { "Visp", "시화법" },
            { "Wara", "바랑 크시티 문자" },
            { "Wole", "울레아이" },
            { "Xpeo", "고대 페르시아 문자" },
            { "Xsux", "수메르-아카드어 설형문자" },
            { "Yiii", "이 문자" },
            { "Zinh", "구전 문자" },
            { "Zmth", "수학 기호" },
            { "Zsye", "이모티콘" },
            { "Zsym", "기호" },
            { "Zxxx", "구전" },
            { "Zyyy", "일반 문자" },
            { "Zzzz", "알 수 없는 문자" },
            { "de_CH", "고지 독일어(스위스)" },
            { "es_ES", "스페인어(유럽)" },
            { "fa_AF", "다리어" },
            { "nl_BE", "플라망어" },
            { "pt_PT", "포르투갈어(유럽)" },
            { "ro_MD", "몰도바어" },
            { "sw_CD", "콩고 스와힐리어" },
            { "%%1901", "전통 독일어 표기법" },
            { "ar_001", "현대 표준 아랍어" },
            { "key.ca", "달력" },
            { "key.cf", "통화 형식" },
            { "key.co", "정렬 순서" },
            { "key.cu", "통화" },
            { "key.em", "이모티콘 표시" },
            { "key.hc", "시간표시법(12시, 24시)" },
            { "key.lb", "줄바꿈 스타일" },
            { "key.lw", "단어의 줄바꿈" },
            { "key.ms", "계량법" },
            { "key.nu", metaValue_key_nu },
            { "key.ss", "약어 뒤 문장 구분" },
            { "key.tz", "시간대" },
            { "key.va", "방언" },
            { "nds_NL", "저지 색슨어" },
            { "%%ALUKU", "알루꾸 방언" },
            { "%%JAUER", "야우어" },
            { "%%POSIX", "Computer" },
            { "%%PUTER", "퓨터" },
            { "%%NDYUKA", "느듀카 방언" },
            { "%%PAMAKA", "파마카 방언" },
            { "%%UCRCOR", "통합 개정 표기법" },
            { "%%ULSTER", "얼스터" },
            { "%%ALALC97", "ALA-LC 로마자 표기법(1997년 개정)" },
            { "%%BAUDDHA", "바우다" },
            { "%%HEPBURN", "헵번식 로마자 표기법" },
            { "%%ITIHASA", "이띠아사" },
            { "%%LAUKIKA", "라우키카" },
            { "%%REVISED", "개정" },
            { "%%VAIDIKA", "바이디카" },
            { "%%1606NICT", "중세 후기 프랑스어(1606년까지)" },
            { "%%BISCAYAN", "비스카얀" },
            { "%%HOGNORSK", "호그노르스크" },
            { "%%LUNA1918", "루나1918" },
            { "%%SCOTLAND", "스코틀랜드 표준 영어" },
            { "%%SURMIRAN", "서미안" },
            { "%%VALLADER", "발라더" },
            { "type.ca.roc", "대만력" },
            { "type.co.eor", "유럽 정렬 규칙" },
            { "type.hc.h11", "12시간제(0–11)" },
            { "type.hc.h12", "12시간제(1–12)" },
            { "type.hc.h23", "24시간제(0–23)" },
            { "type.hc.h24", "24시간제(1–24)" },
            { "type.m0.bgn", "미국 지명위원회(BGN)" },
            { "type.nu.arab", "아라비아-인도식 숫자" },
            { "type.nu.armn", "아르메니아 숫자" },
            { "type.nu.bali", "발리 숫자" },
            { "type.nu.beng", "뱅골 숫자" },
            { "type.nu.brah", "브라미 숫자" },
            { "type.nu.cakm", "챠크마 숫자" },
            { "type.nu.cham", "참 숫자" },
            { "type.nu.deva", "데바나가리 숫자" },
            { "type.nu.ethi", "에티오피아 숫자" },
            { "type.nu.geor", "조지아 숫자" },
            { "type.nu.grek", "그리스 숫자" },
            { "type.nu.gujr", "구자라트 숫자" },
            { "type.nu.guru", "굴묵키 숫자" },
            { "type.nu.hans", "중국어 간체 숫자" },
            { "type.nu.hant", "중국어 번체 숫자" },
            { "type.nu.hebr", "히브리 숫자" },
            { "type.nu.java", "자바 숫자" },
            { "type.nu.jpan", "일본 숫자" },
            { "type.nu.kali", "카야 리식 숫자" },
            { "type.nu.khmr", "크메르 숫자" },
            { "type.nu.knda", "칸나다 숫자" },
            { "type.nu.lana", "타이 탐 호라 숫자" },
            { "type.nu.laoo", "라오 숫자" },
            { "type.nu.latn", "서양 숫자" },
            { "type.nu.lepc", "렙차 숫자" },
            { "type.nu.limb", "림부 숫자" },
            { "type.nu.mlym", "말라얄람 숫자" },
            { "type.nu.mong", "몽골 숫자" },
            { "type.nu.mtei", "메이테이 마옉 숫자" },
            { "type.nu.mymr", "미얀마 숫자" },
            { "type.nu.olck", "올치키 숫자" },
            { "type.nu.orya", "오리야 숫자" },
            { "type.nu.osma", "오스마냐 숫자" },
            { "type.nu.saur", "사우라슈트라 숫자" },
            { "type.nu.shrd", "샤라다 숫자" },
            { "type.nu.sund", "순다 숫자" },
            { "type.nu.taml", "고대 타밀 숫자" },
            { "type.nu.telu", "텔루구 숫자" },
            { "type.nu.thai", "태국 숫자" },
            { "type.nu.tibt", "티벳 숫자" },
            { "type.nu.vaii", "바이 숫자" },
            { "type.ca.dangi", "단기력" },
            { "type.co.ducet", "기본 유니코드 정렬 순서" },
            { "type.lb.loose", "줄바꿈 - 넓게" },
            { "type.nu.roman", "로마 숫자" },
            { "type.ca.coptic", "콥트력" },
            { "type.ca.hebrew", "히브리력" },
            { "type.ca.indian", "인도력" },
            { "type.co.compat", "호환성을 위해 이전 정렬 순서" },
            { "type.co.pinyin", "병음순" },
            { "type.co.search", "범용 검색" },
            { "type.co.stroke", "자획순" },
            { "type.co.unihan", "부수순" },
            { "type.co.zhuyin", "주음순" },
            { "type.d0.fwidth", "전각" },
            { "type.d0.hwidth", "반각" },
            { "type.lb.normal", "줄바꿈 - 보통" },
            { "type.lb.strict", "줄바꿈 - 좁게" },
            { "type.m0.ungegn", "유엔 지명전문가 그룹(UNGEGN)" },
            { "type.ms.metric", "미터법" },
            { "type.nu.native", "기본 숫자" },
            { "type.ca.chinese", "음력" },
            { "type.ca.islamic", "히즈라력" },
            { "type.ca.iso8601", "ISO-8601 달력" },
            { "type.ca.persian", "페르시안력" },
            { "type.cf.account", "회계 통화 형식" },
            { "type.d0.npinyin", metaValue_key_nu },
            { "type.nu.arabext", "확장형 아라비아-인도식 숫자" },
            { "type.nu.armnlow", "아르메니아 소문자 숫자" },
            { "type.nu.finance", "재무 숫자" },
            { "type.nu.greklow", "그리스어 소문자 숫자" },
            { "type.nu.hanidec", "중국어 십진 숫자" },
            { "type.nu.hansfin", "중국어 간체 재무 숫자" },
            { "type.nu.hantfin", "중국어 번체 재무 숫자" },
            { "type.nu.jpanfin", "일본 재무 숫자" },
            { "type.nu.tamldec", "타밀 숫자" },
            { "type.ca.buddhist", "불교력" },
            { "type.ca.ethiopic", "에티오피아력" },
            { "type.ca.japanese", "일본력" },
            { "type.cf.standard", "표준 통화 형식" },
            { "type.co.phonetic", "소리나는 대로 정렬 순서" },
            { "type.co.searchjl", "한글 자음으로 검색" },
            { "type.co.standard", "표준 정렬 순서" },
            { "type.ms.uksystem", "야드파운드법" },
            { "type.ms.ussystem", "미국 계량법" },
            { "type.nu.fullwide", "전자 숫자" },
            { "type.nu.lanatham", "타이 탐탐 숫자" },
            { "type.nu.mymrshan", "미얀마 샨 숫자" },
            { "type.nu.romanlow", "로마 소문자 숫자" },
            { "type.ca.gregorian", "양력" },
            { "type.co.phonebook", "전화번호부순" },
            { "type.co.dictionary", "사전 정렬순" },
            { "type.co.traditional", "전통 역법" },
            { "type.nu.traditional", "전통적인 숫자" },
            { "type.ca.islamic-civil", "히즈라 상용력" },
            { "type.ca.islamic-umalqura", "히즈라력(움 알 쿠라)" },
            { "type.ca.ethiopic-amete-alem", "에티오피아 아메테 알렘력" },
        };
        return data;
    }
}
