# Copyright 2023-2025 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

# Autogenerated by pycargoebuild 0.10

EAPI=8

CRATES="
	adler32@1.2.0
	ahash@0.8.12
	aho-corasick@1.1.3
	alloc-no-stdlib@2.0.4
	alloc-stdlib@0.2.2
	allocator-api2@0.2.21
	android-tzdata@0.1.1
	android_system_properties@0.1.5
	anstream@0.6.19
	anstyle-parse@0.2.7
	anstyle-query@1.1.3
	anstyle-wincon@3.0.9
	anstyle@1.0.11
	autocfg@1.5.0
	base64@0.22.1
	bindgen@0.71.1
	bitflags@2.9.1
	block-buffer@0.10.4
	brotli-decompressor@5.0.0
	brotli@8.0.1
	bumpalo@3.19.0
	cc@1.2.30
	cexpr@0.6.0
	cfg-if@1.0.1
	chrono@0.4.41
	clang-sys@1.8.1
	clap@4.5.42
	clap_builder@4.5.42
	clap_lex@0.7.5
	colorchoice@1.0.4
	colored@3.0.0
	core-foundation-sys@0.8.7
	core2@0.4.0
	cpufeatures@0.2.17
	crc32fast@1.5.0
	crypto-common@0.1.6
	curl-sys@0.4.82+curl-8.14.1
	curl@0.4.48
	dary_heap@0.3.7
	digest@0.10.7
	displaydoc@0.2.5
	either@1.15.0
	encoding-index-japanese@1.20141219.5
	encoding-index-korean@1.20141219.5
	encoding-index-simpchinese@1.20141219.5
	encoding-index-singlebyte@1.20141219.5
	encoding-index-tradchinese@1.20141219.5
	encoding@0.2.33
	encoding_index_tests@0.1.4
	errno@0.3.13
	form_urlencoded@1.2.1
	generic-array@0.14.7
	getrandom@0.3.3
	glob@0.3.2
	hashbrown@0.14.5
	iana-time-zone-haiku@0.1.2
	iana-time-zone@0.1.63
	icu_collections@2.0.0
	icu_locale_core@2.0.0
	icu_normalizer@2.0.0
	icu_normalizer_data@2.0.0
	icu_properties@2.0.1
	icu_properties_data@2.0.1
	icu_provider@2.0.0
	idna@1.0.3
	idna_adapter@1.2.1
	is_terminal_polyfill@1.70.1
	itertools@0.13.0
	itoa@1.0.15
	js-sys@0.3.77
	libc@0.2.174
	libflate@2.1.0
	libflate_lz77@2.1.0
	libloading@0.8.8
	libredox@0.1.8
	libxml@0.3.6
	libz-sys@1.1.22
	linux-raw-sys@0.9.4
	litemap@0.8.0
	log@0.4.27
	md5@0.7.0
	memchr@2.7.5
	minimal-lexical@0.2.1
	nom@7.1.3
	num-traits@0.2.19
	numtoa@0.2.4
	once_cell@1.21.3
	once_cell_polyfill@1.70.1
	openssl-probe@0.1.6
	openssl-src@300.5.1+3.5.1
	openssl-sys@0.9.109
	percent-encoding@2.3.1
	pkg-config@0.3.32
	potential_utf@0.1.2
	ppv-lite86@0.2.21
	proc-macro2@1.0.95
	quote@1.0.40
	r-efi@5.3.0
	rand@0.9.2
	rand_chacha@0.9.0
	rand_core@0.9.3
	redox_syscall@0.5.17
	redox_termios@0.1.3
	regex-automata@0.4.9
	regex-syntax@0.8.5
	regex@1.11.1
	rle-decode-fast@1.0.3
	rustc-hash@2.1.1
	rustix@1.0.8
	rustversion@1.0.21
	ryu@1.0.20
	schannel@0.1.27
	serde@1.0.219
	serde_derive@1.0.219
	serde_json@1.0.141
	sha2@0.10.9
	shlex@1.3.0
	similar@2.7.0
	smallvec@1.15.1
	socket2@0.5.10
	stable_deref_trait@1.2.0
	strsim@0.11.1
	syn@2.0.104
	synstructure@0.13.2
	terminal_size@0.4.2
	termion@4.0.5
	tinystr@0.8.1
	toml@0.5.11
	typenum@1.18.0
	unicode-ident@1.0.18
	url@2.5.4
	utf8_iter@1.0.4
	utf8parse@0.2.2
	uuid@1.17.0
	vcpkg@0.2.15
	version_check@0.9.5
	wasi@0.14.2+wasi-0.2.4
	wasm-bindgen-backend@0.2.100
	wasm-bindgen-macro-support@0.2.100
	wasm-bindgen-macro@0.2.100
	wasm-bindgen-shared@0.2.100
	wasm-bindgen@0.2.100
	windows-core@0.61.2
	windows-implement@0.60.0
	windows-interface@0.59.1
	windows-link@0.1.3
	windows-result@0.3.4
	windows-strings@0.4.2
	windows-sys@0.52.0
	windows-sys@0.59.0
	windows-sys@0.60.2
	windows-targets@0.52.6
	windows-targets@0.53.3
	windows_aarch64_gnullvm@0.52.6
	windows_aarch64_gnullvm@0.53.0
	windows_aarch64_msvc@0.52.6
	windows_aarch64_msvc@0.53.0
	windows_i686_gnu@0.52.6
	windows_i686_gnu@0.53.0
	windows_i686_gnullvm@0.52.6
	windows_i686_gnullvm@0.53.0
	windows_i686_msvc@0.52.6
	windows_i686_msvc@0.53.0
	windows_x86_64_gnu@0.52.6
	windows_x86_64_gnu@0.53.0
	windows_x86_64_gnullvm@0.52.6
	windows_x86_64_gnullvm@0.53.0
	windows_x86_64_msvc@0.52.6
	windows_x86_64_msvc@0.53.0
	winres@0.1.12
	wit-bindgen-rt@0.39.0
	writeable@0.6.1
	xml-rs@0.8.27
	yoke-derive@0.8.0
	yoke@0.8.0
	zerocopy-derive@0.8.26
	zerocopy@0.8.26
	zerofrom-derive@0.1.6
	zerofrom@0.1.6
	zerotrie@0.2.2
	zerovec-derive@0.11.1
	zerovec@0.11.2
"

RUST_MIN_VER="1.88.0"

inherit shell-completion cargo

DESCRIPTION="Hurl, run and test HTTP requests"
HOMEPAGE="https://hurl.dev"
SRC_URI="
	https://github.com/Orange-OpenSource/${PN}/archive/refs/tags/${PV}.tar.gz -> ${P}.tar.gz
	${CARGO_CRATE_URIS}
"

LICENSE="Apache-2.0"
# Dependent crate licenses
LICENSE+=" Apache-2.0 BSD CC0-1.0 ISC MIT MPL-2.0 Unicode-3.0 ZLIB"
SLOT="0"
KEYWORDS="~amd64"

RDEPEND="
	net-misc/curl
	dev-libs/libxml2:=
"
DEPEND="${RDEPEND}"

# Rust.
QA_FLAGS_IGNORED=(
	/usr/bin/hurl
	/usr/bin/hurlfmt
)

QA_PRESTRIPPED="${QA_FLAGS_IGNORED[*]}"

src_install() {
	dobin "$(cargo_target_dir)"/hurl{,fmt}
	doman docs/manual/hurl{,fmt}.1

	dodoc CHANGELOG.md README.md LICENSE

	newbashcomp completions/hurl.bash hurl
	newbashcomp completions/hurlfmt.bash hurlfmt
	# https://github.com/Orange-OpenSource/hurl/issues/3938
	# newzshcomp completions/_hurl _hurl
	# newzshcomp completions/_hurlfmt _hurlfmt
	newfishcomp completions/hurl.fish hurl.fish
	newfishcomp completions/hurlfmt.fish hurlfmt.fish
}

src_test() {
	# These need a local HTTP server.. and don't bother setting one up..
	cargo_src_test -- \
				   --skip simple_sample \
				   --skip runner::hurl_file::run
}
