# Copyright 2022-2024 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=8

JAVA_PKG_IUSE="doc source test"
MAVEN_ID="org.opentest4j:opentest4j:1.3.0"
JAVA_TESTING_FRAMEWORKS="junit-4"

inherit java-pkg-2 java-pkg-simple

DESCRIPTION="Open Test Alliance for the JVM"
HOMEPAGE="https://github.com/ota4j-team/opentest4j"
SRC_URI="https://github.com/ota4j-team/opentest4j/archive/r${PV}.tar.gz -> ${P}.tar.gz"
S="${WORKDIR}/${PN}-r${PV}"

LICENSE="Apache-2.0"
SLOT="0"
KEYWORDS="amd64 arm64 ppc64"

DEPEND=">=virtual/jdk-11:*"	# module-info
RDEPEND=">=virtual/jre-1.8:*"	#939580

JAVA_SRC_DIR=( src/{main,module}/java )

JAVA_TEST_GENTOO_CLASSPATH="junit-4"
JAVA_TEST_SRC_DIR=( src/test/java )
JAVA_TEST_RESOURCE_DIRS=( src/test/resources )

src_test() {
	# src/test/java/org/opentest4j/FileInfoTests.java:52: error: cannot find symbol
	# 		var out = new ByteArrayOutputStream();
	# 		^
	#   symbol:   class var
	#   location: class FileInfoTests
	# src/test/java/org/opentest4j/FileInfoTests.java:55: error: cannot find symbol
	# 		var deserialized = (AssertionFailedError) new ObjectInputStream(
	# 		^
	#   symbol:   class var
	#   location: class FileInfoTests
	# src/test/java/org/opentest4j/FileInfoTests.java:64: error: cannot find symbol
	# 		var contents = "contents".getBytes(UTF_8);
	# 		^
	#   symbol:   class var
	#   location: class FileInfoTests
	# src/test/java/org/opentest4j/FileInfoTests.java:65: error: cannot find symbol
	# 		var fileInfo = new FileInfo("path", contents);
	# 		^
	#   symbol:   class var
	#   location: class FileInfoTests
	JAVAC_ARGS="--source 11 --target 11" java-pkg-simple_src_test
}
