# Copyright 2023-2025 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

# Autogenerated by pycargoebuild 0.6.2

EAPI=8

CRATES="
	addr2line@0.24.2
	adler2@2.0.1
	aho-corasick@1.1.3
	aligned-vec@0.6.4
	aligned@0.4.2
	anes@0.1.6
	anstream@0.6.19
	anstyle-parse@0.2.7
	anstyle-query@1.1.3
	anstyle-wincon@3.0.9
	anstyle@1.0.11
	anyhow@1.0.98
	aom-sys@0.3.3
	arbitrary@1.4.1
	arg_enum_proc_macro@0.3.4
	arrayvec@0.7.6
	as-slice@0.2.1
	assert_cmd@2.0.17
	autocfg@1.4.0
	av-metrics@0.9.1
	av-scenechange@0.14.1
	av1-grain@0.2.4
	backtrace@0.3.75
	bindgen@0.69.5
	bitflags@1.3.2
	bitflags@2.9.1
	bitstream-io@4.2.0
	bstr@1.12.0
	built@0.8.0
	bumpalo@3.18.1
	bytemuck@1.23.1
	byteorder-lite@0.1.0
	byteorder@1.5.0
	cast@0.3.0
	cc@1.2.26
	cexpr@0.6.0
	cfg-expr@0.15.8
	cfg-if@1.0.1
	ciborium-io@0.2.2
	ciborium-ll@0.2.2
	ciborium@0.2.2
	clang-sys@1.8.1
	clap@4.5.40
	clap_builder@4.5.40
	clap_complete@4.5.54
	clap_derive@4.5.40
	clap_lex@0.7.5
	colorchoice@1.0.4
	console@0.15.11
	core2@0.4.0
	crc32fast@1.4.2
	criterion-plot@0.5.0
	criterion@0.6.0
	crossbeam-channel@0.5.15
	crossbeam-deque@0.8.6
	crossbeam-epoch@0.9.18
	crossbeam-queue@0.3.12
	crossbeam-utils@0.8.21
	crossbeam@0.8.4
	crunchy@0.2.3
	diff@0.1.13
	difflib@0.4.0
	displaydoc@0.2.5
	doc-comment@0.3.3
	either@1.15.0
	encode_unicode@1.0.0
	env_logger@0.8.4
	equator-macro@0.4.2
	equator@0.4.2
	equivalent@1.0.2
	errno@0.3.12
	fdeflate@0.3.7
	fern@0.7.1
	flate2@1.1.2
	form_urlencoded@1.2.1
	getrandom@0.2.16
	getrandom@0.3.3
	gimli@0.31.1
	git2@0.20.2
	glob@0.3.2
	half@2.6.0
	hashbrown@0.15.4
	heck@0.5.0
	home@0.5.11
	icu_collections@2.0.0
	icu_locale_core@2.0.0
	icu_normalizer@2.0.0
	icu_normalizer_data@2.0.0
	icu_properties@2.0.1
	icu_properties_data@2.0.1
	icu_provider@2.0.0
	idna@1.0.3
	idna_adapter@1.2.1
	image@0.25.6
	indexmap@2.9.0
	interpolate_name@0.2.4
	is_terminal_polyfill@1.70.1
	itertools@0.10.5
	itertools@0.12.1
	itertools@0.13.0
	itertools@0.14.0
	itoa@1.0.15
	jobserver@0.1.33
	js-sys@0.3.77
	lab@0.11.0
	lazy_static@1.5.0
	lazycell@1.3.0
	libc@0.2.172
	libdav1d-sys@0.7.1+libdav1d.1.4.3
	libfuzzer-sys@0.4.9
	libgit2-sys@0.18.1+1.9.0
	libloading@0.8.8
	libz-sys@1.1.22
	linux-raw-sys@0.4.15
	linux-raw-sys@0.9.4
	litemap@0.8.0
	log@0.4.27
	maybe-rayon@0.1.1
	memchr@2.7.5
	minimal-lexical@0.2.1
	miniz_oxide@0.8.9
	nasm-rs@0.3.0
	new_debug_unreachable@1.0.6
	nom@7.1.3
	nom@8.0.0
	noop_proc_macro@0.3.0
	nu-ansi-term@0.46.0
	num-bigint@0.4.6
	num-derive@0.4.2
	num-integer@0.1.46
	num-rational@0.4.2
	num-traits@0.2.19
	object@0.36.7
	once_cell@1.21.3
	once_cell_polyfill@1.70.1
	oorandom@11.1.5
	overload@0.1.1
	paste@1.0.15
	pastey@0.1.0
	percent-encoding@2.3.1
	pin-project-lite@0.2.16
	pkg-config@0.3.32
	plotters-backend@0.3.7
	plotters-svg@0.3.7
	plotters@0.3.7
	png@0.17.16
	potential_utf@0.1.2
	ppv-lite86@0.2.21
	predicates-core@1.0.9
	predicates-tree@1.0.12
	predicates@3.1.3
	pretty_assertions@1.4.1
	prettyplease@0.2.33
	proc-macro2@1.0.95
	profiling-procmacros@1.0.16
	profiling@1.0.16
	quickcheck@1.0.3
	quote@1.0.40
	r-efi@5.2.0
	rand@0.8.5
	rand@0.9.1
	rand_chacha@0.9.0
	rand_core@0.6.4
	rand_core@0.9.3
	rayon-core@1.12.1
	rayon@1.10.0
	regex-automata@0.4.9
	regex-syntax@0.8.5
	regex@1.11.1
	rustc-demangle@0.1.25
	rustc-hash@1.1.0
	rustix@0.38.44
	rustix@1.0.7
	rustversion@1.0.21
	ryu@1.0.20
	same-file@1.0.6
	scan_fmt@0.2.6
	semver@1.0.26
	serde-big-array@0.5.1
	serde@1.0.219
	serde_derive@1.0.219
	serde_json@1.0.140
	serde_spanned@0.6.9
	sharded-slab@0.1.7
	shlex@1.3.0
	signal-hook-registry@1.4.5
	signal-hook@0.3.18
	simd-adler32@0.3.7
	simd_helpers@0.1.0
	smallvec@1.15.1
	stable_deref_trait@1.2.0
	syn@2.0.102
	synstructure@0.13.2
	system-deps@6.2.2
	target-lexicon@0.12.16
	terminal_size@0.4.2
	termtree@0.5.1
	thiserror-impl@1.0.69
	thiserror-impl@2.0.12
	thiserror@1.0.69
	thiserror@2.0.12
	thread_local@1.1.8
	tinystr@0.8.1
	tinytemplate@1.2.1
	toml@0.8.23
	toml_datetime@0.6.11
	toml_edit@0.22.27
	toml_write@0.1.2
	tracing-attributes@0.1.29
	tracing-chrome@0.7.2
	tracing-core@0.1.34
	tracing-log@0.2.0
	tracing-subscriber@0.3.19
	tracing@0.1.41
	unicode-ident@1.0.18
	unicode-width@0.2.1
	url@2.5.4
	utf8_iter@1.0.4
	utf8parse@0.2.2
	v_frame@0.3.9
	valuable@0.1.1
	vcpkg@0.2.15
	version-compare@0.2.0
	wait-timeout@0.2.1
	walkdir@2.5.0
	wasi@0.11.1+wasi-snapshot-preview1
	wasi@0.14.2+wasi-0.2.4
	wasm-bindgen-backend@0.2.100
	wasm-bindgen-macro-support@0.2.100
	wasm-bindgen-macro@0.2.100
	wasm-bindgen-shared@0.2.100
	wasm-bindgen@0.2.100
	web-sys@0.3.77
	which@4.4.2
	winapi-i686-pc-windows-gnu@0.4.0
	winapi-util@0.1.9
	winapi-x86_64-pc-windows-gnu@0.4.0
	winapi@0.3.9
	windows-sys@0.59.0
	windows-targets@0.52.6
	windows-targets@0.53.0
	windows_aarch64_gnullvm@0.52.6
	windows_aarch64_gnullvm@0.53.0
	windows_aarch64_msvc@0.52.6
	windows_aarch64_msvc@0.53.0
	windows_i686_gnu@0.52.6
	windows_i686_gnu@0.53.0
	windows_i686_gnullvm@0.52.6
	windows_i686_gnullvm@0.53.0
	windows_i686_msvc@0.52.6
	windows_i686_msvc@0.53.0
	windows_x86_64_gnu@0.52.6
	windows_x86_64_gnu@0.53.0
	windows_x86_64_gnullvm@0.52.6
	windows_x86_64_gnullvm@0.53.0
	windows_x86_64_msvc@0.52.6
	windows_x86_64_msvc@0.53.0
	winnow@0.7.11
	wit-bindgen-rt@0.39.0
	writeable@0.6.1
	y4m@0.8.0
	yansi@1.0.1
	yoke-derive@0.8.0
	yoke@0.8.0
	zerocopy-derive@0.8.25
	zerocopy@0.8.25
	zerofrom-derive@0.1.6
	zerofrom@0.1.6
	zerotrie@0.2.2
	zerovec-derive@0.11.1
	zerovec@0.11.2
"

inherit cargo

DESCRIPTION="The fastest and safest AV1 encoder"
HOMEPAGE="https://github.com/xiph/rav1e/"
if [[ ${PV} == *9999 ]] ; then
	EGIT_REPO_URI="https://github.com/xiph/rav1e.git"
	inherit git-r3
else
	SRC_URI="
		https://github.com/xiph/rav1e/archive/v${PV}.tar.gz -> ${P}.tar.gz
		${CARGO_CRATE_URIS}
	"
	KEYWORDS="~amd64 ~arm ~arm64 ~loong ~ppc64 ~riscv ~x86"
fi

LICENSE="BSD-2"
# Dependent crate licenses
LICENSE+="
	Apache-2.0 Apache-2.0-with-LLVM-exceptions BSD-2 BSD ISC MIT
	UoI-NCSA Unicode-3.0
"
SLOT="0/$(ver_cut 1-2)"
IUSE="+capi"

ASM_DEP=">=dev-lang/nasm-2.15"
BDEPEND="
	amd64? ( ${ASM_DEP} )
	capi? ( >=dev-util/cargo-c-0.6.3 )
"
# only used as a build script to check the version of rav1e...
DEPEND="dev-libs/libgit2"

# Rust
QA_FLAGS_IGNORED="usr/lib.*/librav1e.* usr/bin/rav1e"

src_unpack() {
	if [[ ${PV} == *9999* ]]; then
		git-r3_src_unpack
		cargo_live_src_unpack
	else
		default
		cargo_src_unpack
	fi
}

src_compile() {
	# used by build script to get rav1e repository info
	export LIBGIT2_NO_VENDOR=1

	cargo_src_compile

	if use capi; then
		local args=$(usev !debug --release)
		cargo cbuild ${args} --target-dir="capi" \
			--prefix="${EPREFIX}/usr" --libdir="${EPREFIX}/usr/$(get_libdir)" \
			--library-type=cdylib \
			|| die "cargo cbuild failed"
	fi
}

src_install() {
	export CARGO_HOME="${ECARGO_HOME}"
	local args=$(usev debug --debug)

	if use capi; then
		cargo cinstall ${args} --target-dir="capi" \
			--prefix="${EPREFIX}/usr" --libdir="${EPREFIX}/usr/$(get_libdir)" --destdir="${D}" \
			--library-type=cdylib \
			|| die "cargo cinstall failed"
	fi

	cargo_src_install
}
