# Copyright 1999-2025 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

# NOTICE: Before packaging we have to run "ResGen" and "GetDependencies".
# See: https://git.alpinelinux.org/aports/tree/community/powershell/APKBUILD
# The repackaged tarball contains some C# code generated by that subproject.

EAPI=8

DOTNET_PKG_COMPAT="10.0"
NUGET_APIS=(
	"https://api.nuget.org/v3-flatcontainer"
	"https://www.powershellgallery.com/api/v2"
)
NUGETS="
dotnetanalyzers.documentationanalyzers.unstable@1.0.0.59
dotnetanalyzers.documentationanalyzers@1.0.0-beta.59
humanizer.core@2.14.1
json.more.net@2.0.1.2
json.more.net@2.0.2
jsonpointer.net@5.0.0
jsonpointer.net@5.0.2
jsonschema.net@7.2.3
markdig.signed@0.31.0
markdig.signed@0.38.0
microsoft.applicationinsights@2.22.0
microsoft.bcl.asyncinterfaces@5.0.0
microsoft.bcl.asyncinterfaces@8.0.0
microsoft.codeanalysis.analyzers@3.11.0
microsoft.codeanalysis.analyzers@3.3.4
microsoft.codeanalysis.common@4.11.0
microsoft.codeanalysis.csharp@4.11.0
microsoft.codecoverage@17.11.1
microsoft.extensions.objectpool@5.0.10
microsoft.extensions.objectpool@8.0.21
microsoft.management.infrastructure.runtime.unix@3.0.0
microsoft.management.infrastructure.runtime.win@3.0.0
microsoft.management.infrastructure@3.0.0
microsoft.net.test.sdk@17.11.1
microsoft.netcore.platforms@1.1.0
microsoft.netcore.platforms@7.0.4
microsoft.powershell.markdownrender@7.2.1
microsoft.powershell.native@7.4.0
microsoft.security.extensions@1.4.0
microsoft.testplatform.objectmodel@17.11.1
microsoft.testplatform.testhost@17.11.1
microsoft.win32.registry.accesscontrol@9.0.10
microsoft.win32.systemevents@9.0.10
microsoft.windows.compatibility@9.0.10
netstandard.library@2.0.3
newtonsoft.json@13.0.1
newtonsoft.json@13.0.4
packagemanagement@1.4.4
packagemanagement@1.4.8.1
powershellget@2.2.5
psreadline@2.3.6
runtime.android-arm.runtime.native.system.io.ports@9.0.10
runtime.android-arm64.runtime.native.system.io.ports@9.0.10
runtime.android-x64.runtime.native.system.io.ports@9.0.10
runtime.android-x86.runtime.native.system.io.ports@9.0.10
runtime.linux-arm.runtime.native.system.io.ports@9.0.10
runtime.linux-arm64.runtime.native.system.io.ports@9.0.10
runtime.linux-bionic-arm64.runtime.native.system.io.ports@9.0.10
runtime.linux-bionic-x64.runtime.native.system.io.ports@9.0.10
runtime.linux-musl-arm.runtime.native.system.io.ports@9.0.10
runtime.linux-musl-arm64.runtime.native.system.io.ports@9.0.10
runtime.linux-musl-x64.runtime.native.system.io.ports@9.0.10
runtime.linux-x64.runtime.native.system.io.ports@9.0.10
runtime.maccatalyst-arm64.runtime.native.system.io.ports@9.0.10
runtime.maccatalyst-x64.runtime.native.system.io.ports@9.0.10
runtime.native.system.data.sqlclient.sni@4.4.0
runtime.native.system.io.ports@9.0.10
runtime.osx-arm64.runtime.native.system.io.ports@9.0.10
runtime.osx-x64.runtime.native.system.io.ports@9.0.10
runtime.win-arm64.runtime.native.system.data.sqlclient.sni@4.4.0
runtime.win-x64.runtime.native.system.data.sqlclient.sni@4.4.0
runtime.win-x86.runtime.native.system.data.sqlclient.sni@4.4.0
stylecop.analyzers.unstable@1.2.0.556
stylecop.analyzers@1.2.0-beta.556
system.buffers@4.5.1
system.codedom@9.0.10
system.collections.immutable@8.0.0
system.componentmodel.composition.registration@9.0.10
system.componentmodel.composition@9.0.10
system.configuration.configurationmanager@9.0.10
system.data.odbc@9.0.10
system.data.oledb@9.0.10
system.data.sqlclient@4.9.0
system.diagnostics.diagnosticsource@5.0.0
system.diagnostics.diagnosticsource@9.0.10
system.diagnostics.eventlog@9.0.10
system.diagnostics.performancecounter@9.0.10
system.directoryservices.accountmanagement@9.0.10
system.directoryservices.protocols@9.0.10
system.directoryservices@9.0.10
system.drawing.common@9.0.10
system.io.packaging@9.0.10
system.io.ports@9.0.10
system.management@9.0.10
system.memory@4.5.5
system.net.http.winhttphandler@9.0.10
system.numerics.vectors@4.4.0
system.numerics.vectors@4.5.0
system.private.servicemodel@4.10.3
system.reflection.context@9.0.10
system.reflection.dispatchproxy@4.7.1
system.reflection.metadata@1.6.0
system.reflection.metadata@8.0.0
system.reflection.metadata@8.0.1
system.runtime.caching@9.0.10
system.runtime.compilerservices.unsafe@4.5.3
system.runtime.compilerservices.unsafe@6.0.0
system.security.accesscontrol@6.0.1
system.security.cryptography.pkcs@9.0.10
system.security.cryptography.protecteddata@9.0.10
system.security.cryptography.xml@6.0.1
system.security.cryptography.xml@9.0.10
system.security.permissions@9.0.10
system.security.principal.windows@5.0.0
system.servicemodel.duplex@4.10.3
system.servicemodel.http@4.10.3
system.servicemodel.nettcp@4.10.3
system.servicemodel.primitives@4.10.3
system.servicemodel.security@4.10.3
system.servicemodel.syndication@9.0.10
system.serviceprocess.servicecontroller@9.0.10
system.speech@9.0.10
system.text.encoding.codepages@7.0.0
system.text.encoding.codepages@8.0.0
system.text.encoding.codepages@9.0.10
system.text.encodings.web@9.0.10
system.threading.accesscontrol@9.0.10
system.threading.tasks.extensions@4.5.4
system.web.services.description@4.10.3
system.web.services.description@8.0.0
system.windows.extensions@9.0.10
validation@2.4.18
validation@2.5.51
xunit.abstractions@2.0.3
xunit.analyzers@1.18.0
xunit.assert@2.9.3
xunit.core@2.9.3
xunit.extensibility.core@2.9.3
xunit.extensibility.execution@2.4.0
xunit.extensibility.execution@2.9.3
xunit.runner.visualstudio@2.8.2
xunit.skippablefact@1.4.13
xunit@2.9.3
xunitxml.testlogger@4.1.0
"

# Additional PowerShell Gallery modules.
NUGETS+="
microsoft.powershell.archive@1.2.5
microsoft.powershell.psresourceget@1.1.1
packagemanagement@1.4.4
packagemanagement@1.4.8.1
powershellget@2.2.5
psreadline@2.3.6
threadjob@2.0.3
"

inherit check-reqs desktop dotnet-pkg xdg-utils

DESCRIPTION="Cross-platform automation and configuration tool"
HOMEPAGE="https://microsoft.com/powershell/
	https://github.com/PowerShell/PowerShell/"
SRC_URI="
	https://dev.gentoo.org/~xgqt/distfiles/repackaged/${P}.repackaged.tar.xz
	${NUGET_URIS}
"

LICENSE="MIT"
SLOT="$(ver_cut 1-2)"
KEYWORDS="~amd64 ~arm ~arm64"
IUSE="gui vanilla"
RESTRICT="test"

RDEPEND="
	>=dev-libs/libpsl-native-7.4.0:=
	sys-libs/pam:0/0
	|| (
		dev-libs/openssl-compat:1.0.0
		=dev-libs/openssl-1.0*:0/0
	)
	gui? (
		dev-util/desktop-file-utils
		x11-misc/shared-mime-info
	)
"
DEPEND="
	${RDEPEND}
"
IDEPEND="
	app-eselect/eselect-pwsh
"

CHECKREQS_DISK_BUILD="2G"
DOTNET_PKG_PROJECTS=(
	src/powershell-unix/powershell-unix.csproj
	src/Modules/PSGalleryModules.csproj
)
DOTNET_PKG_BAD_PROJECTS=(
	test/xUnit/xUnit.tests.csproj  # Fails to restore.
)
PATCHES=(
	"${FILESDIR}/pwsh-7.3.3-disable-update-check.patch"
)
DOCS=( CHANGELOG CHANGELOG.md CODE_OF_CONDUCT.md README.md docs )

check_requirements_locale() {
	if [[ "${MERGE_TYPE}" != binary ]] ; then
		if use elibc_glibc ; then
			local locales="$(locale -a)"

			if has en_US.utf8 ${locales} ; then
				LC_ALL=en_US.utf8
			elif has en_US.UTF-8 ${locales} ; then
				LC_ALL=en_US.UTF-8
			else
				eerror "The locale en_US.utf8 or en_US.UTF-8 is not available."
				eerror "Please generate en_US.UTF-8 before building ${CATEGORY}/${P}."

				die "Could not switch to the en_US.UTF-8 locale."
			fi
		else
			LC_ALL=en_US.UTF-8
		fi

		export LC_ALL
		einfo "Successfully switched to the ${LC_ALL} locale."
	fi
}

gui_cache_update() {
	if use gui ; then
		xdg_icon_cache_update
		xdg_desktop_database_update
	fi
}

pkg_pretend() {
	check-reqs_pkg_pretend

	check_requirements_locale
}

pkg_setup() {
	check-reqs_pkg_setup
	dotnet-pkg_pkg_setup

	check_requirements_locale
}

src_prepare() {
	if ! use vanilla ; then
		PATCHES+=(
			"${FILESDIR}/pwsh-7.5.0-disable-telemetry.patch"
		)
	fi

	# This is guarded by "RegexGitVersion" in "PowerShell.Common.props".
	local fake_describe="v${PV}-0-g0"
	sed -e "s|git describe --abbrev=60 --long|echo ${fake_describe}|g" \
		-i ./PowerShell.Common.props || die

	echo "v${PV}" > ./powershell.version || die

	dotnet-pkg_src_prepare
}

src_compile() {
	einfo 'Copying DLL files for the missing "ref" directory'
	efsi "${FILESDIR}/pwsh-7.3.3-copy-ref.fsx" "${WORKDIR}/${P}_ref"

	dotnet-pkg_src_compile
}

src_install() {
	local dest_root="/usr/share/${PN}-${SLOT}"

	# Install additional PowerShell Gallery modules.
	local -a psg_modules=(
		Microsoft.PowerShell.Archive
		Microsoft.PowerShell.PSResourceGet
		PSReadLine
		PackageManagement
		PowerShellGet
		ThreadJob
	)
	local psg_module=""
	for psg_module in "${psg_modules[@]}" ; do
		insinto "${dest_root}/Modules/${psg_module}"
		doins -r "${NUGET_PACKAGES}/${psg_module,,}"/*
	done

	dotnet-pkg-base_append_launchervar \
		'PSModulePath="${PSModulePath}:${EPREFIX}/usr/share/GentooPowerShell/Modules:"'
	dotnet-pkg-base_install "${dest_root}"
	dotnet-pkg-base_dolauncher "${dest_root}/pwsh" "pwsh-${SLOT}"

	insinto "${dest_root}/ref"
	doins "${WORKDIR}/${P}_ref"/*

	# Replace "libpsl-native.so" provided by "microsoft.powershell.native".
	rm "${ED}/${dest_root}/libpsl-native.so" || die
	dosym -r "/usr/$(get_libdir)/libpsl-native.so" "${dest_root}/libpsl-native.so"

	# On musl remove "libSystem.IO.Ports.Native.so" linked against glibc.
	if ! use elibc_glibc ; then
		ewarn "libSystem.IO.Ports.Native.so is available only for glibc, removing it"

		rm -f "${ED}/${dest_root}/libSystem.IO.Ports.Native.so" || die
	fi

	if use gui ; then
		newicon ./assets/ps_black_128.svg "powershell-${SLOT}.svg"
		make_desktop_entry "pwsh-${SLOT} -l" "PowerShell ${SLOT}" \
			"powershell-${SLOT}" "ConsoleOnly;System;" "Terminal=true"
	fi

	einstalldocs
}

pkg_postinst() {
	gui_cache_update

	eselect pwsh update ifunset
}

pkg_postrm() {
	gui_cache_update

	eselect pwsh update ifunset
}
