# Copyright 2020-2025 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=8

inherit cmake

DESCRIPTION="c library for the apache avro data serialization system"
HOMEPAGE="https://avro.apache.org/"
SRC_URI="mirror://apache/avro/avro-${PV}/c/avro-c-${PV}.tar.gz"

LICENSE="Apache-2.0"
SLOT="0"
KEYWORDS="amd64"

DEPEND="
	app-arch/snappy:=
	>=dev-libs/jansson-2.3:=
	virtual/zlib:="
RDEPEND="${DEPEND}"

src_test() {
	local CMAKE_SKIP_TESTS=(
		test_avro_commons_schema # commons is only in full distro, not in avro-c
	)

	cmake_src_test
}
