#  transyn.awk Copyright (c) 1993-2021, David A. Clunie DBA PixelMed Publishing. All rights reserved.
# create C++ defines from SOP class template 

NR==1	{
	print "// Automatically generated from template - EDITS WILL BE LOST"
	print ""
	print "// Generated by transyn.awk with options " role " " outname
	print ""

	if (role == "define" || role == "extern" || role == "constant") {
		print "#ifndef __Header_" outname "__"
		print "#define __Header_" outname "__"
		print ""
	}
	else if (role == "table") {
		print "#ifndef __Header_" outname "__"
		print "#define __Header_" outname "__"
		print ""
		print "static TransferSyntaxDictionaryEntry"
		print "\t\tTransferSyntaxDictionaryTable[] = {"
	}
	else {
		print "Error - role " role " invalid" >"/dev/tty"
		exit 1
	}

	}

/^[ 	]*[#]/	{}

/^[ 	]*Name/ {

	name=""
	if (match($0,"Name=\"[^\"]*\""))
		name=substr($0,RSTART+length("Name=\""),
			RLENGTH-length("Name=\"")-1);

	desc=name
	if (match($0,"Desc=\"[^\"]*\""))
		desc=substr($0,RSTART+length("Desc=\""),
			RLENGTH-length("Desc=\"")-1);

	uid=""
	if (match($0,"Uid=\"[^\"]*\""))
		uid=substr($0,RSTART+length("Uid=\""),
			RLENGTH-length("Uid=\"")-1);

	endian=""
	if (match($0,"Endian=\"[^\"]*\""))
		endian=substr($0,RSTART+length("Endian=\""),
			RLENGTH-length("Endian=\"")-1);

	pixel=""
	if (match($0,"Pixel=\"[^\"]*\""))
		pixel=substr($0,RSTART+length("Pixel=\""),
			RLENGTH-length("Pixel=\"")-1);

	vr=""
	if (match($0,"VR=\"[^\"]*\""))
		vr=substr($0,RSTART+length("VR=\""),
			RLENGTH-length("VR=\"")-1);

	encap=""
	if (match($0,"Encap=\"[^\"]*\""))
		encap=substr($0,RSTART+length("Encap=\""),
			RLENGTH-length("Encap=\"")-1);

	if (role == "define") {
		print "#define\t" name "TransferSyntaxUID\t\"" uid "\""
	}
	else if (role== "extern") {
		print "extern const char *" name "TransferSyntaxUID;"
	}
	else if (role == "constant") {
		print "const char *" name "TransferSyntaxUID = \"" uid "\";"
	}
	else if (role == "table") {
		if (endian == "big") pendian="BigEndian"
		else if (endian == "little") pendian="LittleEndian"
		else {
			print "Error - line " NR " - invalid Endian" >"/dev/tty"
			pendian="**BAD**"
		}

		if (vr == "implicit") pvr="ImplicitVR"
		else if (vr == "explicit") pvr="ExplicitVR"
		else {
			print "Error - line " NR " - invalid VR" >"/dev/tty"
			pvr="**BAD**"
		}

		if (encap == "yes") pencap="true"
		else if (encap == "no") pencap="false"
		else {
			print "Error - line " NR " - invalid Encap" >"/dev/tty"
			pencap="**BAD**"
		}

		if (pixel == "big") ppixel="BigEndian"
		else if (pixel == "little") ppixel="LittleEndian"
		else if (pixel == "") ppixel=pendian
		else {
			print "Error - line " NR " - invalid Pixel" >"/dev/tty"
			ppixel="**BAD**"
		}

		print "\t\"" uid "\",\"" desc "\"," pendian "," pvr "," pencap "," ppixel ","
	}

	}

END {
	if (role == "define" || role== "extern" || role == "constant") {
		print ""
		print "#endif /* __Header_" outname "__ */"
	}
	if (role == "table") {
		print "\t0,0,NoEndian,NoVR,false,NoEndian"
		print "};"
		print ""
		print "#endif /* __Header_" outname "__ */"
	}
}

