/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 *
 * Copyright 2005 Todd Kulesza
 *
 * Authors:
 * 		Todd Kulesza <todd@dropline.net>
 */

#ifndef _BLOG_ATOM_H_
#define _BLOG_ATOM_H_

#include "drivel_request.h"
#include "drivel.h"

void
blog_atom_build_login_request (const gchar *username, const gchar *password, 
		const gchar *uri);

void
blog_atom_parse_login_request (DrivelClient *dc, DrivelRequest *dr);

void
blog_atom_build_post_request (const gchar *username, const gchar *password,
		const gchar *uri, const gchar *subject, const gchar *content,
		const gchar *itemid);

void
blog_atom_parse_post_request (DrivelClient *dc, DrivelRequest *dr);

void
blog_atom_build_delete_request (const gchar *username, const gchar *password,
		const gchar *uri);

void
blog_atom_build_getevents_request (const gchar *username, const gchar *password,
		const gchar *uri, gboolean last_entry);

void
blog_atom_parse_getevents_request (DrivelClient *dc, DrivelRequest *dr);

#endif /* _BLOG_ATOM_H_ */
