/////////////////////////////////////////////////////////////////////////////
// Name:        ChaptersDlg.h
// Purpose:     The chapters dialog
// Author:      Alex Thuering
// Created:     19.04.2010
// RCS-ID:      $Id: ChaptersDlg.h,v 1.3 2013/04/28 08:04:42 ntalex Exp $
// Copyright:   (c) Alex Thuering
// Licence:     GPL
/////////////////////////////////////////////////////////////////////////////
#ifndef CHAPTERS_DLG_H
#define CHAPTERS_DLG_H

#include "Pgc.h"
#include "Utils.h"
#include <wxSVG/mediadec_ffmpeg.h>

//(*Headers(ChaptersDlg)
#include "wxVillaLib/Thumbnails.h"
#include <wx/sizer.h>
#include <wx/stattext.h>
#include <wx/checkbox.h>
#include <wx/bmpbuttn.h>
#include <wx/dialog.h>
//*)

class ChaptersDlg: public wxDialog {
public:
	/** Constructor */
	ChaptersDlg(wxWindow* parent, DVD* dvd, int tsi, int pgci, int vobi, Vob* vob);
	/** Destructor */
	virtual ~ChaptersDlg();

	//(*Declarations(ChaptersDlg)
	wxThumbnails* m_thumbnails;
	wxBitmapButton* m_delBt;
	wxCheckBox* m_addCellAtBegin;
	wxBitmapButton* m_addBt;
	wxBitmapButton* m_propBt;
	//*)

private:
	//(*Identifiers(ChaptersDlg)
	static const long ID_THUMBNAILS;
	static const long ID_ADD_BT;
	static const long ID_DEL_BT;
	static const long ID_PROP_BT;
	static const long ID_ADD_CELL_CHECK;
	//*)
	
	DVD* m_dvd;
	int m_tsi;
	int m_pgci;
	int m_vobi;
	Vob* m_vob;
	vector<Cell*> m_cells;
	wxFfmpegMediaDecoder m_decoder;
	wxImage LoadFrame(long pos);
	void AddThumbnail(Cell* cell, int pos = -1);

	//(*Handlers(ChaptersDlg)
	void OnAddBt(wxCommandEvent& event);
	void OnDelBt(wxCommandEvent& event);
	void OnPropBt(wxCommandEvent& event);
	//*)
	void OnThumbDoubleClick(wxCommandEvent& event);
	void OnSelectionChanged(wxCommandEvent& event);
	void OnKeyDown(wxKeyEvent& event) ;
	void OnOkBt(wxCommandEvent& event);

	DECLARE_EVENT_TABLE()
};

#endif // CHAPTERS_DLG_H
