/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import java.nio.file.Path;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.textmate.bundles.TextMateBundleReader;
import org.jetbrains.plugins.textmate.bundles.TextMateFileNameMatcher;
import org.jetbrains.plugins.textmate.language.TextMateLanguageDescriptor;
import org.jetbrains.plugins.textmate.language.preferences.PreferencesRegistry;
import org.jetbrains.plugins.textmate.language.preferences.ShellVariablesRegistry;
import org.jetbrains.plugins.textmate.language.preferences.SnippetsRegistry;
import org.jetbrains.plugins.textmate.language.syntax.highlighting.TextMateTextAttributesAdapter;

public abstract class TextMateService {
    protected static final Logger LOG = Logger.getInstance(TextMateService.class);

    public static TextMateService getInstance() {
        return (TextMateService)ApplicationManager.getApplication().getService(TextMateService.class);
    }

    @Nullable
    public TextMateBundleReader readBundle(@Nullable Path directory) {
        return null;
    }

    public abstract void reloadEnabledBundles();

    @Nullable
    public abstract TextMateLanguageDescriptor getLanguageDescriptorByExtension(@Nullable CharSequence var1);

    @NotNull
    public abstract ShellVariablesRegistry getShellVariableRegistry();

    @NotNull
    public abstract SnippetsRegistry getSnippetRegistry();

    @NotNull
    public abstract PreferencesRegistry getPreferenceRegistry();

    @Nullable
    public abstract TextMateLanguageDescriptor getLanguageDescriptorByFileName(@NotNull CharSequence var1);

    @NotNull
    public abstract Map<TextMateFileNameMatcher, CharSequence> getFileNameMatcherToScopeNameMapping();

    @NotNull
    public abstract Map<CharSequence, TextMateTextAttributesAdapter> getCustomHighlightingColors();
}

