/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals.graph;

import java.time.Duration;
import java.util.Arrays;
import org.apache.kafka.streams.kstream.internals.graph.GraphNode;
import org.apache.kafka.streams.kstream.internals.graph.ProcessorParameters;
import org.apache.kafka.streams.processor.internals.InternalTopologyBuilder;

public class StreamTableJoinNode<K, V, VOut>
extends GraphNode {
    private final String[] storeNames;
    private final ProcessorParameters<K, V, K, VOut> processorParameters;
    private final String otherJoinSideNodeName;
    private final Duration gracePeriod;

    public StreamTableJoinNode(String nodeName, ProcessorParameters<K, V, K, VOut> processorParameters, String[] storeNames, String otherJoinSideNodeName, Duration gracePeriod) {
        super(nodeName);
        this.storeNames = storeNames;
        this.processorParameters = processorParameters;
        this.otherJoinSideNodeName = otherJoinSideNodeName;
        this.gracePeriod = gracePeriod;
    }

    @Override
    public String toString() {
        return "StreamTableJoinNode{storeNames=" + Arrays.toString(this.storeNames) + ", processorParameters=" + String.valueOf(this.processorParameters) + ", otherJoinSideNodeName='" + this.otherJoinSideNodeName + "'} " + super.toString();
    }

    @Override
    public void writeToTopology(InternalTopologyBuilder topologyBuilder) {
        String processorName = this.processorParameters.processorName();
        this.processorParameters.addProcessorTo(topologyBuilder, this.parentNodeNames());
        if (this.otherJoinSideNodeName != null) {
            topologyBuilder.connectProcessorAndStateStores(processorName, this.storeNames);
            if (this.gracePeriod != null) {
                for (String storeName : this.storeNames) {
                    if (!topologyBuilder.isStoreVersioned(storeName)) {
                        throw new IllegalArgumentException("KTable must be versioned to use a grace period in a stream table join.");
                    }
                    if (this.gracePeriod.toMillis() <= topologyBuilder.historyRetention(storeName)) continue;
                    throw new IllegalArgumentException("History retention must be at least grace period.");
                }
            }
        }
    }
}

