/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.spi;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.AssertionFailure;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.type.Type;

public final class CollectionKey
implements Serializable {
    private final String role;
    private final Object key;
    private final @Nullable Type keyType;
    private final SessionFactoryImplementor factory;
    private final int hashCode;

    public CollectionKey(CollectionPersister persister, Object key) {
        this(persister.getRole(), key, persister.getKeyType().getTypeForEqualsHashCode(), persister.getFactory());
    }

    private CollectionKey(String role, @Nullable Object key, @Nullable Type keyType, SessionFactoryImplementor factory) {
        this.role = role;
        if (key == null) {
            throw new AssertionFailure("null identifier for collection of role (" + role + ")");
        }
        this.key = key;
        this.keyType = keyType;
        this.factory = factory;
        this.hashCode = this.generateHashCode();
    }

    private int generateHashCode() {
        int result = 17;
        result = 37 * result + this.role.hashCode();
        result = 37 * result + (this.keyType == null ? this.key.hashCode() : this.keyType.getHashCode(this.key, this.factory));
        return result;
    }

    public String getRole() {
        return this.role;
    }

    public Object getKey() {
        return this.key;
    }

    public String toString() {
        CollectionPersister collectionDescriptor = this.factory.getMappingMetamodel().getCollectionDescriptor(this.role);
        return "CollectionKey" + MessageHelper.collectionInfoString(collectionDescriptor, this.key, this.factory);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || CollectionKey.class != other.getClass()) {
            return false;
        }
        CollectionKey that = (CollectionKey)other;
        return that.role.equals(this.role) && (this.key == that.key || this.keyType == null ? this.key.equals(that.key) : this.keyType.isEqual(this.key, that.key, this.factory));
    }

    public int hashCode() {
        return this.hashCode;
    }

    public void serialize(ObjectOutputStream oos) throws IOException {
        oos.writeObject(this.role);
        oos.writeObject(this.key);
        oos.writeObject(this.keyType);
    }

    public static CollectionKey deserialize(ObjectInputStream ois, SessionImplementor session) throws IOException, ClassNotFoundException {
        return new CollectionKey((String)ois.readObject(), ois.readObject(), (Type)ois.readObject(), (SessionFactoryImplementor)session.getFactory());
    }
}

