/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpa.event.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.hibernate.boot.spi.SessionFactoryOptions;
import org.hibernate.jpa.event.internal.CallbackRegistryImpl;
import org.hibernate.jpa.event.internal.EmptyCallbackRegistryImpl;
import org.hibernate.jpa.event.spi.Callback;
import org.hibernate.jpa.event.spi.CallbackDefinition;
import org.hibernate.jpa.event.spi.CallbackRegistry;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.resource.beans.spi.ManagedBeanRegistry;
import org.hibernate.service.ServiceRegistry;
import org.jboss.logging.Logger;

public final class CallbacksFactory {
    private static final Logger log = Logger.getLogger(CallbacksFactory.class);

    public static CallbackRegistry buildCallbackRegistry(SessionFactoryOptions options, ServiceRegistry serviceRegistry, Collection<PersistentClass> entityBindings) {
        if (!options.areJPACallbacksEnabled()) {
            return new EmptyCallbackRegistryImpl();
        }
        ManagedBeanRegistry beanRegistry = serviceRegistry.getService(ManagedBeanRegistry.class);
        CallbackRegistryImpl.Builder registryBuilder = new CallbackRegistryImpl.Builder();
        HashSet entityClasses = new HashSet();
        for (PersistentClass persistentClass : entityBindings) {
            if (persistentClass.getClassName() == null) continue;
            Class<?> entityClass = persistentClass.getMappedClass();
            if (!entityClasses.add(entityClass)) {
                if (!log.isDebugEnabled()) continue;
                log.debugf("Class [%s] already has callbacks registered; assuming this means the class was mapped twice (using hbm.xml entity-name support) - skipping subsequent registrationsto avoid duplicates", (Object)entityClass.getName());
                continue;
            }
            CallbacksFactory.registerAllCallbacks(persistentClass, registryBuilder, entityClass, beanRegistry);
        }
        return registryBuilder.build();
    }

    private static void registerAllCallbacks(PersistentClass persistentClass, CallbackRegistryImpl.Builder registryBuilder, Class<?> entityClass, ManagedBeanRegistry beanRegistry) {
        registryBuilder.registerCallbacks(entityClass, CallbacksFactory.buildCallbacks(persistentClass.getCallbackDefinitions(), beanRegistry));
        for (Property property : persistentClass.getDeclaredProperties()) {
            registryBuilder.registerCallbacks(entityClass, CallbacksFactory.buildCallbacks(property.getCallbackDefinitions(), beanRegistry));
        }
    }

    private static Callback[] buildCallbacks(List<CallbackDefinition> callbackDefinitions, ManagedBeanRegistry beanRegistry) {
        if (callbackDefinitions == null || callbackDefinitions.isEmpty()) {
            return null;
        }
        ArrayList<Callback> callbacks = new ArrayList<Callback>();
        for (CallbackDefinition definition : callbackDefinitions) {
            callbacks.add(definition.createCallback(beanRegistry));
        }
        return callbacks.toArray(new Callback[0]);
    }
}

