/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.da.comp.writer2latex;

import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.XPropertySet;
import com.sun.star.frame.XFrame;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import java.io.File;
import java.io.IOException;
import org.openoffice.da.comp.w2lcommon.filter.UNOPublisher;
import org.openoffice.da.comp.w2lcommon.helper.MessageBox;
import org.openoffice.da.comp.w2lcommon.helper.PropertyHelper;
import org.openoffice.da.comp.w2lcommon.helper.RegistryHelper;
import org.openoffice.da.comp.w2lcommon.helper.XPropertySetHelper;
import org.openoffice.da.comp.writer2latex.Messages;
import org.openoffice.da.comp.writer2latex.TeXify;
import writer2latex.latex.i18n.ClassicI18n;
import writer2latex.util.CSVList;
import writer2latex.util.Misc;

public class LaTeXUNOPublisher
extends UNOPublisher {
    private TeXify texify = null;
    private String sBibinputs = null;
    private String sBackend = "generic";

    public LaTeXUNOPublisher(XComponentContext xContext, XFrame xFrame, String sAppName) {
        super(xContext, xFrame, sAppName);
    }

    public File getBibTeXDirectory() {
        Object view;
        RegistryHelper registry = new RegistryHelper(this.xContext);
        try {
            view = registry.getRegistryView("/org.openoffice.da.Writer2LaTeX.toolbar.ToolbarOptions/BibliographyOptions", false);
        }
        catch (Exception e) {
            return null;
        }
        XPropertySet xProps = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)view);
        return this.getDirectory(XPropertySetHelper.getPropertyValueAsShort(xProps, "BibTeXLocation"), XPropertySetHelper.getPropertyValueAsString(xProps, "BibTeXDir"));
    }

    @Override
    protected String filterFileName(String sFileName) {
        return Misc.makeTeXFriendly(sFileName, "writer2latex");
    }

    @Override
    protected PropertyValue[] postProcessMediaProps(PropertyValue[] mediaProps) {
        this.sBackend = "generic";
        this.sBibinputs = null;
        PropertyHelper mediaHelper = new PropertyHelper(mediaProps);
        Object filterData = mediaHelper.get("FilterData");
        if (filterData instanceof PropertyValue[]) {
            PropertyHelper filterHelper = new PropertyHelper((PropertyValue[])filterData);
            Object backend = filterHelper.get("backend");
            if (backend instanceof String) {
                this.sBackend = (String)backend;
            }
            RegistryHelper registry = new RegistryHelper(this.xContext);
            try {
                Object view = registry.getRegistryView("/org.openoffice.da.Writer2LaTeX.toolbar.ToolbarOptions/BibliographyOptions", false);
                XPropertySet xProps = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)view);
                String sBibTeXFiles = this.getFileList(XPropertySetHelper.getPropertyValueAsShort(xProps, "BibTeXLocation"), XPropertySetHelper.getPropertyValueAsString(xProps, "BibTeXDir"));
                if (XPropertySetHelper.getPropertyValueAsBoolean(xProps, "UseExternalBibTeXFiles")) {
                    filterHelper.put("external_bibtex_files", sBibTeXFiles);
                    filterHelper.put("bibtex_encoding", ClassicI18n.writeInputenc(XPropertySetHelper.getPropertyValueAsShort(xProps, "BibTeXEncoding")));
                    if (XPropertySetHelper.getPropertyValueAsBoolean(xProps, "ConvertZoteroCitations")) {
                        filterHelper.put("zotero_bibtex_files", sBibTeXFiles);
                    }
                    if (XPropertySetHelper.getPropertyValueAsBoolean(xProps, "ConvertJabRefCitations")) {
                        filterHelper.put("jabref_bibtex_files", sBibTeXFiles);
                    }
                }
                filterHelper.put("include_original_citations", Boolean.toString(XPropertySetHelper.getPropertyValueAsBoolean(xProps, "IncludeOriginalCitations")));
                String sBibTeXDir = XPropertySetHelper.getPropertyValueAsString(xProps, "BibTeXDir");
                if (sBibTeXDir.length() > 0) {
                    this.sBibinputs = sBibTeXDir + File.pathSeparatorChar;
                }
                filterHelper.put("use_natbib", Boolean.toString(XPropertySetHelper.getPropertyValueAsBoolean(xProps, "UseNatbib")));
                filterHelper.put("natbib_options", XPropertySetHelper.getPropertyValueAsString(xProps, "NatbibOptions"));
                mediaHelper.put("FilterData", filterHelper.toArray());
                PropertyValue[] newMediaProps = mediaHelper.toArray();
                registry.disposeRegistryView(view);
                return newMediaProps;
            }
            catch (Exception e) {
                return mediaProps;
            }
        }
        return mediaProps;
    }

    @Override
    protected void postProcess(String sURL, UNOPublisher.TargetFormat format) {
        if (this.texify == null) {
            this.texify = new TeXify(this.xContext);
        }
        File file = new File(Misc.urlToFile(this.getTargetPath()), this.getTargetFileName());
        boolean bResult = true;
        try {
            if (this.sBackend == "pdftex") {
                bResult = this.texify.process(file, this.sBibinputs, (short)3, true);
            } else if (this.sBackend == "dvips") {
                bResult = this.texify.process(file, this.sBibinputs, (short)2, true);
            } else if (this.sBackend == "xetex") {
                bResult = this.texify.process(file, this.sBibinputs, (short)4, true);
            } else if (this.sBackend == "generic") {
                bResult = this.texify.process(file, this.sBibinputs, (short)1, true);
            }
        }
        catch (IOException e) {
            MessageBox msgBox = new MessageBox(this.xContext, this.xFrame);
            msgBox.showMessage("Writer2LaTeX", Messages.getString("LaTeXUNOPublisher.error") + ": " + e.getMessage());
        }
        if (!bResult) {
            MessageBox msgBox = new MessageBox(this.xContext, this.xFrame);
            msgBox.showMessage("Writer2LaTeX", Messages.getString("LaTeXUNOPublisher.error") + ": " + Messages.getString("LaTeXUNOPublisher.failedlatex"));
        }
    }

    private File getDirectory(short nType, String sDirectory) {
        switch (nType) {
            case 0: {
                return new File(sDirectory);
            }
            case 1: {
                return new File(Misc.urlToFile(this.getTargetPath()), sDirectory);
            }
        }
        return Misc.urlToFile(this.getTargetPath());
    }

    private String getFileList(short nType, String sDirectory) {
        File dir = this.getDirectory(nType, sDirectory);
        if (!dir.isDirectory()) {
            return null;
        }
        File[] files = dir.listFiles();
        CSVList filelist = new CSVList(",");
        if (files != null) {
            for (File file : files) {
                if (!file.isFile() || !file.getName().endsWith(".bib")) continue;
                filelist.addValue(Misc.removeExtension(file.getName()));
            }
        }
        return filelist.toString();
    }
}

