/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.da.comp.writer2xhtml;

import com.sun.star.beans.XPropertySet;
import com.sun.star.frame.XFrame;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import org.openoffice.da.comp.w2lcommon.filter.UNOPublisher;
import org.openoffice.da.comp.w2lcommon.helper.MessageBox;
import org.openoffice.da.comp.w2lcommon.helper.RegistryHelper;
import org.openoffice.da.comp.w2lcommon.helper.StreamGobbler;
import org.openoffice.da.comp.w2lcommon.helper.XPropertySetHelper;
import writer2latex.util.Misc;

public class XhtmlUNOPublisher
extends UNOPublisher {
    public XhtmlUNOPublisher(XComponentContext xContext, XFrame xFrame, String sAppName) {
        super(xContext, xFrame, sAppName);
    }

    @Override
    protected void postProcess(String sURL, UNOPublisher.TargetFormat format) {
        RegistryHelper registry = new RegistryHelper(this.xContext);
        int nView = 1;
        String sExecutable = null;
        try {
            Object view = registry.getRegistryView("/org.openoffice.da.Writer2xhtml.toolbar.ToolbarOptions/Settings", false);
            XPropertySet xProps = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)view);
            if (format == UNOPublisher.TargetFormat.xhtml || format == UNOPublisher.TargetFormat.xhtml11 || format == UNOPublisher.TargetFormat.xhtml_mathml || format == UNOPublisher.TargetFormat.html5) {
                nView = XPropertySetHelper.getPropertyValueAsShort(xProps, "XhtmlView");
                sExecutable = XPropertySetHelper.getPropertyValueAsString(xProps, "XhtmlExecutable");
            } else {
                nView = XPropertySetHelper.getPropertyValueAsShort(xProps, "EpubView");
                sExecutable = XPropertySetHelper.getPropertyValueAsString(xProps, "EpubExecutable");
            }
        }
        catch (Exception view) {
            // empty catch block
        }
        File file = Misc.urlToFile(sURL);
        if (file.exists()) {
            if (nView == 0) {
                return;
            }
            if (nView == 1 ? this.openWithDefaultApplication(file) : nView == 2 && this.openWithCustomApplication(file, sExecutable)) {
                return;
            }
        }
        MessageBox msgBox = new MessageBox(this.xContext, this.xFrame);
        msgBox.showMessage("Writer2xhtml", "Error: Failed to open exported document");
    }

    private boolean openWithDefaultApplication(File file) {
        if (Desktop.isDesktopSupported()) {
            Desktop desktop = Desktop.getDesktop();
            try {
                desktop.open(file);
                return true;
            }
            catch (IOException e) {
                System.err.println(e.getMessage());
            }
        }
        return false;
    }

    private boolean openWithCustomApplication(File file, String sExecutable) {
        try {
            Vector<String> command = new Vector<String>();
            command.add(sExecutable);
            command.add(file.getPath());
            ProcessBuilder pb = new ProcessBuilder(command);
            Process proc = pb.start();
            StreamGobbler errorGobbler = new StreamGobbler(proc.getErrorStream(), "ERROR");
            StreamGobbler outputGobbler = new StreamGobbler(proc.getInputStream(), "OUTPUT");
            errorGobbler.start();
            outputGobbler.start();
            return proc.waitFor() == 0;
        }
        catch (InterruptedException e) {
            return false;
        }
        catch (IOException e) {
            return false;
        }
    }
}

