/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.crt.http;

import java.util.ArrayList;
import java.util.List;
import software.amazon.awssdk.crt.http.Http2ConnectionSetting;
import software.amazon.awssdk.crt.http.HttpClientConnectionManagerOptions;

public class Http2StreamManagerOptions {
    public static final int DEFAULT_MAX_WINDOW_SIZE = Integer.MAX_VALUE;
    public static final int DEFAULT_MAX = Integer.MAX_VALUE;
    public static final int DEFAULT_MAX_CONNECTIONS = 2;
    public static final int DEFAULT_CONNECTION_PING_TIMEOUT_MS = 3000;
    private HttpClientConnectionManagerOptions connectionManagerOptions;
    private int idealConcurrentStreamsPerConnection = 100;
    private boolean connectionManualWindowManagement = false;
    private int maxConcurrentStreamsPerConnection = Integer.MAX_VALUE;
    private boolean priorKnowledge = false;
    private boolean closeConnectionOnServerError = false;
    private int connectionPingPeriodMs = 0;
    private int connectionPingTimeoutMs = 0;
    private List<Http2ConnectionSetting> initialSettingsList = new ArrayList<Http2ConnectionSetting>();

    public Http2StreamManagerOptions withInitialSettingsList(List<Http2ConnectionSetting> initialSettingsList) {
        this.initialSettingsList.addAll(initialSettingsList);
        return this;
    }

    public List<Http2ConnectionSetting> getInitialSettingsList() {
        return this.initialSettingsList;
    }

    public Http2StreamManagerOptions withIdealConcurrentStreamsPerConnection(int idealConcurrentStreamsPerConnection) {
        this.idealConcurrentStreamsPerConnection = idealConcurrentStreamsPerConnection;
        return this;
    }

    public int getIdealConcurrentStreamsPerConnection() {
        return this.idealConcurrentStreamsPerConnection;
    }

    public Http2StreamManagerOptions withMaxConcurrentStreamsPerConnection(int maxConcurrentStreamsPerConnection) {
        this.maxConcurrentStreamsPerConnection = maxConcurrentStreamsPerConnection;
        return this;
    }

    public int getMaxConcurrentStreamsPerConnection() {
        return this.maxConcurrentStreamsPerConnection;
    }

    public boolean isConnectionManualWindowManagement() {
        return this.connectionManualWindowManagement;
    }

    public Http2StreamManagerOptions withConnectionManualWindowManagement(boolean connectionManualWindowManagement) {
        this.connectionManualWindowManagement = connectionManualWindowManagement;
        return this;
    }

    public HttpClientConnectionManagerOptions getConnectionManagerOptions() {
        return this.connectionManagerOptions;
    }

    public Http2StreamManagerOptions withConnectionManagerOptions(HttpClientConnectionManagerOptions connectionManagerOptions) {
        this.connectionManagerOptions = connectionManagerOptions;
        return this;
    }

    public boolean hasPriorKnowledge() {
        return this.priorKnowledge;
    }

    public Http2StreamManagerOptions withPriorKnowledge(boolean priorKnowledge) {
        this.priorKnowledge = priorKnowledge;
        return this;
    }

    public boolean shouldCloseConnectionOnServerError() {
        return this.closeConnectionOnServerError;
    }

    public Http2StreamManagerOptions withCloseConnectionOnServerError(boolean closeConnectionOnServerError) {
        this.closeConnectionOnServerError = closeConnectionOnServerError;
        return this;
    }

    public Http2StreamManagerOptions withConnectionPing(int periodMs, int timeoutMs) {
        this.connectionPingPeriodMs = periodMs;
        this.connectionPingTimeoutMs = timeoutMs == 0 ? 3000 : timeoutMs;
        this.connectionPingTimeoutMs = Math.min(this.connectionPingPeriodMs, this.connectionPingTimeoutMs);
        return this;
    }

    public int getConnectionPingPeriodMs() {
        return this.connectionPingPeriodMs;
    }

    public int getConnectionPingTimeoutMs() {
        return this.connectionPingTimeoutMs;
    }

    public void validateOptions() {
        if (this.connectionManagerOptions == null) {
            throw new IllegalArgumentException("Connection manager options are required.");
        }
        this.connectionManagerOptions.validateOptions();
        if ((this.connectionManagerOptions.getTlsConnectionOptions() != null || this.connectionManagerOptions.getTlsContext() != null) && this.priorKnowledge) {
            throw new IllegalArgumentException("HTTP/2 prior knowledge cannot be set when TLS is used.");
        }
        if (this.connectionManagerOptions.getTlsConnectionOptions() == null && this.connectionManagerOptions.getTlsContext() == null && !this.priorKnowledge) {
            throw new IllegalArgumentException("Prior knowledge must be used for cleartext HTTP/2 connections. Upgrade from HTTP/1.1 is not supported.");
        }
        if (this.maxConcurrentStreamsPerConnection <= 0) {
            throw new IllegalArgumentException("Max Concurrent Streams Per Connection must be greater than zero.");
        }
        if (this.idealConcurrentStreamsPerConnection <= 0 || this.idealConcurrentStreamsPerConnection > this.maxConcurrentStreamsPerConnection) {
            throw new IllegalArgumentException("Ideal Concurrent Streams Per Connection must be greater than zero and smaller than max.");
        }
    }
}

