/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.profile.logic;

import com.google.common.net.InetAddresses;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Collection;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.net.IPRange;
import net.shibboleth.shared.servlet.HttpServletSupport;
import org.opensaml.messaging.context.BaseContext;

public class IPRangePredicate
implements Predicate<BaseContext> {
    @Nullable
    private Supplier<HttpServletRequest> httpRequestSupplier;
    @Nonnull
    private Collection<IPRange> addressRanges = CollectionSupport.emptyList();

    IPRangePredicate() {
    }

    public void setRanges(@Nonnull Collection<IPRange> ranges) {
        Constraint.isNotNull(ranges, "Address range collection cannot be null");
        this.addressRanges = CollectionSupport.copyToList(ranges);
    }

    public void setHttpServletRequestSupplier(@Nonnull Supplier<HttpServletRequest> supplier) {
        this.httpRequestSupplier = Constraint.isNotNull(supplier, "HttpServletRequestSupplier cannot be null");
    }

    @Override
    public boolean test(@Nullable BaseContext input) {
        String address;
        HttpServletRequest request = this.httpRequestSupplier != null ? this.httpRequestSupplier.get() : null;
        String string = address = request != null ? HttpServletSupport.getRemoteAddr((ServletRequest)request) : null;
        if (address == null || !InetAddresses.isInetAddress((String)address)) {
            return false;
        }
        for (IPRange range : this.addressRanges) {
            if (!range.contains(InetAddresses.forString((String)address))) continue;
            return true;
        }
        return false;
    }
}

