/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.owlxml.parser;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.formats.OWLXMLDocumentFormat;
import org.semanticweb.owlapi.formats.OWLXMLDocumentFormatFactory;
import org.semanticweb.owlapi.io.AbstractOWLParser;
import org.semanticweb.owlapi.io.OWLOntologyDocumentSource;
import org.semanticweb.owlapi.io.OWLParserException;
import org.semanticweb.owlapi.io.XMLUtils;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.model.OWLDocumentFormatFactory;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyLoaderConfiguration;
import org.semanticweb.owlapi.owlxml.parser.OWLXMLParserException;
import org.semanticweb.owlapi.owlxml.parser.OWLXMLParserHandler;
import org.semanticweb.owlapi.util.SAXParsers;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class OWLXMLParser
extends AbstractOWLParser {
    private static final long serialVersionUID = 40000L;

    @Override
    @Nonnull
    public String getName() {
        return "OWLXMLParser";
    }

    @Override
    public OWLDocumentFormatFactory getSupportedFormat() {
        return new OWLXMLDocumentFormatFactory();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public OWLDocumentFormat parse(OWLOntologyDocumentSource documentSource, OWLOntology ontology, OWLOntologyLoaderConfiguration configuration) throws IOException {
        InputSource isrc = null;
        try {
            isrc = this.getInputSource(documentSource, configuration);
            OWLXMLParserHandler handler = new OWLXMLParserHandler(ontology, configuration);
            SAXParsers.initParserWithOWLAPIStandards(null, configuration.getEntityExpansionLimit()).parse(isrc, (DefaultHandler)handler);
            if (!handler.atLeastOneTagFound()) {
                throw new OWLXMLParserException(handler, "No known tags in the input: is the file an OWL/XML ontology?");
            }
            OWLXMLDocumentFormat format = new OWLXMLDocumentFormat();
            format.copyPrefixesFrom(handler.getPrefixName2PrefixMap());
            String base = handler.getBase().toString();
            if (base != null && format.getDefaultPrefix() == null) {
                format.setDefaultPrefix(XMLUtils.iriWithTerminatingHash(base));
            }
            OWLXMLDocumentFormat oWLXMLDocumentFormat = format;
            return oWLXMLDocumentFormat;
        }
        catch (SAXException e) {
            throw new OWLParserException(e);
        }
        finally {
            block34: {
                if (isrc != null) {
                    try (InputStream in = isrc.getByteStream();){
                        Reader r = isrc.getCharacterStream();
                        Throwable throwable = null;
                        if (r == null) break block34;
                        if (throwable != null) {
                            try {
                                r.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        } else {
                            r.close();
                        }
                    }
                }
            }
        }
    }
}

