/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.util.collection;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class OntoMap<P, I>
implements Serializable {
    private static final long serialVersionUID = 7466889579477428610L;
    private Map<P, I> map;
    private Map<I, Collection<?>> reverse;
    private Class<? extends Collection<?>> collectionClass;

    public OntoMap(Class<?> collectionClass) {
        if (!Collection.class.isAssignableFrom(collectionClass)) {
            throw new IllegalArgumentException("no collection class: " + collectionClass.getName());
        }
        this.collectionClass = collectionClass;
        this.map = new HashMap<P, I>();
        this.reverse = new HashMap();
    }

    public Collection<P> getPreImages() {
        return this.map.keySet();
    }

    public Collection<I> getImages() {
        return this.reverse.keySet();
    }

    public void clear() {
        this.map.clear();
        this.reverse.clear();
    }

    public boolean containsImage(I image) {
        return this.reverse.containsKey(image);
    }

    private Collection<?> newCollection() {
        try {
            Collection<?> c = this.collectionClass.newInstance();
            return c;
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception t) {
            throw new IllegalStateException(t);
        }
    }

    public void add(P preImage, I image) {
        this.map.put(preImage, image);
        Collection<?> preImages = this.reverse.get(image);
        if (preImages == null) {
            preImages = this.newCollection();
            this.reverse.put(image, preImages);
        }
        preImages.add(preImage);
    }

    public void removeAllPreimages(I image) {
        this.reverse.remove(image);
    }

    public void remove(P preImage) {
        Collection<?> preImages = this.reverse.get(this.getImage(preImage));
        if (preImages != null) {
            preImages.remove(preImage);
        }
    }

    public I getImage(P preImage) {
        return this.map.get(preImage);
    }

    public Collection<Map.Entry<P, I>> entries() {
        return this.map.entrySet();
    }

    public Collection<P> getPreImages(I image) {
        Collection<?> preImages = this.reverse.get(image);
        if (preImages == null) {
            return this.newCollection();
        }
        return preImages;
    }
}

