/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.security;

import java.security.Principal;
import java.util.Enumeration;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.security.AuthorizationContext;
import org.apache.solr.servlet.ServletUtils;

public abstract class HttpServletAuthorizationContext
extends AuthorizationContext {
    private final HttpServletRequest servletRequest;

    public HttpServletAuthorizationContext(HttpServletRequest servletRequest) {
        this.servletRequest = servletRequest;
    }

    @Override
    public abstract SolrParams getParams();

    @Override
    public abstract List<AuthorizationContext.CollectionRequest> getCollectionRequests();

    @Override
    public abstract AuthorizationContext.RequestType getRequestType();

    @Override
    public abstract Object getHandler();

    @Override
    public String getResource() {
        return ServletUtils.getPathAfterContext(this.servletRequest);
    }

    @Override
    public String getRemoteAddr() {
        return this.servletRequest.getRemoteAddr();
    }

    @Override
    public Principal getUserPrincipal() {
        return this.servletRequest.getUserPrincipal();
    }

    @Override
    public String getUserName() {
        return this.servletRequest.getRemoteUser();
    }

    @Override
    public String getHttpHeader(String s) {
        return this.servletRequest.getHeader(s);
    }

    @Override
    public Enumeration<String> getHeaderNames() {
        return this.servletRequest.getHeaderNames();
    }

    @Override
    public String getHttpMethod() {
        return this.servletRequest.getMethod();
    }

    @Override
    public String getRemoteHost() {
        return this.servletRequest.getRemoteHost();
    }
}

