/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.ltr;

import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Semaphore;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.util.SolrPluginUtils;
import org.apache.solr.util.plugin.NamedListInitializedPlugin;

public final class LTRThreadModule
implements NamedListInitializedPlugin {
    private static String CONFIG_PREFIX = "threadModule.";
    private int totalPoolThreads = 1;
    private int numThreadsPerRequest = 1;
    private Semaphore ltrSemaphore;
    private volatile ExecutorService createWeightScoreExecutor;

    public static LTRThreadModule getInstance(NamedList<?> args) {
        LTRThreadModule threadManager;
        NamedList<Object> threadManagerArgs = LTRThreadModule.extractThreadModuleParams(args);
        if (threadManagerArgs.size() > 0) {
            threadManager = new LTRThreadModule();
            threadManager.init(threadManagerArgs);
        } else {
            threadManager = null;
        }
        return threadManager;
    }

    private static NamedList<Object> extractThreadModuleParams(NamedList<?> args) {
        NamedList extractedArgs = new NamedList();
        for (Map.Entry entry : args) {
            String key = (String)entry.getKey();
            if (!key.startsWith(CONFIG_PREFIX)) continue;
            extractedArgs.add(key.substring(CONFIG_PREFIX.length()), entry.getValue());
        }
        for (Object key : extractedArgs.asShallowMap().keySet()) {
            args.remove(CONFIG_PREFIX + String.valueOf(key));
        }
        return extractedArgs;
    }

    public LTRThreadModule() {
    }

    LTRThreadModule(int totalPoolThreads, int numThreadsPerRequest) {
        this.totalPoolThreads = totalPoolThreads;
        this.numThreadsPerRequest = numThreadsPerRequest;
        this.init(null);
    }

    public void init(NamedList<?> args) {
        if (args != null) {
            SolrPluginUtils.invokeSetters((Object)this, args);
        }
        this.validate();
        this.ltrSemaphore = this.totalPoolThreads > 1 ? new Semaphore(this.totalPoolThreads) : null;
    }

    private void validate() {
        if (this.totalPoolThreads <= 0) {
            throw new IllegalArgumentException("totalPoolThreads cannot be less than 1");
        }
        if (this.numThreadsPerRequest <= 0) {
            throw new IllegalArgumentException("numThreadsPerRequest cannot be less than 1");
        }
        if (this.totalPoolThreads < this.numThreadsPerRequest) {
            throw new IllegalArgumentException("numThreadsPerRequest cannot be greater than totalPoolThreads");
        }
    }

    public void setTotalPoolThreads(int totalPoolThreads) {
        this.totalPoolThreads = totalPoolThreads;
    }

    public void setNumThreadsPerRequest(int numThreadsPerRequest) {
        this.numThreadsPerRequest = numThreadsPerRequest;
    }

    public Semaphore createQuerySemaphore() {
        return this.numThreadsPerRequest > 1 ? new Semaphore(this.numThreadsPerRequest) : null;
    }

    public void acquireLTRSemaphore() throws InterruptedException {
        this.ltrSemaphore.acquire();
    }

    public void releaseLTRSemaphore() throws InterruptedException {
        this.ltrSemaphore.release();
    }

    public void execute(Runnable command) {
        this.createWeightScoreExecutor.execute(command);
    }

    public void setExecutor(ExecutorService sharedExecutor) {
        this.createWeightScoreExecutor = sharedExecutor;
    }
}

