
#ifndef CSSPARSER_EXPORT_H
#define CSSPARSER_EXPORT_H

#ifdef CSSPARSER_STATIC_DEFINE
#  define CSSPARSER_EXPORT
#  define CSSPARSER_NO_EXPORT
#else
#  ifndef CSSPARSER_EXPORT
#    ifdef cxx_rust_cssparser_EXPORTS
        /* We are building this library */
#      define CSSPARSER_EXPORT __attribute__((visibility("default")))
#    else
        /* We are using this library */
#      define CSSPARSER_EXPORT __attribute__((visibility("default")))
#    endif
#  endif

#  ifndef CSSPARSER_NO_EXPORT
#    define CSSPARSER_NO_EXPORT __attribute__((visibility("hidden")))
#  endif
#endif

#ifndef CSSPARSER_DECL_DEPRECATED
#  define CSSPARSER_DECL_DEPRECATED __attribute__ ((__deprecated__))
#endif

#ifndef CSSPARSER_DECL_DEPRECATED_EXPORT
#  define CSSPARSER_DECL_DEPRECATED_EXPORT CSSPARSER_EXPORT CSSPARSER_DECL_DEPRECATED
#endif

#ifndef CSSPARSER_DECL_DEPRECATED_NO_EXPORT
#  define CSSPARSER_DECL_DEPRECATED_NO_EXPORT CSSPARSER_NO_EXPORT CSSPARSER_DECL_DEPRECATED
#endif

/* NOLINTNEXTLINE(readability-avoid-unconditional-preprocessor-if) */
#if 0 /* DEFINE_NO_DEPRECATED */
#  ifndef CSSPARSER_NO_DEPRECATED
#    define CSSPARSER_NO_DEPRECATED
#  endif
#endif

#define CSSPARSER_DECL_DEPRECATED_TEXT(text) __attribute__ ((__deprecated__(text)))

#if defined(CSSPARSER_NO_DEPRECATED)
#  undef CSSPARSER_DEPRECATED
#  define CSSPARSER_DEPRECATED_EXPORT CSSPARSER_EXPORT
#  define CSSPARSER_DEPRECATED_NO_EXPORT CSSPARSER_NO_EXPORT
#elif defined(CSSPARSER_NO_DEPRECATED_WARNINGS)
#  define CSSPARSER_DEPRECATED
#  define CSSPARSER_DEPRECATED_EXPORT CSSPARSER_EXPORT
#  define CSSPARSER_DEPRECATED_NO_EXPORT CSSPARSER_NO_EXPORT
#else
#  define CSSPARSER_DEPRECATED CSSPARSER_DECL_DEPRECATED
#  define CSSPARSER_DEPRECATED_EXPORT CSSPARSER_DECL_DEPRECATED_EXPORT
#  define CSSPARSER_DEPRECATED_NO_EXPORT CSSPARSER_DECL_DEPRECATED_NO_EXPORT
#endif

/* No deprecated API had been removed from build */
#define CSSPARSER_EXCLUDE_DEPRECATED_BEFORE_AND_AT 0

#define CSSPARSER_BUILD_DEPRECATED_SINCE(major, minor) 1

#ifdef CSSPARSER_NO_DEPRECATED
#  define CSSPARSER_DISABLE_DEPRECATED_BEFORE_AND_AT 0x10000
#endif
#ifdef CSSPARSER_NO_DEPRECATED_WARNINGS
#  define CSSPARSER_DEPRECATED_WARNINGS_SINCE 0
#endif

#ifndef CSSPARSER_DEPRECATED_WARNINGS_SINCE
#  ifdef CSSPARSER_DISABLE_DEPRECATED_BEFORE_AND_AT
#    define CSSPARSER_DEPRECATED_WARNINGS_SINCE CSSPARSER_DISABLE_DEPRECATED_BEFORE_AND_AT
#  else
#    define CSSPARSER_DEPRECATED_WARNINGS_SINCE 0x10000
#  endif
#endif

#ifndef CSSPARSER_DISABLE_DEPRECATED_BEFORE_AND_AT
#  define CSSPARSER_DISABLE_DEPRECATED_BEFORE_AND_AT 0
#endif

#ifdef CSSPARSER_DEPRECATED
#  define CSSPARSER_ENABLE_DEPRECATED_SINCE(major, minor) (((major<<16)|(minor<<8)) > CSSPARSER_DISABLE_DEPRECATED_BEFORE_AND_AT)
#else
#  define CSSPARSER_ENABLE_DEPRECATED_SINCE(major, minor) 0
#endif

#endif /* CSSPARSER_EXPORT_H */
