/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.iotdb.model.meta;

import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.generic.model.GenericTableBase;
import org.jkiss.dbeaver.ext.generic.model.meta.GenericMetaModel;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class IoTDBTableMetaModel
extends GenericMetaModel {
    private static final Log log = Log.getLog(IoTDBTableMetaModel.class);
    private static final String[] allIotdbTableSQLKeywords = new String[]{"ALTER", "AND", "AS", "BETWEEN", "BY", "CASE", "CAST", "CONSTRAINT", "CREATE", "CROSS", "CUBE", "CURRENT_CATALOG", "CURRENT_DATE", "CURRENT_ROLE", "CURRENT_SCHEMA", "CURRENT_TIME", "CURRENT_TIMESTAMP", "CURRENT_USER", "DEALLOCATE", "DELETE", "DESCRIBE", "DISTINCT", "DROP", "ELSE", "END", "ESCAPE", "EXCEPT", "EXISTS", "EXTRACT", "FALSE", "FOR", "FROM", "FULL", "GROUP", "GROUPING", "HAVING", "IN", "INNER", "INSERT", "INTERSECT", "INTO", "IS", "JOIN", "JSON_ARRAY", "JSON_EXISTS", "JSON_OBJECT", "JSON_QUERY", "JSON_TABLE", "JSON_VALUE", "LEFT", "LIKE", "LISTAGG", "LOCALTIME", "LOCALTIMESTAMP", "NATURAL", "NORMALIZE", "NOT", "NULL", "ON", "OR", "ORDER", "OUTER", "PREPARE", "RECURSIVE", "RIGHT", "ROLLUP", "SELECT", "SKIP", "TABLE", "THEN", "TRIM", "TRUE", "UESCAPE", "UNION", "UNNEST", "USING", "VALUES", "WHEN", "WHERE", "WITH", "FILL"};

    private String getInsertTableName(String tb) {
        Object insertTableName = tb;
        for (String keyword : allIotdbTableSQLKeywords) {
            if (!tb.equalsIgnoreCase(keyword)) continue;
            insertTableName = "\"" + tb + "\"";
            break;
        }
        return insertTableName;
    }

    private String getTTL(DBRProgressMonitor monitor, GenericTableBase sourceObject, String databaseName) {
        String ttl = "";
        try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)sourceObject, (String)"Get IoTDB table details");){
            String sql = String.format("select * from information_schema.tables where database like '%s'", databaseName);
            try (JDBCStatement stmt = session.createStatement();
                 JDBCResultSet rs = stmt.executeQuery(sql);){
                if (rs != null && rs.next()) {
                    ttl = rs.getString("ttl(ms)");
                }
            }
        }
        catch (Exception e) {
            try (JDBCSession session2 = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)sourceObject, (String)"Get IoTDB table details");){
                String sql = String.format("show tables details from %s", DBUtils.getQuotedIdentifier((DBPDataSource)sourceObject.getDataSource(), (String)databaseName, (boolean)true, (boolean)true));
                try (JDBCStatement stmt = session2.createStatement();
                     JDBCResultSet rs = stmt.executeQuery(sql);){
                    if (rs != null && rs.next()) {
                        ttl = rs.getString("TTL(ms)");
                    }
                }
            }
            catch (Exception e1) {
                log.error((Object)"Error executing sql", (Throwable)e1);
            }
        }
        if (ttl.equals("INF")) {
            ttl = SQLUtils.quoteString((DBSObject)sourceObject, (String)"INF");
        }
        return ttl;
    }

    private String getTableDDLInfoWithISPrivilege(JDBCSession session, GenericTableBase sourceObject, String databaseName, String insertTableName, String ttl) throws SQLException {
        String sql = String.format("select * from information_schema.columns where database like '%s' and table_name like '%s'", databaseName, insertTableName);
        return this.getTableDDLWithSQL(session, sourceObject, insertTableName, ttl, sql, List.of("column_name", "datatype", "category", "comment"));
    }

    private String getTableDDLInfoWithoutISPrivilege(JDBCSession session, GenericTableBase sourceObject, String databaseName, String insertTableName, String ttl) throws SQLException {
        String sql = String.format("desc %s.%s details", databaseName, insertTableName);
        return this.getTableDDLWithSQL(session, sourceObject, insertTableName, ttl, sql, List.of("ColumnName, DataType, Category, Comment"));
    }

    @NotNull
    private String getTableDDLWithSQL(@NotNull JDBCSession session, @NotNull GenericTableBase sourceObject, @NotNull String insertTableName, @NotNull String ttl, @NotNull String sql, @NotNull List<String> columnTitles) throws SQLException {
        StringBuilder toAppend = new StringBuilder(200);
        try (JDBCStatement stmt = session.createStatement();
             JDBCResultSet rs = stmt.executeQuery(sql);){
            toAppend.append("CREATE TABLE ").append(DBUtils.getQuotedIdentifier((DBPDataSource)sourceObject.getDataSource(), (String)insertTableName)).append(" (\n");
            boolean hasColumn = false;
            while (rs.next()) {
                hasColumn = true;
                toAppend.append("\t").append(rs.getString(columnTitles.get(0))).append(" ");
                toAppend.append(rs.getString(columnTitles.get(1))).append(" ");
                toAppend.append(rs.getString(columnTitles.get(2)));
                String columnComment = rs.getString(columnTitles.get(3));
                if (columnComment != null && !columnComment.isEmpty()) {
                    toAppend.append(" COMMENT ").append(SQLUtils.quoteString((DBSObject)sourceObject, (String)columnComment)).append("");
                }
                toAppend.append(",\n");
            }
            if (hasColumn) {
                toAppend.setLength(toAppend.length() - 2);
            }
            String tableComment = sourceObject.getDescription();
            toAppend.append("\n) ");
            if (tableComment != null && !tableComment.isEmpty()) {
                toAppend.append("COMMENT ").append(SQLUtils.quoteString((DBSObject)sourceObject, (String)tableComment)).append(" ");
            }
            toAppend.append("WITH (TTL=").append(ttl).append(");");
        }
        return toAppend.toString();
    }

    public String getTableDDL(@NotNull DBRProgressMonitor monitor, @NotNull GenericTableBase sourceObject, @NotNull Map<String, Object> options) {
        String databaseName = sourceObject.getParentObject().getName();
        String tableName = sourceObject.getName();
        String insertTableName = this.getInsertTableName(tableName);
        StringBuilder ddl = new StringBuilder(200);
        ddl.append("DROP TABLE IF EXISTS ").append(insertTableName).append(";\n\n");
        String ttl = this.getTTL(monitor, sourceObject, databaseName);
        String toAppend = "";
        try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)sourceObject, (String)"Get IoTDB table column details");){
            toAppend = this.getTableDDLInfoWithISPrivilege(session, sourceObject, databaseName, insertTableName, ttl);
        }
        catch (Exception e) {
            try (JDBCSession session2 = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)sourceObject, (String)"Get IoTDB table column details");){
                toAppend = this.getTableDDLInfoWithoutISPrivilege(session2, sourceObject, databaseName, insertTableName, ttl);
            }
            catch (Exception e1) {
                log.error((Object)"Error executing sql", (Throwable)e1);
            }
        }
        ddl.append(toAppend);
        return ddl.toString();
    }

    public boolean isTrimObjectNames() {
        return true;
    }
}

