/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.palette;

import org.eclipse.gef.SharedImages;
import org.eclipse.gef.internal.GEFMessages;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.gef.tools.MarqueeSelectionTool;
import org.eclipse.jface.resource.ImageDescriptor;

public class MarqueeToolEntry
extends ToolEntry {
    public MarqueeToolEntry() {
        this(null, null);
    }

    public MarqueeToolEntry(String label) {
        this(label, null);
    }

    public MarqueeToolEntry(String label, String description) {
        super(label, description, null, null, MarqueeSelectionTool.class);
        if (label == null || label.length() == 0) {
            this.setLabel(GEFMessages.MarqueeTool_Label);
        }
        this.setUserModificationPermission(1);
    }

    @Override
    public String getDescription() {
        String description = super.getDescription();
        if (description != null) {
            return description;
        }
        int marqueeBehavior = this.getMarqueeBehavior();
        switch (marqueeBehavior) {
            case 2: {
                return GEFMessages.MarqueeTool_Connections_Touched_Desc;
            }
            case 6: {
                return GEFMessages.MarqueeTool_Connections_Contained_Desc;
            }
            case 4: {
                return GEFMessages.MarqueeTool_Nodes_Touched_Desc;
            }
            case 1: {
                return GEFMessages.MarqueeTool_Nodes_Contained_Desc;
            }
            case 5: {
                return GEFMessages.MarqueeTool_Nodes_Touched_And_Related_Connections_Desc;
            }
            case 3: {
                return GEFMessages.MarqueeTool_Nodes_Contained_And_Related_Connections_Desc;
            }
        }
        throw new IllegalArgumentException("Unknown marquee behavior");
    }

    @Override
    public ImageDescriptor getLargeIcon() {
        ImageDescriptor imageDescriptor = super.getLargeIcon();
        if (imageDescriptor != null) {
            return imageDescriptor;
        }
        int marqueeBehavior = this.getMarqueeBehavior();
        if (marqueeBehavior == 6 || marqueeBehavior == 2) {
            return SharedImages.DESC_MARQUEE_TOOL_CONNECTIONS_24;
        }
        if (marqueeBehavior == 1 || marqueeBehavior == 4) {
            return SharedImages.DESC_MARQUEE_TOOL_NODES_24;
        }
        return SharedImages.DESC_MARQUEE_TOOL_24;
    }

    private int getMarqueeBehavior() {
        Object value = this.getToolProperty(MarqueeSelectionTool.PROPERTY_MARQUEE_BEHAVIOR);
        if (value instanceof Integer) {
            Integer intVal = (Integer)value;
            return intVal;
        }
        return 1;
    }

    @Override
    public ImageDescriptor getSmallIcon() {
        ImageDescriptor imageDescriptor = super.getSmallIcon();
        if (imageDescriptor != null) {
            return imageDescriptor;
        }
        int marqueeBehavior = this.getMarqueeBehavior();
        if (marqueeBehavior == 6 || marqueeBehavior == 2) {
            return SharedImages.DESC_MARQUEE_TOOL_CONNECTIONS_16;
        }
        if (marqueeBehavior == 1 || marqueeBehavior == 4) {
            return SharedImages.DESC_MARQUEE_TOOL_NODES_16;
        }
        return SharedImages.DESC_MARQUEE_TOOL_16;
    }
}

