/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi.stubs.elements;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.stubs.IndexSink;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubElement;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubInputStream;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubOutputStream;
import org.jetbrains.kotlin.com.intellij.util.io.StringRef;
import org.jetbrains.kotlin.constant.ConstantValue;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.psi.stubs.KotlinAnnotationEntryStub;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementType;
import org.jetbrains.kotlin.psi.stubs.elements.StubIndexService;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinAnnotationEntryStubImpl;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinConstantValueKt;

public class KtAnnotationEntryElementType
extends KtStubElementType<KotlinAnnotationEntryStub, KtAnnotationEntry> {
    public KtAnnotationEntryElementType(@NotNull @NonNls String debugName) {
        if (debugName == null) {
            KtAnnotationEntryElementType.$$$reportNull$$$0(0);
        }
        super(debugName, KtAnnotationEntry.class, KotlinAnnotationEntryStub.class);
    }

    @Override
    @NotNull
    public KotlinAnnotationEntryStub createStub(@NotNull KtAnnotationEntry psi, StubElement parentStub) {
        Name shortName;
        if (psi == null) {
            KtAnnotationEntryElementType.$$$reportNull$$$0(1);
        }
        String resultName = (shortName = psi.getShortName()) != null ? shortName.asString() : null;
        KtValueArgumentList valueArgumentList = psi.getValueArgumentList();
        boolean hasValueArguments = valueArgumentList != null && !valueArgumentList.getArguments().isEmpty();
        return new KotlinAnnotationEntryStubImpl(parentStub, StringRef.fromString(resultName), hasValueArguments, null);
    }

    @Override
    public void serialize(@NotNull KotlinAnnotationEntryStub stub, @NotNull StubOutputStream dataStream) throws IOException {
        if (stub == null) {
            KtAnnotationEntryElementType.$$$reportNull$$$0(2);
        }
        if (dataStream == null) {
            KtAnnotationEntryElementType.$$$reportNull$$$0(3);
        }
        dataStream.writeName(stub.getShortName());
        dataStream.writeBoolean(stub.hasValueArguments());
        if (stub instanceof KotlinAnnotationEntryStubImpl) {
            Map<Name, ConstantValue<?>> arguments = ((KotlinAnnotationEntryStubImpl)stub).getValueArguments();
            dataStream.writeVarInt(arguments != null ? arguments.size() : 0);
            if (arguments != null) {
                for (Map.Entry<Name, ConstantValue<?>> valueEntry : arguments.entrySet()) {
                    dataStream.writeName(valueEntry.getKey().asString());
                    ConstantValue<?> value2 = valueEntry.getValue();
                    KotlinConstantValueKt.serializeConstantValue(value2, dataStream);
                }
            }
        }
    }

    @Override
    @NotNull
    public KotlinAnnotationEntryStub deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        if (dataStream == null) {
            KtAnnotationEntryElementType.$$$reportNull$$$0(4);
        }
        StringRef text = dataStream.readName();
        boolean hasValueArguments = dataStream.readBoolean();
        int valueArgCount = dataStream.readVarInt();
        LinkedHashMap args = new LinkedHashMap();
        for (int i2 = 0; i2 < valueArgCount; ++i2) {
            args.put(Name.identifier(Objects.requireNonNull(dataStream.readNameString())), KotlinConstantValueKt.deserializeConstantValue(dataStream));
        }
        return new KotlinAnnotationEntryStubImpl(parentStub, text, hasValueArguments, args.isEmpty() ? null : args);
    }

    @Override
    public void indexStub(@NotNull KotlinAnnotationEntryStub stub, @NotNull IndexSink sink) {
        if (stub == null) {
            KtAnnotationEntryElementType.$$$reportNull$$$0(5);
        }
        if (sink == null) {
            KtAnnotationEntryElementType.$$$reportNull$$$0(6);
        }
        StubIndexService.getInstance().indexAnnotation(stub, sink);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psi";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataStream";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/psi/stubs/elements/KtAnnotationEntryElementType";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "createStub";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "serialize";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "deserialize";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "indexStub";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

