/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.security.authorizer;

import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.auth.KafkaPrincipal;

public class AclEntry {
    public static final KafkaPrincipal WILDCARD_PRINCIPAL = new KafkaPrincipal("User", "*");
    public static final String WILDCARD_PRINCIPAL_STRING = WILDCARD_PRINCIPAL.toString();
    public static final String WILDCARD_HOST = "*";
    public static final String WILDCARD_RESOURCE = "*";
    public static final Set<AclOperation> ACL_OPERATIONS = Arrays.stream(AclOperation.values()).filter(t -> t != AclOperation.UNKNOWN && t != AclOperation.ANY).collect(Collectors.toSet());

    public static Set<AclOperation> supportedOperations(ResourceType resourceType) {
        return switch (resourceType) {
            case ResourceType.TOPIC -> Set.of(AclOperation.READ, AclOperation.WRITE, AclOperation.CREATE, AclOperation.DESCRIBE, AclOperation.DELETE, AclOperation.ALTER, AclOperation.DESCRIBE_CONFIGS, AclOperation.ALTER_CONFIGS);
            case ResourceType.GROUP -> Set.of(AclOperation.READ, AclOperation.DESCRIBE, AclOperation.DELETE, AclOperation.DESCRIBE_CONFIGS, AclOperation.ALTER_CONFIGS);
            case ResourceType.CLUSTER -> Set.of(AclOperation.CREATE, AclOperation.CLUSTER_ACTION, AclOperation.DESCRIBE_CONFIGS, AclOperation.ALTER_CONFIGS, AclOperation.IDEMPOTENT_WRITE, AclOperation.ALTER, AclOperation.DESCRIBE);
            case ResourceType.TRANSACTIONAL_ID -> Set.of(AclOperation.DESCRIBE, AclOperation.WRITE, AclOperation.TWO_PHASE_COMMIT);
            case ResourceType.DELEGATION_TOKEN -> Set.of(AclOperation.DESCRIBE);
            case ResourceType.USER -> Set.of(AclOperation.CREATE_TOKENS, AclOperation.DESCRIBE_TOKENS);
            default -> throw new IllegalArgumentException("Not a concrete resource type");
        };
    }

    public static Errors authorizationError(ResourceType resourceType) {
        return switch (resourceType) {
            case ResourceType.TOPIC -> Errors.TOPIC_AUTHORIZATION_FAILED;
            case ResourceType.GROUP -> Errors.GROUP_AUTHORIZATION_FAILED;
            case ResourceType.CLUSTER -> Errors.CLUSTER_AUTHORIZATION_FAILED;
            case ResourceType.TRANSACTIONAL_ID -> Errors.TRANSACTIONAL_ID_AUTHORIZATION_FAILED;
            case ResourceType.DELEGATION_TOKEN -> Errors.DELEGATION_TOKEN_AUTHORIZATION_FAILED;
            default -> throw new IllegalArgumentException("Authorization error type not known");
        };
    }
}

