/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.protection;

import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Response;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.admin.ResourceSetService;
import org.keycloak.authorization.common.KeycloakIdentity;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.protection.permission.PermissionService;
import org.keycloak.authorization.protection.permission.PermissionTicketService;
import org.keycloak.authorization.protection.policy.UserManagedPermissionService;
import org.keycloak.authorization.protection.resource.ResourceService;
import org.keycloak.common.ClientConnection;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.services.ErrorResponseException;
import org.keycloak.services.resources.admin.AdminAuth;
import org.keycloak.services.resources.admin.AdminEventBuilder;

public class ProtectionService {
    private final KeycloakSession session;
    private final AuthorizationProvider authorization;
    protected final ClientConnection clientConnection;

    public ProtectionService(AuthorizationProvider authorization) {
        this.session = authorization.getKeycloakSession();
        this.authorization = authorization;
        this.clientConnection = this.session.getContext().getConnection();
    }

    @Path(value="/resource_set")
    public Object resource() {
        KeycloakIdentity identity = this.createIdentity(true);
        ResourceServer resourceServer = this.getResourceServer(identity);
        ResourceSetService resourceManager = new ResourceSetService(this.session, resourceServer, this.authorization, null, this.createAdminEventBuilder(identity, resourceServer));
        return new ResourceService(this.session, resourceServer, identity, resourceManager);
    }

    private AdminEventBuilder createAdminEventBuilder(KeycloakIdentity identity, ResourceServer resourceServer) {
        RealmModel realm = this.authorization.getRealm();
        ClientModel client = realm.getClientById(resourceServer.getClientId());
        KeycloakSession keycloakSession = this.authorization.getKeycloakSession();
        UserModel serviceAccount = keycloakSession.users().getServiceAccount(client);
        AdminEventBuilder adminEvent = new AdminEventBuilder(realm, new AdminAuth(realm, identity.getAccessToken(), serviceAccount, client), keycloakSession, this.clientConnection);
        return adminEvent;
    }

    @Path(value="/permission")
    public Object permission() {
        KeycloakIdentity identity = this.createIdentity(false);
        return new PermissionService(identity, this.getResourceServer(identity), this.authorization);
    }

    @Path(value="/permission/ticket")
    public Object ticket() {
        KeycloakIdentity identity = this.createIdentity(false);
        return new PermissionTicketService(identity, this.getResourceServer(identity), this.authorization);
    }

    @Path(value="/uma-policy")
    public Object policy() {
        KeycloakIdentity identity = this.createIdentity(false);
        return new UserManagedPermissionService(identity, this.getResourceServer(identity), this.authorization, this.createAdminEventBuilder(identity, this.getResourceServer(identity)));
    }

    private KeycloakIdentity createIdentity(boolean checkProtectionScope) {
        KeycloakIdentity identity = new KeycloakIdentity(this.authorization.getKeycloakSession());
        ResourceServer resourceServer = this.getResourceServer(identity);
        KeycloakSession keycloakSession = this.authorization.getKeycloakSession();
        RealmModel realm = keycloakSession.getContext().getRealm();
        ClientModel client = realm.getClientById(resourceServer.getClientId());
        if (checkProtectionScope && !identity.hasClientRole(client.getClientId(), "uma_protection")) {
            throw new ErrorResponseException("invalid_scope", "Requires uma_protection scope.", Response.Status.FORBIDDEN);
        }
        return identity;
    }

    private ResourceServer getResourceServer(KeycloakIdentity identity) {
        String clientId = identity.getAccessToken().getIssuedFor();
        RealmModel realm = this.authorization.getKeycloakSession().getContext().getRealm();
        ClientModel clientModel = realm.getClientByClientId(clientId);
        if (clientModel == null && (clientModel = realm.getClientById(clientId)) == null) {
            throw new ErrorResponseException("invalid_clientId", "Client application with id [" + clientId + "] does not exist in realm [" + realm.getName() + "]", Response.Status.BAD_REQUEST);
        }
        ResourceServer resourceServer = this.authorization.getStoreFactory().getResourceServerStore().findByClient(clientModel);
        if (resourceServer == null) {
            throw new ErrorResponseException("invalid_clientId", "Client application [" + clientModel.getClientId() + "] is not registered as a resource server.", Response.Status.FORBIDDEN);
        }
        return resourceServer;
    }
}

