/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.locale;

import org.jboss.logging.Logger;
import org.keycloak.cookie.CookieProvider;
import org.keycloak.cookie.CookieType;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventType;
import org.keycloak.locale.LocaleSelectorProvider;
import org.keycloak.locale.LocaleUpdaterProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.UserModel;
import org.keycloak.storage.ReadOnlyException;

public class DefaultLocaleUpdaterProvider
implements LocaleUpdaterProvider {
    private static final Logger logger = Logger.getLogger(LocaleSelectorProvider.class);
    private final KeycloakSession session;

    public DefaultLocaleUpdaterProvider(KeycloakSession session) {
        this.session = session;
    }

    public void updateUsersLocale(UserModel user, String locale) {
        String previousLocale = user.getFirstAttribute("locale");
        if (!locale.equals(previousLocale)) {
            try {
                EventBuilder event = new EventBuilder(this.session.getContext().getRealm(), this.session, this.session.getContext().getConnection()).event(EventType.UPDATE_PROFILE).user(user).client(this.session.getContext().getClient()).detail("previous_locale", previousLocale).detail("updated_locale", locale);
                user.setSingleAttribute("locale", locale);
                this.updateLocaleCookie(locale);
                event.success();
            }
            catch (ReadOnlyException e) {
                logger.debug((Object)"Attempt to store 'locale' attribute to read only user model. Ignoring exception", (Throwable)e);
            }
        }
        logger.debugv("Setting locale for user {0} to {1}", (Object)user.getUsername(), (Object)locale);
    }

    public void updateLocaleCookie(String locale) {
        ((CookieProvider)this.session.getProvider(CookieProvider.class)).set(CookieType.LOCALE, locale);
        logger.debugv("Updating locale cookie to {0}", (Object)locale);
    }

    public void expireLocaleCookie() {
        ((CookieProvider)this.session.getProvider(CookieProvider.class)).expire(CookieType.LOCALE);
    }

    public void close() {
    }
}

